/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iap.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iap.v1.Brand;
import com.google.cloud.iap.v1.CreateBrandRequest;
import com.google.cloud.iap.v1.CreateIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.DeleteIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.GetBrandRequest;
import com.google.cloud.iap.v1.GetIdentityAwareProxyClientRequest;
import com.google.cloud.iap.v1.IdentityAwareProxyClient;
import com.google.cloud.iap.v1.IdentityAwareProxyOAuthServiceClient;
import com.google.cloud.iap.v1.ListBrandsRequest;
import com.google.cloud.iap.v1.ListBrandsResponse;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsRequest;
import com.google.cloud.iap.v1.ListIdentityAwareProxyClientsResponse;
import com.google.cloud.iap.v1.ResetIdentityAwareProxyClientSecretRequest;
import com.google.cloud.iap.v1.stub.GrpcIdentityAwareProxyOAuthServiceCallableFactory;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyOAuthServiceStub;
import com.google.cloud.iap.v1.stub.IdentityAwareProxyOAuthServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIdentityAwareProxyOAuthServiceStub
extends IdentityAwareProxyOAuthServiceStub {
    private static final MethodDescriptor<ListBrandsRequest, ListBrandsResponse> listBrandsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListBrands").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBrandsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBrandsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateBrandRequest, Brand> createBrandMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateBrand").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBrandRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Brand.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetBrandRequest, Brand> getBrandMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetBrand").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBrandRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Brand.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/CreateIdentityAwareProxyClient").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateIdentityAwareProxyClientRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IdentityAwareProxyClient.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ListIdentityAwareProxyClients").setRequestMarshaller(ProtoUtils.marshaller((Message)ListIdentityAwareProxyClientsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListIdentityAwareProxyClientsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/GetIdentityAwareProxyClient").setRequestMarshaller(ProtoUtils.marshaller((Message)GetIdentityAwareProxyClientRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IdentityAwareProxyClient.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/ResetIdentityAwareProxyClientSecret").setRequestMarshaller(ProtoUtils.marshaller((Message)ResetIdentityAwareProxyClientSecretRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)IdentityAwareProxyClient.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.iap.v1.IdentityAwareProxyOAuthService/DeleteIdentityAwareProxyClient").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteIdentityAwareProxyClientRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListBrandsRequest, ListBrandsResponse> listBrandsCallable;
    private final UnaryCallable<CreateBrandRequest, Brand> createBrandCallable;
    private final UnaryCallable<GetBrandRequest, Brand> getBrandCallable;
    private final UnaryCallable<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientCallable;
    private final UnaryCallable<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsCallable;
    private final UnaryCallable<ListIdentityAwareProxyClientsRequest, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsPagedCallable;
    private final UnaryCallable<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientCallable;
    private final UnaryCallable<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretCallable;
    private final UnaryCallable<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIdentityAwareProxyOAuthServiceStub create(IdentityAwareProxyOAuthServiceStubSettings settings) throws IOException {
        return new GrpcIdentityAwareProxyOAuthServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIdentityAwareProxyOAuthServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIdentityAwareProxyOAuthServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIdentityAwareProxyOAuthServiceCallableFactory());
    }

    protected GrpcIdentityAwareProxyOAuthServiceStub(IdentityAwareProxyOAuthServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listBrandsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBrandsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings createBrandTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBrandMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getBrandTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBrandMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createIdentityAwareProxyClientTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createIdentityAwareProxyClientMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listIdentityAwareProxyClientsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listIdentityAwareProxyClientsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getIdentityAwareProxyClientTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getIdentityAwareProxyClientMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings resetIdentityAwareProxyClientSecretTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(resetIdentityAwareProxyClientSecretMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteIdentityAwareProxyClientTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteIdentityAwareProxyClientMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listBrandsCallable = callableFactory.createUnaryCallable(listBrandsTransportSettings, settings.listBrandsSettings(), clientContext);
        this.createBrandCallable = callableFactory.createUnaryCallable(createBrandTransportSettings, settings.createBrandSettings(), clientContext);
        this.getBrandCallable = callableFactory.createUnaryCallable(getBrandTransportSettings, settings.getBrandSettings(), clientContext);
        this.createIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(createIdentityAwareProxyClientTransportSettings, settings.createIdentityAwareProxyClientSettings(), clientContext);
        this.listIdentityAwareProxyClientsCallable = callableFactory.createUnaryCallable(listIdentityAwareProxyClientsTransportSettings, settings.listIdentityAwareProxyClientsSettings(), clientContext);
        this.listIdentityAwareProxyClientsPagedCallable = callableFactory.createPagedCallable(listIdentityAwareProxyClientsTransportSettings, settings.listIdentityAwareProxyClientsSettings(), clientContext);
        this.getIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(getIdentityAwareProxyClientTransportSettings, settings.getIdentityAwareProxyClientSettings(), clientContext);
        this.resetIdentityAwareProxyClientSecretCallable = callableFactory.createUnaryCallable(resetIdentityAwareProxyClientSecretTransportSettings, settings.resetIdentityAwareProxyClientSecretSettings(), clientContext);
        this.deleteIdentityAwareProxyClientCallable = callableFactory.createUnaryCallable(deleteIdentityAwareProxyClientTransportSettings, settings.deleteIdentityAwareProxyClientSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListBrandsRequest, ListBrandsResponse> listBrandsCallable() {
        return this.listBrandsCallable;
    }

    @Override
    public UnaryCallable<CreateBrandRequest, Brand> createBrandCallable() {
        return this.createBrandCallable;
    }

    @Override
    public UnaryCallable<GetBrandRequest, Brand> getBrandCallable() {
        return this.getBrandCallable;
    }

    @Override
    public UnaryCallable<CreateIdentityAwareProxyClientRequest, IdentityAwareProxyClient> createIdentityAwareProxyClientCallable() {
        return this.createIdentityAwareProxyClientCallable;
    }

    @Override
    public UnaryCallable<ListIdentityAwareProxyClientsRequest, ListIdentityAwareProxyClientsResponse> listIdentityAwareProxyClientsCallable() {
        return this.listIdentityAwareProxyClientsCallable;
    }

    @Override
    public UnaryCallable<ListIdentityAwareProxyClientsRequest, IdentityAwareProxyOAuthServiceClient.ListIdentityAwareProxyClientsPagedResponse> listIdentityAwareProxyClientsPagedCallable() {
        return this.listIdentityAwareProxyClientsPagedCallable;
    }

    @Override
    public UnaryCallable<GetIdentityAwareProxyClientRequest, IdentityAwareProxyClient> getIdentityAwareProxyClientCallable() {
        return this.getIdentityAwareProxyClientCallable;
    }

    @Override
    public UnaryCallable<ResetIdentityAwareProxyClientSecretRequest, IdentityAwareProxyClient> resetIdentityAwareProxyClientSecretCallable() {
        return this.resetIdentityAwareProxyClientSecretCallable;
    }

    @Override
    public UnaryCallable<DeleteIdentityAwareProxyClientRequest, Empty> deleteIdentityAwareProxyClientCallable() {
        return this.deleteIdentityAwareProxyClientCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

