/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.credentials.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenResponse;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenResponse;
import com.google.cloud.iam.credentials.v1.SignBlobRequest;
import com.google.cloud.iam.credentials.v1.SignBlobResponse;
import com.google.cloud.iam.credentials.v1.SignJwtRequest;
import com.google.cloud.iam.credentials.v1.SignJwtResponse;
import com.google.cloud.iam.credentials.v1.stub.GrpcIamCredentialsCallableFactory;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStub;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcIamCredentialsStub
extends IamCredentialsStub {
    private static final MethodDescriptor<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.credentials.v1.IAMCredentials/GenerateAccessToken").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateAccessTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateAccessTokenResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.credentials.v1.IAMCredentials/GenerateIdToken").setRequestMarshaller(ProtoUtils.marshaller((Message)GenerateIdTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GenerateIdTokenResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SignBlobRequest, SignBlobResponse> signBlobMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.credentials.v1.IAMCredentials/SignBlob").setRequestMarshaller(ProtoUtils.marshaller((Message)SignBlobRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SignBlobResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<SignJwtRequest, SignJwtResponse> signJwtMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.iam.credentials.v1.IAMCredentials/SignJwt").setRequestMarshaller(ProtoUtils.marshaller((Message)SignJwtRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)SignJwtResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable;
    private final UnaryCallable<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenCallable;
    private final UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable;
    private final UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcIamCredentialsStub create(IamCredentialsStubSettings settings) throws IOException {
        return new GrpcIamCredentialsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcIamCredentialsStub create(ClientContext clientContext) throws IOException {
        return new GrpcIamCredentialsStub(IamCredentialsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcIamCredentialsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcIamCredentialsStub(IamCredentialsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcIamCredentialsStub(IamCredentialsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcIamCredentialsCallableFactory());
    }

    protected GrpcIamCredentialsStub(IamCredentialsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings generateAccessTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateAccessTokenMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings generateIdTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(generateIdTokenMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings signBlobTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(signBlobMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings signJwtTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(signJwtMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.generateAccessTokenCallable = callableFactory.createUnaryCallable(generateAccessTokenTransportSettings, settings.generateAccessTokenSettings(), clientContext);
        this.generateIdTokenCallable = callableFactory.createUnaryCallable(generateIdTokenTransportSettings, settings.generateIdTokenSettings(), clientContext);
        this.signBlobCallable = callableFactory.createUnaryCallable(signBlobTransportSettings, settings.signBlobSettings(), clientContext);
        this.signJwtCallable = callableFactory.createUnaryCallable(signJwtTransportSettings, settings.signJwtSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.generateAccessTokenCallable;
    }

    @Override
    public UnaryCallable<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenCallable() {
        return this.generateIdTokenCallable;
    }

    @Override
    public UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable() {
        return this.signBlobCallable;
    }

    @Override
    public UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable() {
        return this.signJwtCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

