/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.credentials.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenResponse;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenResponse;
import com.google.cloud.iam.credentials.v1.SignBlobRequest;
import com.google.cloud.iam.credentials.v1.SignBlobResponse;
import com.google.cloud.iam.credentials.v1.SignJwtRequest;
import com.google.cloud.iam.credentials.v1.SignJwtResponse;
import com.google.cloud.iam.credentials.v1.stub.HttpJsonIamCredentialsCallableFactory;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStub;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStubSettings;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonIamCredentialsStub
extends IamCredentialsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.credentials.v1.IAMCredentials/GenerateAccessToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/serviceAccounts/*}:generateAccessToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateAccessTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.credentials.v1.IAMCredentials/GenerateIdToken").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/serviceAccounts/*}:generateIdToken", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)GenerateIdTokenResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SignBlobRequest, SignBlobResponse> signBlobMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.credentials.v1.IAMCredentials/SignBlob").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/serviceAccounts/*}:signBlob", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SignBlobResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SignJwtRequest, SignJwtResponse> signJwtMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.iam.credentials.v1.IAMCredentials/SignJwt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/serviceAccounts/*}:signJwt", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)SignJwtResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable;
    private final UnaryCallable<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenCallable;
    private final UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable;
    private final UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonIamCredentialsStub create(IamCredentialsStubSettings settings) throws IOException {
        return new HttpJsonIamCredentialsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonIamCredentialsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonIamCredentialsStub(IamCredentialsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonIamCredentialsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonIamCredentialsStub(IamCredentialsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonIamCredentialsStub(IamCredentialsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonIamCredentialsCallableFactory());
    }

    protected HttpJsonIamCredentialsStub(IamCredentialsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings generateAccessTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateAccessTokenMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings generateIdTokenTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(generateIdTokenMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings signBlobTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(signBlobMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings signJwtTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(signJwtMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.generateAccessTokenCallable = callableFactory.createUnaryCallable(generateAccessTokenTransportSettings, settings.generateAccessTokenSettings(), clientContext);
        this.generateIdTokenCallable = callableFactory.createUnaryCallable(generateIdTokenTransportSettings, settings.generateIdTokenSettings(), clientContext);
        this.signBlobCallable = callableFactory.createUnaryCallable(signBlobTransportSettings, settings.signBlobSettings(), clientContext);
        this.signJwtCallable = callableFactory.createUnaryCallable(signJwtTransportSettings, settings.signJwtSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(generateAccessTokenMethodDescriptor);
        methodDescriptors.add(generateIdTokenMethodDescriptor);
        methodDescriptors.add(signBlobMethodDescriptor);
        methodDescriptors.add(signJwtMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.generateAccessTokenCallable;
    }

    @Override
    public UnaryCallable<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenCallable() {
        return this.generateIdTokenCallable;
    }

    @Override
    public UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable() {
        return this.signBlobCallable;
    }

    @Override
    public UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable() {
        return this.signJwtCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

