/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.iam.credentials.v1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateAccessTokenResponse;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenRequest;
import com.google.cloud.iam.credentials.v1.GenerateIdTokenResponse;
import com.google.cloud.iam.credentials.v1.IamCredentialsSettings;
import com.google.cloud.iam.credentials.v1.ServiceAccountName;
import com.google.cloud.iam.credentials.v1.SignBlobRequest;
import com.google.cloud.iam.credentials.v1.SignBlobResponse;
import com.google.cloud.iam.credentials.v1.SignJwtRequest;
import com.google.cloud.iam.credentials.v1.SignJwtResponse;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStub;
import com.google.cloud.iam.credentials.v1.stub.IamCredentialsStubSettings;
import com.google.protobuf.ByteString;
import com.google.protobuf.Duration;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class IamCredentialsClient
implements BackgroundResource {
    private final IamCredentialsSettings settings;
    private final IamCredentialsStub stub;

    public static final IamCredentialsClient create() throws IOException {
        return IamCredentialsClient.create(IamCredentialsSettings.newBuilder().build());
    }

    public static final IamCredentialsClient create(IamCredentialsSettings settings) throws IOException {
        return new IamCredentialsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final IamCredentialsClient create(IamCredentialsStub stub) {
        return new IamCredentialsClient(stub);
    }

    protected IamCredentialsClient(IamCredentialsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((IamCredentialsStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected IamCredentialsClient(IamCredentialsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final IamCredentialsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public IamCredentialsStub getStub() {
        return this.stub;
    }

    public final GenerateAccessTokenResponse generateAccessToken(ServiceAccountName name, List<String> delegates, List<String> scope, Duration lifetime) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setName(name == null ? null : name.toString()).addAllDelegates(delegates).addAllScope(scope).setLifetime(lifetime).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(String name, List<String> delegates, List<String> scope, Duration lifetime) {
        GenerateAccessTokenRequest request = GenerateAccessTokenRequest.newBuilder().setName(name).addAllDelegates(delegates).addAllScope(scope).setLifetime(lifetime).build();
        return this.generateAccessToken(request);
    }

    public final GenerateAccessTokenResponse generateAccessToken(GenerateAccessTokenRequest request) {
        return (GenerateAccessTokenResponse)this.generateAccessTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateAccessTokenRequest, GenerateAccessTokenResponse> generateAccessTokenCallable() {
        return this.stub.generateAccessTokenCallable();
    }

    public final GenerateIdTokenResponse generateIdToken(ServiceAccountName name, List<String> delegates, String audience, boolean includeEmail) {
        GenerateIdTokenRequest request = GenerateIdTokenRequest.newBuilder().setName(name == null ? null : name.toString()).addAllDelegates(delegates).setAudience(audience).setIncludeEmail(includeEmail).build();
        return this.generateIdToken(request);
    }

    public final GenerateIdTokenResponse generateIdToken(String name, List<String> delegates, String audience, boolean includeEmail) {
        GenerateIdTokenRequest request = GenerateIdTokenRequest.newBuilder().setName(name).addAllDelegates(delegates).setAudience(audience).setIncludeEmail(includeEmail).build();
        return this.generateIdToken(request);
    }

    public final GenerateIdTokenResponse generateIdToken(GenerateIdTokenRequest request) {
        return (GenerateIdTokenResponse)this.generateIdTokenCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateIdTokenRequest, GenerateIdTokenResponse> generateIdTokenCallable() {
        return this.stub.generateIdTokenCallable();
    }

    public final SignBlobResponse signBlob(ServiceAccountName name, List<String> delegates, ByteString payload) {
        SignBlobRequest request = SignBlobRequest.newBuilder().setName(name == null ? null : name.toString()).addAllDelegates(delegates).setPayload(payload).build();
        return this.signBlob(request);
    }

    public final SignBlobResponse signBlob(String name, List<String> delegates, ByteString payload) {
        SignBlobRequest request = SignBlobRequest.newBuilder().setName(name).addAllDelegates(delegates).setPayload(payload).build();
        return this.signBlob(request);
    }

    public final SignBlobResponse signBlob(SignBlobRequest request) {
        return (SignBlobResponse)this.signBlobCallable().call((Object)request);
    }

    public final UnaryCallable<SignBlobRequest, SignBlobResponse> signBlobCallable() {
        return this.stub.signBlobCallable();
    }

    public final SignJwtResponse signJwt(ServiceAccountName name, List<String> delegates, String payload) {
        SignJwtRequest request = SignJwtRequest.newBuilder().setName(name == null ? null : name.toString()).addAllDelegates(delegates).setPayload(payload).build();
        return this.signJwt(request);
    }

    public final SignJwtResponse signJwt(String name, List<String> delegates, String payload) {
        SignJwtRequest request = SignJwtRequest.newBuilder().setName(name).addAllDelegates(delegates).setPayload(payload).build();
        return this.signJwt(request);
    }

    public final SignJwtResponse signJwt(SignJwtRequest request) {
        return (SignJwtResponse)this.signJwtCallable().call((Object)request);
    }

    public final UnaryCallable<SignJwtRequest, SignJwtResponse> signJwtCallable() {
        return this.stub.signJwtCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

