/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gsuiteaddons.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gsuiteaddons.v1.Authorization;
import com.google.cloud.gsuiteaddons.v1.CreateDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.DeleteDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.Deployment;
import com.google.cloud.gsuiteaddons.v1.GSuiteAddOnsClient;
import com.google.cloud.gsuiteaddons.v1.GetAuthorizationRequest;
import com.google.cloud.gsuiteaddons.v1.GetDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.GetInstallStatusRequest;
import com.google.cloud.gsuiteaddons.v1.InstallDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.InstallStatus;
import com.google.cloud.gsuiteaddons.v1.ListDeploymentsRequest;
import com.google.cloud.gsuiteaddons.v1.ListDeploymentsResponse;
import com.google.cloud.gsuiteaddons.v1.ReplaceDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.UninstallDeploymentRequest;
import com.google.cloud.gsuiteaddons.v1.stub.GSuiteAddOnsStub;
import com.google.cloud.gsuiteaddons.v1.stub.GrpcGSuiteAddOnsStub;
import com.google.cloud.gsuiteaddons.v1.stub.HttpJsonGSuiteAddOnsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class GSuiteAddOnsStubSettings
extends StubSettings<GSuiteAddOnsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetAuthorizationRequest, Authorization> getAuthorizationSettings;
    private final UnaryCallSettings<CreateDeploymentRequest, Deployment> createDeploymentSettings;
    private final UnaryCallSettings<ReplaceDeploymentRequest, Deployment> replaceDeploymentSettings;
    private final UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings;
    private final PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
    private final UnaryCallSettings<DeleteDeploymentRequest, Empty> deleteDeploymentSettings;
    private final UnaryCallSettings<InstallDeploymentRequest, Empty> installDeploymentSettings;
    private final UnaryCallSettings<UninstallDeploymentRequest, Empty> uninstallDeploymentSettings;
    private final UnaryCallSettings<GetInstallStatusRequest, InstallStatus> getInstallStatusSettings;
    private static final PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> LIST_DEPLOYMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>(){

        public String emptyToken() {
            return "";
        }

        public ListDeploymentsRequest injectToken(ListDeploymentsRequest payload, String token) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageToken(token).build();
        }

        public ListDeploymentsRequest injectPageSize(ListDeploymentsRequest payload, int pageSize) {
            return ListDeploymentsRequest.newBuilder((ListDeploymentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeploymentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeploymentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Deployment> extractResources(ListDeploymentsResponse payload) {
            return payload.getDeploymentsList() == null ? ImmutableList.of() : payload.getDeploymentsList();
        }
    };
    private static final PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse> LIST_DEPLOYMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse>(){

        public ApiFuture<GSuiteAddOnsClient.ListDeploymentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> callable, ListDeploymentsRequest request, ApiCallContext context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEPLOYMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GSuiteAddOnsClient.ListDeploymentsPagedResponse.createAsync((PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetAuthorizationRequest, Authorization> getAuthorizationSettings() {
        return this.getAuthorizationSettings;
    }

    public UnaryCallSettings<CreateDeploymentRequest, Deployment> createDeploymentSettings() {
        return this.createDeploymentSettings;
    }

    public UnaryCallSettings<ReplaceDeploymentRequest, Deployment> replaceDeploymentSettings() {
        return this.replaceDeploymentSettings;
    }

    public UnaryCallSettings<GetDeploymentRequest, Deployment> getDeploymentSettings() {
        return this.getDeploymentSettings;
    }

    public PagedCallSettings<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
        return this.listDeploymentsSettings;
    }

    public UnaryCallSettings<DeleteDeploymentRequest, Empty> deleteDeploymentSettings() {
        return this.deleteDeploymentSettings;
    }

    public UnaryCallSettings<InstallDeploymentRequest, Empty> installDeploymentSettings() {
        return this.installDeploymentSettings;
    }

    public UnaryCallSettings<UninstallDeploymentRequest, Empty> uninstallDeploymentSettings() {
        return this.uninstallDeploymentSettings;
    }

    public UnaryCallSettings<GetInstallStatusRequest, InstallStatus> getInstallStatusSettings() {
        return this.getInstallStatusSettings;
    }

    public GSuiteAddOnsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGSuiteAddOnsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGSuiteAddOnsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return GSuiteAddOnsStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "gsuiteaddons";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gsuiteaddons.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gsuiteaddons.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GSuiteAddOnsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GSuiteAddOnsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GSuiteAddOnsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return GSuiteAddOnsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GSuiteAddOnsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getAuthorizationSettings = settingsBuilder.getAuthorizationSettings().build();
        this.createDeploymentSettings = settingsBuilder.createDeploymentSettings().build();
        this.replaceDeploymentSettings = settingsBuilder.replaceDeploymentSettings().build();
        this.getDeploymentSettings = settingsBuilder.getDeploymentSettings().build();
        this.listDeploymentsSettings = settingsBuilder.listDeploymentsSettings().build();
        this.deleteDeploymentSettings = settingsBuilder.deleteDeploymentSettings().build();
        this.installDeploymentSettings = settingsBuilder.installDeploymentSettings().build();
        this.uninstallDeploymentSettings = settingsBuilder.uninstallDeploymentSettings().build();
        this.getInstallStatusSettings = settingsBuilder.getInstallStatusSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GSuiteAddOnsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetAuthorizationRequest, Authorization> getAuthorizationSettings;
        private final UnaryCallSettings.Builder<CreateDeploymentRequest, Deployment> createDeploymentSettings;
        private final UnaryCallSettings.Builder<ReplaceDeploymentRequest, Deployment> replaceDeploymentSettings;
        private final UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings;
        private final PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse> listDeploymentsSettings;
        private final UnaryCallSettings.Builder<DeleteDeploymentRequest, Empty> deleteDeploymentSettings;
        private final UnaryCallSettings.Builder<InstallDeploymentRequest, Empty> installDeploymentSettings;
        private final UnaryCallSettings.Builder<UninstallDeploymentRequest, Empty> uninstallDeploymentSettings;
        private final UnaryCallSettings.Builder<GetInstallStatusRequest, InstallStatus> getInstallStatusSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getAuthorizationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.replaceDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeploymentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEPLOYMENTS_PAGE_STR_FACT);
            this.deleteDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.installDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.uninstallDeploymentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getInstallStatusSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAuthorizationSettings, this.createDeploymentSettings, this.replaceDeploymentSettings, this.getDeploymentSettings, this.listDeploymentsSettings, this.deleteDeploymentSettings, this.installDeploymentSettings, this.uninstallDeploymentSettings, this.getInstallStatusSettings);
            Builder.initDefaults(this);
        }

        protected Builder(GSuiteAddOnsStubSettings settings) {
            super((StubSettings)settings);
            this.getAuthorizationSettings = settings.getAuthorizationSettings.toBuilder();
            this.createDeploymentSettings = settings.createDeploymentSettings.toBuilder();
            this.replaceDeploymentSettings = settings.replaceDeploymentSettings.toBuilder();
            this.getDeploymentSettings = settings.getDeploymentSettings.toBuilder();
            this.listDeploymentsSettings = settings.listDeploymentsSettings.toBuilder();
            this.deleteDeploymentSettings = settings.deleteDeploymentSettings.toBuilder();
            this.installDeploymentSettings = settings.installDeploymentSettings.toBuilder();
            this.uninstallDeploymentSettings = settings.uninstallDeploymentSettings.toBuilder();
            this.getInstallStatusSettings = settings.getInstallStatusSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getAuthorizationSettings, this.createDeploymentSettings, this.replaceDeploymentSettings, this.getDeploymentSettings, this.listDeploymentsSettings, this.deleteDeploymentSettings, this.installDeploymentSettings, this.uninstallDeploymentSettings, this.getInstallStatusSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GSuiteAddOnsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GSuiteAddOnsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GSuiteAddOnsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GSuiteAddOnsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)GSuiteAddOnsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)GSuiteAddOnsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GSuiteAddOnsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(GSuiteAddOnsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getAuthorizationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.createDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.replaceDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDeploymentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.installDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.uninstallDeploymentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInstallStatusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetAuthorizationRequest, Authorization> getAuthorizationSettings() {
            return this.getAuthorizationSettings;
        }

        public UnaryCallSettings.Builder<CreateDeploymentRequest, Deployment> createDeploymentSettings() {
            return this.createDeploymentSettings;
        }

        public UnaryCallSettings.Builder<ReplaceDeploymentRequest, Deployment> replaceDeploymentSettings() {
            return this.replaceDeploymentSettings;
        }

        public UnaryCallSettings.Builder<GetDeploymentRequest, Deployment> getDeploymentSettings() {
            return this.getDeploymentSettings;
        }

        public PagedCallSettings.Builder<ListDeploymentsRequest, ListDeploymentsResponse, GSuiteAddOnsClient.ListDeploymentsPagedResponse> listDeploymentsSettings() {
            return this.listDeploymentsSettings;
        }

        public UnaryCallSettings.Builder<DeleteDeploymentRequest, Empty> deleteDeploymentSettings() {
            return this.deleteDeploymentSettings;
        }

        public UnaryCallSettings.Builder<InstallDeploymentRequest, Empty> installDeploymentSettings() {
            return this.installDeploymentSettings;
        }

        public UnaryCallSettings.Builder<UninstallDeploymentRequest, Empty> uninstallDeploymentSettings() {
            return this.uninstallDeploymentSettings;
        }

        public UnaryCallSettings.Builder<GetInstallStatusRequest, InstallStatus> getInstallStatusSettings() {
            return this.getInstallStatusSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return GSuiteAddOnsStubSettings.getDefaultEndpoint();
        }

        public GSuiteAddOnsStubSettings build() throws IOException {
            return new GSuiteAddOnsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.UNKNOWN})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)10000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)10000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)10000L)).setTotalTimeout(Duration.ofMillis((long)10000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

