/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gkemulticloud.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gkemulticloud.v1.AwsCluster;
import com.google.cloud.gkemulticloud.v1.AwsClustersClient;
import com.google.cloud.gkemulticloud.v1.AwsJsonWebKeys;
import com.google.cloud.gkemulticloud.v1.AwsNodePool;
import com.google.cloud.gkemulticloud.v1.AwsOpenIdConfig;
import com.google.cloud.gkemulticloud.v1.AwsServerConfig;
import com.google.cloud.gkemulticloud.v1.CreateAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.CreateAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.DeleteAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAwsAccessTokenResponse;
import com.google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenRequest;
import com.google.cloud.gkemulticloud.v1.GenerateAwsClusterAgentTokenResponse;
import com.google.cloud.gkemulticloud.v1.GetAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsJsonWebKeysRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsOpenIdConfigRequest;
import com.google.cloud.gkemulticloud.v1.GetAwsServerConfigRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsClustersRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsClustersResponse;
import com.google.cloud.gkemulticloud.v1.ListAwsNodePoolsRequest;
import com.google.cloud.gkemulticloud.v1.ListAwsNodePoolsResponse;
import com.google.cloud.gkemulticloud.v1.OperationMetadata;
import com.google.cloud.gkemulticloud.v1.RollbackAwsNodePoolUpdateRequest;
import com.google.cloud.gkemulticloud.v1.UpdateAwsClusterRequest;
import com.google.cloud.gkemulticloud.v1.UpdateAwsNodePoolRequest;
import com.google.cloud.gkemulticloud.v1.stub.AwsClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.GrpcAwsClustersStub;
import com.google.cloud.gkemulticloud.v1.stub.HttpJsonAwsClustersStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class AwsClustersStubSettings
extends StubSettings<AwsClustersStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateAwsClusterRequest, Operation> createAwsClusterSettings;
    private final OperationCallSettings<CreateAwsClusterRequest, AwsCluster, OperationMetadata> createAwsClusterOperationSettings;
    private final UnaryCallSettings<UpdateAwsClusterRequest, Operation> updateAwsClusterSettings;
    private final OperationCallSettings<UpdateAwsClusterRequest, AwsCluster, OperationMetadata> updateAwsClusterOperationSettings;
    private final UnaryCallSettings<GetAwsClusterRequest, AwsCluster> getAwsClusterSettings;
    private final PagedCallSettings<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse> listAwsClustersSettings;
    private final UnaryCallSettings<DeleteAwsClusterRequest, Operation> deleteAwsClusterSettings;
    private final OperationCallSettings<DeleteAwsClusterRequest, Empty, OperationMetadata> deleteAwsClusterOperationSettings;
    private final UnaryCallSettings<GenerateAwsClusterAgentTokenRequest, GenerateAwsClusterAgentTokenResponse> generateAwsClusterAgentTokenSettings;
    private final UnaryCallSettings<GenerateAwsAccessTokenRequest, GenerateAwsAccessTokenResponse> generateAwsAccessTokenSettings;
    private final UnaryCallSettings<CreateAwsNodePoolRequest, Operation> createAwsNodePoolSettings;
    private final OperationCallSettings<CreateAwsNodePoolRequest, AwsNodePool, OperationMetadata> createAwsNodePoolOperationSettings;
    private final UnaryCallSettings<UpdateAwsNodePoolRequest, Operation> updateAwsNodePoolSettings;
    private final OperationCallSettings<UpdateAwsNodePoolRequest, AwsNodePool, OperationMetadata> updateAwsNodePoolOperationSettings;
    private final UnaryCallSettings<RollbackAwsNodePoolUpdateRequest, Operation> rollbackAwsNodePoolUpdateSettings;
    private final OperationCallSettings<RollbackAwsNodePoolUpdateRequest, AwsNodePool, OperationMetadata> rollbackAwsNodePoolUpdateOperationSettings;
    private final UnaryCallSettings<GetAwsNodePoolRequest, AwsNodePool> getAwsNodePoolSettings;
    private final PagedCallSettings<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse> listAwsNodePoolsSettings;
    private final UnaryCallSettings<DeleteAwsNodePoolRequest, Operation> deleteAwsNodePoolSettings;
    private final OperationCallSettings<DeleteAwsNodePoolRequest, Empty, OperationMetadata> deleteAwsNodePoolOperationSettings;
    private final UnaryCallSettings<GetAwsOpenIdConfigRequest, AwsOpenIdConfig> getAwsOpenIdConfigSettings;
    private final UnaryCallSettings<GetAwsJsonWebKeysRequest, AwsJsonWebKeys> getAwsJsonWebKeysSettings;
    private final UnaryCallSettings<GetAwsServerConfigRequest, AwsServerConfig> getAwsServerConfigSettings;
    private static final PagedListDescriptor<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster> LIST_AWS_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListAwsClustersRequest injectToken(ListAwsClustersRequest payload, String token) {
            return ListAwsClustersRequest.newBuilder((ListAwsClustersRequest)payload).setPageToken(token).build();
        }

        public ListAwsClustersRequest injectPageSize(ListAwsClustersRequest payload, int pageSize) {
            return ListAwsClustersRequest.newBuilder((ListAwsClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAwsClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAwsClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AwsCluster> extractResources(ListAwsClustersResponse payload) {
            return payload.getAwsClustersList() == null ? ImmutableList.of() : payload.getAwsClustersList();
        }
    };
    private static final PagedListDescriptor<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool> LIST_AWS_NODE_POOLS_PAGE_STR_DESC = new PagedListDescriptor<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool>(){

        public String emptyToken() {
            return "";
        }

        public ListAwsNodePoolsRequest injectToken(ListAwsNodePoolsRequest payload, String token) {
            return ListAwsNodePoolsRequest.newBuilder((ListAwsNodePoolsRequest)payload).setPageToken(token).build();
        }

        public ListAwsNodePoolsRequest injectPageSize(ListAwsNodePoolsRequest payload, int pageSize) {
            return ListAwsNodePoolsRequest.newBuilder((ListAwsNodePoolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAwsNodePoolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAwsNodePoolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AwsNodePool> extractResources(ListAwsNodePoolsResponse payload) {
            return payload.getAwsNodePoolsList() == null ? ImmutableList.of() : payload.getAwsNodePoolsList();
        }
    };
    private static final PagedListResponseFactory<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse> LIST_AWS_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse>(){

        public ApiFuture<AwsClustersClient.ListAwsClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListAwsClustersRequest, ListAwsClustersResponse> callable, ListAwsClustersRequest request, ApiCallContext context, ApiFuture<ListAwsClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AWS_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AwsClustersClient.ListAwsClustersPagedResponse.createAsync((PageContext<ListAwsClustersRequest, ListAwsClustersResponse, AwsCluster>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse> LIST_AWS_NODE_POOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse>(){

        public ApiFuture<AwsClustersClient.ListAwsNodePoolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse> callable, ListAwsNodePoolsRequest request, ApiCallContext context, ApiFuture<ListAwsNodePoolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_AWS_NODE_POOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return AwsClustersClient.ListAwsNodePoolsPagedResponse.createAsync((PageContext<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsNodePool>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateAwsClusterRequest, Operation> createAwsClusterSettings() {
        return this.createAwsClusterSettings;
    }

    public OperationCallSettings<CreateAwsClusterRequest, AwsCluster, OperationMetadata> createAwsClusterOperationSettings() {
        return this.createAwsClusterOperationSettings;
    }

    public UnaryCallSettings<UpdateAwsClusterRequest, Operation> updateAwsClusterSettings() {
        return this.updateAwsClusterSettings;
    }

    public OperationCallSettings<UpdateAwsClusterRequest, AwsCluster, OperationMetadata> updateAwsClusterOperationSettings() {
        return this.updateAwsClusterOperationSettings;
    }

    public UnaryCallSettings<GetAwsClusterRequest, AwsCluster> getAwsClusterSettings() {
        return this.getAwsClusterSettings;
    }

    public PagedCallSettings<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse> listAwsClustersSettings() {
        return this.listAwsClustersSettings;
    }

    public UnaryCallSettings<DeleteAwsClusterRequest, Operation> deleteAwsClusterSettings() {
        return this.deleteAwsClusterSettings;
    }

    public OperationCallSettings<DeleteAwsClusterRequest, Empty, OperationMetadata> deleteAwsClusterOperationSettings() {
        return this.deleteAwsClusterOperationSettings;
    }

    public UnaryCallSettings<GenerateAwsClusterAgentTokenRequest, GenerateAwsClusterAgentTokenResponse> generateAwsClusterAgentTokenSettings() {
        return this.generateAwsClusterAgentTokenSettings;
    }

    public UnaryCallSettings<GenerateAwsAccessTokenRequest, GenerateAwsAccessTokenResponse> generateAwsAccessTokenSettings() {
        return this.generateAwsAccessTokenSettings;
    }

    public UnaryCallSettings<CreateAwsNodePoolRequest, Operation> createAwsNodePoolSettings() {
        return this.createAwsNodePoolSettings;
    }

    public OperationCallSettings<CreateAwsNodePoolRequest, AwsNodePool, OperationMetadata> createAwsNodePoolOperationSettings() {
        return this.createAwsNodePoolOperationSettings;
    }

    public UnaryCallSettings<UpdateAwsNodePoolRequest, Operation> updateAwsNodePoolSettings() {
        return this.updateAwsNodePoolSettings;
    }

    public OperationCallSettings<UpdateAwsNodePoolRequest, AwsNodePool, OperationMetadata> updateAwsNodePoolOperationSettings() {
        return this.updateAwsNodePoolOperationSettings;
    }

    public UnaryCallSettings<RollbackAwsNodePoolUpdateRequest, Operation> rollbackAwsNodePoolUpdateSettings() {
        return this.rollbackAwsNodePoolUpdateSettings;
    }

    public OperationCallSettings<RollbackAwsNodePoolUpdateRequest, AwsNodePool, OperationMetadata> rollbackAwsNodePoolUpdateOperationSettings() {
        return this.rollbackAwsNodePoolUpdateOperationSettings;
    }

    public UnaryCallSettings<GetAwsNodePoolRequest, AwsNodePool> getAwsNodePoolSettings() {
        return this.getAwsNodePoolSettings;
    }

    public PagedCallSettings<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse> listAwsNodePoolsSettings() {
        return this.listAwsNodePoolsSettings;
    }

    public UnaryCallSettings<DeleteAwsNodePoolRequest, Operation> deleteAwsNodePoolSettings() {
        return this.deleteAwsNodePoolSettings;
    }

    public OperationCallSettings<DeleteAwsNodePoolRequest, Empty, OperationMetadata> deleteAwsNodePoolOperationSettings() {
        return this.deleteAwsNodePoolOperationSettings;
    }

    public UnaryCallSettings<GetAwsOpenIdConfigRequest, AwsOpenIdConfig> getAwsOpenIdConfigSettings() {
        return this.getAwsOpenIdConfigSettings;
    }

    public UnaryCallSettings<GetAwsJsonWebKeysRequest, AwsJsonWebKeys> getAwsJsonWebKeysSettings() {
        return this.getAwsJsonWebKeysSettings;
    }

    public UnaryCallSettings<GetAwsServerConfigRequest, AwsServerConfig> getAwsServerConfigSettings() {
        return this.getAwsServerConfigSettings;
    }

    public AwsClustersStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcAwsClustersStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonAwsClustersStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "gkemulticloud";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gkemulticloud.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "gkemulticloud.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return AwsClustersStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AwsClustersStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(AwsClustersStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return AwsClustersStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected AwsClustersStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createAwsClusterSettings = settingsBuilder.createAwsClusterSettings().build();
        this.createAwsClusterOperationSettings = settingsBuilder.createAwsClusterOperationSettings().build();
        this.updateAwsClusterSettings = settingsBuilder.updateAwsClusterSettings().build();
        this.updateAwsClusterOperationSettings = settingsBuilder.updateAwsClusterOperationSettings().build();
        this.getAwsClusterSettings = settingsBuilder.getAwsClusterSettings().build();
        this.listAwsClustersSettings = settingsBuilder.listAwsClustersSettings().build();
        this.deleteAwsClusterSettings = settingsBuilder.deleteAwsClusterSettings().build();
        this.deleteAwsClusterOperationSettings = settingsBuilder.deleteAwsClusterOperationSettings().build();
        this.generateAwsClusterAgentTokenSettings = settingsBuilder.generateAwsClusterAgentTokenSettings().build();
        this.generateAwsAccessTokenSettings = settingsBuilder.generateAwsAccessTokenSettings().build();
        this.createAwsNodePoolSettings = settingsBuilder.createAwsNodePoolSettings().build();
        this.createAwsNodePoolOperationSettings = settingsBuilder.createAwsNodePoolOperationSettings().build();
        this.updateAwsNodePoolSettings = settingsBuilder.updateAwsNodePoolSettings().build();
        this.updateAwsNodePoolOperationSettings = settingsBuilder.updateAwsNodePoolOperationSettings().build();
        this.rollbackAwsNodePoolUpdateSettings = settingsBuilder.rollbackAwsNodePoolUpdateSettings().build();
        this.rollbackAwsNodePoolUpdateOperationSettings = settingsBuilder.rollbackAwsNodePoolUpdateOperationSettings().build();
        this.getAwsNodePoolSettings = settingsBuilder.getAwsNodePoolSettings().build();
        this.listAwsNodePoolsSettings = settingsBuilder.listAwsNodePoolsSettings().build();
        this.deleteAwsNodePoolSettings = settingsBuilder.deleteAwsNodePoolSettings().build();
        this.deleteAwsNodePoolOperationSettings = settingsBuilder.deleteAwsNodePoolOperationSettings().build();
        this.getAwsOpenIdConfigSettings = settingsBuilder.getAwsOpenIdConfigSettings().build();
        this.getAwsJsonWebKeysSettings = settingsBuilder.getAwsJsonWebKeysSettings().build();
        this.getAwsServerConfigSettings = settingsBuilder.getAwsServerConfigSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<AwsClustersStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateAwsClusterRequest, Operation> createAwsClusterSettings;
        private final OperationCallSettings.Builder<CreateAwsClusterRequest, AwsCluster, OperationMetadata> createAwsClusterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAwsClusterRequest, Operation> updateAwsClusterSettings;
        private final OperationCallSettings.Builder<UpdateAwsClusterRequest, AwsCluster, OperationMetadata> updateAwsClusterOperationSettings;
        private final UnaryCallSettings.Builder<GetAwsClusterRequest, AwsCluster> getAwsClusterSettings;
        private final PagedCallSettings.Builder<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse> listAwsClustersSettings;
        private final UnaryCallSettings.Builder<DeleteAwsClusterRequest, Operation> deleteAwsClusterSettings;
        private final OperationCallSettings.Builder<DeleteAwsClusterRequest, Empty, OperationMetadata> deleteAwsClusterOperationSettings;
        private final UnaryCallSettings.Builder<GenerateAwsClusterAgentTokenRequest, GenerateAwsClusterAgentTokenResponse> generateAwsClusterAgentTokenSettings;
        private final UnaryCallSettings.Builder<GenerateAwsAccessTokenRequest, GenerateAwsAccessTokenResponse> generateAwsAccessTokenSettings;
        private final UnaryCallSettings.Builder<CreateAwsNodePoolRequest, Operation> createAwsNodePoolSettings;
        private final OperationCallSettings.Builder<CreateAwsNodePoolRequest, AwsNodePool, OperationMetadata> createAwsNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<UpdateAwsNodePoolRequest, Operation> updateAwsNodePoolSettings;
        private final OperationCallSettings.Builder<UpdateAwsNodePoolRequest, AwsNodePool, OperationMetadata> updateAwsNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<RollbackAwsNodePoolUpdateRequest, Operation> rollbackAwsNodePoolUpdateSettings;
        private final OperationCallSettings.Builder<RollbackAwsNodePoolUpdateRequest, AwsNodePool, OperationMetadata> rollbackAwsNodePoolUpdateOperationSettings;
        private final UnaryCallSettings.Builder<GetAwsNodePoolRequest, AwsNodePool> getAwsNodePoolSettings;
        private final PagedCallSettings.Builder<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse> listAwsNodePoolsSettings;
        private final UnaryCallSettings.Builder<DeleteAwsNodePoolRequest, Operation> deleteAwsNodePoolSettings;
        private final OperationCallSettings.Builder<DeleteAwsNodePoolRequest, Empty, OperationMetadata> deleteAwsNodePoolOperationSettings;
        private final UnaryCallSettings.Builder<GetAwsOpenIdConfigRequest, AwsOpenIdConfig> getAwsOpenIdConfigSettings;
        private final UnaryCallSettings.Builder<GetAwsJsonWebKeysRequest, AwsJsonWebKeys> getAwsJsonWebKeysSettings;
        private final UnaryCallSettings.Builder<GetAwsServerConfigRequest, AwsServerConfig> getAwsServerConfigSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createAwsClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAwsClusterOperationSettings = OperationCallSettings.newBuilder();
            this.updateAwsClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAwsClusterOperationSettings = OperationCallSettings.newBuilder();
            this.getAwsClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAwsClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AWS_CLUSTERS_PAGE_STR_FACT);
            this.deleteAwsClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAwsClusterOperationSettings = OperationCallSettings.newBuilder();
            this.generateAwsClusterAgentTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.generateAwsAccessTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAwsNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAwsNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.updateAwsNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAwsNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.rollbackAwsNodePoolUpdateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.rollbackAwsNodePoolUpdateOperationSettings = OperationCallSettings.newBuilder();
            this.getAwsNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAwsNodePoolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_AWS_NODE_POOLS_PAGE_STR_FACT);
            this.deleteAwsNodePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteAwsNodePoolOperationSettings = OperationCallSettings.newBuilder();
            this.getAwsOpenIdConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAwsJsonWebKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAwsServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAwsClusterSettings, this.updateAwsClusterSettings, this.getAwsClusterSettings, this.listAwsClustersSettings, this.deleteAwsClusterSettings, this.generateAwsClusterAgentTokenSettings, this.generateAwsAccessTokenSettings, this.createAwsNodePoolSettings, this.updateAwsNodePoolSettings, this.rollbackAwsNodePoolUpdateSettings, this.getAwsNodePoolSettings, this.listAwsNodePoolsSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteAwsNodePoolSettings, this.getAwsOpenIdConfigSettings, this.getAwsJsonWebKeysSettings, this.getAwsServerConfigSettings});
            Builder.initDefaults(this);
        }

        protected Builder(AwsClustersStubSettings settings) {
            super((StubSettings)settings);
            this.createAwsClusterSettings = settings.createAwsClusterSettings.toBuilder();
            this.createAwsClusterOperationSettings = settings.createAwsClusterOperationSettings.toBuilder();
            this.updateAwsClusterSettings = settings.updateAwsClusterSettings.toBuilder();
            this.updateAwsClusterOperationSettings = settings.updateAwsClusterOperationSettings.toBuilder();
            this.getAwsClusterSettings = settings.getAwsClusterSettings.toBuilder();
            this.listAwsClustersSettings = settings.listAwsClustersSettings.toBuilder();
            this.deleteAwsClusterSettings = settings.deleteAwsClusterSettings.toBuilder();
            this.deleteAwsClusterOperationSettings = settings.deleteAwsClusterOperationSettings.toBuilder();
            this.generateAwsClusterAgentTokenSettings = settings.generateAwsClusterAgentTokenSettings.toBuilder();
            this.generateAwsAccessTokenSettings = settings.generateAwsAccessTokenSettings.toBuilder();
            this.createAwsNodePoolSettings = settings.createAwsNodePoolSettings.toBuilder();
            this.createAwsNodePoolOperationSettings = settings.createAwsNodePoolOperationSettings.toBuilder();
            this.updateAwsNodePoolSettings = settings.updateAwsNodePoolSettings.toBuilder();
            this.updateAwsNodePoolOperationSettings = settings.updateAwsNodePoolOperationSettings.toBuilder();
            this.rollbackAwsNodePoolUpdateSettings = settings.rollbackAwsNodePoolUpdateSettings.toBuilder();
            this.rollbackAwsNodePoolUpdateOperationSettings = settings.rollbackAwsNodePoolUpdateOperationSettings.toBuilder();
            this.getAwsNodePoolSettings = settings.getAwsNodePoolSettings.toBuilder();
            this.listAwsNodePoolsSettings = settings.listAwsNodePoolsSettings.toBuilder();
            this.deleteAwsNodePoolSettings = settings.deleteAwsNodePoolSettings.toBuilder();
            this.deleteAwsNodePoolOperationSettings = settings.deleteAwsNodePoolOperationSettings.toBuilder();
            this.getAwsOpenIdConfigSettings = settings.getAwsOpenIdConfigSettings.toBuilder();
            this.getAwsJsonWebKeysSettings = settings.getAwsJsonWebKeysSettings.toBuilder();
            this.getAwsServerConfigSettings = settings.getAwsServerConfigSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createAwsClusterSettings, this.updateAwsClusterSettings, this.getAwsClusterSettings, this.listAwsClustersSettings, this.deleteAwsClusterSettings, this.generateAwsClusterAgentTokenSettings, this.generateAwsAccessTokenSettings, this.createAwsNodePoolSettings, this.updateAwsNodePoolSettings, this.rollbackAwsNodePoolUpdateSettings, this.getAwsNodePoolSettings, this.listAwsNodePoolsSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteAwsNodePoolSettings, this.getAwsOpenIdConfigSettings, this.getAwsJsonWebKeysSettings, this.getAwsServerConfigSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(AwsClustersStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)AwsClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AwsClustersStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AwsClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)AwsClustersStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)AwsClustersStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)AwsClustersStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(AwsClustersStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createAwsClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAwsClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAwsClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAwsClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAwsClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.generateAwsClusterAgentTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.generateAwsAccessTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAwsNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateAwsNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.rollbackAwsNodePoolUpdateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAwsNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAwsNodePoolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAwsNodePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAwsOpenIdConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAwsJsonWebKeysSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getAwsServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAwsClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AwsCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAwsClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AwsCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAwsClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createAwsNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AwsNodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateAwsNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AwsNodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.rollbackAwsNodePoolUpdateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(AwsNodePool.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteAwsNodePoolOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateAwsClusterRequest, Operation> createAwsClusterSettings() {
            return this.createAwsClusterSettings;
        }

        public OperationCallSettings.Builder<CreateAwsClusterRequest, AwsCluster, OperationMetadata> createAwsClusterOperationSettings() {
            return this.createAwsClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAwsClusterRequest, Operation> updateAwsClusterSettings() {
            return this.updateAwsClusterSettings;
        }

        public OperationCallSettings.Builder<UpdateAwsClusterRequest, AwsCluster, OperationMetadata> updateAwsClusterOperationSettings() {
            return this.updateAwsClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAwsClusterRequest, AwsCluster> getAwsClusterSettings() {
            return this.getAwsClusterSettings;
        }

        public PagedCallSettings.Builder<ListAwsClustersRequest, ListAwsClustersResponse, AwsClustersClient.ListAwsClustersPagedResponse> listAwsClustersSettings() {
            return this.listAwsClustersSettings;
        }

        public UnaryCallSettings.Builder<DeleteAwsClusterRequest, Operation> deleteAwsClusterSettings() {
            return this.deleteAwsClusterSettings;
        }

        public OperationCallSettings.Builder<DeleteAwsClusterRequest, Empty, OperationMetadata> deleteAwsClusterOperationSettings() {
            return this.deleteAwsClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<GenerateAwsClusterAgentTokenRequest, GenerateAwsClusterAgentTokenResponse> generateAwsClusterAgentTokenSettings() {
            return this.generateAwsClusterAgentTokenSettings;
        }

        public UnaryCallSettings.Builder<GenerateAwsAccessTokenRequest, GenerateAwsAccessTokenResponse> generateAwsAccessTokenSettings() {
            return this.generateAwsAccessTokenSettings;
        }

        public UnaryCallSettings.Builder<CreateAwsNodePoolRequest, Operation> createAwsNodePoolSettings() {
            return this.createAwsNodePoolSettings;
        }

        public OperationCallSettings.Builder<CreateAwsNodePoolRequest, AwsNodePool, OperationMetadata> createAwsNodePoolOperationSettings() {
            return this.createAwsNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateAwsNodePoolRequest, Operation> updateAwsNodePoolSettings() {
            return this.updateAwsNodePoolSettings;
        }

        public OperationCallSettings.Builder<UpdateAwsNodePoolRequest, AwsNodePool, OperationMetadata> updateAwsNodePoolOperationSettings() {
            return this.updateAwsNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<RollbackAwsNodePoolUpdateRequest, Operation> rollbackAwsNodePoolUpdateSettings() {
            return this.rollbackAwsNodePoolUpdateSettings;
        }

        public OperationCallSettings.Builder<RollbackAwsNodePoolUpdateRequest, AwsNodePool, OperationMetadata> rollbackAwsNodePoolUpdateOperationSettings() {
            return this.rollbackAwsNodePoolUpdateOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAwsNodePoolRequest, AwsNodePool> getAwsNodePoolSettings() {
            return this.getAwsNodePoolSettings;
        }

        public PagedCallSettings.Builder<ListAwsNodePoolsRequest, ListAwsNodePoolsResponse, AwsClustersClient.ListAwsNodePoolsPagedResponse> listAwsNodePoolsSettings() {
            return this.listAwsNodePoolsSettings;
        }

        public UnaryCallSettings.Builder<DeleteAwsNodePoolRequest, Operation> deleteAwsNodePoolSettings() {
            return this.deleteAwsNodePoolSettings;
        }

        public OperationCallSettings.Builder<DeleteAwsNodePoolRequest, Empty, OperationMetadata> deleteAwsNodePoolOperationSettings() {
            return this.deleteAwsNodePoolOperationSettings;
        }

        public UnaryCallSettings.Builder<GetAwsOpenIdConfigRequest, AwsOpenIdConfig> getAwsOpenIdConfigSettings() {
            return this.getAwsOpenIdConfigSettings;
        }

        public UnaryCallSettings.Builder<GetAwsJsonWebKeysRequest, AwsJsonWebKeys> getAwsJsonWebKeysSettings() {
            return this.getAwsJsonWebKeysSettings;
        }

        public UnaryCallSettings.Builder<GetAwsServerConfigRequest, AwsServerConfig> getAwsServerConfigSettings() {
            return this.getAwsServerConfigSettings;
        }

        public AwsClustersStubSettings build() throws IOException {
            return new AwsClustersStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

