/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gdchardwaremanagement.v1alpha;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gdchardwaremanagement.v1alpha.CancelOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ChangeLogEntry;
import com.google.cloud.gdchardwaremanagement.v1alpha.ChangeLogEntryName;
import com.google.cloud.gdchardwaremanagement.v1alpha.Comment;
import com.google.cloud.gdchardwaremanagement.v1alpha.CommentName;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateCommentRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateHardwareGroupRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateHardwareRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateSiteRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.CreateZoneRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.DeleteHardwareGroupRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.DeleteHardwareRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.DeleteOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.DeleteSiteRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.DeleteZoneRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GDCHardwareManagementSettings;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetChangeLogEntryRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetCommentRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetHardwareGroupRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetHardwareRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetSiteRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetSkuRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.GetZoneRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.Hardware;
import com.google.cloud.gdchardwaremanagement.v1alpha.HardwareGroup;
import com.google.cloud.gdchardwaremanagement.v1alpha.HardwareGroupName;
import com.google.cloud.gdchardwaremanagement.v1alpha.HardwareName;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListChangeLogEntriesRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListChangeLogEntriesResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListCommentsRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListCommentsResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListHardwareGroupsRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListHardwareGroupsResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListHardwareRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListHardwareResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListOrdersRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListOrdersResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListSitesRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListSitesResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListSkusRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListSkusResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListZonesRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.ListZonesResponse;
import com.google.cloud.gdchardwaremanagement.v1alpha.LocationName;
import com.google.cloud.gdchardwaremanagement.v1alpha.OperationMetadata;
import com.google.cloud.gdchardwaremanagement.v1alpha.Order;
import com.google.cloud.gdchardwaremanagement.v1alpha.OrderName;
import com.google.cloud.gdchardwaremanagement.v1alpha.RecordActionOnCommentRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.RequestOrderDateChangeRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.SignalZoneStateRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.Site;
import com.google.cloud.gdchardwaremanagement.v1alpha.SiteName;
import com.google.cloud.gdchardwaremanagement.v1alpha.Sku;
import com.google.cloud.gdchardwaremanagement.v1alpha.SkuName;
import com.google.cloud.gdchardwaremanagement.v1alpha.SubmitOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.UpdateHardwareGroupRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.UpdateHardwareRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.UpdateOrderRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.UpdateSiteRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.UpdateZoneRequest;
import com.google.cloud.gdchardwaremanagement.v1alpha.Zone;
import com.google.cloud.gdchardwaremanagement.v1alpha.ZoneName;
import com.google.cloud.gdchardwaremanagement.v1alpha.stub.GDCHardwareManagementStub;
import com.google.cloud.gdchardwaremanagement.v1alpha.stub.GDCHardwareManagementStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.type.Date;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GDCHardwareManagementClient
implements BackgroundResource {
    private final GDCHardwareManagementSettings settings;
    private final GDCHardwareManagementStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final GDCHardwareManagementClient create() throws IOException {
        return GDCHardwareManagementClient.create(GDCHardwareManagementSettings.newBuilder().build());
    }

    public static final GDCHardwareManagementClient create(GDCHardwareManagementSettings settings) throws IOException {
        return new GDCHardwareManagementClient(settings);
    }

    public static final GDCHardwareManagementClient create(GDCHardwareManagementStub stub) {
        return new GDCHardwareManagementClient(stub);
    }

    protected GDCHardwareManagementClient(GDCHardwareManagementSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GDCHardwareManagementStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected GDCHardwareManagementClient(GDCHardwareManagementStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final GDCHardwareManagementSettings getSettings() {
        return this.settings;
    }

    public GDCHardwareManagementStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListOrdersPagedResponse listOrders(LocationName parent) {
        ListOrdersRequest request = ListOrdersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listOrders(request);
    }

    public final ListOrdersPagedResponse listOrders(String parent) {
        ListOrdersRequest request = ListOrdersRequest.newBuilder().setParent(parent).build();
        return this.listOrders(request);
    }

    public final ListOrdersPagedResponse listOrders(ListOrdersRequest request) {
        return (ListOrdersPagedResponse)((Object)this.listOrdersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersPagedResponse> listOrdersPagedCallable() {
        return this.stub.listOrdersPagedCallable();
    }

    public final UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable() {
        return this.stub.listOrdersCallable();
    }

    public final Order getOrder(OrderName name) {
        GetOrderRequest request = GetOrderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getOrder(request);
    }

    public final Order getOrder(String name) {
        GetOrderRequest request = GetOrderRequest.newBuilder().setName(name).build();
        return this.getOrder(request);
    }

    public final Order getOrder(GetOrderRequest request) {
        return (Order)this.getOrderCallable().call((Object)request);
    }

    public final UnaryCallable<GetOrderRequest, Order> getOrderCallable() {
        return this.stub.getOrderCallable();
    }

    public final OperationFuture<Order, OperationMetadata> createOrderAsync(LocationName parent, Order order, String orderId) {
        CreateOrderRequest request = CreateOrderRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setOrder(order).setOrderId(orderId).build();
        return this.createOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> createOrderAsync(String parent, Order order, String orderId) {
        CreateOrderRequest request = CreateOrderRequest.newBuilder().setParent(parent).setOrder(order).setOrderId(orderId).build();
        return this.createOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> createOrderAsync(CreateOrderRequest request) {
        return this.createOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateOrderRequest, Order, OperationMetadata> createOrderOperationCallable() {
        return this.stub.createOrderOperationCallable();
    }

    public final UnaryCallable<CreateOrderRequest, Operation> createOrderCallable() {
        return this.stub.createOrderCallable();
    }

    public final OperationFuture<Order, OperationMetadata> updateOrderAsync(Order order, FieldMask updateMask) {
        UpdateOrderRequest request = UpdateOrderRequest.newBuilder().setOrder(order).setUpdateMask(updateMask).build();
        return this.updateOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> updateOrderAsync(UpdateOrderRequest request) {
        return this.updateOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateOrderRequest, Order, OperationMetadata> updateOrderOperationCallable() {
        return this.stub.updateOrderOperationCallable();
    }

    public final UnaryCallable<UpdateOrderRequest, Operation> updateOrderCallable() {
        return this.stub.updateOrderCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrderAsync(OrderName name) {
        DeleteOrderRequest request = DeleteOrderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteOrderAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrderAsync(String name) {
        DeleteOrderRequest request = DeleteOrderRequest.newBuilder().setName(name).build();
        return this.deleteOrderAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteOrderAsync(DeleteOrderRequest request) {
        return this.deleteOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteOrderRequest, Empty, OperationMetadata> deleteOrderOperationCallable() {
        return this.stub.deleteOrderOperationCallable();
    }

    public final UnaryCallable<DeleteOrderRequest, Operation> deleteOrderCallable() {
        return this.stub.deleteOrderCallable();
    }

    public final OperationFuture<Order, OperationMetadata> submitOrderAsync(OrderName name) {
        SubmitOrderRequest request = SubmitOrderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.submitOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> submitOrderAsync(String name) {
        SubmitOrderRequest request = SubmitOrderRequest.newBuilder().setName(name).build();
        return this.submitOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> submitOrderAsync(SubmitOrderRequest request) {
        return this.submitOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SubmitOrderRequest, Order, OperationMetadata> submitOrderOperationCallable() {
        return this.stub.submitOrderOperationCallable();
    }

    public final UnaryCallable<SubmitOrderRequest, Operation> submitOrderCallable() {
        return this.stub.submitOrderCallable();
    }

    public final OperationFuture<Order, OperationMetadata> cancelOrderAsync(OrderName name) {
        CancelOrderRequest request = CancelOrderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> cancelOrderAsync(String name) {
        CancelOrderRequest request = CancelOrderRequest.newBuilder().setName(name).build();
        return this.cancelOrderAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> cancelOrderAsync(CancelOrderRequest request) {
        return this.cancelOrderOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CancelOrderRequest, Order, OperationMetadata> cancelOrderOperationCallable() {
        return this.stub.cancelOrderOperationCallable();
    }

    public final UnaryCallable<CancelOrderRequest, Operation> cancelOrderCallable() {
        return this.stub.cancelOrderCallable();
    }

    public final ListSitesPagedResponse listSites(LocationName parent) {
        ListSitesRequest request = ListSitesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSites(request);
    }

    public final ListSitesPagedResponse listSites(String parent) {
        ListSitesRequest request = ListSitesRequest.newBuilder().setParent(parent).build();
        return this.listSites(request);
    }

    public final ListSitesPagedResponse listSites(ListSitesRequest request) {
        return (ListSitesPagedResponse)((Object)this.listSitesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSitesRequest, ListSitesPagedResponse> listSitesPagedCallable() {
        return this.stub.listSitesPagedCallable();
    }

    public final UnaryCallable<ListSitesRequest, ListSitesResponse> listSitesCallable() {
        return this.stub.listSitesCallable();
    }

    public final Site getSite(SiteName name) {
        GetSiteRequest request = GetSiteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSite(request);
    }

    public final Site getSite(String name) {
        GetSiteRequest request = GetSiteRequest.newBuilder().setName(name).build();
        return this.getSite(request);
    }

    public final Site getSite(GetSiteRequest request) {
        return (Site)this.getSiteCallable().call((Object)request);
    }

    public final UnaryCallable<GetSiteRequest, Site> getSiteCallable() {
        return this.stub.getSiteCallable();
    }

    public final OperationFuture<Site, OperationMetadata> createSiteAsync(LocationName parent, Site site, String siteId) {
        CreateSiteRequest request = CreateSiteRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setSite(site).setSiteId(siteId).build();
        return this.createSiteAsync(request);
    }

    public final OperationFuture<Site, OperationMetadata> createSiteAsync(String parent, Site site, String siteId) {
        CreateSiteRequest request = CreateSiteRequest.newBuilder().setParent(parent).setSite(site).setSiteId(siteId).build();
        return this.createSiteAsync(request);
    }

    public final OperationFuture<Site, OperationMetadata> createSiteAsync(CreateSiteRequest request) {
        return this.createSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateSiteRequest, Site, OperationMetadata> createSiteOperationCallable() {
        return this.stub.createSiteOperationCallable();
    }

    public final UnaryCallable<CreateSiteRequest, Operation> createSiteCallable() {
        return this.stub.createSiteCallable();
    }

    public final OperationFuture<Site, OperationMetadata> updateSiteAsync(Site site, FieldMask updateMask) {
        UpdateSiteRequest request = UpdateSiteRequest.newBuilder().setSite(site).setUpdateMask(updateMask).build();
        return this.updateSiteAsync(request);
    }

    public final OperationFuture<Site, OperationMetadata> updateSiteAsync(UpdateSiteRequest request) {
        return this.updateSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateSiteRequest, Site, OperationMetadata> updateSiteOperationCallable() {
        return this.stub.updateSiteOperationCallable();
    }

    public final UnaryCallable<UpdateSiteRequest, Operation> updateSiteCallable() {
        return this.stub.updateSiteCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSiteAsync(SiteName name) {
        DeleteSiteRequest request = DeleteSiteRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteSiteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSiteAsync(String name) {
        DeleteSiteRequest request = DeleteSiteRequest.newBuilder().setName(name).build();
        return this.deleteSiteAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteSiteAsync(DeleteSiteRequest request) {
        return this.deleteSiteOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteSiteRequest, Empty, OperationMetadata> deleteSiteOperationCallable() {
        return this.stub.deleteSiteOperationCallable();
    }

    public final UnaryCallable<DeleteSiteRequest, Operation> deleteSiteCallable() {
        return this.stub.deleteSiteCallable();
    }

    public final ListHardwareGroupsPagedResponse listHardwareGroups(OrderName parent) {
        ListHardwareGroupsRequest request = ListHardwareGroupsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHardwareGroups(request);
    }

    public final ListHardwareGroupsPagedResponse listHardwareGroups(String parent) {
        ListHardwareGroupsRequest request = ListHardwareGroupsRequest.newBuilder().setParent(parent).build();
        return this.listHardwareGroups(request);
    }

    public final ListHardwareGroupsPagedResponse listHardwareGroups(ListHardwareGroupsRequest request) {
        return (ListHardwareGroupsPagedResponse)((Object)this.listHardwareGroupsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHardwareGroupsRequest, ListHardwareGroupsPagedResponse> listHardwareGroupsPagedCallable() {
        return this.stub.listHardwareGroupsPagedCallable();
    }

    public final UnaryCallable<ListHardwareGroupsRequest, ListHardwareGroupsResponse> listHardwareGroupsCallable() {
        return this.stub.listHardwareGroupsCallable();
    }

    public final HardwareGroup getHardwareGroup(HardwareGroupName name) {
        GetHardwareGroupRequest request = GetHardwareGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHardwareGroup(request);
    }

    public final HardwareGroup getHardwareGroup(String name) {
        GetHardwareGroupRequest request = GetHardwareGroupRequest.newBuilder().setName(name).build();
        return this.getHardwareGroup(request);
    }

    public final HardwareGroup getHardwareGroup(GetHardwareGroupRequest request) {
        return (HardwareGroup)this.getHardwareGroupCallable().call((Object)request);
    }

    public final UnaryCallable<GetHardwareGroupRequest, HardwareGroup> getHardwareGroupCallable() {
        return this.stub.getHardwareGroupCallable();
    }

    public final OperationFuture<HardwareGroup, OperationMetadata> createHardwareGroupAsync(OrderName parent, HardwareGroup hardwareGroup, String hardwareGroupId) {
        CreateHardwareGroupRequest request = CreateHardwareGroupRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHardwareGroup(hardwareGroup).setHardwareGroupId(hardwareGroupId).build();
        return this.createHardwareGroupAsync(request);
    }

    public final OperationFuture<HardwareGroup, OperationMetadata> createHardwareGroupAsync(String parent, HardwareGroup hardwareGroup, String hardwareGroupId) {
        CreateHardwareGroupRequest request = CreateHardwareGroupRequest.newBuilder().setParent(parent).setHardwareGroup(hardwareGroup).setHardwareGroupId(hardwareGroupId).build();
        return this.createHardwareGroupAsync(request);
    }

    public final OperationFuture<HardwareGroup, OperationMetadata> createHardwareGroupAsync(CreateHardwareGroupRequest request) {
        return this.createHardwareGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHardwareGroupRequest, HardwareGroup, OperationMetadata> createHardwareGroupOperationCallable() {
        return this.stub.createHardwareGroupOperationCallable();
    }

    public final UnaryCallable<CreateHardwareGroupRequest, Operation> createHardwareGroupCallable() {
        return this.stub.createHardwareGroupCallable();
    }

    public final OperationFuture<HardwareGroup, OperationMetadata> updateHardwareGroupAsync(HardwareGroup hardwareGroup, FieldMask updateMask) {
        UpdateHardwareGroupRequest request = UpdateHardwareGroupRequest.newBuilder().setHardwareGroup(hardwareGroup).setUpdateMask(updateMask).build();
        return this.updateHardwareGroupAsync(request);
    }

    public final OperationFuture<HardwareGroup, OperationMetadata> updateHardwareGroupAsync(UpdateHardwareGroupRequest request) {
        return this.updateHardwareGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHardwareGroupRequest, HardwareGroup, OperationMetadata> updateHardwareGroupOperationCallable() {
        return this.stub.updateHardwareGroupOperationCallable();
    }

    public final UnaryCallable<UpdateHardwareGroupRequest, Operation> updateHardwareGroupCallable() {
        return this.stub.updateHardwareGroupCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareGroupAsync(HardwareGroupName name) {
        DeleteHardwareGroupRequest request = DeleteHardwareGroupRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHardwareGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareGroupAsync(String name) {
        DeleteHardwareGroupRequest request = DeleteHardwareGroupRequest.newBuilder().setName(name).build();
        return this.deleteHardwareGroupAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareGroupAsync(DeleteHardwareGroupRequest request) {
        return this.deleteHardwareGroupOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHardwareGroupRequest, Empty, OperationMetadata> deleteHardwareGroupOperationCallable() {
        return this.stub.deleteHardwareGroupOperationCallable();
    }

    public final UnaryCallable<DeleteHardwareGroupRequest, Operation> deleteHardwareGroupCallable() {
        return this.stub.deleteHardwareGroupCallable();
    }

    public final ListHardwarePagedResponse listHardware(LocationName parent) {
        ListHardwareRequest request = ListHardwareRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listHardware(request);
    }

    public final ListHardwarePagedResponse listHardware(String parent) {
        ListHardwareRequest request = ListHardwareRequest.newBuilder().setParent(parent).build();
        return this.listHardware(request);
    }

    public final ListHardwarePagedResponse listHardware(ListHardwareRequest request) {
        return (ListHardwarePagedResponse)((Object)this.listHardwarePagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListHardwareRequest, ListHardwarePagedResponse> listHardwarePagedCallable() {
        return this.stub.listHardwarePagedCallable();
    }

    public final UnaryCallable<ListHardwareRequest, ListHardwareResponse> listHardwareCallable() {
        return this.stub.listHardwareCallable();
    }

    public final Hardware getHardware(HardwareName name) {
        GetHardwareRequest request = GetHardwareRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getHardware(request);
    }

    public final Hardware getHardware(String name) {
        GetHardwareRequest request = GetHardwareRequest.newBuilder().setName(name).build();
        return this.getHardware(request);
    }

    public final Hardware getHardware(GetHardwareRequest request) {
        return (Hardware)this.getHardwareCallable().call((Object)request);
    }

    public final UnaryCallable<GetHardwareRequest, Hardware> getHardwareCallable() {
        return this.stub.getHardwareCallable();
    }

    public final OperationFuture<Hardware, OperationMetadata> createHardwareAsync(LocationName parent, Hardware hardware, String hardwareId) {
        CreateHardwareRequest request = CreateHardwareRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setHardware(hardware).setHardwareId(hardwareId).build();
        return this.createHardwareAsync(request);
    }

    public final OperationFuture<Hardware, OperationMetadata> createHardwareAsync(String parent, Hardware hardware, String hardwareId) {
        CreateHardwareRequest request = CreateHardwareRequest.newBuilder().setParent(parent).setHardware(hardware).setHardwareId(hardwareId).build();
        return this.createHardwareAsync(request);
    }

    public final OperationFuture<Hardware, OperationMetadata> createHardwareAsync(CreateHardwareRequest request) {
        return this.createHardwareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateHardwareRequest, Hardware, OperationMetadata> createHardwareOperationCallable() {
        return this.stub.createHardwareOperationCallable();
    }

    public final UnaryCallable<CreateHardwareRequest, Operation> createHardwareCallable() {
        return this.stub.createHardwareCallable();
    }

    public final OperationFuture<Hardware, OperationMetadata> updateHardwareAsync(Hardware hardware, FieldMask updateMask) {
        UpdateHardwareRequest request = UpdateHardwareRequest.newBuilder().setHardware(hardware).setUpdateMask(updateMask).build();
        return this.updateHardwareAsync(request);
    }

    public final OperationFuture<Hardware, OperationMetadata> updateHardwareAsync(UpdateHardwareRequest request) {
        return this.updateHardwareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateHardwareRequest, Hardware, OperationMetadata> updateHardwareOperationCallable() {
        return this.stub.updateHardwareOperationCallable();
    }

    public final UnaryCallable<UpdateHardwareRequest, Operation> updateHardwareCallable() {
        return this.stub.updateHardwareCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareAsync(HardwareName name) {
        DeleteHardwareRequest request = DeleteHardwareRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteHardwareAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareAsync(String name) {
        DeleteHardwareRequest request = DeleteHardwareRequest.newBuilder().setName(name).build();
        return this.deleteHardwareAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteHardwareAsync(DeleteHardwareRequest request) {
        return this.deleteHardwareOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteHardwareRequest, Empty, OperationMetadata> deleteHardwareOperationCallable() {
        return this.stub.deleteHardwareOperationCallable();
    }

    public final UnaryCallable<DeleteHardwareRequest, Operation> deleteHardwareCallable() {
        return this.stub.deleteHardwareCallable();
    }

    public final ListCommentsPagedResponse listComments(OrderName parent) {
        ListCommentsRequest request = ListCommentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listComments(request);
    }

    public final ListCommentsPagedResponse listComments(String parent) {
        ListCommentsRequest request = ListCommentsRequest.newBuilder().setParent(parent).build();
        return this.listComments(request);
    }

    public final ListCommentsPagedResponse listComments(ListCommentsRequest request) {
        return (ListCommentsPagedResponse)((Object)this.listCommentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCommentsRequest, ListCommentsPagedResponse> listCommentsPagedCallable() {
        return this.stub.listCommentsPagedCallable();
    }

    public final UnaryCallable<ListCommentsRequest, ListCommentsResponse> listCommentsCallable() {
        return this.stub.listCommentsCallable();
    }

    public final Comment getComment(CommentName name) {
        GetCommentRequest request = GetCommentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getComment(request);
    }

    public final Comment getComment(String name) {
        GetCommentRequest request = GetCommentRequest.newBuilder().setName(name).build();
        return this.getComment(request);
    }

    public final Comment getComment(GetCommentRequest request) {
        return (Comment)this.getCommentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCommentRequest, Comment> getCommentCallable() {
        return this.stub.getCommentCallable();
    }

    public final OperationFuture<Comment, OperationMetadata> createCommentAsync(OrderName parent, Comment comment, String commentId) {
        CreateCommentRequest request = CreateCommentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setComment(comment).setCommentId(commentId).build();
        return this.createCommentAsync(request);
    }

    public final OperationFuture<Comment, OperationMetadata> createCommentAsync(String parent, Comment comment, String commentId) {
        CreateCommentRequest request = CreateCommentRequest.newBuilder().setParent(parent).setComment(comment).setCommentId(commentId).build();
        return this.createCommentAsync(request);
    }

    public final OperationFuture<Comment, OperationMetadata> createCommentAsync(CreateCommentRequest request) {
        return this.createCommentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCommentRequest, Comment, OperationMetadata> createCommentOperationCallable() {
        return this.stub.createCommentOperationCallable();
    }

    public final UnaryCallable<CreateCommentRequest, Operation> createCommentCallable() {
        return this.stub.createCommentCallable();
    }

    public final Comment recordActionOnComment(CommentName name, RecordActionOnCommentRequest.ActionType actionType) {
        RecordActionOnCommentRequest request = RecordActionOnCommentRequest.newBuilder().setName(name == null ? null : name.toString()).setActionType(actionType).build();
        return this.recordActionOnComment(request);
    }

    public final Comment recordActionOnComment(String name, RecordActionOnCommentRequest.ActionType actionType) {
        RecordActionOnCommentRequest request = RecordActionOnCommentRequest.newBuilder().setName(name).setActionType(actionType).build();
        return this.recordActionOnComment(request);
    }

    public final Comment recordActionOnComment(RecordActionOnCommentRequest request) {
        return (Comment)this.recordActionOnCommentCallable().call((Object)request);
    }

    public final UnaryCallable<RecordActionOnCommentRequest, Comment> recordActionOnCommentCallable() {
        return this.stub.recordActionOnCommentCallable();
    }

    public final ListChangeLogEntriesPagedResponse listChangeLogEntries(OrderName parent) {
        ListChangeLogEntriesRequest request = ListChangeLogEntriesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChangeLogEntries(request);
    }

    public final ListChangeLogEntriesPagedResponse listChangeLogEntries(String parent) {
        ListChangeLogEntriesRequest request = ListChangeLogEntriesRequest.newBuilder().setParent(parent).build();
        return this.listChangeLogEntries(request);
    }

    public final ListChangeLogEntriesPagedResponse listChangeLogEntries(ListChangeLogEntriesRequest request) {
        return (ListChangeLogEntriesPagedResponse)((Object)this.listChangeLogEntriesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChangeLogEntriesRequest, ListChangeLogEntriesPagedResponse> listChangeLogEntriesPagedCallable() {
        return this.stub.listChangeLogEntriesPagedCallable();
    }

    public final UnaryCallable<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse> listChangeLogEntriesCallable() {
        return this.stub.listChangeLogEntriesCallable();
    }

    public final ChangeLogEntry getChangeLogEntry(ChangeLogEntryName name) {
        GetChangeLogEntryRequest request = GetChangeLogEntryRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChangeLogEntry(request);
    }

    public final ChangeLogEntry getChangeLogEntry(String name) {
        GetChangeLogEntryRequest request = GetChangeLogEntryRequest.newBuilder().setName(name).build();
        return this.getChangeLogEntry(request);
    }

    public final ChangeLogEntry getChangeLogEntry(GetChangeLogEntryRequest request) {
        return (ChangeLogEntry)this.getChangeLogEntryCallable().call((Object)request);
    }

    public final UnaryCallable<GetChangeLogEntryRequest, ChangeLogEntry> getChangeLogEntryCallable() {
        return this.stub.getChangeLogEntryCallable();
    }

    public final ListSkusPagedResponse listSkus(LocationName parent) {
        ListSkusRequest request = ListSkusRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listSkus(request);
    }

    public final ListSkusPagedResponse listSkus(String parent) {
        ListSkusRequest request = ListSkusRequest.newBuilder().setParent(parent).build();
        return this.listSkus(request);
    }

    public final ListSkusPagedResponse listSkus(ListSkusRequest request) {
        return (ListSkusPagedResponse)((Object)this.listSkusPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListSkusRequest, ListSkusPagedResponse> listSkusPagedCallable() {
        return this.stub.listSkusPagedCallable();
    }

    public final UnaryCallable<ListSkusRequest, ListSkusResponse> listSkusCallable() {
        return this.stub.listSkusCallable();
    }

    public final Sku getSku(SkuName name) {
        GetSkuRequest request = GetSkuRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSku(request);
    }

    public final Sku getSku(String name) {
        GetSkuRequest request = GetSkuRequest.newBuilder().setName(name).build();
        return this.getSku(request);
    }

    public final Sku getSku(GetSkuRequest request) {
        return (Sku)this.getSkuCallable().call((Object)request);
    }

    public final UnaryCallable<GetSkuRequest, Sku> getSkuCallable() {
        return this.stub.getSkuCallable();
    }

    public final ListZonesPagedResponse listZones(LocationName parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(String parent) {
        ListZonesRequest request = ListZonesRequest.newBuilder().setParent(parent).build();
        return this.listZones(request);
    }

    public final ListZonesPagedResponse listZones(ListZonesRequest request) {
        return (ListZonesPagedResponse)((Object)this.listZonesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListZonesRequest, ListZonesPagedResponse> listZonesPagedCallable() {
        return this.stub.listZonesPagedCallable();
    }

    public final UnaryCallable<ListZonesRequest, ListZonesResponse> listZonesCallable() {
        return this.stub.listZonesCallable();
    }

    public final Zone getZone(ZoneName name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getZone(request);
    }

    public final Zone getZone(String name) {
        GetZoneRequest request = GetZoneRequest.newBuilder().setName(name).build();
        return this.getZone(request);
    }

    public final Zone getZone(GetZoneRequest request) {
        return (Zone)this.getZoneCallable().call((Object)request);
    }

    public final UnaryCallable<GetZoneRequest, Zone> getZoneCallable() {
        return this.stub.getZoneCallable();
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(LocationName parent, Zone zone, String zoneId) {
        CreateZoneRequest request = CreateZoneRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setZone(zone).setZoneId(zoneId).build();
        return this.createZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(String parent, Zone zone, String zoneId) {
        CreateZoneRequest request = CreateZoneRequest.newBuilder().setParent(parent).setZone(zone).setZoneId(zoneId).build();
        return this.createZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> createZoneAsync(CreateZoneRequest request) {
        return this.createZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateZoneRequest, Zone, OperationMetadata> createZoneOperationCallable() {
        return this.stub.createZoneOperationCallable();
    }

    public final UnaryCallable<CreateZoneRequest, Operation> createZoneCallable() {
        return this.stub.createZoneCallable();
    }

    public final OperationFuture<Zone, OperationMetadata> updateZoneAsync(Zone zone, FieldMask updateMask) {
        UpdateZoneRequest request = UpdateZoneRequest.newBuilder().setZone(zone).setUpdateMask(updateMask).build();
        return this.updateZoneAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> updateZoneAsync(UpdateZoneRequest request) {
        return this.updateZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateZoneRequest, Zone, OperationMetadata> updateZoneOperationCallable() {
        return this.stub.updateZoneOperationCallable();
    }

    public final UnaryCallable<UpdateZoneRequest, Operation> updateZoneCallable() {
        return this.stub.updateZoneCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(ZoneName name) {
        DeleteZoneRequest request = DeleteZoneRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteZoneAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(String name) {
        DeleteZoneRequest request = DeleteZoneRequest.newBuilder().setName(name).build();
        return this.deleteZoneAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteZoneAsync(DeleteZoneRequest request) {
        return this.deleteZoneOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteZoneRequest, Empty, OperationMetadata> deleteZoneOperationCallable() {
        return this.stub.deleteZoneOperationCallable();
    }

    public final UnaryCallable<DeleteZoneRequest, Operation> deleteZoneCallable() {
        return this.stub.deleteZoneCallable();
    }

    public final OperationFuture<Zone, OperationMetadata> signalZoneStateAsync(ZoneName name, SignalZoneStateRequest.StateSignal stateSignal) {
        SignalZoneStateRequest request = SignalZoneStateRequest.newBuilder().setName(name == null ? null : name.toString()).setStateSignal(stateSignal).build();
        return this.signalZoneStateAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> signalZoneStateAsync(String name, SignalZoneStateRequest.StateSignal stateSignal) {
        SignalZoneStateRequest request = SignalZoneStateRequest.newBuilder().setName(name).setStateSignal(stateSignal).build();
        return this.signalZoneStateAsync(request);
    }

    public final OperationFuture<Zone, OperationMetadata> signalZoneStateAsync(SignalZoneStateRequest request) {
        return this.signalZoneStateOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<SignalZoneStateRequest, Zone, OperationMetadata> signalZoneStateOperationCallable() {
        return this.stub.signalZoneStateOperationCallable();
    }

    public final UnaryCallable<SignalZoneStateRequest, Operation> signalZoneStateCallable() {
        return this.stub.signalZoneStateCallable();
    }

    public final OperationFuture<Order, OperationMetadata> requestOrderDateChangeAsync(OrderName name, Date requestedDate) {
        RequestOrderDateChangeRequest request = RequestOrderDateChangeRequest.newBuilder().setName(name == null ? null : name.toString()).setRequestedDate(requestedDate).build();
        return this.requestOrderDateChangeAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> requestOrderDateChangeAsync(String name, Date requestedDate) {
        RequestOrderDateChangeRequest request = RequestOrderDateChangeRequest.newBuilder().setName(name).setRequestedDate(requestedDate).build();
        return this.requestOrderDateChangeAsync(request);
    }

    public final OperationFuture<Order, OperationMetadata> requestOrderDateChangeAsync(RequestOrderDateChangeRequest request) {
        return this.requestOrderDateChangeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RequestOrderDateChangeRequest, Order, OperationMetadata> requestOrderDateChangeOperationCallable() {
        return this.stub.requestOrderDateChangeOperationCallable();
    }

    public final UnaryCallable<RequestOrderDateChangeRequest, Operation> requestOrderDateChangeCallable() {
        return this.stub.requestOrderDateChangeCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListZonesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        private ListZonesFixedSizeCollection(List<ListZonesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListZonesFixedSizeCollection createEmptyCollection() {
            return new ListZonesFixedSizeCollection(null, 0);
        }

        protected ListZonesFixedSizeCollection createCollection(List<ListZonesPage> pages, int collectionSize) {
            return new ListZonesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListZonesPage
    extends AbstractPage<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage> {
        private ListZonesPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            super(context, (Object)response);
        }

        private static ListZonesPage createEmptyPage() {
            return new ListZonesPage(null, null);
        }

        protected ListZonesPage createPage(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ListZonesResponse response) {
            return new ListZonesPage(context, response);
        }

        public ApiFuture<ListZonesPage> createPageAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListZonesPagedResponse
    extends AbstractPagedListResponse<ListZonesRequest, ListZonesResponse, Zone, ListZonesPage, ListZonesFixedSizeCollection> {
        public static ApiFuture<ListZonesPagedResponse> createAsync(PageContext<ListZonesRequest, ListZonesResponse, Zone> context, ApiFuture<ListZonesResponse> futureResponse) {
            ApiFuture<ListZonesPage> futurePage = ListZonesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListZonesPagedResponse((ListZonesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListZonesPagedResponse(ListZonesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListZonesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSkusFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        private ListSkusFixedSizeCollection(List<ListSkusPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSkusFixedSizeCollection createEmptyCollection() {
            return new ListSkusFixedSizeCollection(null, 0);
        }

        protected ListSkusFixedSizeCollection createCollection(List<ListSkusPage> pages, int collectionSize) {
            return new ListSkusFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSkusPage
    extends AbstractPage<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage> {
        private ListSkusPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            super(context, (Object)response);
        }

        private static ListSkusPage createEmptyPage() {
            return new ListSkusPage(null, null);
        }

        protected ListSkusPage createPage(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ListSkusResponse response) {
            return new ListSkusPage(context, response);
        }

        public ApiFuture<ListSkusPage> createPageAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSkusPagedResponse
    extends AbstractPagedListResponse<ListSkusRequest, ListSkusResponse, Sku, ListSkusPage, ListSkusFixedSizeCollection> {
        public static ApiFuture<ListSkusPagedResponse> createAsync(PageContext<ListSkusRequest, ListSkusResponse, Sku> context, ApiFuture<ListSkusResponse> futureResponse) {
            ApiFuture<ListSkusPage> futurePage = ListSkusPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSkusPagedResponse((ListSkusPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSkusPagedResponse(ListSkusPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSkusFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChangeLogEntriesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry, ListChangeLogEntriesPage, ListChangeLogEntriesFixedSizeCollection> {
        private ListChangeLogEntriesFixedSizeCollection(List<ListChangeLogEntriesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChangeLogEntriesFixedSizeCollection createEmptyCollection() {
            return new ListChangeLogEntriesFixedSizeCollection(null, 0);
        }

        protected ListChangeLogEntriesFixedSizeCollection createCollection(List<ListChangeLogEntriesPage> pages, int collectionSize) {
            return new ListChangeLogEntriesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChangeLogEntriesPage
    extends AbstractPage<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry, ListChangeLogEntriesPage> {
        private ListChangeLogEntriesPage(PageContext<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry> context, ListChangeLogEntriesResponse response) {
            super(context, (Object)response);
        }

        private static ListChangeLogEntriesPage createEmptyPage() {
            return new ListChangeLogEntriesPage(null, null);
        }

        protected ListChangeLogEntriesPage createPage(PageContext<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry> context, ListChangeLogEntriesResponse response) {
            return new ListChangeLogEntriesPage(context, response);
        }

        public ApiFuture<ListChangeLogEntriesPage> createPageAsync(PageContext<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry> context, ApiFuture<ListChangeLogEntriesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChangeLogEntriesPagedResponse
    extends AbstractPagedListResponse<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry, ListChangeLogEntriesPage, ListChangeLogEntriesFixedSizeCollection> {
        public static ApiFuture<ListChangeLogEntriesPagedResponse> createAsync(PageContext<ListChangeLogEntriesRequest, ListChangeLogEntriesResponse, ChangeLogEntry> context, ApiFuture<ListChangeLogEntriesResponse> futureResponse) {
            ApiFuture<ListChangeLogEntriesPage> futurePage = ListChangeLogEntriesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChangeLogEntriesPagedResponse((ListChangeLogEntriesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChangeLogEntriesPagedResponse(ListChangeLogEntriesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChangeLogEntriesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCommentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage, ListCommentsFixedSizeCollection> {
        private ListCommentsFixedSizeCollection(List<ListCommentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCommentsFixedSizeCollection createEmptyCollection() {
            return new ListCommentsFixedSizeCollection(null, 0);
        }

        protected ListCommentsFixedSizeCollection createCollection(List<ListCommentsPage> pages, int collectionSize) {
            return new ListCommentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCommentsPage
    extends AbstractPage<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage> {
        private ListCommentsPage(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ListCommentsResponse response) {
            super(context, (Object)response);
        }

        private static ListCommentsPage createEmptyPage() {
            return new ListCommentsPage(null, null);
        }

        protected ListCommentsPage createPage(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ListCommentsResponse response) {
            return new ListCommentsPage(context, response);
        }

        public ApiFuture<ListCommentsPage> createPageAsync(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ApiFuture<ListCommentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCommentsPagedResponse
    extends AbstractPagedListResponse<ListCommentsRequest, ListCommentsResponse, Comment, ListCommentsPage, ListCommentsFixedSizeCollection> {
        public static ApiFuture<ListCommentsPagedResponse> createAsync(PageContext<ListCommentsRequest, ListCommentsResponse, Comment> context, ApiFuture<ListCommentsResponse> futureResponse) {
            ApiFuture<ListCommentsPage> futurePage = ListCommentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCommentsPagedResponse((ListCommentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCommentsPagedResponse(ListCommentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCommentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHardwareFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHardwareRequest, ListHardwareResponse, Hardware, ListHardwarePage, ListHardwareFixedSizeCollection> {
        private ListHardwareFixedSizeCollection(List<ListHardwarePage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHardwareFixedSizeCollection createEmptyCollection() {
            return new ListHardwareFixedSizeCollection(null, 0);
        }

        protected ListHardwareFixedSizeCollection createCollection(List<ListHardwarePage> pages, int collectionSize) {
            return new ListHardwareFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHardwarePage
    extends AbstractPage<ListHardwareRequest, ListHardwareResponse, Hardware, ListHardwarePage> {
        private ListHardwarePage(PageContext<ListHardwareRequest, ListHardwareResponse, Hardware> context, ListHardwareResponse response) {
            super(context, (Object)response);
        }

        private static ListHardwarePage createEmptyPage() {
            return new ListHardwarePage(null, null);
        }

        protected ListHardwarePage createPage(PageContext<ListHardwareRequest, ListHardwareResponse, Hardware> context, ListHardwareResponse response) {
            return new ListHardwarePage(context, response);
        }

        public ApiFuture<ListHardwarePage> createPageAsync(PageContext<ListHardwareRequest, ListHardwareResponse, Hardware> context, ApiFuture<ListHardwareResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHardwarePagedResponse
    extends AbstractPagedListResponse<ListHardwareRequest, ListHardwareResponse, Hardware, ListHardwarePage, ListHardwareFixedSizeCollection> {
        public static ApiFuture<ListHardwarePagedResponse> createAsync(PageContext<ListHardwareRequest, ListHardwareResponse, Hardware> context, ApiFuture<ListHardwareResponse> futureResponse) {
            ApiFuture<ListHardwarePage> futurePage = ListHardwarePage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHardwarePagedResponse((ListHardwarePage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHardwarePagedResponse(ListHardwarePage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHardwareFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListHardwareGroupsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup, ListHardwareGroupsPage, ListHardwareGroupsFixedSizeCollection> {
        private ListHardwareGroupsFixedSizeCollection(List<ListHardwareGroupsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListHardwareGroupsFixedSizeCollection createEmptyCollection() {
            return new ListHardwareGroupsFixedSizeCollection(null, 0);
        }

        protected ListHardwareGroupsFixedSizeCollection createCollection(List<ListHardwareGroupsPage> pages, int collectionSize) {
            return new ListHardwareGroupsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListHardwareGroupsPage
    extends AbstractPage<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup, ListHardwareGroupsPage> {
        private ListHardwareGroupsPage(PageContext<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup> context, ListHardwareGroupsResponse response) {
            super(context, (Object)response);
        }

        private static ListHardwareGroupsPage createEmptyPage() {
            return new ListHardwareGroupsPage(null, null);
        }

        protected ListHardwareGroupsPage createPage(PageContext<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup> context, ListHardwareGroupsResponse response) {
            return new ListHardwareGroupsPage(context, response);
        }

        public ApiFuture<ListHardwareGroupsPage> createPageAsync(PageContext<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup> context, ApiFuture<ListHardwareGroupsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListHardwareGroupsPagedResponse
    extends AbstractPagedListResponse<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup, ListHardwareGroupsPage, ListHardwareGroupsFixedSizeCollection> {
        public static ApiFuture<ListHardwareGroupsPagedResponse> createAsync(PageContext<ListHardwareGroupsRequest, ListHardwareGroupsResponse, HardwareGroup> context, ApiFuture<ListHardwareGroupsResponse> futureResponse) {
            ApiFuture<ListHardwareGroupsPage> futurePage = ListHardwareGroupsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListHardwareGroupsPagedResponse((ListHardwareGroupsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListHardwareGroupsPagedResponse(ListHardwareGroupsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListHardwareGroupsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListSitesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListSitesRequest, ListSitesResponse, Site, ListSitesPage, ListSitesFixedSizeCollection> {
        private ListSitesFixedSizeCollection(List<ListSitesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListSitesFixedSizeCollection createEmptyCollection() {
            return new ListSitesFixedSizeCollection(null, 0);
        }

        protected ListSitesFixedSizeCollection createCollection(List<ListSitesPage> pages, int collectionSize) {
            return new ListSitesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListSitesPage
    extends AbstractPage<ListSitesRequest, ListSitesResponse, Site, ListSitesPage> {
        private ListSitesPage(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ListSitesResponse response) {
            super(context, (Object)response);
        }

        private static ListSitesPage createEmptyPage() {
            return new ListSitesPage(null, null);
        }

        protected ListSitesPage createPage(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ListSitesResponse response) {
            return new ListSitesPage(context, response);
        }

        public ApiFuture<ListSitesPage> createPageAsync(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ApiFuture<ListSitesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListSitesPagedResponse
    extends AbstractPagedListResponse<ListSitesRequest, ListSitesResponse, Site, ListSitesPage, ListSitesFixedSizeCollection> {
        public static ApiFuture<ListSitesPagedResponse> createAsync(PageContext<ListSitesRequest, ListSitesResponse, Site> context, ApiFuture<ListSitesResponse> futureResponse) {
            ApiFuture<ListSitesPage> futurePage = ListSitesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListSitesPagedResponse((ListSitesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListSitesPagedResponse(ListSitesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListSitesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListOrdersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        private ListOrdersFixedSizeCollection(List<ListOrdersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListOrdersFixedSizeCollection createEmptyCollection() {
            return new ListOrdersFixedSizeCollection(null, 0);
        }

        protected ListOrdersFixedSizeCollection createCollection(List<ListOrdersPage> pages, int collectionSize) {
            return new ListOrdersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListOrdersPage
    extends AbstractPage<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage> {
        private ListOrdersPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            super(context, (Object)response);
        }

        private static ListOrdersPage createEmptyPage() {
            return new ListOrdersPage(null, null);
        }

        protected ListOrdersPage createPage(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ListOrdersResponse response) {
            return new ListOrdersPage(context, response);
        }

        public ApiFuture<ListOrdersPage> createPageAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListOrdersPagedResponse
    extends AbstractPagedListResponse<ListOrdersRequest, ListOrdersResponse, Order, ListOrdersPage, ListOrdersFixedSizeCollection> {
        public static ApiFuture<ListOrdersPagedResponse> createAsync(PageContext<ListOrdersRequest, ListOrdersResponse, Order> context, ApiFuture<ListOrdersResponse> futureResponse) {
            ApiFuture<ListOrdersPage> futurePage = ListOrdersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListOrdersPagedResponse((ListOrdersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListOrdersPagedResponse(ListOrdersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListOrdersFixedSizeCollection.createEmptyCollection());
        }
    }
}

