/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.functions.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.functions.v1.CallFunctionRequest;
import com.google.cloud.functions.v1.CallFunctionResponse;
import com.google.cloud.functions.v1.CloudFunction;
import com.google.cloud.functions.v1.CloudFunctionName;
import com.google.cloud.functions.v1.CloudFunctionsServiceSettings;
import com.google.cloud.functions.v1.CreateFunctionRequest;
import com.google.cloud.functions.v1.DeleteFunctionRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlRequest;
import com.google.cloud.functions.v1.GenerateDownloadUrlResponse;
import com.google.cloud.functions.v1.GenerateUploadUrlRequest;
import com.google.cloud.functions.v1.GenerateUploadUrlResponse;
import com.google.cloud.functions.v1.GetFunctionRequest;
import com.google.cloud.functions.v1.ListFunctionsRequest;
import com.google.cloud.functions.v1.ListFunctionsResponse;
import com.google.cloud.functions.v1.LocationName;
import com.google.cloud.functions.v1.OperationMetadataV1;
import com.google.cloud.functions.v1.UpdateFunctionRequest;
import com.google.cloud.functions.v1.stub.CloudFunctionsServiceStub;
import com.google.cloud.functions.v1.stub.CloudFunctionsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CloudFunctionsServiceClient
implements BackgroundResource {
    private final CloudFunctionsServiceSettings settings;
    private final CloudFunctionsServiceStub stub;
    private final OperationsClient operationsClient;

    public static final CloudFunctionsServiceClient create() throws IOException {
        return CloudFunctionsServiceClient.create(CloudFunctionsServiceSettings.newBuilder().build());
    }

    public static final CloudFunctionsServiceClient create(CloudFunctionsServiceSettings settings) throws IOException {
        return new CloudFunctionsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudFunctionsServiceClient create(CloudFunctionsServiceStub stub) {
        return new CloudFunctionsServiceClient(stub);
    }

    protected CloudFunctionsServiceClient(CloudFunctionsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudFunctionsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudFunctionsServiceClient(CloudFunctionsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CloudFunctionsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudFunctionsServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListFunctionsPagedResponse listFunctions(ListFunctionsRequest request) {
        return (ListFunctionsPagedResponse)((Object)this.listFunctionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsPagedResponse> listFunctionsPagedCallable() {
        return this.stub.listFunctionsPagedCallable();
    }

    public final UnaryCallable<ListFunctionsRequest, ListFunctionsResponse> listFunctionsCallable() {
        return this.stub.listFunctionsCallable();
    }

    public final CloudFunction getFunction(CloudFunctionName name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getFunction(request);
    }

    public final CloudFunction getFunction(String name) {
        GetFunctionRequest request = GetFunctionRequest.newBuilder().setName(name).build();
        return this.getFunction(request);
    }

    public final CloudFunction getFunction(GetFunctionRequest request) {
        return (CloudFunction)this.getFunctionCallable().call((Object)request);
    }

    public final UnaryCallable<GetFunctionRequest, CloudFunction> getFunctionCallable() {
        return this.stub.getFunctionCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(LocationName location, CloudFunction function) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setLocation(location == null ? null : location.toString()).setFunction(function).build();
        return this.createFunctionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(String location, CloudFunction function) {
        CreateFunctionRequest request = CreateFunctionRequest.newBuilder().setLocation(location).setFunction(function).build();
        return this.createFunctionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CloudFunction, OperationMetadataV1> createFunctionAsync(CreateFunctionRequest request) {
        return this.createFunctionOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateFunctionRequest, CloudFunction, OperationMetadataV1> createFunctionOperationCallable() {
        return this.stub.createFunctionOperationCallable();
    }

    public final UnaryCallable<CreateFunctionRequest, Operation> createFunctionCallable() {
        return this.stub.createFunctionCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CloudFunction, OperationMetadataV1> updateFunctionAsync(CloudFunction function) {
        UpdateFunctionRequest request = UpdateFunctionRequest.newBuilder().setFunction(function).build();
        return this.updateFunctionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<CloudFunction, OperationMetadataV1> updateFunctionAsync(UpdateFunctionRequest request) {
        return this.updateFunctionOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateFunctionRequest, CloudFunction, OperationMetadataV1> updateFunctionOperationCallable() {
        return this.stub.updateFunctionOperationCallable();
    }

    public final UnaryCallable<UpdateFunctionRequest, Operation> updateFunctionCallable() {
        return this.stub.updateFunctionCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(CloudFunctionName name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteFunctionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(String name) {
        DeleteFunctionRequest request = DeleteFunctionRequest.newBuilder().setName(name).build();
        return this.deleteFunctionAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadataV1> deleteFunctionAsync(DeleteFunctionRequest request) {
        return this.deleteFunctionOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteFunctionRequest, Empty, OperationMetadataV1> deleteFunctionOperationCallable() {
        return this.stub.deleteFunctionOperationCallable();
    }

    public final UnaryCallable<DeleteFunctionRequest, Operation> deleteFunctionCallable() {
        return this.stub.deleteFunctionCallable();
    }

    public final CallFunctionResponse callFunction(CloudFunctionName name, String data) {
        CallFunctionRequest request = CallFunctionRequest.newBuilder().setName(name == null ? null : name.toString()).setData(data).build();
        return this.callFunction(request);
    }

    public final CallFunctionResponse callFunction(String name, String data) {
        CallFunctionRequest request = CallFunctionRequest.newBuilder().setName(name).setData(data).build();
        return this.callFunction(request);
    }

    public final CallFunctionResponse callFunction(CallFunctionRequest request) {
        return (CallFunctionResponse)this.callFunctionCallable().call((Object)request);
    }

    public final UnaryCallable<CallFunctionRequest, CallFunctionResponse> callFunctionCallable() {
        return this.stub.callFunctionCallable();
    }

    public final GenerateUploadUrlResponse generateUploadUrl(GenerateUploadUrlRequest request) {
        return (GenerateUploadUrlResponse)this.generateUploadUrlCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateUploadUrlRequest, GenerateUploadUrlResponse> generateUploadUrlCallable() {
        return this.stub.generateUploadUrlCallable();
    }

    public final GenerateDownloadUrlResponse generateDownloadUrl(GenerateDownloadUrlRequest request) {
        return (GenerateDownloadUrlResponse)this.generateDownloadUrlCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateDownloadUrlRequest, GenerateDownloadUrlResponse> generateDownloadUrlCallable() {
        return this.stub.generateDownloadUrlCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListFunctionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        private ListFunctionsFixedSizeCollection(List<ListFunctionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListFunctionsFixedSizeCollection createEmptyCollection() {
            return new ListFunctionsFixedSizeCollection(null, 0);
        }

        protected ListFunctionsFixedSizeCollection createCollection(List<ListFunctionsPage> pages, int collectionSize) {
            return new ListFunctionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListFunctionsPage
    extends AbstractPage<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage> {
        private ListFunctionsPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ListFunctionsResponse response) {
            super(context, (Object)response);
        }

        private static ListFunctionsPage createEmptyPage() {
            return new ListFunctionsPage(null, null);
        }

        protected ListFunctionsPage createPage(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ListFunctionsResponse response) {
            return new ListFunctionsPage(context, response);
        }

        public ApiFuture<ListFunctionsPage> createPageAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListFunctionsPagedResponse
    extends AbstractPagedListResponse<ListFunctionsRequest, ListFunctionsResponse, CloudFunction, ListFunctionsPage, ListFunctionsFixedSizeCollection> {
        public static ApiFuture<ListFunctionsPagedResponse> createAsync(PageContext<ListFunctionsRequest, ListFunctionsResponse, CloudFunction> context, ApiFuture<ListFunctionsResponse> futureResponse) {
            ApiFuture<ListFunctionsPage> futurePage = ListFunctionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListFunctionsPage, ListFunctionsPagedResponse>(){

                public ListFunctionsPagedResponse apply(ListFunctionsPage input) {
                    return new ListFunctionsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListFunctionsPagedResponse(ListFunctionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListFunctionsFixedSizeCollection.createEmptyCollection());
        }
    }
}

