/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.UserDataConverter;
import java.time.Duration;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ExecutionStats {
    private final long resultsReturned;
    @Nonnull
    private final Duration executionDuration;
    private final long readOperations;
    @Nonnull
    private final Map<String, Object> debugStats;

    ExecutionStats(com.google.firestore.v1.ExecutionStats proto) {
        this.resultsReturned = proto.getResultsReturned();
        this.executionDuration = Duration.ofSeconds(proto.getExecutionDuration().getSeconds(), proto.getExecutionDuration().getNanos());
        this.readOperations = proto.getReadOperations();
        this.debugStats = UserDataConverter.decodeStruct(proto.getDebugStats());
    }

    public long getResultsReturned() {
        return this.resultsReturned;
    }

    @Nonnull
    public Duration getExecutionDuration() {
        return this.executionDuration;
    }

    public long getReadOperations() {
        return this.readOperations;
    }

    @Nonnull
    public Map<String, Object> getDebugStats() {
        return this.debugStats;
    }
}

