/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.api.gax.rpc.ApiStreamObserver;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.ExplainMetrics;
import com.google.cloud.firestore.ExplainOptions;
import com.google.cloud.firestore.ExplainResults;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.Query;
import com.google.cloud.firestore.QueryDocumentSnapshot;
import com.google.cloud.firestore.telemetry.TraceUtil;
import com.google.cloud.firestore.v1.FirestoreSettings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public abstract class StreamableQuery<SnapshotType> {
    final Query.QueryOptions options;
    final FirestoreRpcContext<?> rpcContext;

    StreamableQuery(FirestoreRpcContext<?> rpcContext, Query.QueryOptions options) {
        this.rpcContext = rpcContext;
        this.options = options;
    }

    abstract RunQueryRequest.Builder toRunQueryRequestBuilder(@Nullable ByteString var1, @Nullable Timestamp var2, @Nullable ExplainOptions var3);

    abstract boolean isRetryableWithCursor();

    abstract StreamableQuery<SnapshotType> startAfter(@Nonnull DocumentSnapshot var1);

    abstract SnapshotType createSnaphot(Timestamp var1, List<QueryDocumentSnapshot> var2);

    @Nonnull
    public Firestore getFirestore() {
        return this.rpcContext.getFirestore();
    }

    @Nonnull
    public abstract ApiFuture<SnapshotType> get();

    ApiFuture<SnapshotType> get(@Nullable ByteString transactionId, @Nullable Timestamp requestReadTime) {
        TraceUtil.Span span = ((FirestoreOptions)this.getFirestore().getOptions()).getTraceUtil().startSpan(transactionId == null ? "Query.Get" : "Transaction.Get.Query");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            final SettableApiFuture result = SettableApiFuture.create();
            this.internalStream(new ApiStreamObserver<RunQueryResponse>(){
                final List<QueryDocumentSnapshot> documentSnapshots = new ArrayList<QueryDocumentSnapshot>();
                Timestamp responseReadTime;

                public void onNext(RunQueryResponse runQueryResponse) {
                    if (runQueryResponse.hasDocument()) {
                        Document document = runQueryResponse.getDocument();
                        QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(StreamableQuery.this.rpcContext, Timestamp.fromProto((com.google.protobuf.Timestamp)runQueryResponse.getReadTime()), document);
                        this.documentSnapshots.add(documentSnapshot);
                    }
                    if (this.responseReadTime == null) {
                        this.responseReadTime = Timestamp.fromProto((com.google.protobuf.Timestamp)runQueryResponse.getReadTime());
                    }
                }

                public void onError(Throwable throwable) {
                    result.setException(throwable);
                }

                public void onCompleted() {
                    List resultView = Query.LimitType.Last.equals((Object)StreamableQuery.this.options.getLimitType()) ? Lists.reverse(this.documentSnapshots) : this.documentSnapshots;
                    Object querySnapshot = StreamableQuery.this.createSnaphot(this.responseReadTime, resultView);
                    result.set(querySnapshot);
                }
            }, this.rpcContext.getClock().nanoTime(), transactionId, requestReadTime, null, false);
            span.endAtFuture(result);
            SettableApiFuture settableApiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return settableApiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    @Nonnull
    public ApiFuture<ExplainResults<SnapshotType>> explain(ExplainOptions options) {
        TraceUtil.Span span = ((FirestoreOptions)this.getFirestore().getOptions()).getTraceUtil().startSpan("Query.Get");
        TraceUtil.Scope ignored = span.makeCurrent();
        try {
            final SettableApiFuture result = SettableApiFuture.create();
            this.internalStream(new ApiStreamObserver<RunQueryResponse>(){
                @Nullable
                List<QueryDocumentSnapshot> documentSnapshots = null;
                Timestamp readTime;
                ExplainMetrics metrics;

                public void onNext(RunQueryResponse runQueryResponse) {
                    if (runQueryResponse.hasDocument()) {
                        if (this.documentSnapshots == null) {
                            this.documentSnapshots = new ArrayList<QueryDocumentSnapshot>();
                        }
                        Document document = runQueryResponse.getDocument();
                        QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(StreamableQuery.this.rpcContext, Timestamp.fromProto((com.google.protobuf.Timestamp)runQueryResponse.getReadTime()), document);
                        this.documentSnapshots.add(documentSnapshot);
                    }
                    if (this.readTime == null) {
                        this.readTime = Timestamp.fromProto((com.google.protobuf.Timestamp)runQueryResponse.getReadTime());
                    }
                    if (runQueryResponse.hasExplainMetrics()) {
                        this.metrics = new ExplainMetrics(runQueryResponse.getExplainMetrics());
                        if (this.documentSnapshots == null && this.metrics.getExecutionStats() != null) {
                            this.documentSnapshots = Collections.emptyList();
                        }
                    }
                }

                public void onError(Throwable throwable) {
                    result.setException(throwable);
                }

                public void onCompleted() {
                    Object snapshot = null;
                    if (this.documentSnapshots != null) {
                        List resultView = Query.LimitType.Last.equals((Object)StreamableQuery.this.options.getLimitType()) ? Lists.reverse(this.documentSnapshots) : this.documentSnapshots;
                        snapshot = StreamableQuery.this.createSnaphot(this.readTime, resultView);
                    }
                    result.set(new ExplainResults<Object>(this.metrics, snapshot));
                }
            }, this.rpcContext.getClock().nanoTime(), null, null, options, false);
            span.endAtFuture(result);
            SettableApiFuture settableApiFuture = result;
            if (ignored != null) {
                ignored.close();
            }
            return settableApiFuture;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception error) {
                span.end(error);
                throw error;
            }
        }
    }

    protected void internalStream(final ApiStreamObserver<RunQueryResponse> runQueryResponseObserver, final long startTimeNanos, final @Nullable ByteString transactionId, @Nullable Timestamp readTime, final @Nullable ExplainOptions explainOptions, boolean isRetryRequestWithCursor) {
        TraceUtil traceUtil = ((FirestoreOptions)this.getFirestore().getOptions()).getTraceUtil();
        int NUM_RESPONSES_PER_TRACE_EVENT = 100;
        final TraceUtil.Span currentSpan = traceUtil.currentSpan();
        currentSpan.addEvent("RunQuery", (Map<String, Object>)new ImmutableMap.Builder().put((Object)"transactional", (Object)(transactionId != null ? 1 : 0)).put((Object)"retry_query_with_cursor", (Object)isRetryRequestWithCursor).build());
        final AtomicReference lastReceivedDocument = new AtomicReference();
        ResponseObserver<RunQueryResponse> observer = new ResponseObserver<RunQueryResponse>(){
            Timestamp readTime;
            boolean firstResponse = false;
            int numDocuments = 0;
            boolean hasCompleted = false;

            public void onStart(StreamController streamController) {
            }

            public void onResponse(RunQueryResponse response) {
                if (!this.firstResponse) {
                    this.firstResponse = true;
                    currentSpan.addEvent("RunQuery: First Response");
                }
                runQueryResponseObserver.onNext((Object)response);
                if (response.hasDocument()) {
                    ++this.numDocuments;
                    if (this.numDocuments % 100 == 0) {
                        currentSpan.addEvent("RunQuery: Received " + this.numDocuments + " documents");
                    }
                    Document document = response.getDocument();
                    QueryDocumentSnapshot documentSnapshot = QueryDocumentSnapshot.fromDocument(StreamableQuery.this.rpcContext, Timestamp.fromProto((com.google.protobuf.Timestamp)response.getReadTime()), document);
                    lastReceivedDocument.set(documentSnapshot);
                }
                if (response.getDone()) {
                    currentSpan.addEvent("RunQuery: Received RunQueryResponse.Done");
                    this.onComplete();
                }
            }

            public void onError(Throwable throwable) {
                QueryDocumentSnapshot cursor = (QueryDocumentSnapshot)lastReceivedDocument.get();
                if (StreamableQuery.this.isRetryableWithCursor() && this.shouldRetry(cursor, throwable)) {
                    currentSpan.addEvent("RunQuery: Retryable Error", Collections.singletonMap("error.message", throwable.getMessage()));
                    StreamableQuery.this.startAfter(cursor).internalStream((ApiStreamObserver<RunQueryResponse>)runQueryResponseObserver, startTimeNanos, null, StreamableQuery.this.options.getRequireConsistency() ? cursor.getReadTime() : null, explainOptions, true);
                } else {
                    currentSpan.addEvent("RunQuery: Error", Collections.singletonMap("error.message", throwable.getMessage()));
                    runQueryResponseObserver.onError(throwable);
                }
            }

            public void onComplete() {
                if (this.hasCompleted) {
                    return;
                }
                this.hasCompleted = true;
                currentSpan.addEvent("RunQuery: Completed", Collections.singletonMap("doc_count", this.numDocuments));
                runQueryResponseObserver.onCompleted();
            }

            boolean shouldRetry(DocumentSnapshot lastDocument, Throwable t) {
                if (lastDocument == null) {
                    return false;
                }
                if (explainOptions != null) {
                    return false;
                }
                Set retryableCodes = FirestoreSettings.newBuilder().runQuerySettings().getRetryableCodes();
                return StreamableQuery.this.shouldRetryQuery(t, transactionId, startTimeNanos, retryableCodes);
            }
        };
        this.rpcContext.streamRequest(this.toRunQueryRequestBuilder(transactionId, readTime, explainOptions).build(), observer, this.rpcContext.getClient().runQueryCallable());
    }

    boolean shouldRetryQuery(Throwable throwable, @Nullable ByteString transactionId, long startTimeNanos, Set<StatusCode.Code> retryableCodes) {
        if (transactionId != null) {
            return false;
        }
        if (!this.isRetryableError(throwable, retryableCodes)) {
            return false;
        }
        if (this.rpcContext.getTotalRequestTimeout().isZero()) {
            return true;
        }
        Duration duration = Duration.ofNanos((long)(this.rpcContext.getClock().nanoTime() - startTimeNanos));
        return duration.compareTo(this.rpcContext.getTotalRequestTimeout()) < 0;
    }

    private boolean isRetryableError(Throwable throwable, Set<StatusCode.Code> retryableCodes) {
        if (!(throwable instanceof FirestoreException)) {
            return false;
        }
        Status status = ((FirestoreException)((Object)throwable)).getStatus();
        for (StatusCode.Code code : retryableCodes) {
            if (!code.equals((Object)StatusCode.Code.valueOf((String)status.getCode().name()))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("%s{options=%s}", this.getClass().getSimpleName(), this.options);
    }
}

