/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreAdminClient;
import com.google.cloud.firestore.v1.stub.FirestoreAdminStub;
import com.google.cloud.firestore.v1.stub.GrpcFirestoreAdminStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.firestore.admin.v1.CreateIndexRequest;
import com.google.firestore.admin.v1.DeleteIndexRequest;
import com.google.firestore.admin.v1.ExportDocumentsRequest;
import com.google.firestore.admin.v1.Field;
import com.google.firestore.admin.v1.GetFieldRequest;
import com.google.firestore.admin.v1.GetIndexRequest;
import com.google.firestore.admin.v1.ImportDocumentsRequest;
import com.google.firestore.admin.v1.Index;
import com.google.firestore.admin.v1.ListFieldsRequest;
import com.google.firestore.admin.v1.ListFieldsResponse;
import com.google.firestore.admin.v1.ListIndexesRequest;
import com.google.firestore.admin.v1.ListIndexesResponse;
import com.google.firestore.admin.v1.UpdateFieldRequest;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class FirestoreAdminStubSettings
extends StubSettings<FirestoreAdminStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/datastore").build();
    private final UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings;
    private final PagedCallSettings<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
    private final UnaryCallSettings<GetIndexRequest, Index> getIndexSettings;
    private final UnaryCallSettings<DeleteIndexRequest, Empty> deleteIndexSettings;
    private final UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings;
    private final UnaryCallSettings<ExportDocumentsRequest, Operation> exportDocumentsSettings;
    private final UnaryCallSettings<GetFieldRequest, Field> getFieldSettings;
    private final PagedCallSettings<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings;
    private final UnaryCallSettings<UpdateFieldRequest, Operation> updateFieldSettings;
    private static final PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index> LIST_INDEXES_PAGE_STR_DESC = new PagedListDescriptor<ListIndexesRequest, ListIndexesResponse, Index>(){

        public String emptyToken() {
            return "";
        }

        public ListIndexesRequest injectToken(ListIndexesRequest payload, String token) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageToken(token).build();
        }

        public ListIndexesRequest injectPageSize(ListIndexesRequest payload, int pageSize) {
            return ListIndexesRequest.newBuilder((ListIndexesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListIndexesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListIndexesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Index> extractResources(ListIndexesResponse payload) {
            return payload.getIndexesList() != null ? payload.getIndexesList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListFieldsRequest, ListFieldsResponse, Field> LIST_FIELDS_PAGE_STR_DESC = new PagedListDescriptor<ListFieldsRequest, ListFieldsResponse, Field>(){

        public String emptyToken() {
            return "";
        }

        public ListFieldsRequest injectToken(ListFieldsRequest payload, String token) {
            return ListFieldsRequest.newBuilder((ListFieldsRequest)payload).setPageToken(token).build();
        }

        public ListFieldsRequest injectPageSize(ListFieldsRequest payload, int pageSize) {
            return ListFieldsRequest.newBuilder((ListFieldsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListFieldsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListFieldsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Field> extractResources(ListFieldsResponse payload) {
            return payload.getFieldsList() != null ? payload.getFieldsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> LIST_INDEXES_PAGE_STR_FACT = new PagedListResponseFactory<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse>(){

        public ApiFuture<FirestoreAdminClient.ListIndexesPagedResponse> getFuturePagedResponse(UnaryCallable<ListIndexesRequest, ListIndexesResponse> callable, ListIndexesRequest request, ApiCallContext context, ApiFuture<ListIndexesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INDEXES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirestoreAdminClient.ListIndexesPagedResponse.createAsync((PageContext<ListIndexesRequest, ListIndexesResponse, Index>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> LIST_FIELDS_PAGE_STR_FACT = new PagedListResponseFactory<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse>(){

        public ApiFuture<FirestoreAdminClient.ListFieldsPagedResponse> getFuturePagedResponse(UnaryCallable<ListFieldsRequest, ListFieldsResponse> callable, ListFieldsRequest request, ApiCallContext context, ApiFuture<ListFieldsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_FIELDS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return FirestoreAdminClient.ListFieldsPagedResponse.createAsync((PageContext<ListFieldsRequest, ListFieldsResponse, Field>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateIndexRequest, Operation> createIndexSettings() {
        return this.createIndexSettings;
    }

    public PagedCallSettings<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
        return this.listIndexesSettings;
    }

    public UnaryCallSettings<GetIndexRequest, Index> getIndexSettings() {
        return this.getIndexSettings;
    }

    public UnaryCallSettings<DeleteIndexRequest, Empty> deleteIndexSettings() {
        return this.deleteIndexSettings;
    }

    public UnaryCallSettings<ImportDocumentsRequest, Operation> importDocumentsSettings() {
        return this.importDocumentsSettings;
    }

    public UnaryCallSettings<ExportDocumentsRequest, Operation> exportDocumentsSettings() {
        return this.exportDocumentsSettings;
    }

    public UnaryCallSettings<GetFieldRequest, Field> getFieldSettings() {
        return this.getFieldSettings;
    }

    public PagedCallSettings<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings() {
        return this.listFieldsSettings;
    }

    public UnaryCallSettings<UpdateFieldRequest, Operation> updateFieldSettings() {
        return this.updateFieldSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public FirestoreAdminStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcFirestoreAdminStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "firestore.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return FirestoreAdminStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(FirestoreAdminStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected FirestoreAdminStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createIndexSettings = settingsBuilder.createIndexSettings().build();
        this.listIndexesSettings = settingsBuilder.listIndexesSettings().build();
        this.getIndexSettings = settingsBuilder.getIndexSettings().build();
        this.deleteIndexSettings = settingsBuilder.deleteIndexSettings().build();
        this.importDocumentsSettings = settingsBuilder.importDocumentsSettings().build();
        this.exportDocumentsSettings = settingsBuilder.exportDocumentsSettings().build();
        this.getFieldSettings = settingsBuilder.getFieldSettings().build();
        this.listFieldsSettings = settingsBuilder.listFieldsSettings().build();
        this.updateFieldSettings = settingsBuilder.updateFieldSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<FirestoreAdminStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings;
        private final PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings;
        private final UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings;
        private final UnaryCallSettings.Builder<DeleteIndexRequest, Empty> deleteIndexSettings;
        private final UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings;
        private final UnaryCallSettings.Builder<ExportDocumentsRequest, Operation> exportDocumentsSettings;
        private final UnaryCallSettings.Builder<GetFieldRequest, Field> getFieldSettings;
        private final PagedCallSettings.Builder<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings;
        private final UnaryCallSettings.Builder<UpdateFieldRequest, Operation> updateFieldSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listIndexesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INDEXES_PAGE_STR_FACT);
            this.getIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteIndexSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listFieldsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_FIELDS_PAGE_STR_FACT);
            this.updateFieldSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.listIndexesSettings, this.getIndexSettings, this.deleteIndexSettings, this.importDocumentsSettings, this.exportDocumentsSettings, this.getFieldSettings, this.listFieldsSettings, this.updateFieldSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(FirestoreAdminStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)FirestoreAdminStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)FirestoreAdminStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(FirestoreAdminStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listIndexesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteIndexSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.importDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.exportDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listFieldsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.updateFieldSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(FirestoreAdminStubSettings settings) {
            super((StubSettings)settings);
            this.createIndexSettings = settings.createIndexSettings.toBuilder();
            this.listIndexesSettings = settings.listIndexesSettings.toBuilder();
            this.getIndexSettings = settings.getIndexSettings.toBuilder();
            this.deleteIndexSettings = settings.deleteIndexSettings.toBuilder();
            this.importDocumentsSettings = settings.importDocumentsSettings.toBuilder();
            this.exportDocumentsSettings = settings.exportDocumentsSettings.toBuilder();
            this.getFieldSettings = settings.getFieldSettings.toBuilder();
            this.listFieldsSettings = settings.listFieldsSettings.toBuilder();
            this.updateFieldSettings = settings.updateFieldSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createIndexSettings, this.listIndexesSettings, this.getIndexSettings, this.deleteIndexSettings, this.importDocumentsSettings, this.exportDocumentsSettings, this.getFieldSettings, this.listFieldsSettings, this.updateFieldSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateIndexRequest, Operation> createIndexSettings() {
            return this.createIndexSettings;
        }

        public PagedCallSettings.Builder<ListIndexesRequest, ListIndexesResponse, FirestoreAdminClient.ListIndexesPagedResponse> listIndexesSettings() {
            return this.listIndexesSettings;
        }

        public UnaryCallSettings.Builder<GetIndexRequest, Index> getIndexSettings() {
            return this.getIndexSettings;
        }

        public UnaryCallSettings.Builder<DeleteIndexRequest, Empty> deleteIndexSettings() {
            return this.deleteIndexSettings;
        }

        public UnaryCallSettings.Builder<ImportDocumentsRequest, Operation> importDocumentsSettings() {
            return this.importDocumentsSettings;
        }

        public UnaryCallSettings.Builder<ExportDocumentsRequest, Operation> exportDocumentsSettings() {
            return this.exportDocumentsSettings;
        }

        public UnaryCallSettings.Builder<GetFieldRequest, Field> getFieldSettings() {
            return this.getFieldSettings;
        }

        public PagedCallSettings.Builder<ListFieldsRequest, ListFieldsResponse, FirestoreAdminClient.ListFieldsPagedResponse> listFieldsSettings() {
            return this.listFieldsSettings;
        }

        public UnaryCallSettings.Builder<UpdateFieldRequest, Operation> updateFieldSettings() {
            return this.updateFieldSettings;
        }

        public FirestoreAdminStubSettings build() throws IOException {
            return new FirestoreAdminStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

