/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.DocumentSnapshot;
import com.google.cloud.firestore.FirestoreImpl;
import com.google.cloud.firestore.ResourcePath;
import com.google.common.base.Preconditions;
import com.google.firestore.v1beta1.Document;
import com.google.firestore.v1beta1.Value;
import com.google.protobuf.Timestamp;
import java.util.Map;
import javax.annotation.Nonnull;
import org.threeten.bp.Instant;

public final class QueryDocumentSnapshot
extends DocumentSnapshot {
    private QueryDocumentSnapshot(FirestoreImpl firestore, DocumentReference docRef, Map<String, Value> fields, Instant readTime, Instant updateTime, Instant createTime) {
        super(firestore, docRef, fields, readTime, updateTime, createTime);
    }

    static QueryDocumentSnapshot fromDocument(FirestoreImpl firestore, Timestamp readTime, Document document) {
        Timestamp updateTime = document.getUpdateTime();
        Timestamp createTime = document.getCreateTime();
        return new QueryDocumentSnapshot(firestore, new DocumentReference(firestore, ResourcePath.create(document.getName())), document.getFieldsMap(), Instant.ofEpochSecond((long)readTime.getSeconds(), (long)readTime.getNanos()), Instant.ofEpochSecond((long)updateTime.getSeconds(), (long)updateTime.getNanos()), Instant.ofEpochSecond((long)createTime.getSeconds(), (long)createTime.getNanos()));
    }

    @Override
    @Nonnull
    public Map<String, Object> getData() {
        Map<String, Object> result = super.getData();
        Preconditions.checkNotNull(result, (Object)"Data in a QueryDocumentSnapshot should be non-null");
        return result;
    }

    @Override
    @Nonnull
    public <T> T toObject(@Nonnull Class<T> valueType) {
        T result = super.toObject(valueType);
        Preconditions.checkNotNull(result, (Object)"Object in a QueryDocumentSnapshot should be non-null");
        return result;
    }
}

