/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.firestore.v1beta1.DocumentMask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

final class DocumentMask {
    static final DocumentMask EMPTY_MASK = new DocumentMask((SortedSet<FieldPath>)new TreeSet<FieldPath>());
    private final SortedSet<FieldPath> fieldPaths;

    DocumentMask(Collection<FieldPath> fieldPaths) {
        this((SortedSet<FieldPath>)new TreeSet<FieldPath>(fieldPaths));
    }

    private DocumentMask(SortedSet<FieldPath> fieldPaths) {
        this.fieldPaths = fieldPaths;
    }

    static DocumentMask fromObject(Map<String, Object> values) {
        List<FieldPath> fieldPaths = DocumentMask.extractFromMap(values, FieldPath.empty());
        return new DocumentMask(fieldPaths);
    }

    private static List<FieldPath> extractFromMap(Map<String, Object> values, FieldPath path) {
        ArrayList<FieldPath> fieldPaths = new ArrayList<FieldPath>();
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            Object value = entry.getValue();
            FieldPath childPath = path.append(FieldPath.of(entry.getKey()));
            if (entry.getValue() == FieldValue.SERVER_TIMESTAMP_SENTINEL) continue;
            if (entry.getValue() == FieldValue.DELETE_SENTINEL) {
                fieldPaths.add(childPath);
                continue;
            }
            if (value instanceof Map) {
                fieldPaths.addAll(DocumentMask.extractFromMap((Map)value, childPath));
                continue;
            }
            fieldPaths.add(childPath);
        }
        return fieldPaths;
    }

    com.google.firestore.v1beta1.DocumentMask toPb() {
        DocumentMask.Builder updateMask = com.google.firestore.v1beta1.DocumentMask.newBuilder();
        for (FieldPath fieldPath : this.fieldPaths) {
            updateMask.addFieldPaths(fieldPath.getEncodedPath());
        }
        return updateMask.build();
    }

    boolean isEmpty() {
        return this.fieldPaths.isEmpty();
    }
}

