/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.ChannelConnectionName;
import com.google.cloud.eventarc.v1.ChannelName;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateEnrollmentRequest;
import com.google.cloud.eventarc.v1.CreateGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.CreateMessageBusRequest;
import com.google.cloud.eventarc.v1.CreatePipelineRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteEnrollmentRequest;
import com.google.cloud.eventarc.v1.DeleteGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.DeleteMessageBusRequest;
import com.google.cloud.eventarc.v1.DeletePipelineRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.Enrollment;
import com.google.cloud.eventarc.v1.EnrollmentName;
import com.google.cloud.eventarc.v1.EventarcSettings;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetEnrollmentRequest;
import com.google.cloud.eventarc.v1.GetGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.GetGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.GetMessageBusRequest;
import com.google.cloud.eventarc.v1.GetPipelineRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.GoogleApiSource;
import com.google.cloud.eventarc.v1.GoogleApiSourceName;
import com.google.cloud.eventarc.v1.GoogleChannelConfig;
import com.google.cloud.eventarc.v1.GoogleChannelConfigName;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListEnrollmentsRequest;
import com.google.cloud.eventarc.v1.ListEnrollmentsResponse;
import com.google.cloud.eventarc.v1.ListGoogleApiSourcesRequest;
import com.google.cloud.eventarc.v1.ListGoogleApiSourcesResponse;
import com.google.cloud.eventarc.v1.ListMessageBusEnrollmentsRequest;
import com.google.cloud.eventarc.v1.ListMessageBusEnrollmentsResponse;
import com.google.cloud.eventarc.v1.ListMessageBusesRequest;
import com.google.cloud.eventarc.v1.ListMessageBusesResponse;
import com.google.cloud.eventarc.v1.ListPipelinesRequest;
import com.google.cloud.eventarc.v1.ListPipelinesResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.LocationName;
import com.google.cloud.eventarc.v1.MessageBus;
import com.google.cloud.eventarc.v1.MessageBusName;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Pipeline;
import com.google.cloud.eventarc.v1.PipelineName;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.ProviderName;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.TriggerName;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateEnrollmentRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleApiSourceRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.UpdateMessageBusRequest;
import com.google.cloud.eventarc.v1.UpdatePipelineRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.EventarcStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class EventarcClient
implements BackgroundResource {
    private final EventarcSettings settings;
    private final EventarcStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final EventarcClient create() throws IOException {
        return EventarcClient.create(EventarcSettings.newBuilder().build());
    }

    public static final EventarcClient create(EventarcSettings settings) throws IOException {
        return new EventarcClient(settings);
    }

    public static final EventarcClient create(EventarcStub stub) {
        return new EventarcClient(stub);
    }

    protected EventarcClient(EventarcSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((EventarcStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected EventarcClient(EventarcStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final EventarcSettings getSettings() {
        return this.settings;
    }

    public EventarcStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final Trigger getTrigger(TriggerName name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(String name) {
        GetTriggerRequest request = GetTriggerRequest.newBuilder().setName(name).build();
        return this.getTrigger(request);
    }

    public final Trigger getTrigger(GetTriggerRequest request) {
        return (Trigger)this.getTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetTriggerRequest, Trigger> getTriggerCallable() {
        return this.stub.getTriggerCallable();
    }

    public final ListTriggersPagedResponse listTriggers(LocationName parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(String parent) {
        ListTriggersRequest request = ListTriggersRequest.newBuilder().setParent(parent).build();
        return this.listTriggers(request);
    }

    public final ListTriggersPagedResponse listTriggers(ListTriggersRequest request) {
        return (ListTriggersPagedResponse)((Object)this.listTriggersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersPagedResponse> listTriggersPagedCallable() {
        return this.stub.listTriggersPagedCallable();
    }

    public final UnaryCallable<ListTriggersRequest, ListTriggersResponse> listTriggersCallable() {
        return this.stub.listTriggersCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(LocationName parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(String parent, Trigger trigger, String triggerId) {
        CreateTriggerRequest request = CreateTriggerRequest.newBuilder().setParent(parent).setTrigger(trigger).setTriggerId(triggerId).build();
        return this.createTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> createTriggerAsync(CreateTriggerRequest request) {
        return this.createTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationCallable() {
        return this.stub.createTriggerOperationCallable();
    }

    public final UnaryCallable<CreateTriggerRequest, Operation> createTriggerCallable() {
        return this.stub.createTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(Trigger trigger, FieldMask updateMask, boolean allowMissing) {
        UpdateTriggerRequest request = UpdateTriggerRequest.newBuilder().setTrigger(trigger).setUpdateMask(updateMask).setAllowMissing(allowMissing).build();
        return this.updateTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> updateTriggerAsync(UpdateTriggerRequest request) {
        return this.updateTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationCallable() {
        return this.stub.updateTriggerOperationCallable();
    }

    public final UnaryCallable<UpdateTriggerRequest, Operation> updateTriggerCallable() {
        return this.stub.updateTriggerCallable();
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(TriggerName name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name == null ? null : name.toString()).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(String name, boolean allowMissing) {
        DeleteTriggerRequest request = DeleteTriggerRequest.newBuilder().setName(name).setAllowMissing(allowMissing).build();
        return this.deleteTriggerAsync(request);
    }

    public final OperationFuture<Trigger, OperationMetadata> deleteTriggerAsync(DeleteTriggerRequest request) {
        return this.deleteTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationCallable() {
        return this.stub.deleteTriggerOperationCallable();
    }

    public final UnaryCallable<DeleteTriggerRequest, Operation> deleteTriggerCallable() {
        return this.stub.deleteTriggerCallable();
    }

    public final Channel getChannel(ChannelName name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(String name) {
        GetChannelRequest request = GetChannelRequest.newBuilder().setName(name).build();
        return this.getChannel(request);
    }

    public final Channel getChannel(GetChannelRequest request) {
        return (Channel)this.getChannelCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelRequest, Channel> getChannelCallable() {
        return this.stub.getChannelCallable();
    }

    public final ListChannelsPagedResponse listChannels(LocationName parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(String parent) {
        ListChannelsRequest request = ListChannelsRequest.newBuilder().setParent(parent).build();
        return this.listChannels(request);
    }

    public final ListChannelsPagedResponse listChannels(ListChannelsRequest request) {
        return (ListChannelsPagedResponse)((Object)this.listChannelsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsPagedResponse> listChannelsPagedCallable() {
        return this.stub.listChannelsPagedCallable();
    }

    public final UnaryCallable<ListChannelsRequest, ListChannelsResponse> listChannelsCallable() {
        return this.stub.listChannelsCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(LocationName parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(String parent, Channel channel, String channelId) {
        CreateChannelRequest request = CreateChannelRequest.newBuilder().setParent(parent).setChannel(channel).setChannelId(channelId).build();
        return this.createChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> createChannelAsync(CreateChannelRequest request) {
        return this.createChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationCallable() {
        return this.stub.createChannelOperationCallable();
    }

    public final UnaryCallable<CreateChannelRequest, Operation> createChannelCallable() {
        return this.stub.createChannelCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(Channel channel, FieldMask updateMask) {
        UpdateChannelRequest request = UpdateChannelRequest.newBuilder().setChannel(channel).setUpdateMask(updateMask).build();
        return this.updateChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> updateChannelAsync(UpdateChannelRequest request) {
        return this.updateChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationCallable() {
        return this.stub.updateChannelOperationCallable();
    }

    public final UnaryCallable<UpdateChannelRequest, Operation> updateChannelCallable() {
        return this.stub.updateChannelCallable();
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(ChannelName name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(String name) {
        DeleteChannelRequest request = DeleteChannelRequest.newBuilder().setName(name).build();
        return this.deleteChannelAsync(request);
    }

    public final OperationFuture<Channel, OperationMetadata> deleteChannelAsync(DeleteChannelRequest request) {
        return this.deleteChannelOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationCallable() {
        return this.stub.deleteChannelOperationCallable();
    }

    public final UnaryCallable<DeleteChannelRequest, Operation> deleteChannelCallable() {
        return this.stub.deleteChannelCallable();
    }

    public final Provider getProvider(ProviderName name) {
        GetProviderRequest request = GetProviderRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getProvider(request);
    }

    public final Provider getProvider(String name) {
        GetProviderRequest request = GetProviderRequest.newBuilder().setName(name).build();
        return this.getProvider(request);
    }

    public final Provider getProvider(GetProviderRequest request) {
        return (Provider)this.getProviderCallable().call((Object)request);
    }

    public final UnaryCallable<GetProviderRequest, Provider> getProviderCallable() {
        return this.stub.getProviderCallable();
    }

    public final ListProvidersPagedResponse listProviders(LocationName parent) {
        ListProvidersRequest request = ListProvidersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listProviders(request);
    }

    public final ListProvidersPagedResponse listProviders(String parent) {
        ListProvidersRequest request = ListProvidersRequest.newBuilder().setParent(parent).build();
        return this.listProviders(request);
    }

    public final ListProvidersPagedResponse listProviders(ListProvidersRequest request) {
        return (ListProvidersPagedResponse)((Object)this.listProvidersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListProvidersRequest, ListProvidersPagedResponse> listProvidersPagedCallable() {
        return this.stub.listProvidersPagedCallable();
    }

    public final UnaryCallable<ListProvidersRequest, ListProvidersResponse> listProvidersCallable() {
        return this.stub.listProvidersCallable();
    }

    public final ChannelConnection getChannelConnection(ChannelConnectionName name) {
        GetChannelConnectionRequest request = GetChannelConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChannelConnection(request);
    }

    public final ChannelConnection getChannelConnection(String name) {
        GetChannelConnectionRequest request = GetChannelConnectionRequest.newBuilder().setName(name).build();
        return this.getChannelConnection(request);
    }

    public final ChannelConnection getChannelConnection(GetChannelConnectionRequest request) {
        return (ChannelConnection)this.getChannelConnectionCallable().call((Object)request);
    }

    public final UnaryCallable<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionCallable() {
        return this.stub.getChannelConnectionCallable();
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(LocationName parent) {
        ListChannelConnectionsRequest request = ListChannelConnectionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChannelConnections(request);
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(String parent) {
        ListChannelConnectionsRequest request = ListChannelConnectionsRequest.newBuilder().setParent(parent).build();
        return this.listChannelConnections(request);
    }

    public final ListChannelConnectionsPagedResponse listChannelConnections(ListChannelConnectionsRequest request) {
        return (ListChannelConnectionsPagedResponse)((Object)this.listChannelConnectionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsPagedResponse> listChannelConnectionsPagedCallable() {
        return this.stub.listChannelConnectionsPagedCallable();
    }

    public final UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> listChannelConnectionsCallable() {
        return this.stub.listChannelConnectionsCallable();
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(LocationName parent, ChannelConnection channelConnection, String channelConnectionId) {
        CreateChannelConnectionRequest request = CreateChannelConnectionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setChannelConnection(channelConnection).setChannelConnectionId(channelConnectionId).build();
        return this.createChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(String parent, ChannelConnection channelConnection, String channelConnectionId) {
        CreateChannelConnectionRequest request = CreateChannelConnectionRequest.newBuilder().setParent(parent).setChannelConnection(channelConnection).setChannelConnectionId(channelConnectionId).build();
        return this.createChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> createChannelConnectionAsync(CreateChannelConnectionRequest request) {
        return this.createChannelConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationCallable() {
        return this.stub.createChannelConnectionOperationCallable();
    }

    public final UnaryCallable<CreateChannelConnectionRequest, Operation> createChannelConnectionCallable() {
        return this.stub.createChannelConnectionCallable();
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(ChannelConnectionName name) {
        DeleteChannelConnectionRequest request = DeleteChannelConnectionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(String name) {
        DeleteChannelConnectionRequest request = DeleteChannelConnectionRequest.newBuilder().setName(name).build();
        return this.deleteChannelConnectionAsync(request);
    }

    public final OperationFuture<ChannelConnection, OperationMetadata> deleteChannelConnectionAsync(DeleteChannelConnectionRequest request) {
        return this.deleteChannelConnectionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationCallable() {
        return this.stub.deleteChannelConnectionOperationCallable();
    }

    public final UnaryCallable<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionCallable() {
        return this.stub.deleteChannelConnectionCallable();
    }

    public final GoogleChannelConfig getGoogleChannelConfig(GoogleChannelConfigName name) {
        GetGoogleChannelConfigRequest request = GetGoogleChannelConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGoogleChannelConfig(request);
    }

    public final GoogleChannelConfig getGoogleChannelConfig(String name) {
        GetGoogleChannelConfigRequest request = GetGoogleChannelConfigRequest.newBuilder().setName(name).build();
        return this.getGoogleChannelConfig(request);
    }

    public final GoogleChannelConfig getGoogleChannelConfig(GetGoogleChannelConfigRequest request) {
        return (GoogleChannelConfig)this.getGoogleChannelConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigCallable() {
        return this.stub.getGoogleChannelConfigCallable();
    }

    public final GoogleChannelConfig updateGoogleChannelConfig(GoogleChannelConfig googleChannelConfig, FieldMask updateMask) {
        UpdateGoogleChannelConfigRequest request = UpdateGoogleChannelConfigRequest.newBuilder().setGoogleChannelConfig(googleChannelConfig).setUpdateMask(updateMask).build();
        return this.updateGoogleChannelConfig(request);
    }

    public final GoogleChannelConfig updateGoogleChannelConfig(UpdateGoogleChannelConfigRequest request) {
        return (GoogleChannelConfig)this.updateGoogleChannelConfigCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigCallable() {
        return this.stub.updateGoogleChannelConfigCallable();
    }

    public final MessageBus getMessageBus(MessageBusName name) {
        GetMessageBusRequest request = GetMessageBusRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getMessageBus(request);
    }

    public final MessageBus getMessageBus(String name) {
        GetMessageBusRequest request = GetMessageBusRequest.newBuilder().setName(name).build();
        return this.getMessageBus(request);
    }

    public final MessageBus getMessageBus(GetMessageBusRequest request) {
        return (MessageBus)this.getMessageBusCallable().call((Object)request);
    }

    public final UnaryCallable<GetMessageBusRequest, MessageBus> getMessageBusCallable() {
        return this.stub.getMessageBusCallable();
    }

    public final ListMessageBusesPagedResponse listMessageBuses(LocationName parent) {
        ListMessageBusesRequest request = ListMessageBusesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMessageBuses(request);
    }

    public final ListMessageBusesPagedResponse listMessageBuses(String parent) {
        ListMessageBusesRequest request = ListMessageBusesRequest.newBuilder().setParent(parent).build();
        return this.listMessageBuses(request);
    }

    public final ListMessageBusesPagedResponse listMessageBuses(ListMessageBusesRequest request) {
        return (ListMessageBusesPagedResponse)((Object)this.listMessageBusesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMessageBusesRequest, ListMessageBusesPagedResponse> listMessageBusesPagedCallable() {
        return this.stub.listMessageBusesPagedCallable();
    }

    public final UnaryCallable<ListMessageBusesRequest, ListMessageBusesResponse> listMessageBusesCallable() {
        return this.stub.listMessageBusesCallable();
    }

    public final ListMessageBusEnrollmentsPagedResponse listMessageBusEnrollments(MessageBusName parent) {
        ListMessageBusEnrollmentsRequest request = ListMessageBusEnrollmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listMessageBusEnrollments(request);
    }

    public final ListMessageBusEnrollmentsPagedResponse listMessageBusEnrollments(String parent) {
        ListMessageBusEnrollmentsRequest request = ListMessageBusEnrollmentsRequest.newBuilder().setParent(parent).build();
        return this.listMessageBusEnrollments(request);
    }

    public final ListMessageBusEnrollmentsPagedResponse listMessageBusEnrollments(ListMessageBusEnrollmentsRequest request) {
        return (ListMessageBusEnrollmentsPagedResponse)((Object)this.listMessageBusEnrollmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsPagedResponse> listMessageBusEnrollmentsPagedCallable() {
        return this.stub.listMessageBusEnrollmentsPagedCallable();
    }

    public final UnaryCallable<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse> listMessageBusEnrollmentsCallable() {
        return this.stub.listMessageBusEnrollmentsCallable();
    }

    public final OperationFuture<MessageBus, OperationMetadata> createMessageBusAsync(LocationName parent, MessageBus messageBus, String messageBusId) {
        CreateMessageBusRequest request = CreateMessageBusRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setMessageBus(messageBus).setMessageBusId(messageBusId).build();
        return this.createMessageBusAsync(request);
    }

    public final OperationFuture<MessageBus, OperationMetadata> createMessageBusAsync(String parent, MessageBus messageBus, String messageBusId) {
        CreateMessageBusRequest request = CreateMessageBusRequest.newBuilder().setParent(parent).setMessageBus(messageBus).setMessageBusId(messageBusId).build();
        return this.createMessageBusAsync(request);
    }

    public final OperationFuture<MessageBus, OperationMetadata> createMessageBusAsync(CreateMessageBusRequest request) {
        return this.createMessageBusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateMessageBusRequest, MessageBus, OperationMetadata> createMessageBusOperationCallable() {
        return this.stub.createMessageBusOperationCallable();
    }

    public final UnaryCallable<CreateMessageBusRequest, Operation> createMessageBusCallable() {
        return this.stub.createMessageBusCallable();
    }

    public final OperationFuture<MessageBus, OperationMetadata> updateMessageBusAsync(MessageBus messageBus, FieldMask updateMask) {
        UpdateMessageBusRequest request = UpdateMessageBusRequest.newBuilder().setMessageBus(messageBus).setUpdateMask(updateMask).build();
        return this.updateMessageBusAsync(request);
    }

    public final OperationFuture<MessageBus, OperationMetadata> updateMessageBusAsync(UpdateMessageBusRequest request) {
        return this.updateMessageBusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateMessageBusRequest, MessageBus, OperationMetadata> updateMessageBusOperationCallable() {
        return this.stub.updateMessageBusOperationCallable();
    }

    public final UnaryCallable<UpdateMessageBusRequest, Operation> updateMessageBusCallable() {
        return this.stub.updateMessageBusCallable();
    }

    public final OperationFuture<MessageBus, OperationMetadata> deleteMessageBusAsync(MessageBusName name, String etag) {
        DeleteMessageBusRequest request = DeleteMessageBusRequest.newBuilder().setName(name == null ? null : name.toString()).setEtag(etag).build();
        return this.deleteMessageBusAsync(request);
    }

    public final OperationFuture<MessageBus, OperationMetadata> deleteMessageBusAsync(String name, String etag) {
        DeleteMessageBusRequest request = DeleteMessageBusRequest.newBuilder().setName(name).setEtag(etag).build();
        return this.deleteMessageBusAsync(request);
    }

    public final OperationFuture<MessageBus, OperationMetadata> deleteMessageBusAsync(DeleteMessageBusRequest request) {
        return this.deleteMessageBusOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteMessageBusRequest, MessageBus, OperationMetadata> deleteMessageBusOperationCallable() {
        return this.stub.deleteMessageBusOperationCallable();
    }

    public final UnaryCallable<DeleteMessageBusRequest, Operation> deleteMessageBusCallable() {
        return this.stub.deleteMessageBusCallable();
    }

    public final Enrollment getEnrollment(EnrollmentName name) {
        GetEnrollmentRequest request = GetEnrollmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEnrollment(request);
    }

    public final Enrollment getEnrollment(String name) {
        GetEnrollmentRequest request = GetEnrollmentRequest.newBuilder().setName(name).build();
        return this.getEnrollment(request);
    }

    public final Enrollment getEnrollment(GetEnrollmentRequest request) {
        return (Enrollment)this.getEnrollmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetEnrollmentRequest, Enrollment> getEnrollmentCallable() {
        return this.stub.getEnrollmentCallable();
    }

    public final ListEnrollmentsPagedResponse listEnrollments(LocationName parent) {
        ListEnrollmentsRequest request = ListEnrollmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listEnrollments(request);
    }

    public final ListEnrollmentsPagedResponse listEnrollments(String parent) {
        ListEnrollmentsRequest request = ListEnrollmentsRequest.newBuilder().setParent(parent).build();
        return this.listEnrollments(request);
    }

    public final ListEnrollmentsPagedResponse listEnrollments(ListEnrollmentsRequest request) {
        return (ListEnrollmentsPagedResponse)((Object)this.listEnrollmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListEnrollmentsRequest, ListEnrollmentsPagedResponse> listEnrollmentsPagedCallable() {
        return this.stub.listEnrollmentsPagedCallable();
    }

    public final UnaryCallable<ListEnrollmentsRequest, ListEnrollmentsResponse> listEnrollmentsCallable() {
        return this.stub.listEnrollmentsCallable();
    }

    public final OperationFuture<Enrollment, OperationMetadata> createEnrollmentAsync(LocationName parent, Enrollment enrollment, String enrollmentId) {
        CreateEnrollmentRequest request = CreateEnrollmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setEnrollment(enrollment).setEnrollmentId(enrollmentId).build();
        return this.createEnrollmentAsync(request);
    }

    public final OperationFuture<Enrollment, OperationMetadata> createEnrollmentAsync(String parent, Enrollment enrollment, String enrollmentId) {
        CreateEnrollmentRequest request = CreateEnrollmentRequest.newBuilder().setParent(parent).setEnrollment(enrollment).setEnrollmentId(enrollmentId).build();
        return this.createEnrollmentAsync(request);
    }

    public final OperationFuture<Enrollment, OperationMetadata> createEnrollmentAsync(CreateEnrollmentRequest request) {
        return this.createEnrollmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateEnrollmentRequest, Enrollment, OperationMetadata> createEnrollmentOperationCallable() {
        return this.stub.createEnrollmentOperationCallable();
    }

    public final UnaryCallable<CreateEnrollmentRequest, Operation> createEnrollmentCallable() {
        return this.stub.createEnrollmentCallable();
    }

    public final OperationFuture<Enrollment, OperationMetadata> updateEnrollmentAsync(Enrollment enrollment, FieldMask updateMask) {
        UpdateEnrollmentRequest request = UpdateEnrollmentRequest.newBuilder().setEnrollment(enrollment).setUpdateMask(updateMask).build();
        return this.updateEnrollmentAsync(request);
    }

    public final OperationFuture<Enrollment, OperationMetadata> updateEnrollmentAsync(UpdateEnrollmentRequest request) {
        return this.updateEnrollmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateEnrollmentRequest, Enrollment, OperationMetadata> updateEnrollmentOperationCallable() {
        return this.stub.updateEnrollmentOperationCallable();
    }

    public final UnaryCallable<UpdateEnrollmentRequest, Operation> updateEnrollmentCallable() {
        return this.stub.updateEnrollmentCallable();
    }

    public final OperationFuture<Enrollment, OperationMetadata> deleteEnrollmentAsync(EnrollmentName name, String etag) {
        DeleteEnrollmentRequest request = DeleteEnrollmentRequest.newBuilder().setName(name == null ? null : name.toString()).setEtag(etag).build();
        return this.deleteEnrollmentAsync(request);
    }

    public final OperationFuture<Enrollment, OperationMetadata> deleteEnrollmentAsync(String name, String etag) {
        DeleteEnrollmentRequest request = DeleteEnrollmentRequest.newBuilder().setName(name).setEtag(etag).build();
        return this.deleteEnrollmentAsync(request);
    }

    public final OperationFuture<Enrollment, OperationMetadata> deleteEnrollmentAsync(DeleteEnrollmentRequest request) {
        return this.deleteEnrollmentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteEnrollmentRequest, Enrollment, OperationMetadata> deleteEnrollmentOperationCallable() {
        return this.stub.deleteEnrollmentOperationCallable();
    }

    public final UnaryCallable<DeleteEnrollmentRequest, Operation> deleteEnrollmentCallable() {
        return this.stub.deleteEnrollmentCallable();
    }

    public final Pipeline getPipeline(PipelineName name) {
        GetPipelineRequest request = GetPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPipeline(request);
    }

    public final Pipeline getPipeline(String name) {
        GetPipelineRequest request = GetPipelineRequest.newBuilder().setName(name).build();
        return this.getPipeline(request);
    }

    public final Pipeline getPipeline(GetPipelineRequest request) {
        return (Pipeline)this.getPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<GetPipelineRequest, Pipeline> getPipelineCallable() {
        return this.stub.getPipelineCallable();
    }

    public final ListPipelinesPagedResponse listPipelines(LocationName parent) {
        ListPipelinesRequest request = ListPipelinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listPipelines(request);
    }

    public final ListPipelinesPagedResponse listPipelines(String parent) {
        ListPipelinesRequest request = ListPipelinesRequest.newBuilder().setParent(parent).build();
        return this.listPipelines(request);
    }

    public final ListPipelinesPagedResponse listPipelines(ListPipelinesRequest request) {
        return (ListPipelinesPagedResponse)((Object)this.listPipelinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListPipelinesRequest, ListPipelinesPagedResponse> listPipelinesPagedCallable() {
        return this.stub.listPipelinesPagedCallable();
    }

    public final UnaryCallable<ListPipelinesRequest, ListPipelinesResponse> listPipelinesCallable() {
        return this.stub.listPipelinesCallable();
    }

    public final OperationFuture<Pipeline, OperationMetadata> createPipelineAsync(LocationName parent, Pipeline pipeline, String pipelineId) {
        CreatePipelineRequest request = CreatePipelineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setPipeline(pipeline).setPipelineId(pipelineId).build();
        return this.createPipelineAsync(request);
    }

    public final OperationFuture<Pipeline, OperationMetadata> createPipelineAsync(String parent, Pipeline pipeline, String pipelineId) {
        CreatePipelineRequest request = CreatePipelineRequest.newBuilder().setParent(parent).setPipeline(pipeline).setPipelineId(pipelineId).build();
        return this.createPipelineAsync(request);
    }

    public final OperationFuture<Pipeline, OperationMetadata> createPipelineAsync(CreatePipelineRequest request) {
        return this.createPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreatePipelineRequest, Pipeline, OperationMetadata> createPipelineOperationCallable() {
        return this.stub.createPipelineOperationCallable();
    }

    public final UnaryCallable<CreatePipelineRequest, Operation> createPipelineCallable() {
        return this.stub.createPipelineCallable();
    }

    public final OperationFuture<Pipeline, OperationMetadata> updatePipelineAsync(Pipeline pipeline, FieldMask updateMask) {
        UpdatePipelineRequest request = UpdatePipelineRequest.newBuilder().setPipeline(pipeline).setUpdateMask(updateMask).build();
        return this.updatePipelineAsync(request);
    }

    public final OperationFuture<Pipeline, OperationMetadata> updatePipelineAsync(UpdatePipelineRequest request) {
        return this.updatePipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdatePipelineRequest, Pipeline, OperationMetadata> updatePipelineOperationCallable() {
        return this.stub.updatePipelineOperationCallable();
    }

    public final UnaryCallable<UpdatePipelineRequest, Operation> updatePipelineCallable() {
        return this.stub.updatePipelineCallable();
    }

    public final OperationFuture<Pipeline, OperationMetadata> deletePipelineAsync(PipelineName name, String etag) {
        DeletePipelineRequest request = DeletePipelineRequest.newBuilder().setName(name == null ? null : name.toString()).setEtag(etag).build();
        return this.deletePipelineAsync(request);
    }

    public final OperationFuture<Pipeline, OperationMetadata> deletePipelineAsync(String name, String etag) {
        DeletePipelineRequest request = DeletePipelineRequest.newBuilder().setName(name).setEtag(etag).build();
        return this.deletePipelineAsync(request);
    }

    public final OperationFuture<Pipeline, OperationMetadata> deletePipelineAsync(DeletePipelineRequest request) {
        return this.deletePipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeletePipelineRequest, Pipeline, OperationMetadata> deletePipelineOperationCallable() {
        return this.stub.deletePipelineOperationCallable();
    }

    public final UnaryCallable<DeletePipelineRequest, Operation> deletePipelineCallable() {
        return this.stub.deletePipelineCallable();
    }

    public final GoogleApiSource getGoogleApiSource(GoogleApiSourceName name) {
        GetGoogleApiSourceRequest request = GetGoogleApiSourceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGoogleApiSource(request);
    }

    public final GoogleApiSource getGoogleApiSource(String name) {
        GetGoogleApiSourceRequest request = GetGoogleApiSourceRequest.newBuilder().setName(name).build();
        return this.getGoogleApiSource(request);
    }

    public final GoogleApiSource getGoogleApiSource(GetGoogleApiSourceRequest request) {
        return (GoogleApiSource)this.getGoogleApiSourceCallable().call((Object)request);
    }

    public final UnaryCallable<GetGoogleApiSourceRequest, GoogleApiSource> getGoogleApiSourceCallable() {
        return this.stub.getGoogleApiSourceCallable();
    }

    public final ListGoogleApiSourcesPagedResponse listGoogleApiSources(LocationName parent) {
        ListGoogleApiSourcesRequest request = ListGoogleApiSourcesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGoogleApiSources(request);
    }

    public final ListGoogleApiSourcesPagedResponse listGoogleApiSources(String parent) {
        ListGoogleApiSourcesRequest request = ListGoogleApiSourcesRequest.newBuilder().setParent(parent).build();
        return this.listGoogleApiSources(request);
    }

    public final ListGoogleApiSourcesPagedResponse listGoogleApiSources(ListGoogleApiSourcesRequest request) {
        return (ListGoogleApiSourcesPagedResponse)((Object)this.listGoogleApiSourcesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGoogleApiSourcesRequest, ListGoogleApiSourcesPagedResponse> listGoogleApiSourcesPagedCallable() {
        return this.stub.listGoogleApiSourcesPagedCallable();
    }

    public final UnaryCallable<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse> listGoogleApiSourcesCallable() {
        return this.stub.listGoogleApiSourcesCallable();
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> createGoogleApiSourceAsync(LocationName parent, GoogleApiSource googleApiSource, String googleApiSourceId) {
        CreateGoogleApiSourceRequest request = CreateGoogleApiSourceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGoogleApiSource(googleApiSource).setGoogleApiSourceId(googleApiSourceId).build();
        return this.createGoogleApiSourceAsync(request);
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> createGoogleApiSourceAsync(String parent, GoogleApiSource googleApiSource, String googleApiSourceId) {
        CreateGoogleApiSourceRequest request = CreateGoogleApiSourceRequest.newBuilder().setParent(parent).setGoogleApiSource(googleApiSource).setGoogleApiSourceId(googleApiSourceId).build();
        return this.createGoogleApiSourceAsync(request);
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> createGoogleApiSourceAsync(CreateGoogleApiSourceRequest request) {
        return this.createGoogleApiSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> createGoogleApiSourceOperationCallable() {
        return this.stub.createGoogleApiSourceOperationCallable();
    }

    public final UnaryCallable<CreateGoogleApiSourceRequest, Operation> createGoogleApiSourceCallable() {
        return this.stub.createGoogleApiSourceCallable();
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> updateGoogleApiSourceAsync(GoogleApiSource googleApiSource, FieldMask updateMask) {
        UpdateGoogleApiSourceRequest request = UpdateGoogleApiSourceRequest.newBuilder().setGoogleApiSource(googleApiSource).setUpdateMask(updateMask).build();
        return this.updateGoogleApiSourceAsync(request);
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> updateGoogleApiSourceAsync(UpdateGoogleApiSourceRequest request) {
        return this.updateGoogleApiSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> updateGoogleApiSourceOperationCallable() {
        return this.stub.updateGoogleApiSourceOperationCallable();
    }

    public final UnaryCallable<UpdateGoogleApiSourceRequest, Operation> updateGoogleApiSourceCallable() {
        return this.stub.updateGoogleApiSourceCallable();
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> deleteGoogleApiSourceAsync(GoogleApiSourceName name, String etag) {
        DeleteGoogleApiSourceRequest request = DeleteGoogleApiSourceRequest.newBuilder().setName(name == null ? null : name.toString()).setEtag(etag).build();
        return this.deleteGoogleApiSourceAsync(request);
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> deleteGoogleApiSourceAsync(String name, String etag) {
        DeleteGoogleApiSourceRequest request = DeleteGoogleApiSourceRequest.newBuilder().setName(name).setEtag(etag).build();
        return this.deleteGoogleApiSourceAsync(request);
    }

    public final OperationFuture<GoogleApiSource, OperationMetadata> deleteGoogleApiSourceAsync(DeleteGoogleApiSourceRequest request) {
        return this.deleteGoogleApiSourceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteGoogleApiSourceRequest, GoogleApiSource, OperationMetadata> deleteGoogleApiSourceOperationCallable() {
        return this.stub.deleteGoogleApiSourceOperationCallable();
    }

    public final UnaryCallable<DeleteGoogleApiSourceRequest, Operation> deleteGoogleApiSourceCallable() {
        return this.stub.deleteGoogleApiSourceCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListGoogleApiSourcesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource, ListGoogleApiSourcesPage, ListGoogleApiSourcesFixedSizeCollection> {
        private ListGoogleApiSourcesFixedSizeCollection(List<ListGoogleApiSourcesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGoogleApiSourcesFixedSizeCollection createEmptyCollection() {
            return new ListGoogleApiSourcesFixedSizeCollection(null, 0);
        }

        protected ListGoogleApiSourcesFixedSizeCollection createCollection(List<ListGoogleApiSourcesPage> pages, int collectionSize) {
            return new ListGoogleApiSourcesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGoogleApiSourcesPage
    extends AbstractPage<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource, ListGoogleApiSourcesPage> {
        private ListGoogleApiSourcesPage(PageContext<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource> context, ListGoogleApiSourcesResponse response) {
            super(context, (Object)response);
        }

        private static ListGoogleApiSourcesPage createEmptyPage() {
            return new ListGoogleApiSourcesPage(null, null);
        }

        protected ListGoogleApiSourcesPage createPage(PageContext<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource> context, ListGoogleApiSourcesResponse response) {
            return new ListGoogleApiSourcesPage(context, response);
        }

        public ApiFuture<ListGoogleApiSourcesPage> createPageAsync(PageContext<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource> context, ApiFuture<ListGoogleApiSourcesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGoogleApiSourcesPagedResponse
    extends AbstractPagedListResponse<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource, ListGoogleApiSourcesPage, ListGoogleApiSourcesFixedSizeCollection> {
        public static ApiFuture<ListGoogleApiSourcesPagedResponse> createAsync(PageContext<ListGoogleApiSourcesRequest, ListGoogleApiSourcesResponse, GoogleApiSource> context, ApiFuture<ListGoogleApiSourcesResponse> futureResponse) {
            ApiFuture<ListGoogleApiSourcesPage> futurePage = ListGoogleApiSourcesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListGoogleApiSourcesPagedResponse((ListGoogleApiSourcesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListGoogleApiSourcesPagedResponse(ListGoogleApiSourcesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGoogleApiSourcesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListPipelinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListPipelinesRequest, ListPipelinesResponse, Pipeline, ListPipelinesPage, ListPipelinesFixedSizeCollection> {
        private ListPipelinesFixedSizeCollection(List<ListPipelinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListPipelinesFixedSizeCollection createEmptyCollection() {
            return new ListPipelinesFixedSizeCollection(null, 0);
        }

        protected ListPipelinesFixedSizeCollection createCollection(List<ListPipelinesPage> pages, int collectionSize) {
            return new ListPipelinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListPipelinesPage
    extends AbstractPage<ListPipelinesRequest, ListPipelinesResponse, Pipeline, ListPipelinesPage> {
        private ListPipelinesPage(PageContext<ListPipelinesRequest, ListPipelinesResponse, Pipeline> context, ListPipelinesResponse response) {
            super(context, (Object)response);
        }

        private static ListPipelinesPage createEmptyPage() {
            return new ListPipelinesPage(null, null);
        }

        protected ListPipelinesPage createPage(PageContext<ListPipelinesRequest, ListPipelinesResponse, Pipeline> context, ListPipelinesResponse response) {
            return new ListPipelinesPage(context, response);
        }

        public ApiFuture<ListPipelinesPage> createPageAsync(PageContext<ListPipelinesRequest, ListPipelinesResponse, Pipeline> context, ApiFuture<ListPipelinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListPipelinesPagedResponse
    extends AbstractPagedListResponse<ListPipelinesRequest, ListPipelinesResponse, Pipeline, ListPipelinesPage, ListPipelinesFixedSizeCollection> {
        public static ApiFuture<ListPipelinesPagedResponse> createAsync(PageContext<ListPipelinesRequest, ListPipelinesResponse, Pipeline> context, ApiFuture<ListPipelinesResponse> futureResponse) {
            ApiFuture<ListPipelinesPage> futurePage = ListPipelinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListPipelinesPagedResponse((ListPipelinesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListPipelinesPagedResponse(ListPipelinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListPipelinesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListEnrollmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment, ListEnrollmentsPage, ListEnrollmentsFixedSizeCollection> {
        private ListEnrollmentsFixedSizeCollection(List<ListEnrollmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListEnrollmentsFixedSizeCollection createEmptyCollection() {
            return new ListEnrollmentsFixedSizeCollection(null, 0);
        }

        protected ListEnrollmentsFixedSizeCollection createCollection(List<ListEnrollmentsPage> pages, int collectionSize) {
            return new ListEnrollmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListEnrollmentsPage
    extends AbstractPage<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment, ListEnrollmentsPage> {
        private ListEnrollmentsPage(PageContext<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment> context, ListEnrollmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListEnrollmentsPage createEmptyPage() {
            return new ListEnrollmentsPage(null, null);
        }

        protected ListEnrollmentsPage createPage(PageContext<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment> context, ListEnrollmentsResponse response) {
            return new ListEnrollmentsPage(context, response);
        }

        public ApiFuture<ListEnrollmentsPage> createPageAsync(PageContext<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment> context, ApiFuture<ListEnrollmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListEnrollmentsPagedResponse
    extends AbstractPagedListResponse<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment, ListEnrollmentsPage, ListEnrollmentsFixedSizeCollection> {
        public static ApiFuture<ListEnrollmentsPagedResponse> createAsync(PageContext<ListEnrollmentsRequest, ListEnrollmentsResponse, Enrollment> context, ApiFuture<ListEnrollmentsResponse> futureResponse) {
            ApiFuture<ListEnrollmentsPage> futurePage = ListEnrollmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListEnrollmentsPagedResponse((ListEnrollmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListEnrollmentsPagedResponse(ListEnrollmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListEnrollmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMessageBusEnrollmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String, ListMessageBusEnrollmentsPage, ListMessageBusEnrollmentsFixedSizeCollection> {
        private ListMessageBusEnrollmentsFixedSizeCollection(List<ListMessageBusEnrollmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMessageBusEnrollmentsFixedSizeCollection createEmptyCollection() {
            return new ListMessageBusEnrollmentsFixedSizeCollection(null, 0);
        }

        protected ListMessageBusEnrollmentsFixedSizeCollection createCollection(List<ListMessageBusEnrollmentsPage> pages, int collectionSize) {
            return new ListMessageBusEnrollmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMessageBusEnrollmentsPage
    extends AbstractPage<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String, ListMessageBusEnrollmentsPage> {
        private ListMessageBusEnrollmentsPage(PageContext<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String> context, ListMessageBusEnrollmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListMessageBusEnrollmentsPage createEmptyPage() {
            return new ListMessageBusEnrollmentsPage(null, null);
        }

        protected ListMessageBusEnrollmentsPage createPage(PageContext<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String> context, ListMessageBusEnrollmentsResponse response) {
            return new ListMessageBusEnrollmentsPage(context, response);
        }

        public ApiFuture<ListMessageBusEnrollmentsPage> createPageAsync(PageContext<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String> context, ApiFuture<ListMessageBusEnrollmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMessageBusEnrollmentsPagedResponse
    extends AbstractPagedListResponse<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String, ListMessageBusEnrollmentsPage, ListMessageBusEnrollmentsFixedSizeCollection> {
        public static ApiFuture<ListMessageBusEnrollmentsPagedResponse> createAsync(PageContext<ListMessageBusEnrollmentsRequest, ListMessageBusEnrollmentsResponse, String> context, ApiFuture<ListMessageBusEnrollmentsResponse> futureResponse) {
            ApiFuture<ListMessageBusEnrollmentsPage> futurePage = ListMessageBusEnrollmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMessageBusEnrollmentsPagedResponse((ListMessageBusEnrollmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMessageBusEnrollmentsPagedResponse(ListMessageBusEnrollmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMessageBusEnrollmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListMessageBusesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus, ListMessageBusesPage, ListMessageBusesFixedSizeCollection> {
        private ListMessageBusesFixedSizeCollection(List<ListMessageBusesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListMessageBusesFixedSizeCollection createEmptyCollection() {
            return new ListMessageBusesFixedSizeCollection(null, 0);
        }

        protected ListMessageBusesFixedSizeCollection createCollection(List<ListMessageBusesPage> pages, int collectionSize) {
            return new ListMessageBusesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListMessageBusesPage
    extends AbstractPage<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus, ListMessageBusesPage> {
        private ListMessageBusesPage(PageContext<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus> context, ListMessageBusesResponse response) {
            super(context, (Object)response);
        }

        private static ListMessageBusesPage createEmptyPage() {
            return new ListMessageBusesPage(null, null);
        }

        protected ListMessageBusesPage createPage(PageContext<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus> context, ListMessageBusesResponse response) {
            return new ListMessageBusesPage(context, response);
        }

        public ApiFuture<ListMessageBusesPage> createPageAsync(PageContext<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus> context, ApiFuture<ListMessageBusesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListMessageBusesPagedResponse
    extends AbstractPagedListResponse<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus, ListMessageBusesPage, ListMessageBusesFixedSizeCollection> {
        public static ApiFuture<ListMessageBusesPagedResponse> createAsync(PageContext<ListMessageBusesRequest, ListMessageBusesResponse, MessageBus> context, ApiFuture<ListMessageBusesResponse> futureResponse) {
            ApiFuture<ListMessageBusesPage> futurePage = ListMessageBusesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListMessageBusesPagedResponse((ListMessageBusesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListMessageBusesPagedResponse(ListMessageBusesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListMessageBusesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChannelConnectionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage, ListChannelConnectionsFixedSizeCollection> {
        private ListChannelConnectionsFixedSizeCollection(List<ListChannelConnectionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelConnectionsFixedSizeCollection createEmptyCollection() {
            return new ListChannelConnectionsFixedSizeCollection(null, 0);
        }

        protected ListChannelConnectionsFixedSizeCollection createCollection(List<ListChannelConnectionsPage> pages, int collectionSize) {
            return new ListChannelConnectionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelConnectionsPage
    extends AbstractPage<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage> {
        private ListChannelConnectionsPage(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ListChannelConnectionsResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelConnectionsPage createEmptyPage() {
            return new ListChannelConnectionsPage(null, null);
        }

        protected ListChannelConnectionsPage createPage(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ListChannelConnectionsResponse response) {
            return new ListChannelConnectionsPage(context, response);
        }

        public ApiFuture<ListChannelConnectionsPage> createPageAsync(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelConnectionsPagedResponse
    extends AbstractPagedListResponse<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection, ListChannelConnectionsPage, ListChannelConnectionsFixedSizeCollection> {
        public static ApiFuture<ListChannelConnectionsPagedResponse> createAsync(PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            ApiFuture<ListChannelConnectionsPage> futurePage = ListChannelConnectionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelConnectionsPagedResponse((ListChannelConnectionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelConnectionsPagedResponse(ListChannelConnectionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelConnectionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListProvidersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage, ListProvidersFixedSizeCollection> {
        private ListProvidersFixedSizeCollection(List<ListProvidersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListProvidersFixedSizeCollection createEmptyCollection() {
            return new ListProvidersFixedSizeCollection(null, 0);
        }

        protected ListProvidersFixedSizeCollection createCollection(List<ListProvidersPage> pages, int collectionSize) {
            return new ListProvidersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListProvidersPage
    extends AbstractPage<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage> {
        private ListProvidersPage(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ListProvidersResponse response) {
            super(context, (Object)response);
        }

        private static ListProvidersPage createEmptyPage() {
            return new ListProvidersPage(null, null);
        }

        protected ListProvidersPage createPage(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ListProvidersResponse response) {
            return new ListProvidersPage(context, response);
        }

        public ApiFuture<ListProvidersPage> createPageAsync(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ApiFuture<ListProvidersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListProvidersPagedResponse
    extends AbstractPagedListResponse<ListProvidersRequest, ListProvidersResponse, Provider, ListProvidersPage, ListProvidersFixedSizeCollection> {
        public static ApiFuture<ListProvidersPagedResponse> createAsync(PageContext<ListProvidersRequest, ListProvidersResponse, Provider> context, ApiFuture<ListProvidersResponse> futureResponse) {
            ApiFuture<ListProvidersPage> futurePage = ListProvidersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListProvidersPagedResponse((ListProvidersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListProvidersPagedResponse(ListProvidersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListProvidersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChannelsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        private ListChannelsFixedSizeCollection(List<ListChannelsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChannelsFixedSizeCollection createEmptyCollection() {
            return new ListChannelsFixedSizeCollection(null, 0);
        }

        protected ListChannelsFixedSizeCollection createCollection(List<ListChannelsPage> pages, int collectionSize) {
            return new ListChannelsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChannelsPage
    extends AbstractPage<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage> {
        private ListChannelsPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            super(context, (Object)response);
        }

        private static ListChannelsPage createEmptyPage() {
            return new ListChannelsPage(null, null);
        }

        protected ListChannelsPage createPage(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ListChannelsResponse response) {
            return new ListChannelsPage(context, response);
        }

        public ApiFuture<ListChannelsPage> createPageAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChannelsPagedResponse
    extends AbstractPagedListResponse<ListChannelsRequest, ListChannelsResponse, Channel, ListChannelsPage, ListChannelsFixedSizeCollection> {
        public static ApiFuture<ListChannelsPagedResponse> createAsync(PageContext<ListChannelsRequest, ListChannelsResponse, Channel> context, ApiFuture<ListChannelsResponse> futureResponse) {
            ApiFuture<ListChannelsPage> futurePage = ListChannelsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChannelsPagedResponse((ListChannelsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChannelsPagedResponse(ListChannelsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChannelsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTriggersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        private ListTriggersFixedSizeCollection(List<ListTriggersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTriggersFixedSizeCollection createEmptyCollection() {
            return new ListTriggersFixedSizeCollection(null, 0);
        }

        protected ListTriggersFixedSizeCollection createCollection(List<ListTriggersPage> pages, int collectionSize) {
            return new ListTriggersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTriggersPage
    extends AbstractPage<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage> {
        private ListTriggersPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            super(context, (Object)response);
        }

        private static ListTriggersPage createEmptyPage() {
            return new ListTriggersPage(null, null);
        }

        protected ListTriggersPage createPage(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ListTriggersResponse response) {
            return new ListTriggersPage(context, response);
        }

        public ApiFuture<ListTriggersPage> createPageAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTriggersPagedResponse
    extends AbstractPagedListResponse<ListTriggersRequest, ListTriggersResponse, Trigger, ListTriggersPage, ListTriggersFixedSizeCollection> {
        public static ApiFuture<ListTriggersPagedResponse> createAsync(PageContext<ListTriggersRequest, ListTriggersResponse, Trigger> context, ApiFuture<ListTriggersResponse> futureResponse) {
            ApiFuture<ListTriggersPage> futurePage = ListTriggersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTriggersPagedResponse((ListTriggersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTriggersPagedResponse(ListTriggersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTriggersFixedSizeCollection.createEmptyCollection());
        }
    }
}

