/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.v1.Channel;
import com.google.cloud.eventarc.v1.ChannelConnection;
import com.google.cloud.eventarc.v1.CreateChannelConnectionRequest;
import com.google.cloud.eventarc.v1.CreateChannelRequest;
import com.google.cloud.eventarc.v1.CreateTriggerRequest;
import com.google.cloud.eventarc.v1.DeleteChannelConnectionRequest;
import com.google.cloud.eventarc.v1.DeleteChannelRequest;
import com.google.cloud.eventarc.v1.DeleteTriggerRequest;
import com.google.cloud.eventarc.v1.EventarcClient;
import com.google.cloud.eventarc.v1.GetChannelConnectionRequest;
import com.google.cloud.eventarc.v1.GetChannelRequest;
import com.google.cloud.eventarc.v1.GetGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.GetProviderRequest;
import com.google.cloud.eventarc.v1.GetTriggerRequest;
import com.google.cloud.eventarc.v1.GoogleChannelConfig;
import com.google.cloud.eventarc.v1.ListChannelConnectionsRequest;
import com.google.cloud.eventarc.v1.ListChannelConnectionsResponse;
import com.google.cloud.eventarc.v1.ListChannelsRequest;
import com.google.cloud.eventarc.v1.ListChannelsResponse;
import com.google.cloud.eventarc.v1.ListProvidersRequest;
import com.google.cloud.eventarc.v1.ListProvidersResponse;
import com.google.cloud.eventarc.v1.ListTriggersRequest;
import com.google.cloud.eventarc.v1.ListTriggersResponse;
import com.google.cloud.eventarc.v1.OperationMetadata;
import com.google.cloud.eventarc.v1.Provider;
import com.google.cloud.eventarc.v1.Trigger;
import com.google.cloud.eventarc.v1.UpdateChannelRequest;
import com.google.cloud.eventarc.v1.UpdateGoogleChannelConfigRequest;
import com.google.cloud.eventarc.v1.UpdateTriggerRequest;
import com.google.cloud.eventarc.v1.stub.EventarcStub;
import com.google.cloud.eventarc.v1.stub.GrpcEventarcStub;
import com.google.cloud.eventarc.v1.stub.HttpJsonEventarcStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EventarcStubSettings
extends StubSettings<EventarcStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings;
    private final PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
    private final UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings;
    private final OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
    private final UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings;
    private final OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
    private final UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings;
    private final OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
    private final UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings;
    private final PagedCallSettings<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings;
    private final UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings;
    private final OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
    private final UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings;
    private final OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
    private final UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings;
    private final OperationCallSettings<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings;
    private final UnaryCallSettings<GetProviderRequest, Provider> getProviderSettings;
    private final PagedCallSettings<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings;
    private final UnaryCallSettings<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings;
    private final PagedCallSettings<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings;
    private final UnaryCallSettings<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings;
    private final OperationCallSettings<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings;
    private final UnaryCallSettings<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings;
    private final OperationCallSettings<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings;
    private final UnaryCallSettings<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings;
    private final UnaryCallSettings<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger> LIST_TRIGGERS_PAGE_STR_DESC = new PagedListDescriptor<ListTriggersRequest, ListTriggersResponse, Trigger>(){

        public String emptyToken() {
            return "";
        }

        public ListTriggersRequest injectToken(ListTriggersRequest payload, String token) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageToken(token).build();
        }

        public ListTriggersRequest injectPageSize(ListTriggersRequest payload, int pageSize) {
            return ListTriggersRequest.newBuilder((ListTriggersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTriggersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTriggersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Trigger> extractResources(ListTriggersResponse payload) {
            return payload.getTriggersList() == null ? ImmutableList.of() : payload.getTriggersList();
        }
    };
    private static final PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel> LIST_CHANNELS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelsRequest, ListChannelsResponse, Channel>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelsRequest injectToken(ListChannelsRequest payload, String token) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageToken(token).build();
        }

        public ListChannelsRequest injectPageSize(ListChannelsRequest payload, int pageSize) {
            return ListChannelsRequest.newBuilder((ListChannelsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Channel> extractResources(ListChannelsResponse payload) {
            return payload.getChannelsList() == null ? ImmutableList.of() : payload.getChannelsList();
        }
    };
    private static final PagedListDescriptor<ListProvidersRequest, ListProvidersResponse, Provider> LIST_PROVIDERS_PAGE_STR_DESC = new PagedListDescriptor<ListProvidersRequest, ListProvidersResponse, Provider>(){

        public String emptyToken() {
            return "";
        }

        public ListProvidersRequest injectToken(ListProvidersRequest payload, String token) {
            return ListProvidersRequest.newBuilder((ListProvidersRequest)payload).setPageToken(token).build();
        }

        public ListProvidersRequest injectPageSize(ListProvidersRequest payload, int pageSize) {
            return ListProvidersRequest.newBuilder((ListProvidersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProvidersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProvidersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Provider> extractResources(ListProvidersResponse payload) {
            return payload.getProvidersList() == null ? ImmutableList.of() : payload.getProvidersList();
        }
    };
    private static final PagedListDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection> LIST_CHANNEL_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelConnectionsRequest injectToken(ListChannelConnectionsRequest payload, String token) {
            return ListChannelConnectionsRequest.newBuilder((ListChannelConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListChannelConnectionsRequest injectPageSize(ListChannelConnectionsRequest payload, int pageSize) {
            return ListChannelConnectionsRequest.newBuilder((ListChannelConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ChannelConnection> extractResources(ListChannelConnectionsResponse payload) {
            return payload.getChannelConnectionsList() == null ? ImmutableList.of() : payload.getChannelConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> LIST_TRIGGERS_PAGE_STR_FACT = new PagedListResponseFactory<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse>(){

        public ApiFuture<EventarcClient.ListTriggersPagedResponse> getFuturePagedResponse(UnaryCallable<ListTriggersRequest, ListTriggersResponse> callable, ListTriggersRequest request, ApiCallContext context, ApiFuture<ListTriggersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRIGGERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListTriggersPagedResponse.createAsync((PageContext<ListTriggersRequest, ListTriggersResponse, Trigger>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> LIST_CHANNELS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse>(){

        public ApiFuture<EventarcClient.ListChannelsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelsRequest, ListChannelsResponse> callable, ListChannelsRequest request, ApiCallContext context, ApiFuture<ListChannelsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNELS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListChannelsPagedResponse.createAsync((PageContext<ListChannelsRequest, ListChannelsResponse, Channel>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> LIST_PROVIDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse>(){

        public ApiFuture<EventarcClient.ListProvidersPagedResponse> getFuturePagedResponse(UnaryCallable<ListProvidersRequest, ListProvidersResponse> callable, ListProvidersRequest request, ApiCallContext context, ApiFuture<ListProvidersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROVIDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListProvidersPagedResponse.createAsync((PageContext<ListProvidersRequest, ListProvidersResponse, Provider>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> LIST_CHANNEL_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse>(){

        public ApiFuture<EventarcClient.ListChannelConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelConnectionsRequest, ListChannelConnectionsResponse> callable, ListChannelConnectionsRequest request, ApiCallContext context, ApiFuture<ListChannelConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNEL_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListChannelConnectionsPagedResponse.createAsync((PageContext<ListChannelConnectionsRequest, ListChannelConnectionsResponse, ChannelConnection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse>(){

        public ApiFuture<EventarcClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EventarcClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetTriggerRequest, Trigger> getTriggerSettings() {
        return this.getTriggerSettings;
    }

    public PagedCallSettings<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
        return this.listTriggersSettings;
    }

    public UnaryCallSettings<CreateTriggerRequest, Operation> createTriggerSettings() {
        return this.createTriggerSettings;
    }

    public OperationCallSettings<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
        return this.createTriggerOperationSettings;
    }

    public UnaryCallSettings<UpdateTriggerRequest, Operation> updateTriggerSettings() {
        return this.updateTriggerSettings;
    }

    public OperationCallSettings<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
        return this.updateTriggerOperationSettings;
    }

    public UnaryCallSettings<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
        return this.deleteTriggerSettings;
    }

    public OperationCallSettings<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
        return this.deleteTriggerOperationSettings;
    }

    public UnaryCallSettings<GetChannelRequest, Channel> getChannelSettings() {
        return this.getChannelSettings;
    }

    public PagedCallSettings<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings() {
        return this.listChannelsSettings;
    }

    public UnaryCallSettings<CreateChannelRequest, Operation> createChannelSettings() {
        return this.createChannelSettings;
    }

    public OperationCallSettings<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
        return this.createChannelOperationSettings;
    }

    public UnaryCallSettings<UpdateChannelRequest, Operation> updateChannelSettings() {
        return this.updateChannelSettings;
    }

    public OperationCallSettings<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
        return this.updateChannelOperationSettings;
    }

    public UnaryCallSettings<DeleteChannelRequest, Operation> deleteChannelSettings() {
        return this.deleteChannelSettings;
    }

    public OperationCallSettings<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings() {
        return this.deleteChannelOperationSettings;
    }

    public UnaryCallSettings<GetProviderRequest, Provider> getProviderSettings() {
        return this.getProviderSettings;
    }

    public PagedCallSettings<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings() {
        return this.listProvidersSettings;
    }

    public UnaryCallSettings<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings() {
        return this.getChannelConnectionSettings;
    }

    public PagedCallSettings<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings() {
        return this.listChannelConnectionsSettings;
    }

    public UnaryCallSettings<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings() {
        return this.createChannelConnectionSettings;
    }

    public OperationCallSettings<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings() {
        return this.createChannelConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings() {
        return this.deleteChannelConnectionSettings;
    }

    public OperationCallSettings<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings() {
        return this.deleteChannelConnectionOperationSettings;
    }

    public UnaryCallSettings<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings() {
        return this.getGoogleChannelConfigSettings;
    }

    public UnaryCallSettings<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings() {
        return this.updateGoogleChannelConfigSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public EventarcStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEventarcStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEventarcStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EventarcStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "eventarc";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "eventarc.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "eventarc.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EventarcStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EventarcStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EventarcStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EventarcStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EventarcStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getTriggerSettings = settingsBuilder.getTriggerSettings().build();
        this.listTriggersSettings = settingsBuilder.listTriggersSettings().build();
        this.createTriggerSettings = settingsBuilder.createTriggerSettings().build();
        this.createTriggerOperationSettings = settingsBuilder.createTriggerOperationSettings().build();
        this.updateTriggerSettings = settingsBuilder.updateTriggerSettings().build();
        this.updateTriggerOperationSettings = settingsBuilder.updateTriggerOperationSettings().build();
        this.deleteTriggerSettings = settingsBuilder.deleteTriggerSettings().build();
        this.deleteTriggerOperationSettings = settingsBuilder.deleteTriggerOperationSettings().build();
        this.getChannelSettings = settingsBuilder.getChannelSettings().build();
        this.listChannelsSettings = settingsBuilder.listChannelsSettings().build();
        this.createChannelSettings = settingsBuilder.createChannelSettings().build();
        this.createChannelOperationSettings = settingsBuilder.createChannelOperationSettings().build();
        this.updateChannelSettings = settingsBuilder.updateChannelSettings().build();
        this.updateChannelOperationSettings = settingsBuilder.updateChannelOperationSettings().build();
        this.deleteChannelSettings = settingsBuilder.deleteChannelSettings().build();
        this.deleteChannelOperationSettings = settingsBuilder.deleteChannelOperationSettings().build();
        this.getProviderSettings = settingsBuilder.getProviderSettings().build();
        this.listProvidersSettings = settingsBuilder.listProvidersSettings().build();
        this.getChannelConnectionSettings = settingsBuilder.getChannelConnectionSettings().build();
        this.listChannelConnectionsSettings = settingsBuilder.listChannelConnectionsSettings().build();
        this.createChannelConnectionSettings = settingsBuilder.createChannelConnectionSettings().build();
        this.createChannelConnectionOperationSettings = settingsBuilder.createChannelConnectionOperationSettings().build();
        this.deleteChannelConnectionSettings = settingsBuilder.deleteChannelConnectionSettings().build();
        this.deleteChannelConnectionOperationSettings = settingsBuilder.deleteChannelConnectionOperationSettings().build();
        this.getGoogleChannelConfigSettings = settingsBuilder.getGoogleChannelConfigSettings().build();
        this.updateGoogleChannelConfigSettings = settingsBuilder.updateGoogleChannelConfigSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EventarcStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings;
        private final PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings;
        private final UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings;
        private final OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings;
        private final UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings;
        private final OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings;
        private final UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings;
        private final OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings;
        private final UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings;
        private final PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings;
        private final UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings;
        private final OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings;
        private final UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings;
        private final OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings;
        private final UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings;
        private final OperationCallSettings.Builder<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings;
        private final UnaryCallSettings.Builder<GetProviderRequest, Provider> getProviderSettings;
        private final PagedCallSettings.Builder<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings;
        private final UnaryCallSettings.Builder<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings;
        private final PagedCallSettings.Builder<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings;
        private final UnaryCallSettings.Builder<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings;
        private final OperationCallSettings.Builder<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings;
        private final OperationCallSettings.Builder<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings;
        private final UnaryCallSettings.Builder<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings;
        private final UnaryCallSettings.Builder<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTriggersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRIGGERS_PAGE_STR_FACT);
            this.createTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.updateTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.deleteTriggerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTriggerOperationSettings = OperationCallSettings.newBuilder();
            this.getChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listChannelsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNELS_PAGE_STR_FACT);
            this.createChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelOperationSettings = OperationCallSettings.newBuilder();
            this.updateChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateChannelOperationSettings = OperationCallSettings.newBuilder();
            this.deleteChannelSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelOperationSettings = OperationCallSettings.newBuilder();
            this.getProviderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProvidersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROVIDERS_PAGE_STR_FACT);
            this.getChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listChannelConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNEL_CONNECTIONS_PAGE_STR_FACT);
            this.createChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteChannelConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteChannelConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.getGoogleChannelConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGoogleChannelConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings, this.getChannelSettings, this.listChannelsSettings, this.createChannelSettings, this.updateChannelSettings, this.deleteChannelSettings, this.getProviderSettings, this.listProvidersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getChannelConnectionSettings, this.listChannelConnectionsSettings, this.createChannelConnectionSettings, this.deleteChannelConnectionSettings, this.getGoogleChannelConfigSettings, this.updateGoogleChannelConfigSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EventarcStubSettings settings) {
            super((StubSettings)settings);
            this.getTriggerSettings = settings.getTriggerSettings.toBuilder();
            this.listTriggersSettings = settings.listTriggersSettings.toBuilder();
            this.createTriggerSettings = settings.createTriggerSettings.toBuilder();
            this.createTriggerOperationSettings = settings.createTriggerOperationSettings.toBuilder();
            this.updateTriggerSettings = settings.updateTriggerSettings.toBuilder();
            this.updateTriggerOperationSettings = settings.updateTriggerOperationSettings.toBuilder();
            this.deleteTriggerSettings = settings.deleteTriggerSettings.toBuilder();
            this.deleteTriggerOperationSettings = settings.deleteTriggerOperationSettings.toBuilder();
            this.getChannelSettings = settings.getChannelSettings.toBuilder();
            this.listChannelsSettings = settings.listChannelsSettings.toBuilder();
            this.createChannelSettings = settings.createChannelSettings.toBuilder();
            this.createChannelOperationSettings = settings.createChannelOperationSettings.toBuilder();
            this.updateChannelSettings = settings.updateChannelSettings.toBuilder();
            this.updateChannelOperationSettings = settings.updateChannelOperationSettings.toBuilder();
            this.deleteChannelSettings = settings.deleteChannelSettings.toBuilder();
            this.deleteChannelOperationSettings = settings.deleteChannelOperationSettings.toBuilder();
            this.getProviderSettings = settings.getProviderSettings.toBuilder();
            this.listProvidersSettings = settings.listProvidersSettings.toBuilder();
            this.getChannelConnectionSettings = settings.getChannelConnectionSettings.toBuilder();
            this.listChannelConnectionsSettings = settings.listChannelConnectionsSettings.toBuilder();
            this.createChannelConnectionSettings = settings.createChannelConnectionSettings.toBuilder();
            this.createChannelConnectionOperationSettings = settings.createChannelConnectionOperationSettings.toBuilder();
            this.deleteChannelConnectionSettings = settings.deleteChannelConnectionSettings.toBuilder();
            this.deleteChannelConnectionOperationSettings = settings.deleteChannelConnectionOperationSettings.toBuilder();
            this.getGoogleChannelConfigSettings = settings.getGoogleChannelConfigSettings.toBuilder();
            this.updateGoogleChannelConfigSettings = settings.updateGoogleChannelConfigSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getTriggerSettings, this.listTriggersSettings, this.createTriggerSettings, this.updateTriggerSettings, this.deleteTriggerSettings, this.getChannelSettings, this.listChannelsSettings, this.createChannelSettings, this.updateChannelSettings, this.deleteChannelSettings, this.getProviderSettings, this.listProvidersSettings, (Object[])new UnaryCallSettings.Builder[]{this.getChannelConnectionSettings, this.listChannelConnectionsSettings, this.createChannelConnectionSettings, this.deleteChannelConnectionSettings, this.getGoogleChannelConfigSettings, this.updateGoogleChannelConfigSettings, this.listLocationsSettings, this.getLocationSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EventarcStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EventarcStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EventarcStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EventarcStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EventarcStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EventarcStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EventarcStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EventarcStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listTriggersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteTriggerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listChannelsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteChannelSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getProviderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProvidersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listChannelConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteChannelConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getGoogleChannelConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateGoogleChannelConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteTriggerOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Trigger.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteChannelOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Channel.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createChannelConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteChannelConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ChannelConnection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetTriggerRequest, Trigger> getTriggerSettings() {
            return this.getTriggerSettings;
        }

        public PagedCallSettings.Builder<ListTriggersRequest, ListTriggersResponse, EventarcClient.ListTriggersPagedResponse> listTriggersSettings() {
            return this.listTriggersSettings;
        }

        public UnaryCallSettings.Builder<CreateTriggerRequest, Operation> createTriggerSettings() {
            return this.createTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateTriggerRequest, Trigger, OperationMetadata> createTriggerOperationSettings() {
            return this.createTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateTriggerRequest, Operation> updateTriggerSettings() {
            return this.updateTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateTriggerRequest, Trigger, OperationMetadata> updateTriggerOperationSettings() {
            return this.updateTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteTriggerRequest, Operation> deleteTriggerSettings() {
            return this.deleteTriggerSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteTriggerRequest, Trigger, OperationMetadata> deleteTriggerOperationSettings() {
            return this.deleteTriggerOperationSettings;
        }

        public UnaryCallSettings.Builder<GetChannelRequest, Channel> getChannelSettings() {
            return this.getChannelSettings;
        }

        public PagedCallSettings.Builder<ListChannelsRequest, ListChannelsResponse, EventarcClient.ListChannelsPagedResponse> listChannelsSettings() {
            return this.listChannelsSettings;
        }

        public UnaryCallSettings.Builder<CreateChannelRequest, Operation> createChannelSettings() {
            return this.createChannelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateChannelRequest, Channel, OperationMetadata> createChannelOperationSettings() {
            return this.createChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateChannelRequest, Operation> updateChannelSettings() {
            return this.updateChannelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateChannelRequest, Channel, OperationMetadata> updateChannelOperationSettings() {
            return this.updateChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteChannelRequest, Operation> deleteChannelSettings() {
            return this.deleteChannelSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteChannelRequest, Channel, OperationMetadata> deleteChannelOperationSettings() {
            return this.deleteChannelOperationSettings;
        }

        public UnaryCallSettings.Builder<GetProviderRequest, Provider> getProviderSettings() {
            return this.getProviderSettings;
        }

        public PagedCallSettings.Builder<ListProvidersRequest, ListProvidersResponse, EventarcClient.ListProvidersPagedResponse> listProvidersSettings() {
            return this.listProvidersSettings;
        }

        public UnaryCallSettings.Builder<GetChannelConnectionRequest, ChannelConnection> getChannelConnectionSettings() {
            return this.getChannelConnectionSettings;
        }

        public PagedCallSettings.Builder<ListChannelConnectionsRequest, ListChannelConnectionsResponse, EventarcClient.ListChannelConnectionsPagedResponse> listChannelConnectionsSettings() {
            return this.listChannelConnectionsSettings;
        }

        public UnaryCallSettings.Builder<CreateChannelConnectionRequest, Operation> createChannelConnectionSettings() {
            return this.createChannelConnectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateChannelConnectionRequest, ChannelConnection, OperationMetadata> createChannelConnectionOperationSettings() {
            return this.createChannelConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteChannelConnectionRequest, Operation> deleteChannelConnectionSettings() {
            return this.deleteChannelConnectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteChannelConnectionRequest, ChannelConnection, OperationMetadata> deleteChannelConnectionOperationSettings() {
            return this.deleteChannelConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGoogleChannelConfigRequest, GoogleChannelConfig> getGoogleChannelConfigSettings() {
            return this.getGoogleChannelConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateGoogleChannelConfigRequest, GoogleChannelConfig> updateGoogleChannelConfigSettings() {
            return this.updateGoogleChannelConfigSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EventarcClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EventarcStubSettings.getDefaultEndpoint();
        }

        public EventarcStubSettings build() throws IOException {
            return new EventarcStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

