/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.eventarc.publishing.v1;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsRequest;
import com.google.cloud.eventarc.publishing.v1.PublishChannelConnectionEventsResponse;
import com.google.cloud.eventarc.publishing.v1.PublishEventsRequest;
import com.google.cloud.eventarc.publishing.v1.PublishEventsResponse;
import com.google.cloud.eventarc.publishing.v1.PublisherSettings;
import com.google.cloud.eventarc.publishing.v1.stub.PublisherStub;
import com.google.cloud.eventarc.publishing.v1.stub.PublisherStubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class PublisherClient
implements BackgroundResource {
    private final PublisherSettings settings;
    private final PublisherStub stub;

    public static final PublisherClient create() throws IOException {
        return PublisherClient.create(PublisherSettings.newBuilder().build());
    }

    public static final PublisherClient create(PublisherSettings settings) throws IOException {
        return new PublisherClient(settings);
    }

    public static final PublisherClient create(PublisherStub stub) {
        return new PublisherClient(stub);
    }

    protected PublisherClient(PublisherSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((PublisherStubSettings)settings.getStubSettings()).createStub();
    }

    protected PublisherClient(PublisherStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final PublisherSettings getSettings() {
        return this.settings;
    }

    public PublisherStub getStub() {
        return this.stub;
    }

    public final PublishChannelConnectionEventsResponse publishChannelConnectionEvents(PublishChannelConnectionEventsRequest request) {
        return (PublishChannelConnectionEventsResponse)this.publishChannelConnectionEventsCallable().call((Object)request);
    }

    public final UnaryCallable<PublishChannelConnectionEventsRequest, PublishChannelConnectionEventsResponse> publishChannelConnectionEventsCallable() {
        return this.stub.publishChannelConnectionEventsCallable();
    }

    public final PublishEventsResponse publishEvents(PublishEventsRequest request) {
        return (PublishEventsResponse)this.publishEventsCallable().call((Object)request);
    }

    public final UnaryCallable<PublishEventsRequest, PublishEventsResponse> publishEventsCallable() {
        return this.stub.publishEventsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

