/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.edgenetwork.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.edgenetwork.v1.CreateInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.CreateNetworkRequest;
import com.google.cloud.edgenetwork.v1.CreateRouterRequest;
import com.google.cloud.edgenetwork.v1.CreateSubnetRequest;
import com.google.cloud.edgenetwork.v1.DeleteInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.DeleteNetworkRequest;
import com.google.cloud.edgenetwork.v1.DeleteRouterRequest;
import com.google.cloud.edgenetwork.v1.DeleteSubnetRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseInterconnectResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseNetworkResponse;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterRequest;
import com.google.cloud.edgenetwork.v1.DiagnoseRouterResponse;
import com.google.cloud.edgenetwork.v1.EdgeNetworkClient;
import com.google.cloud.edgenetwork.v1.GetInterconnectAttachmentRequest;
import com.google.cloud.edgenetwork.v1.GetInterconnectRequest;
import com.google.cloud.edgenetwork.v1.GetNetworkRequest;
import com.google.cloud.edgenetwork.v1.GetRouterRequest;
import com.google.cloud.edgenetwork.v1.GetSubnetRequest;
import com.google.cloud.edgenetwork.v1.GetZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneRequest;
import com.google.cloud.edgenetwork.v1.InitializeZoneResponse;
import com.google.cloud.edgenetwork.v1.Interconnect;
import com.google.cloud.edgenetwork.v1.InterconnectAttachment;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectAttachmentsResponse;
import com.google.cloud.edgenetwork.v1.ListInterconnectsRequest;
import com.google.cloud.edgenetwork.v1.ListInterconnectsResponse;
import com.google.cloud.edgenetwork.v1.ListNetworksRequest;
import com.google.cloud.edgenetwork.v1.ListNetworksResponse;
import com.google.cloud.edgenetwork.v1.ListRoutersRequest;
import com.google.cloud.edgenetwork.v1.ListRoutersResponse;
import com.google.cloud.edgenetwork.v1.ListSubnetsRequest;
import com.google.cloud.edgenetwork.v1.ListSubnetsResponse;
import com.google.cloud.edgenetwork.v1.ListZonesRequest;
import com.google.cloud.edgenetwork.v1.ListZonesResponse;
import com.google.cloud.edgenetwork.v1.Network;
import com.google.cloud.edgenetwork.v1.OperationMetadata;
import com.google.cloud.edgenetwork.v1.Router;
import com.google.cloud.edgenetwork.v1.Subnet;
import com.google.cloud.edgenetwork.v1.UpdateRouterRequest;
import com.google.cloud.edgenetwork.v1.UpdateSubnetRequest;
import com.google.cloud.edgenetwork.v1.Zone;
import com.google.cloud.edgenetwork.v1.stub.EdgeNetworkStub;
import com.google.cloud.edgenetwork.v1.stub.GrpcEdgeNetworkStub;
import com.google.cloud.edgenetwork.v1.stub.HttpJsonEdgeNetworkStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EdgeNetworkStubSettings
extends StubSettings<EdgeNetworkStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<InitializeZoneRequest, InitializeZoneResponse> initializeZoneSettings;
    private final PagedCallSettings<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse> listZonesSettings;
    private final UnaryCallSettings<GetZoneRequest, Zone> getZoneSettings;
    private final PagedCallSettings<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse> listNetworksSettings;
    private final UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings;
    private final UnaryCallSettings<DiagnoseNetworkRequest, DiagnoseNetworkResponse> diagnoseNetworkSettings;
    private final UnaryCallSettings<CreateNetworkRequest, Operation> createNetworkSettings;
    private final OperationCallSettings<CreateNetworkRequest, Network, OperationMetadata> createNetworkOperationSettings;
    private final UnaryCallSettings<DeleteNetworkRequest, Operation> deleteNetworkSettings;
    private final OperationCallSettings<DeleteNetworkRequest, Empty, OperationMetadata> deleteNetworkOperationSettings;
    private final PagedCallSettings<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse> listSubnetsSettings;
    private final UnaryCallSettings<GetSubnetRequest, Subnet> getSubnetSettings;
    private final UnaryCallSettings<CreateSubnetRequest, Operation> createSubnetSettings;
    private final OperationCallSettings<CreateSubnetRequest, Subnet, OperationMetadata> createSubnetOperationSettings;
    private final UnaryCallSettings<UpdateSubnetRequest, Operation> updateSubnetSettings;
    private final OperationCallSettings<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationSettings;
    private final UnaryCallSettings<DeleteSubnetRequest, Operation> deleteSubnetSettings;
    private final OperationCallSettings<DeleteSubnetRequest, Empty, OperationMetadata> deleteSubnetOperationSettings;
    private final PagedCallSettings<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse> listInterconnectsSettings;
    private final UnaryCallSettings<GetInterconnectRequest, Interconnect> getInterconnectSettings;
    private final UnaryCallSettings<DiagnoseInterconnectRequest, DiagnoseInterconnectResponse> diagnoseInterconnectSettings;
    private final PagedCallSettings<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings;
    private final UnaryCallSettings<GetInterconnectAttachmentRequest, InterconnectAttachment> getInterconnectAttachmentSettings;
    private final UnaryCallSettings<CreateInterconnectAttachmentRequest, Operation> createInterconnectAttachmentSettings;
    private final OperationCallSettings<CreateInterconnectAttachmentRequest, InterconnectAttachment, OperationMetadata> createInterconnectAttachmentOperationSettings;
    private final UnaryCallSettings<DeleteInterconnectAttachmentRequest, Operation> deleteInterconnectAttachmentSettings;
    private final OperationCallSettings<DeleteInterconnectAttachmentRequest, Empty, OperationMetadata> deleteInterconnectAttachmentOperationSettings;
    private final PagedCallSettings<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse> listRoutersSettings;
    private final UnaryCallSettings<GetRouterRequest, Router> getRouterSettings;
    private final UnaryCallSettings<DiagnoseRouterRequest, DiagnoseRouterResponse> diagnoseRouterSettings;
    private final UnaryCallSettings<CreateRouterRequest, Operation> createRouterSettings;
    private final OperationCallSettings<CreateRouterRequest, Router, OperationMetadata> createRouterOperationSettings;
    private final UnaryCallSettings<UpdateRouterRequest, Operation> updateRouterSettings;
    private final OperationCallSettings<UpdateRouterRequest, Router, OperationMetadata> updateRouterOperationSettings;
    private final UnaryCallSettings<DeleteRouterRequest, Operation> deleteRouterSettings;
    private final OperationCallSettings<DeleteRouterRequest, Empty, OperationMetadata> deleteRouterOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListZonesRequest, ListZonesResponse, Zone> LIST_ZONES_PAGE_STR_DESC = new PagedListDescriptor<ListZonesRequest, ListZonesResponse, Zone>(){

        public String emptyToken() {
            return "";
        }

        public ListZonesRequest injectToken(ListZonesRequest payload, String token) {
            return ListZonesRequest.newBuilder((ListZonesRequest)payload).setPageToken(token).build();
        }

        public ListZonesRequest injectPageSize(ListZonesRequest payload, int pageSize) {
            return ListZonesRequest.newBuilder((ListZonesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListZonesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListZonesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Zone> extractResources(ListZonesResponse payload) {
            return payload.getZonesList() == null ? ImmutableList.of() : payload.getZonesList();
        }
    };
    private static final PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network> LIST_NETWORKS_PAGE_STR_DESC = new PagedListDescriptor<ListNetworksRequest, ListNetworksResponse, Network>(){

        public String emptyToken() {
            return "";
        }

        public ListNetworksRequest injectToken(ListNetworksRequest payload, String token) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageToken(token).build();
        }

        public ListNetworksRequest injectPageSize(ListNetworksRequest payload, int pageSize) {
            return ListNetworksRequest.newBuilder((ListNetworksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListNetworksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListNetworksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Network> extractResources(ListNetworksResponse payload) {
            return payload.getNetworksList() == null ? ImmutableList.of() : payload.getNetworksList();
        }
    };
    private static final PagedListDescriptor<ListSubnetsRequest, ListSubnetsResponse, Subnet> LIST_SUBNETS_PAGE_STR_DESC = new PagedListDescriptor<ListSubnetsRequest, ListSubnetsResponse, Subnet>(){

        public String emptyToken() {
            return "";
        }

        public ListSubnetsRequest injectToken(ListSubnetsRequest payload, String token) {
            return ListSubnetsRequest.newBuilder((ListSubnetsRequest)payload).setPageToken(token).build();
        }

        public ListSubnetsRequest injectPageSize(ListSubnetsRequest payload, int pageSize) {
            return ListSubnetsRequest.newBuilder((ListSubnetsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubnetsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubnetsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Subnet> extractResources(ListSubnetsResponse payload) {
            return payload.getSubnetsList() == null ? ImmutableList.of() : payload.getSubnetsList();
        }
    };
    private static final PagedListDescriptor<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect> LIST_INTERCONNECTS_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectsRequest injectToken(ListInterconnectsRequest payload, String token) {
            return ListInterconnectsRequest.newBuilder((ListInterconnectsRequest)payload).setPageToken(token).build();
        }

        public ListInterconnectsRequest injectPageSize(ListInterconnectsRequest payload, int pageSize) {
            return ListInterconnectsRequest.newBuilder((ListInterconnectsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInterconnectsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Interconnect> extractResources(ListInterconnectsResponse payload) {
            return payload.getInterconnectsList() == null ? ImmutableList.of() : payload.getInterconnectsList();
        }
    };
    private static final PagedListDescriptor<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment> LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment>(){

        public String emptyToken() {
            return "";
        }

        public ListInterconnectAttachmentsRequest injectToken(ListInterconnectAttachmentsRequest payload, String token) {
            return ListInterconnectAttachmentsRequest.newBuilder((ListInterconnectAttachmentsRequest)payload).setPageToken(token).build();
        }

        public ListInterconnectAttachmentsRequest injectPageSize(ListInterconnectAttachmentsRequest payload, int pageSize) {
            return ListInterconnectAttachmentsRequest.newBuilder((ListInterconnectAttachmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInterconnectAttachmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInterconnectAttachmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InterconnectAttachment> extractResources(ListInterconnectAttachmentsResponse payload) {
            return payload.getInterconnectAttachmentsList() == null ? ImmutableList.of() : payload.getInterconnectAttachmentsList();
        }
    };
    private static final PagedListDescriptor<ListRoutersRequest, ListRoutersResponse, Router> LIST_ROUTERS_PAGE_STR_DESC = new PagedListDescriptor<ListRoutersRequest, ListRoutersResponse, Router>(){

        public String emptyToken() {
            return "";
        }

        public ListRoutersRequest injectToken(ListRoutersRequest payload, String token) {
            return ListRoutersRequest.newBuilder((ListRoutersRequest)payload).setPageToken(token).build();
        }

        public ListRoutersRequest injectPageSize(ListRoutersRequest payload, int pageSize) {
            return ListRoutersRequest.newBuilder((ListRoutersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRoutersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRoutersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Router> extractResources(ListRoutersResponse payload) {
            return payload.getRoutersList() == null ? ImmutableList.of() : payload.getRoutersList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList() == null ? ImmutableList.of() : payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse> LIST_ZONES_PAGE_STR_FACT = new PagedListResponseFactory<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListZonesPagedResponse> getFuturePagedResponse(UnaryCallable<ListZonesRequest, ListZonesResponse> callable, ListZonesRequest request, ApiCallContext context, ApiFuture<ListZonesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ZONES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListZonesPagedResponse.createAsync((PageContext<ListZonesRequest, ListZonesResponse, Zone>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse> LIST_NETWORKS_PAGE_STR_FACT = new PagedListResponseFactory<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListNetworksPagedResponse> getFuturePagedResponse(UnaryCallable<ListNetworksRequest, ListNetworksResponse> callable, ListNetworksRequest request, ApiCallContext context, ApiFuture<ListNetworksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_NETWORKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListNetworksPagedResponse.createAsync((PageContext<ListNetworksRequest, ListNetworksResponse, Network>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse> LIST_SUBNETS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListSubnetsPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubnetsRequest, ListSubnetsResponse> callable, ListSubnetsRequest request, ApiCallContext context, ApiFuture<ListSubnetsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBNETS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListSubnetsPagedResponse.createAsync((PageContext<ListSubnetsRequest, ListSubnetsResponse, Subnet>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse> LIST_INTERCONNECTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListInterconnectsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectsRequest, ListInterconnectsResponse> callable, ListInterconnectsRequest request, ApiCallContext context, ApiFuture<ListInterconnectsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERCONNECTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListInterconnectsPagedResponse.createAsync((PageContext<ListInterconnectsRequest, ListInterconnectsResponse, Interconnect>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse> callable, ListInterconnectAttachmentsRequest request, ApiCallContext context, ApiFuture<ListInterconnectAttachmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse.createAsync((PageContext<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, InterconnectAttachment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse> LIST_ROUTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListRoutersPagedResponse> getFuturePagedResponse(UnaryCallable<ListRoutersRequest, ListRoutersResponse> callable, ListRoutersRequest request, ApiCallContext context, ApiFuture<ListRoutersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ROUTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListRoutersPagedResponse.createAsync((PageContext<ListRoutersRequest, ListRoutersResponse, Router>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse>(){

        public ApiFuture<EdgeNetworkClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EdgeNetworkClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<InitializeZoneRequest, InitializeZoneResponse> initializeZoneSettings() {
        return this.initializeZoneSettings;
    }

    public PagedCallSettings<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse> listZonesSettings() {
        return this.listZonesSettings;
    }

    public UnaryCallSettings<GetZoneRequest, Zone> getZoneSettings() {
        return this.getZoneSettings;
    }

    public PagedCallSettings<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse> listNetworksSettings() {
        return this.listNetworksSettings;
    }

    public UnaryCallSettings<GetNetworkRequest, Network> getNetworkSettings() {
        return this.getNetworkSettings;
    }

    public UnaryCallSettings<DiagnoseNetworkRequest, DiagnoseNetworkResponse> diagnoseNetworkSettings() {
        return this.diagnoseNetworkSettings;
    }

    public UnaryCallSettings<CreateNetworkRequest, Operation> createNetworkSettings() {
        return this.createNetworkSettings;
    }

    public OperationCallSettings<CreateNetworkRequest, Network, OperationMetadata> createNetworkOperationSettings() {
        return this.createNetworkOperationSettings;
    }

    public UnaryCallSettings<DeleteNetworkRequest, Operation> deleteNetworkSettings() {
        return this.deleteNetworkSettings;
    }

    public OperationCallSettings<DeleteNetworkRequest, Empty, OperationMetadata> deleteNetworkOperationSettings() {
        return this.deleteNetworkOperationSettings;
    }

    public PagedCallSettings<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse> listSubnetsSettings() {
        return this.listSubnetsSettings;
    }

    public UnaryCallSettings<GetSubnetRequest, Subnet> getSubnetSettings() {
        return this.getSubnetSettings;
    }

    public UnaryCallSettings<CreateSubnetRequest, Operation> createSubnetSettings() {
        return this.createSubnetSettings;
    }

    public OperationCallSettings<CreateSubnetRequest, Subnet, OperationMetadata> createSubnetOperationSettings() {
        return this.createSubnetOperationSettings;
    }

    public UnaryCallSettings<UpdateSubnetRequest, Operation> updateSubnetSettings() {
        return this.updateSubnetSettings;
    }

    public OperationCallSettings<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationSettings() {
        return this.updateSubnetOperationSettings;
    }

    public UnaryCallSettings<DeleteSubnetRequest, Operation> deleteSubnetSettings() {
        return this.deleteSubnetSettings;
    }

    public OperationCallSettings<DeleteSubnetRequest, Empty, OperationMetadata> deleteSubnetOperationSettings() {
        return this.deleteSubnetOperationSettings;
    }

    public PagedCallSettings<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse> listInterconnectsSettings() {
        return this.listInterconnectsSettings;
    }

    public UnaryCallSettings<GetInterconnectRequest, Interconnect> getInterconnectSettings() {
        return this.getInterconnectSettings;
    }

    public UnaryCallSettings<DiagnoseInterconnectRequest, DiagnoseInterconnectResponse> diagnoseInterconnectSettings() {
        return this.diagnoseInterconnectSettings;
    }

    public PagedCallSettings<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings() {
        return this.listInterconnectAttachmentsSettings;
    }

    public UnaryCallSettings<GetInterconnectAttachmentRequest, InterconnectAttachment> getInterconnectAttachmentSettings() {
        return this.getInterconnectAttachmentSettings;
    }

    public UnaryCallSettings<CreateInterconnectAttachmentRequest, Operation> createInterconnectAttachmentSettings() {
        return this.createInterconnectAttachmentSettings;
    }

    public OperationCallSettings<CreateInterconnectAttachmentRequest, InterconnectAttachment, OperationMetadata> createInterconnectAttachmentOperationSettings() {
        return this.createInterconnectAttachmentOperationSettings;
    }

    public UnaryCallSettings<DeleteInterconnectAttachmentRequest, Operation> deleteInterconnectAttachmentSettings() {
        return this.deleteInterconnectAttachmentSettings;
    }

    public OperationCallSettings<DeleteInterconnectAttachmentRequest, Empty, OperationMetadata> deleteInterconnectAttachmentOperationSettings() {
        return this.deleteInterconnectAttachmentOperationSettings;
    }

    public PagedCallSettings<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse> listRoutersSettings() {
        return this.listRoutersSettings;
    }

    public UnaryCallSettings<GetRouterRequest, Router> getRouterSettings() {
        return this.getRouterSettings;
    }

    public UnaryCallSettings<DiagnoseRouterRequest, DiagnoseRouterResponse> diagnoseRouterSettings() {
        return this.diagnoseRouterSettings;
    }

    public UnaryCallSettings<CreateRouterRequest, Operation> createRouterSettings() {
        return this.createRouterSettings;
    }

    public OperationCallSettings<CreateRouterRequest, Router, OperationMetadata> createRouterOperationSettings() {
        return this.createRouterOperationSettings;
    }

    public UnaryCallSettings<UpdateRouterRequest, Operation> updateRouterSettings() {
        return this.updateRouterSettings;
    }

    public OperationCallSettings<UpdateRouterRequest, Router, OperationMetadata> updateRouterOperationSettings() {
        return this.updateRouterOperationSettings;
    }

    public UnaryCallSettings<DeleteRouterRequest, Operation> deleteRouterSettings() {
        return this.deleteRouterSettings;
    }

    public OperationCallSettings<DeleteRouterRequest, Empty, OperationMetadata> deleteRouterOperationSettings() {
        return this.deleteRouterOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public EdgeNetworkStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEdgeNetworkStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonEdgeNetworkStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return EdgeNetworkStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "edgenetwork";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "edgenetwork.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "edgenetwork.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EdgeNetworkStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EdgeNetworkStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EdgeNetworkStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return EdgeNetworkStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EdgeNetworkStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.initializeZoneSettings = settingsBuilder.initializeZoneSettings().build();
        this.listZonesSettings = settingsBuilder.listZonesSettings().build();
        this.getZoneSettings = settingsBuilder.getZoneSettings().build();
        this.listNetworksSettings = settingsBuilder.listNetworksSettings().build();
        this.getNetworkSettings = settingsBuilder.getNetworkSettings().build();
        this.diagnoseNetworkSettings = settingsBuilder.diagnoseNetworkSettings().build();
        this.createNetworkSettings = settingsBuilder.createNetworkSettings().build();
        this.createNetworkOperationSettings = settingsBuilder.createNetworkOperationSettings().build();
        this.deleteNetworkSettings = settingsBuilder.deleteNetworkSettings().build();
        this.deleteNetworkOperationSettings = settingsBuilder.deleteNetworkOperationSettings().build();
        this.listSubnetsSettings = settingsBuilder.listSubnetsSettings().build();
        this.getSubnetSettings = settingsBuilder.getSubnetSettings().build();
        this.createSubnetSettings = settingsBuilder.createSubnetSettings().build();
        this.createSubnetOperationSettings = settingsBuilder.createSubnetOperationSettings().build();
        this.updateSubnetSettings = settingsBuilder.updateSubnetSettings().build();
        this.updateSubnetOperationSettings = settingsBuilder.updateSubnetOperationSettings().build();
        this.deleteSubnetSettings = settingsBuilder.deleteSubnetSettings().build();
        this.deleteSubnetOperationSettings = settingsBuilder.deleteSubnetOperationSettings().build();
        this.listInterconnectsSettings = settingsBuilder.listInterconnectsSettings().build();
        this.getInterconnectSettings = settingsBuilder.getInterconnectSettings().build();
        this.diagnoseInterconnectSettings = settingsBuilder.diagnoseInterconnectSettings().build();
        this.listInterconnectAttachmentsSettings = settingsBuilder.listInterconnectAttachmentsSettings().build();
        this.getInterconnectAttachmentSettings = settingsBuilder.getInterconnectAttachmentSettings().build();
        this.createInterconnectAttachmentSettings = settingsBuilder.createInterconnectAttachmentSettings().build();
        this.createInterconnectAttachmentOperationSettings = settingsBuilder.createInterconnectAttachmentOperationSettings().build();
        this.deleteInterconnectAttachmentSettings = settingsBuilder.deleteInterconnectAttachmentSettings().build();
        this.deleteInterconnectAttachmentOperationSettings = settingsBuilder.deleteInterconnectAttachmentOperationSettings().build();
        this.listRoutersSettings = settingsBuilder.listRoutersSettings().build();
        this.getRouterSettings = settingsBuilder.getRouterSettings().build();
        this.diagnoseRouterSettings = settingsBuilder.diagnoseRouterSettings().build();
        this.createRouterSettings = settingsBuilder.createRouterSettings().build();
        this.createRouterOperationSettings = settingsBuilder.createRouterOperationSettings().build();
        this.updateRouterSettings = settingsBuilder.updateRouterSettings().build();
        this.updateRouterOperationSettings = settingsBuilder.updateRouterOperationSettings().build();
        this.deleteRouterSettings = settingsBuilder.deleteRouterSettings().build();
        this.deleteRouterOperationSettings = settingsBuilder.deleteRouterOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EdgeNetworkStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<InitializeZoneRequest, InitializeZoneResponse> initializeZoneSettings;
        private final PagedCallSettings.Builder<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse> listZonesSettings;
        private final UnaryCallSettings.Builder<GetZoneRequest, Zone> getZoneSettings;
        private final PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse> listNetworksSettings;
        private final UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings;
        private final UnaryCallSettings.Builder<DiagnoseNetworkRequest, DiagnoseNetworkResponse> diagnoseNetworkSettings;
        private final UnaryCallSettings.Builder<CreateNetworkRequest, Operation> createNetworkSettings;
        private final OperationCallSettings.Builder<CreateNetworkRequest, Network, OperationMetadata> createNetworkOperationSettings;
        private final UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteNetworkSettings;
        private final OperationCallSettings.Builder<DeleteNetworkRequest, Empty, OperationMetadata> deleteNetworkOperationSettings;
        private final PagedCallSettings.Builder<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse> listSubnetsSettings;
        private final UnaryCallSettings.Builder<GetSubnetRequest, Subnet> getSubnetSettings;
        private final UnaryCallSettings.Builder<CreateSubnetRequest, Operation> createSubnetSettings;
        private final OperationCallSettings.Builder<CreateSubnetRequest, Subnet, OperationMetadata> createSubnetOperationSettings;
        private final UnaryCallSettings.Builder<UpdateSubnetRequest, Operation> updateSubnetSettings;
        private final OperationCallSettings.Builder<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationSettings;
        private final UnaryCallSettings.Builder<DeleteSubnetRequest, Operation> deleteSubnetSettings;
        private final OperationCallSettings.Builder<DeleteSubnetRequest, Empty, OperationMetadata> deleteSubnetOperationSettings;
        private final PagedCallSettings.Builder<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse> listInterconnectsSettings;
        private final UnaryCallSettings.Builder<GetInterconnectRequest, Interconnect> getInterconnectSettings;
        private final UnaryCallSettings.Builder<DiagnoseInterconnectRequest, DiagnoseInterconnectResponse> diagnoseInterconnectSettings;
        private final PagedCallSettings.Builder<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings;
        private final UnaryCallSettings.Builder<GetInterconnectAttachmentRequest, InterconnectAttachment> getInterconnectAttachmentSettings;
        private final UnaryCallSettings.Builder<CreateInterconnectAttachmentRequest, Operation> createInterconnectAttachmentSettings;
        private final OperationCallSettings.Builder<CreateInterconnectAttachmentRequest, InterconnectAttachment, OperationMetadata> createInterconnectAttachmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInterconnectAttachmentRequest, Operation> deleteInterconnectAttachmentSettings;
        private final OperationCallSettings.Builder<DeleteInterconnectAttachmentRequest, Empty, OperationMetadata> deleteInterconnectAttachmentOperationSettings;
        private final PagedCallSettings.Builder<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse> listRoutersSettings;
        private final UnaryCallSettings.Builder<GetRouterRequest, Router> getRouterSettings;
        private final UnaryCallSettings.Builder<DiagnoseRouterRequest, DiagnoseRouterResponse> diagnoseRouterSettings;
        private final UnaryCallSettings.Builder<CreateRouterRequest, Operation> createRouterSettings;
        private final OperationCallSettings.Builder<CreateRouterRequest, Router, OperationMetadata> createRouterOperationSettings;
        private final UnaryCallSettings.Builder<UpdateRouterRequest, Operation> updateRouterSettings;
        private final OperationCallSettings.Builder<UpdateRouterRequest, Router, OperationMetadata> updateRouterOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRouterRequest, Operation> deleteRouterSettings;
        private final OperationCallSettings.Builder<DeleteRouterRequest, Empty, OperationMetadata> deleteRouterOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.initializeZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listZonesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ZONES_PAGE_STR_FACT);
            this.getZoneSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listNetworksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_NETWORKS_PAGE_STR_FACT);
            this.getNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.diagnoseNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createNetworkOperationSettings = OperationCallSettings.newBuilder();
            this.deleteNetworkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteNetworkOperationSettings = OperationCallSettings.newBuilder();
            this.listSubnetsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBNETS_PAGE_STR_FACT);
            this.getSubnetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSubnetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createSubnetOperationSettings = OperationCallSettings.newBuilder();
            this.updateSubnetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSubnetOperationSettings = OperationCallSettings.newBuilder();
            this.deleteSubnetSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSubnetOperationSettings = OperationCallSettings.newBuilder();
            this.listInterconnectsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERCONNECTS_PAGE_STR_FACT);
            this.getInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.diagnoseInterconnectSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listInterconnectAttachmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INTERCONNECT_ATTACHMENTS_PAGE_STR_FACT);
            this.getInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInterconnectAttachmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInterconnectAttachmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInterconnectAttachmentOperationSettings = OperationCallSettings.newBuilder();
            this.listRoutersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ROUTERS_PAGE_STR_FACT);
            this.getRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.diagnoseRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRouterOperationSettings = OperationCallSettings.newBuilder();
            this.updateRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRouterOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRouterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRouterOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.initializeZoneSettings, this.listZonesSettings, this.getZoneSettings, this.listNetworksSettings, this.getNetworkSettings, this.diagnoseNetworkSettings, this.createNetworkSettings, this.deleteNetworkSettings, this.listSubnetsSettings, this.getSubnetSettings, this.createSubnetSettings, this.updateSubnetSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSubnetSettings, this.listInterconnectsSettings, this.getInterconnectSettings, this.diagnoseInterconnectSettings, this.listInterconnectAttachmentsSettings, this.getInterconnectAttachmentSettings, this.createInterconnectAttachmentSettings, this.deleteInterconnectAttachmentSettings, this.listRoutersSettings, this.getRouterSettings, this.diagnoseRouterSettings, this.createRouterSettings, this.updateRouterSettings, this.deleteRouterSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(EdgeNetworkStubSettings settings) {
            super((StubSettings)settings);
            this.initializeZoneSettings = settings.initializeZoneSettings.toBuilder();
            this.listZonesSettings = settings.listZonesSettings.toBuilder();
            this.getZoneSettings = settings.getZoneSettings.toBuilder();
            this.listNetworksSettings = settings.listNetworksSettings.toBuilder();
            this.getNetworkSettings = settings.getNetworkSettings.toBuilder();
            this.diagnoseNetworkSettings = settings.diagnoseNetworkSettings.toBuilder();
            this.createNetworkSettings = settings.createNetworkSettings.toBuilder();
            this.createNetworkOperationSettings = settings.createNetworkOperationSettings.toBuilder();
            this.deleteNetworkSettings = settings.deleteNetworkSettings.toBuilder();
            this.deleteNetworkOperationSettings = settings.deleteNetworkOperationSettings.toBuilder();
            this.listSubnetsSettings = settings.listSubnetsSettings.toBuilder();
            this.getSubnetSettings = settings.getSubnetSettings.toBuilder();
            this.createSubnetSettings = settings.createSubnetSettings.toBuilder();
            this.createSubnetOperationSettings = settings.createSubnetOperationSettings.toBuilder();
            this.updateSubnetSettings = settings.updateSubnetSettings.toBuilder();
            this.updateSubnetOperationSettings = settings.updateSubnetOperationSettings.toBuilder();
            this.deleteSubnetSettings = settings.deleteSubnetSettings.toBuilder();
            this.deleteSubnetOperationSettings = settings.deleteSubnetOperationSettings.toBuilder();
            this.listInterconnectsSettings = settings.listInterconnectsSettings.toBuilder();
            this.getInterconnectSettings = settings.getInterconnectSettings.toBuilder();
            this.diagnoseInterconnectSettings = settings.diagnoseInterconnectSettings.toBuilder();
            this.listInterconnectAttachmentsSettings = settings.listInterconnectAttachmentsSettings.toBuilder();
            this.getInterconnectAttachmentSettings = settings.getInterconnectAttachmentSettings.toBuilder();
            this.createInterconnectAttachmentSettings = settings.createInterconnectAttachmentSettings.toBuilder();
            this.createInterconnectAttachmentOperationSettings = settings.createInterconnectAttachmentOperationSettings.toBuilder();
            this.deleteInterconnectAttachmentSettings = settings.deleteInterconnectAttachmentSettings.toBuilder();
            this.deleteInterconnectAttachmentOperationSettings = settings.deleteInterconnectAttachmentOperationSettings.toBuilder();
            this.listRoutersSettings = settings.listRoutersSettings.toBuilder();
            this.getRouterSettings = settings.getRouterSettings.toBuilder();
            this.diagnoseRouterSettings = settings.diagnoseRouterSettings.toBuilder();
            this.createRouterSettings = settings.createRouterSettings.toBuilder();
            this.createRouterOperationSettings = settings.createRouterOperationSettings.toBuilder();
            this.updateRouterSettings = settings.updateRouterSettings.toBuilder();
            this.updateRouterOperationSettings = settings.updateRouterOperationSettings.toBuilder();
            this.deleteRouterSettings = settings.deleteRouterSettings.toBuilder();
            this.deleteRouterOperationSettings = settings.deleteRouterOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.initializeZoneSettings, this.listZonesSettings, this.getZoneSettings, this.listNetworksSettings, this.getNetworkSettings, this.diagnoseNetworkSettings, this.createNetworkSettings, this.deleteNetworkSettings, this.listSubnetsSettings, this.getSubnetSettings, this.createSubnetSettings, this.updateSubnetSettings, (Object[])new UnaryCallSettings.Builder[]{this.deleteSubnetSettings, this.listInterconnectsSettings, this.getInterconnectSettings, this.diagnoseInterconnectSettings, this.listInterconnectAttachmentsSettings, this.getInterconnectAttachmentSettings, this.createInterconnectAttachmentSettings, this.deleteInterconnectAttachmentSettings, this.listRoutersSettings, this.getRouterSettings, this.diagnoseRouterSettings, this.createRouterSettings, this.updateRouterSettings, this.deleteRouterSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EdgeNetworkStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EdgeNetworkStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EdgeNetworkStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EdgeNetworkStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)EdgeNetworkStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)EdgeNetworkStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EdgeNetworkStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(EdgeNetworkStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.initializeZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listZonesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getZoneSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listNetworksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.diagnoseNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteNetworkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listSubnetsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getSubnetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createSubnetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateSubnetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteSubnetSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listInterconnectsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.diagnoseInterconnectSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listInterconnectAttachmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteInterconnectAttachmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listRoutersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.diagnoseRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRouterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createNetworkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Network.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteNetworkOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createSubnetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Subnet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateSubnetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Subnet.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteSubnetOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createInterconnectAttachmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InterconnectAttachment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteInterconnectAttachmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createRouterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Router.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateRouterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Router.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRouterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<InitializeZoneRequest, InitializeZoneResponse> initializeZoneSettings() {
            return this.initializeZoneSettings;
        }

        public PagedCallSettings.Builder<ListZonesRequest, ListZonesResponse, EdgeNetworkClient.ListZonesPagedResponse> listZonesSettings() {
            return this.listZonesSettings;
        }

        public UnaryCallSettings.Builder<GetZoneRequest, Zone> getZoneSettings() {
            return this.getZoneSettings;
        }

        public PagedCallSettings.Builder<ListNetworksRequest, ListNetworksResponse, EdgeNetworkClient.ListNetworksPagedResponse> listNetworksSettings() {
            return this.listNetworksSettings;
        }

        public UnaryCallSettings.Builder<GetNetworkRequest, Network> getNetworkSettings() {
            return this.getNetworkSettings;
        }

        public UnaryCallSettings.Builder<DiagnoseNetworkRequest, DiagnoseNetworkResponse> diagnoseNetworkSettings() {
            return this.diagnoseNetworkSettings;
        }

        public UnaryCallSettings.Builder<CreateNetworkRequest, Operation> createNetworkSettings() {
            return this.createNetworkSettings;
        }

        public OperationCallSettings.Builder<CreateNetworkRequest, Network, OperationMetadata> createNetworkOperationSettings() {
            return this.createNetworkOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteNetworkRequest, Operation> deleteNetworkSettings() {
            return this.deleteNetworkSettings;
        }

        public OperationCallSettings.Builder<DeleteNetworkRequest, Empty, OperationMetadata> deleteNetworkOperationSettings() {
            return this.deleteNetworkOperationSettings;
        }

        public PagedCallSettings.Builder<ListSubnetsRequest, ListSubnetsResponse, EdgeNetworkClient.ListSubnetsPagedResponse> listSubnetsSettings() {
            return this.listSubnetsSettings;
        }

        public UnaryCallSettings.Builder<GetSubnetRequest, Subnet> getSubnetSettings() {
            return this.getSubnetSettings;
        }

        public UnaryCallSettings.Builder<CreateSubnetRequest, Operation> createSubnetSettings() {
            return this.createSubnetSettings;
        }

        public OperationCallSettings.Builder<CreateSubnetRequest, Subnet, OperationMetadata> createSubnetOperationSettings() {
            return this.createSubnetOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateSubnetRequest, Operation> updateSubnetSettings() {
            return this.updateSubnetSettings;
        }

        public OperationCallSettings.Builder<UpdateSubnetRequest, Subnet, OperationMetadata> updateSubnetOperationSettings() {
            return this.updateSubnetOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteSubnetRequest, Operation> deleteSubnetSettings() {
            return this.deleteSubnetSettings;
        }

        public OperationCallSettings.Builder<DeleteSubnetRequest, Empty, OperationMetadata> deleteSubnetOperationSettings() {
            return this.deleteSubnetOperationSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectsRequest, ListInterconnectsResponse, EdgeNetworkClient.ListInterconnectsPagedResponse> listInterconnectsSettings() {
            return this.listInterconnectsSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectRequest, Interconnect> getInterconnectSettings() {
            return this.getInterconnectSettings;
        }

        public UnaryCallSettings.Builder<DiagnoseInterconnectRequest, DiagnoseInterconnectResponse> diagnoseInterconnectSettings() {
            return this.diagnoseInterconnectSettings;
        }

        public PagedCallSettings.Builder<ListInterconnectAttachmentsRequest, ListInterconnectAttachmentsResponse, EdgeNetworkClient.ListInterconnectAttachmentsPagedResponse> listInterconnectAttachmentsSettings() {
            return this.listInterconnectAttachmentsSettings;
        }

        public UnaryCallSettings.Builder<GetInterconnectAttachmentRequest, InterconnectAttachment> getInterconnectAttachmentSettings() {
            return this.getInterconnectAttachmentSettings;
        }

        public UnaryCallSettings.Builder<CreateInterconnectAttachmentRequest, Operation> createInterconnectAttachmentSettings() {
            return this.createInterconnectAttachmentSettings;
        }

        public OperationCallSettings.Builder<CreateInterconnectAttachmentRequest, InterconnectAttachment, OperationMetadata> createInterconnectAttachmentOperationSettings() {
            return this.createInterconnectAttachmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInterconnectAttachmentRequest, Operation> deleteInterconnectAttachmentSettings() {
            return this.deleteInterconnectAttachmentSettings;
        }

        public OperationCallSettings.Builder<DeleteInterconnectAttachmentRequest, Empty, OperationMetadata> deleteInterconnectAttachmentOperationSettings() {
            return this.deleteInterconnectAttachmentOperationSettings;
        }

        public PagedCallSettings.Builder<ListRoutersRequest, ListRoutersResponse, EdgeNetworkClient.ListRoutersPagedResponse> listRoutersSettings() {
            return this.listRoutersSettings;
        }

        public UnaryCallSettings.Builder<GetRouterRequest, Router> getRouterSettings() {
            return this.getRouterSettings;
        }

        public UnaryCallSettings.Builder<DiagnoseRouterRequest, DiagnoseRouterResponse> diagnoseRouterSettings() {
            return this.diagnoseRouterSettings;
        }

        public UnaryCallSettings.Builder<CreateRouterRequest, Operation> createRouterSettings() {
            return this.createRouterSettings;
        }

        public OperationCallSettings.Builder<CreateRouterRequest, Router, OperationMetadata> createRouterOperationSettings() {
            return this.createRouterOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateRouterRequest, Operation> updateRouterSettings() {
            return this.updateRouterSettings;
        }

        public OperationCallSettings.Builder<UpdateRouterRequest, Router, OperationMetadata> updateRouterOperationSettings() {
            return this.updateRouterOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRouterRequest, Operation> deleteRouterSettings() {
            return this.deleteRouterSettings;
        }

        public OperationCallSettings.Builder<DeleteRouterRequest, Empty, OperationMetadata> deleteRouterOperationSettings() {
            return this.deleteRouterOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, EdgeNetworkClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return EdgeNetworkStubSettings.getDefaultEndpoint();
        }

        public EdgeNetworkStubSettings build() throws IOException {
            return new EdgeNetworkStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

