/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta2.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta2.BatchProcessDocumentsRequest;
import com.google.cloud.documentai.v1beta2.BatchProcessDocumentsResponse;
import com.google.cloud.documentai.v1beta2.Document;
import com.google.cloud.documentai.v1beta2.DocumentUnderstandingServiceClient;
import com.google.cloud.documentai.v1beta2.OperationMetadata;
import com.google.cloud.documentai.v1beta2.ProcessDocumentRequest;
import com.google.cloud.documentai.v1beta2.stub.DocumentUnderstandingServiceStub;
import com.google.cloud.documentai.v1beta2.stub.DocumentUnderstandingServiceStubSettings;
import com.google.cloud.documentai.v1beta2.stub.GrpcDocumentUnderstandingServiceCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDocumentUnderstandingServiceStub
extends DocumentUnderstandingServiceStub {
    private static final MethodDescriptor<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta2.DocumentUnderstandingService/BatchProcessDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)BatchProcessDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ProcessDocumentRequest, Document> processDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.documentai.v1beta2.DocumentUnderstandingService/ProcessDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ProcessDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsCallable;
    private final OperationCallable<BatchProcessDocumentsRequest, BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsOperationCallable;
    private final UnaryCallable<ProcessDocumentRequest, Document> processDocumentCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DocumentUnderstandingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentUnderstandingServiceStub create(DocumentUnderstandingServiceStubSettings settings) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentUnderstandingServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentUnderstandingServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentUnderstandingServiceCallableFactory());
    }

    protected GrpcDocumentUnderstandingServiceStub(DocumentUnderstandingServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings batchProcessDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(batchProcessDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings processDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(processDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.batchProcessDocumentsCallable = callableFactory.createUnaryCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsSettings(), clientContext);
        this.batchProcessDocumentsOperationCallable = callableFactory.createOperationCallable(batchProcessDocumentsTransportSettings, settings.batchProcessDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.processDocumentCallable = callableFactory.createUnaryCallable(processDocumentTransportSettings, settings.processDocumentSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<BatchProcessDocumentsRequest, Operation> batchProcessDocumentsCallable() {
        return this.batchProcessDocumentsCallable;
    }

    @Override
    public OperationCallable<BatchProcessDocumentsRequest, BatchProcessDocumentsResponse, OperationMetadata> batchProcessDocumentsOperationCallable() {
        return this.batchProcessDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<ProcessDocumentRequest, Document> processDocumentCallable() {
        return this.processDocumentCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DocumentUnderstandingServiceClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

