/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.documentai.v1beta3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.documentai.v1beta3.BatchProcessMetadata;
import com.google.cloud.documentai.v1beta3.BatchProcessRequest;
import com.google.cloud.documentai.v1beta3.BatchProcessResponse;
import com.google.cloud.documentai.v1beta3.CreateProcessorRequest;
import com.google.cloud.documentai.v1beta3.DeleteProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DeleteProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.DisableProcessorRequest;
import com.google.cloud.documentai.v1beta3.DisableProcessorResponse;
import com.google.cloud.documentai.v1beta3.DocumentProcessorServiceClient;
import com.google.cloud.documentai.v1beta3.EnableProcessorMetadata;
import com.google.cloud.documentai.v1beta3.EnableProcessorRequest;
import com.google.cloud.documentai.v1beta3.EnableProcessorResponse;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesRequest;
import com.google.cloud.documentai.v1beta3.FetchProcessorTypesResponse;
import com.google.cloud.documentai.v1beta3.ListProcessorsRequest;
import com.google.cloud.documentai.v1beta3.ListProcessorsResponse;
import com.google.cloud.documentai.v1beta3.ProcessRequest;
import com.google.cloud.documentai.v1beta3.ProcessResponse;
import com.google.cloud.documentai.v1beta3.Processor;
import com.google.cloud.documentai.v1beta3.ReviewDocumentOperationMetadata;
import com.google.cloud.documentai.v1beta3.ReviewDocumentRequest;
import com.google.cloud.documentai.v1beta3.ReviewDocumentResponse;
import com.google.cloud.documentai.v1beta3.stub.DocumentProcessorServiceStub;
import com.google.cloud.documentai.v1beta3.stub.GrpcDocumentProcessorServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DocumentProcessorServiceStubSettings
extends StubSettings<DocumentProcessorServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings;
    private final UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
    private final OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
    private final UnaryCallSettings<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings;
    private final PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings;
    private final UnaryCallSettings<CreateProcessorRequest, Processor> createProcessorSettings;
    private final UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings;
    private final OperationCallSettings<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings;
    private final UnaryCallSettings<EnableProcessorRequest, Operation> enableProcessorSettings;
    private final OperationCallSettings<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings;
    private final UnaryCallSettings<DisableProcessorRequest, Operation> disableProcessorSettings;
    private final OperationCallSettings<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings;
    private final UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings;
    private final OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;
    private static final PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor> LIST_PROCESSORS_PAGE_STR_DESC = new PagedListDescriptor<ListProcessorsRequest, ListProcessorsResponse, Processor>(){

        public String emptyToken() {
            return "";
        }

        public ListProcessorsRequest injectToken(ListProcessorsRequest payload, String token) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageToken(token).build();
        }

        public ListProcessorsRequest injectPageSize(ListProcessorsRequest payload, int pageSize) {
            return ListProcessorsRequest.newBuilder((ListProcessorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProcessorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProcessorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Processor> extractResources(ListProcessorsResponse payload) {
            return payload.getProcessorsList() == null ? ImmutableList.of() : payload.getProcessorsList();
        }
    };
    private static final PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> LIST_PROCESSORS_PAGE_STR_FACT = new PagedListResponseFactory<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse>(){

        public ApiFuture<DocumentProcessorServiceClient.ListProcessorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProcessorsRequest, ListProcessorsResponse> callable, ListProcessorsRequest request, ApiCallContext context, ApiFuture<ListProcessorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PROCESSORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DocumentProcessorServiceClient.ListProcessorsPagedResponse.createAsync((PageContext<ListProcessorsRequest, ListProcessorsResponse, Processor>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<ProcessRequest, ProcessResponse> processDocumentSettings() {
        return this.processDocumentSettings;
    }

    public UnaryCallSettings<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
        return this.batchProcessDocumentsSettings;
    }

    public OperationCallSettings<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
        return this.batchProcessDocumentsOperationSettings;
    }

    public UnaryCallSettings<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings() {
        return this.fetchProcessorTypesSettings;
    }

    public PagedCallSettings<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings() {
        return this.listProcessorsSettings;
    }

    public UnaryCallSettings<CreateProcessorRequest, Processor> createProcessorSettings() {
        return this.createProcessorSettings;
    }

    public UnaryCallSettings<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
        return this.deleteProcessorSettings;
    }

    public OperationCallSettings<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings() {
        return this.deleteProcessorOperationSettings;
    }

    public UnaryCallSettings<EnableProcessorRequest, Operation> enableProcessorSettings() {
        return this.enableProcessorSettings;
    }

    public OperationCallSettings<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings() {
        return this.enableProcessorOperationSettings;
    }

    public UnaryCallSettings<DisableProcessorRequest, Operation> disableProcessorSettings() {
        return this.disableProcessorSettings;
    }

    public OperationCallSettings<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings() {
        return this.disableProcessorOperationSettings;
    }

    public UnaryCallSettings<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
        return this.reviewDocumentSettings;
    }

    public OperationCallSettings<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
        return this.reviewDocumentOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DocumentProcessorServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDocumentProcessorServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "documentai.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "documentai.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DocumentProcessorServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DocumentProcessorServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DocumentProcessorServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.processDocumentSettings = settingsBuilder.processDocumentSettings().build();
        this.batchProcessDocumentsSettings = settingsBuilder.batchProcessDocumentsSettings().build();
        this.batchProcessDocumentsOperationSettings = settingsBuilder.batchProcessDocumentsOperationSettings().build();
        this.fetchProcessorTypesSettings = settingsBuilder.fetchProcessorTypesSettings().build();
        this.listProcessorsSettings = settingsBuilder.listProcessorsSettings().build();
        this.createProcessorSettings = settingsBuilder.createProcessorSettings().build();
        this.deleteProcessorSettings = settingsBuilder.deleteProcessorSettings().build();
        this.deleteProcessorOperationSettings = settingsBuilder.deleteProcessorOperationSettings().build();
        this.enableProcessorSettings = settingsBuilder.enableProcessorSettings().build();
        this.enableProcessorOperationSettings = settingsBuilder.enableProcessorOperationSettings().build();
        this.disableProcessorSettings = settingsBuilder.disableProcessorSettings().build();
        this.disableProcessorOperationSettings = settingsBuilder.disableProcessorOperationSettings().build();
        this.reviewDocumentSettings = settingsBuilder.reviewDocumentSettings().build();
        this.reviewDocumentOperationSettings = settingsBuilder.reviewDocumentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DocumentProcessorServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings;
        private final UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings;
        private final OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings;
        private final UnaryCallSettings.Builder<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings;
        private final PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings;
        private final UnaryCallSettings.Builder<CreateProcessorRequest, Processor> createProcessorSettings;
        private final UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings;
        private final OperationCallSettings.Builder<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings;
        private final UnaryCallSettings.Builder<EnableProcessorRequest, Operation> enableProcessorSettings;
        private final OperationCallSettings.Builder<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings;
        private final UnaryCallSettings.Builder<DisableProcessorRequest, Operation> disableProcessorSettings;
        private final OperationCallSettings.Builder<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings;
        private final UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings;
        private final OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.processDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchProcessDocumentsOperationSettings = OperationCallSettings.newBuilder();
            this.fetchProcessorTypesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProcessorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PROCESSORS_PAGE_STR_FACT);
            this.createProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.enableProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enableProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.disableProcessorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.disableProcessorOperationSettings = OperationCallSettings.newBuilder();
            this.reviewDocumentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.reviewDocumentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.fetchProcessorTypesSettings, this.listProcessorsSettings, this.createProcessorSettings, this.deleteProcessorSettings, this.enableProcessorSettings, this.disableProcessorSettings, this.reviewDocumentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DocumentProcessorServiceStubSettings settings) {
            super((StubSettings)settings);
            this.processDocumentSettings = settings.processDocumentSettings.toBuilder();
            this.batchProcessDocumentsSettings = settings.batchProcessDocumentsSettings.toBuilder();
            this.batchProcessDocumentsOperationSettings = settings.batchProcessDocumentsOperationSettings.toBuilder();
            this.fetchProcessorTypesSettings = settings.fetchProcessorTypesSettings.toBuilder();
            this.listProcessorsSettings = settings.listProcessorsSettings.toBuilder();
            this.createProcessorSettings = settings.createProcessorSettings.toBuilder();
            this.deleteProcessorSettings = settings.deleteProcessorSettings.toBuilder();
            this.deleteProcessorOperationSettings = settings.deleteProcessorOperationSettings.toBuilder();
            this.enableProcessorSettings = settings.enableProcessorSettings.toBuilder();
            this.enableProcessorOperationSettings = settings.enableProcessorOperationSettings.toBuilder();
            this.disableProcessorSettings = settings.disableProcessorSettings.toBuilder();
            this.disableProcessorOperationSettings = settings.disableProcessorOperationSettings.toBuilder();
            this.reviewDocumentSettings = settings.reviewDocumentSettings.toBuilder();
            this.reviewDocumentOperationSettings = settings.reviewDocumentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.processDocumentSettings, this.batchProcessDocumentsSettings, this.fetchProcessorTypesSettings, this.listProcessorsSettings, this.createProcessorSettings, this.deleteProcessorSettings, this.enableProcessorSettings, this.disableProcessorSettings, this.reviewDocumentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DocumentProcessorServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DocumentProcessorServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DocumentProcessorServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(DocumentProcessorServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(DocumentProcessorServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.processDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchProcessDocumentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchProcessorTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listProcessorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.enableProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.disableProcessorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.reviewDocumentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.batchProcessDocumentsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchProcessResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(BatchProcessMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DeleteProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.enableProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(EnableProcessorResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(EnableProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.disableProcessorOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DisableProcessorResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(DisableProcessorMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.reviewDocumentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ReviewDocumentResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ReviewDocumentOperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ProcessRequest, ProcessResponse> processDocumentSettings() {
            return this.processDocumentSettings;
        }

        public UnaryCallSettings.Builder<BatchProcessRequest, Operation> batchProcessDocumentsSettings() {
            return this.batchProcessDocumentsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchProcessRequest, BatchProcessResponse, BatchProcessMetadata> batchProcessDocumentsOperationSettings() {
            return this.batchProcessDocumentsOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchProcessorTypesRequest, FetchProcessorTypesResponse> fetchProcessorTypesSettings() {
            return this.fetchProcessorTypesSettings;
        }

        public PagedCallSettings.Builder<ListProcessorsRequest, ListProcessorsResponse, DocumentProcessorServiceClient.ListProcessorsPagedResponse> listProcessorsSettings() {
            return this.listProcessorsSettings;
        }

        public UnaryCallSettings.Builder<CreateProcessorRequest, Processor> createProcessorSettings() {
            return this.createProcessorSettings;
        }

        public UnaryCallSettings.Builder<DeleteProcessorRequest, Operation> deleteProcessorSettings() {
            return this.deleteProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteProcessorRequest, Empty, DeleteProcessorMetadata> deleteProcessorOperationSettings() {
            return this.deleteProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<EnableProcessorRequest, Operation> enableProcessorSettings() {
            return this.enableProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<EnableProcessorRequest, EnableProcessorResponse, EnableProcessorMetadata> enableProcessorOperationSettings() {
            return this.enableProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<DisableProcessorRequest, Operation> disableProcessorSettings() {
            return this.disableProcessorSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DisableProcessorRequest, DisableProcessorResponse, DisableProcessorMetadata> disableProcessorOperationSettings() {
            return this.disableProcessorOperationSettings;
        }

        public UnaryCallSettings.Builder<ReviewDocumentRequest, Operation> reviewDocumentSettings() {
            return this.reviewDocumentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ReviewDocumentRequest, ReviewDocumentResponse, ReviewDocumentOperationMetadata> reviewDocumentOperationSettings() {
            return this.reviewDocumentOperationSettings;
        }

        public DocumentProcessorServiceStubSettings build() throws IOException {
            return new DocumentProcessorServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

