/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.api.gax.paging.Page;
import com.google.api.services.dns.model.ManagedZone;
import com.google.cloud.dns.ChangeRequest;
import com.google.cloud.dns.ChangeRequestInfo;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsOptions;
import com.google.cloud.dns.RecordSet;
import com.google.cloud.dns.ZoneInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Zone
extends ZoneInfo {
    private static final long serialVersionUID = -5817771337847861598L;
    private final DnsOptions options;
    private transient Dns dns;

    Zone(Dns dns, ZoneInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.dns = dns;
        this.options = (DnsOptions)dns.getOptions();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    public Zone reload(Dns.ZoneOption ... options) {
        return this.dns.getZone(this.getName(), options);
    }

    public boolean delete() {
        return this.dns.delete(this.getName());
    }

    public Page<RecordSet> listRecordSets(Dns.RecordSetListOption ... options) {
        return this.dns.listRecordSets(this.getName(), options);
    }

    public ChangeRequest applyChangeRequest(ChangeRequestInfo changeRequest, Dns.ChangeRequestOption ... options) {
        Preconditions.checkNotNull((Object)changeRequest);
        return this.dns.applyChangeRequest(this.getName(), changeRequest, options);
    }

    public ChangeRequest getChangeRequest(String changeRequestId, Dns.ChangeRequestOption ... options) {
        Preconditions.checkNotNull((Object)changeRequestId);
        return this.dns.getChangeRequest(this.getName(), changeRequestId, options);
    }

    public Page<ChangeRequest> listChangeRequests(Dns.ChangeRequestListOption ... options) {
        return this.dns.listChangeRequests(this.getName(), options);
    }

    public Dns getDns() {
        return this.dns;
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Zone.class)) {
            return false;
        }
        Zone other = (Zone)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.dns = (Dns)this.options.getService();
    }

    static Zone fromPb(Dns dns, ManagedZone zone) {
        ZoneInfo info = ZoneInfo.fromPb(zone);
        return new Zone(dns, new ZoneInfo.BuilderImpl(info));
    }

    public static class Builder
    extends ZoneInfo.Builder {
        private final Dns dns;
        private final ZoneInfo.BuilderImpl infoBuilder;

        private Builder(Zone zone) {
            this.dns = zone.dns;
            this.infoBuilder = new ZoneInfo.BuilderImpl(zone);
        }

        @Override
        public Builder setName(String name) {
            this.infoBuilder.setName(name);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.infoBuilder.setGeneratedId(generatedId);
            return this;
        }

        @Override
        Builder setCreationTimeMillis(long creationTimeMillis) {
            this.infoBuilder.setCreationTimeMillis(creationTimeMillis);
            return this;
        }

        @Override
        public Builder setDnsName(String dnsName) {
            this.infoBuilder.setDnsName(dnsName);
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.infoBuilder.setDescription(description);
            return this;
        }

        @Override
        Builder setNameServerSet(String nameServerSet) {
            this.infoBuilder.setNameServerSet(nameServerSet);
            return this;
        }

        @Override
        Builder setNameServers(List<String> nameServers) {
            this.infoBuilder.setNameServers(nameServers);
            return this;
        }

        @Override
        public Builder setDnsSecConfig(ZoneInfo.DnsSecConfig dnsSecConfig) {
            this.infoBuilder.setDnsSecConfig(dnsSecConfig);
            return this;
        }

        @Override
        public Builder setLabels(Map<String, String> labels) {
            this.infoBuilder.setLabels(labels);
            return this;
        }

        @Override
        public Zone build() {
            return new Zone(this.dns, this.infoBuilder);
        }
    }
}

