/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dns;

import com.google.cloud.HttpTransportOptions;
import com.google.cloud.ServiceDefaults;
import com.google.cloud.ServiceOptions;
import com.google.cloud.ServiceRpc;
import com.google.cloud.TransportOptions;
import com.google.cloud.dns.Dns;
import com.google.cloud.dns.DnsFactory;
import com.google.cloud.dns.DnsImpl;
import com.google.cloud.dns.spi.DnsRpcFactory;
import com.google.cloud.dns.spi.v1.DnsRpc;
import com.google.cloud.dns.spi.v1.HttpDnsRpc;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class DnsOptions
extends ServiceOptions<Dns, DnsOptions> {
    private static final long serialVersionUID = -2501790264435912627L;
    private static final String API_SHORT_NAME = "Dns";
    private static final String GC_DNS_RW = "https://www.googleapis.com/auth/ndev.clouddns.readwrite";
    private static final Set<String> SCOPES = ImmutableSet.of((Object)"https://www.googleapis.com/auth/ndev.clouddns.readwrite");

    private DnsOptions(Builder builder) {
        super(DnsFactory.class, DnsRpcFactory.class, (ServiceOptions.Builder)builder, (ServiceDefaults)new DnsDefaults());
    }

    public static HttpTransportOptions getDefaultHttpTransportOptions() {
        return HttpTransportOptions.newBuilder().build();
    }

    protected Set<String> getScopes() {
        return SCOPES;
    }

    protected DnsRpc getDnsRpcV1() {
        return (DnsRpc)this.getRpc();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static DnsOptions getDefaultInstance() {
        return DnsOptions.newBuilder().build();
    }

    public boolean equals(Object obj) {
        return obj instanceof DnsOptions && this.baseEquals((DnsOptions)((Object)obj));
    }

    public int hashCode() {
        return this.baseHashCode();
    }

    private static class DnsDefaults
    implements ServiceDefaults<Dns, DnsOptions> {
        private DnsDefaults() {
        }

        public DnsFactory getDefaultServiceFactory() {
            return DefaultDnsFactory.INSTANCE;
        }

        public DnsRpcFactory getDefaultRpcFactory() {
            return DefaultDnsRpcFactory.INSTANCE;
        }

        public TransportOptions getDefaultTransportOptions() {
            return DnsOptions.getDefaultHttpTransportOptions();
        }
    }

    public static class Builder
    extends ServiceOptions.Builder<Dns, DnsOptions, Builder> {
        private Builder() {
        }

        private Builder(DnsOptions options) {
            super((ServiceOptions)options);
        }

        public Builder setTransportOptions(TransportOptions transportOptions) {
            if (!(transportOptions instanceof HttpTransportOptions)) {
                throw new IllegalArgumentException("Only http transport is allowed for Dns.");
            }
            return (Builder)super.setTransportOptions(transportOptions);
        }

        public DnsOptions build() {
            return new DnsOptions(this);
        }
    }

    public static class DefaultDnsRpcFactory
    implements DnsRpcFactory {
        private static final DnsRpcFactory INSTANCE = new DefaultDnsRpcFactory();

        public ServiceRpc create(DnsOptions options) {
            return new HttpDnsRpc(options);
        }
    }

    public static class DefaultDnsFactory
    implements DnsFactory {
        private static final DnsFactory INSTANCE = new DefaultDnsFactory();

        public Dns create(DnsOptions options) {
            return new DnsImpl(options);
        }
    }
}

