/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2beta1;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.core.PropertiesProvider;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.grpc.GrpcTransport;
import com.google.api.gax.grpc.GrpcTransportProvider;
import com.google.api.gax.grpc.InstantiatingChannelProvider;
import com.google.api.gax.grpc.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientSettings;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.SimpleCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.dlp.v2beta1.stub.DlpServiceStub;
import com.google.cloud.dlp.v2beta1.stub.GrpcDlpServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.privacy.dlp.v2beta1.CreateInspectOperationRequest;
import com.google.privacy.dlp.v2beta1.InspectContentRequest;
import com.google.privacy.dlp.v2beta1.InspectContentResponse;
import com.google.privacy.dlp.v2beta1.InspectOperationMetadata;
import com.google.privacy.dlp.v2beta1.InspectOperationResult;
import com.google.privacy.dlp.v2beta1.ListInfoTypesRequest;
import com.google.privacy.dlp.v2beta1.ListInfoTypesResponse;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsRequest;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsResponse;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesRequest;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesResponse;
import com.google.privacy.dlp.v2beta1.RedactContentRequest;
import com.google.privacy.dlp.v2beta1.RedactContentResponse;
import io.grpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class DlpServiceSettings
extends ClientSettings {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private static final String DEFAULT_GAPIC_NAME = "gapic";
    private static final String DEFAULT_GAPIC_VERSION = "";
    private static final String PROPERTIES_FILE = "/com/google/cloud/dlp/project.properties";
    private static final String META_VERSION_KEY = "artifact.version";
    private static String gapicVersion;
    private final SimpleCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings;
    private final SimpleCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings;
    private final OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata, Operation> createInspectOperationSettings;
    private final SimpleCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
    private final SimpleCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
    private final SimpleCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;

    public SimpleCallSettings<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
        return this.inspectContentSettings;
    }

    public SimpleCallSettings<RedactContentRequest, RedactContentResponse> redactContentSettings() {
        return this.redactContentSettings;
    }

    public OperationCallSettings<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata, Operation> createInspectOperationSettings() {
        return this.createInspectOperationSettings;
    }

    public SimpleCallSettings<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
        return this.listInspectFindingsSettings;
    }

    public SimpleCallSettings<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
        return this.listInfoTypesSettings;
    }

    public SimpleCallSettings<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
        return this.listRootCategoriesSettings;
    }

    public DlpServiceStub createStub() throws IOException {
        if (this.getTransportProvider().getTransportName().equals(GrpcTransport.getGrpcTransportName())) {
            return GrpcDlpServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dlp.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingChannelProvider.Builder defaultGrpcChannelProviderBuilder() {
        return InstantiatingChannelProvider.newBuilder().setEndpoint(DlpServiceSettings.getDefaultEndpoint()).setGeneratorHeader(DEFAULT_GAPIC_NAME, DlpServiceSettings.getGapicVersion());
    }

    public static GrpcTransportProvider.Builder defaultGrpcTransportProviderBuilder() {
        return GrpcTransportProvider.newBuilder().setChannelProvider((ChannelProvider)DlpServiceSettings.defaultGrpcChannelProviderBuilder().build());
    }

    public static TransportProvider defaultTransportProvider() {
        return DlpServiceSettings.defaultGrpcTransportProviderBuilder().build();
    }

    private static String getGapicVersion() {
        if (gapicVersion == null) {
            gapicVersion = PropertiesProvider.loadProperty(DlpServiceSettings.class, (String)PROPERTIES_FILE, (String)META_VERSION_KEY);
            gapicVersion = gapicVersion == null ? DEFAULT_GAPIC_VERSION : gapicVersion;
        }
        return gapicVersion;
    }

    @Deprecated
    public static Builder defaultBuilder() {
        return Builder.createDefault();
    }

    @Deprecated
    public static Builder defaultBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DlpServiceSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder.getExecutorProvider(), settingsBuilder.getTransportProvider(), settingsBuilder.getCredentialsProvider(), settingsBuilder.getClock());
        this.inspectContentSettings = settingsBuilder.inspectContentSettings().build();
        this.redactContentSettings = settingsBuilder.redactContentSettings().build();
        this.createInspectOperationSettings = settingsBuilder.createInspectOperationSettings().build();
        this.listInspectFindingsSettings = settingsBuilder.listInspectFindingsSettings().build();
        this.listInfoTypesSettings = settingsBuilder.listInfoTypesSettings().build();
        this.listRootCategoriesSettings = settingsBuilder.listRootCategoriesSettings().build();
    }

    public static class Builder
    extends ClientSettings.Builder {
        private final ImmutableList<UnaryCallSettings.Builder> unaryMethodSettingsBuilders;
        private final SimpleCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings;
        private final SimpleCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings;
        private final OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata, Operation> createInspectOperationSettings;
        private final SimpleCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings;
        private final SimpleCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings;
        private final SimpleCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        private Builder() {
            this((ClientContext)null);
        }

        private Builder(ClientContext clientContext) {
            super(clientContext);
            this.inspectContentSettings = SimpleCallSettings.newBuilder();
            this.redactContentSettings = SimpleCallSettings.newBuilder();
            this.createInspectOperationSettings = OperationCallSettings.newBuilder();
            this.listInspectFindingsSettings = SimpleCallSettings.newBuilder();
            this.listInfoTypesSettings = SimpleCallSettings.newBuilder();
            this.listRootCategoriesSettings = SimpleCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportProvider(DlpServiceSettings.defaultTransportProvider());
            builder.setCredentialsProvider((CredentialsProvider)DlpServiceSettings.defaultCredentialsProviderBuilder().build());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.inspectContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.redactContentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInspectFindingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listInfoTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listRootCategoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createInspectOperationSettings().setInitialCallSettings(SimpleCallSettings.newBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default")).build()).setResponseClass(InspectOperationResult.class).setMetadataClass(InspectOperationMetadata.class).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)20000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)86400000L)).build()));
            return builder;
        }

        private Builder(DlpServiceSettings settings) {
            super((ClientSettings)settings);
            this.inspectContentSettings = settings.inspectContentSettings.toBuilder();
            this.redactContentSettings = settings.redactContentSettings.toBuilder();
            this.createInspectOperationSettings = settings.createInspectOperationSettings.toBuilder();
            this.listInspectFindingsSettings = settings.listInspectFindingsSettings.toBuilder();
            this.listInfoTypesSettings = settings.listInfoTypesSettings.toBuilder();
            this.listRootCategoriesSettings = settings.listRootCategoriesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.inspectContentSettings, this.redactContentSettings, this.listInspectFindingsSettings, this.listInfoTypesSettings, this.listRootCategoriesSettings);
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            super.setExecutorProvider(executorProvider);
            return this;
        }

        public Builder setTransportProvider(TransportProvider transportProvider) {
            super.setTransportProvider(transportProvider);
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            super.setCredentialsProvider(credentialsProvider);
            return this;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder, Void> settingsUpdater) throws Exception {
            super.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public SimpleCallSettings.Builder<InspectContentRequest, InspectContentResponse> inspectContentSettings() {
            return this.inspectContentSettings;
        }

        public SimpleCallSettings.Builder<RedactContentRequest, RedactContentResponse> redactContentSettings() {
            return this.redactContentSettings;
        }

        public OperationCallSettings.Builder<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata, Operation> createInspectOperationSettings() {
            return this.createInspectOperationSettings;
        }

        public SimpleCallSettings.Builder<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsSettings() {
            return this.listInspectFindingsSettings;
        }

        public SimpleCallSettings.Builder<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesSettings() {
            return this.listInfoTypesSettings;
        }

        public SimpleCallSettings.Builder<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesSettings() {
            return this.listRootCategoriesSettings;
        }

        public DlpServiceSettings build() throws IOException {
            return new DlpServiceSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode[]{GrpcStatusCode.of((Status.Code)Status.Code.DEADLINE_EXCEEDED), GrpcStatusCode.of((Status.Code)Status.Code.UNAVAILABLE)})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

