/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dlp.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelAndExecutor;
import com.google.api.gax.grpc.ChannelProvider;
import com.google.api.gax.grpc.ClientContext;
import com.google.api.gax.grpc.ExecutorProvider;
import com.google.api.gax.grpc.FixedChannelProvider;
import com.google.api.gax.grpc.FixedExecutorProvider;
import com.google.api.gax.grpc.OperationCallable;
import com.google.api.gax.grpc.OperationFuture;
import com.google.api.gax.grpc.SimpleCallSettings;
import com.google.api.gax.grpc.UnaryCallable;
import com.google.auth.Credentials;
import com.google.cloud.dlp.v2beta1.DlpServiceSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.OperationsSettings;
import com.google.privacy.dlp.v2beta1.ContentItem;
import com.google.privacy.dlp.v2beta1.CreateInspectOperationRequest;
import com.google.privacy.dlp.v2beta1.InspectConfig;
import com.google.privacy.dlp.v2beta1.InspectContentRequest;
import com.google.privacy.dlp.v2beta1.InspectContentResponse;
import com.google.privacy.dlp.v2beta1.InspectOperationMetadata;
import com.google.privacy.dlp.v2beta1.InspectOperationResult;
import com.google.privacy.dlp.v2beta1.ListInfoTypesRequest;
import com.google.privacy.dlp.v2beta1.ListInfoTypesResponse;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsRequest;
import com.google.privacy.dlp.v2beta1.ListInspectFindingsResponse;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesRequest;
import com.google.privacy.dlp.v2beta1.ListRootCategoriesResponse;
import com.google.privacy.dlp.v2beta1.OutputStorageConfig;
import com.google.privacy.dlp.v2beta1.RedactContentRequest;
import com.google.privacy.dlp.v2beta1.RedactContentResponse;
import com.google.privacy.dlp.v2beta1.ResultName;
import com.google.privacy.dlp.v2beta1.StorageConfig;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@BetaApi
public class DlpServiceClient
implements AutoCloseable {
    private final DlpServiceSettings settings;
    private final ScheduledExecutorService executor;
    private final ManagedChannel channel;
    private final OperationsClient operationsClient;
    private final List<AutoCloseable> closeables = new ArrayList<AutoCloseable>();
    private final UnaryCallable<InspectContentRequest, InspectContentResponse> inspectContentCallable;
    private final UnaryCallable<RedactContentRequest, RedactContentResponse> redactContentCallable;
    private final UnaryCallable<CreateInspectOperationRequest, Operation> createInspectOperationCallable;
    private final OperationCallable<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationCallable;
    private final UnaryCallable<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsCallable;
    private final UnaryCallable<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesCallable;
    private final UnaryCallable<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesCallable;

    public static final DlpServiceClient create() throws IOException {
        return DlpServiceClient.create(DlpServiceSettings.defaultBuilder().build());
    }

    public static final DlpServiceClient create(DlpServiceSettings settings) throws IOException {
        return new DlpServiceClient(settings);
    }

    protected DlpServiceClient(DlpServiceSettings settings) throws IOException {
        this.settings = settings;
        ChannelAndExecutor channelAndExecutor = settings.getChannelAndExecutor();
        this.executor = channelAndExecutor.getExecutor();
        this.channel = channelAndExecutor.getChannel();
        Credentials credentials = settings.getCredentialsProvider().getCredentials();
        ClientContext clientContext = ClientContext.newBuilder().setExecutor(this.executor).setChannel((Channel)this.channel).setCredentials(credentials).build();
        OperationsSettings operationsSettings = OperationsSettings.defaultBuilder().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)this.executor)).setChannelProvider((ChannelProvider)FixedChannelProvider.create((ManagedChannel)this.channel)).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentials)).build();
        this.operationsClient = OperationsClient.create((OperationsSettings)operationsSettings);
        this.inspectContentCallable = UnaryCallable.create(settings.inspectContentSettings(), (ClientContext)clientContext);
        this.redactContentCallable = UnaryCallable.create(settings.redactContentSettings(), (ClientContext)clientContext);
        this.createInspectOperationCallable = UnaryCallable.create((SimpleCallSettings)settings.createInspectOperationSettings().getInitialCallSettings(), (ClientContext)clientContext);
        this.createInspectOperationOperationCallable = OperationCallable.create(settings.createInspectOperationSettings(), (ClientContext)clientContext, (OperationsClient)this.operationsClient);
        this.listInspectFindingsCallable = UnaryCallable.create(settings.listInspectFindingsSettings(), (ClientContext)clientContext);
        this.listInfoTypesCallable = UnaryCallable.create(settings.listInfoTypesSettings(), (ClientContext)clientContext);
        this.listRootCategoriesCallable = UnaryCallable.create(settings.listRootCategoriesSettings(), (ClientContext)clientContext);
        if (settings.getChannelProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    DlpServiceClient.this.channel.shutdown();
                }
            });
        }
        if (settings.getExecutorProvider().shouldAutoClose()) {
            this.closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    DlpServiceClient.this.executor.shutdown();
                }
            });
        }
    }

    public final DlpServiceSettings getSettings() {
        return this.settings;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final InspectContentResponse inspectContent(InspectConfig inspectConfig, List<ContentItem> items) {
        InspectContentRequest request = InspectContentRequest.newBuilder().setInspectConfig(inspectConfig).addAllItems(items).build();
        return this.inspectContent(request);
    }

    public final InspectContentResponse inspectContent(InspectContentRequest request) {
        return (InspectContentResponse)this.inspectContentCallable().call((Object)request);
    }

    public final UnaryCallable<InspectContentRequest, InspectContentResponse> inspectContentCallable() {
        return this.inspectContentCallable;
    }

    public final RedactContentResponse redactContent(InspectConfig inspectConfig, List<ContentItem> items, List<RedactContentRequest.ReplaceConfig> replaceConfigs) {
        RedactContentRequest request = RedactContentRequest.newBuilder().setInspectConfig(inspectConfig).addAllItems(items).addAllReplaceConfigs(replaceConfigs).build();
        return this.redactContent(request);
    }

    public final RedactContentResponse redactContent(RedactContentRequest request) {
        return (RedactContentResponse)this.redactContentCallable().call((Object)request);
    }

    public final UnaryCallable<RedactContentRequest, RedactContentResponse> redactContentCallable() {
        return this.redactContentCallable;
    }

    public final OperationFuture<InspectOperationResult, InspectOperationMetadata> createInspectOperationAsync(InspectConfig inspectConfig, StorageConfig storageConfig, OutputStorageConfig outputConfig) {
        CreateInspectOperationRequest request = CreateInspectOperationRequest.newBuilder().setInspectConfig(inspectConfig).setStorageConfig(storageConfig).setOutputConfig(outputConfig).build();
        return this.createInspectOperationAsync(request);
    }

    public final OperationFuture<InspectOperationResult, InspectOperationMetadata> createInspectOperationAsync(CreateInspectOperationRequest request) {
        return this.createInspectOperationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInspectOperationRequest, InspectOperationResult, InspectOperationMetadata> createInspectOperationOperationCallable() {
        return this.createInspectOperationOperationCallable;
    }

    public final UnaryCallable<CreateInspectOperationRequest, Operation> createInspectOperationCallable() {
        return this.createInspectOperationCallable;
    }

    public final ListInspectFindingsResponse listInspectFindings(ResultName name) {
        ListInspectFindingsRequest request = ListInspectFindingsRequest.newBuilder().setNameWithResultName(name).build();
        return this.listInspectFindings(request);
    }

    public final ListInspectFindingsResponse listInspectFindings(ListInspectFindingsRequest request) {
        return (ListInspectFindingsResponse)this.listInspectFindingsCallable().call((Object)request);
    }

    public final UnaryCallable<ListInspectFindingsRequest, ListInspectFindingsResponse> listInspectFindingsCallable() {
        return this.listInspectFindingsCallable;
    }

    public final ListInfoTypesResponse listInfoTypes(String category, String languageCode) {
        ListInfoTypesRequest request = ListInfoTypesRequest.newBuilder().setCategory(category).setLanguageCode(languageCode).build();
        return this.listInfoTypes(request);
    }

    public final ListInfoTypesResponse listInfoTypes(ListInfoTypesRequest request) {
        return (ListInfoTypesResponse)this.listInfoTypesCallable().call((Object)request);
    }

    public final UnaryCallable<ListInfoTypesRequest, ListInfoTypesResponse> listInfoTypesCallable() {
        return this.listInfoTypesCallable;
    }

    public final ListRootCategoriesResponse listRootCategories(String languageCode) {
        ListRootCategoriesRequest request = ListRootCategoriesRequest.newBuilder().setLanguageCode(languageCode).build();
        return this.listRootCategories(request);
    }

    private final ListRootCategoriesResponse listRootCategories(ListRootCategoriesRequest request) {
        return (ListRootCategoriesResponse)this.listRootCategoriesCallable().call((Object)request);
    }

    public final UnaryCallable<ListRootCategoriesRequest, ListRootCategoriesResponse> listRootCategoriesCallable() {
        return this.listRootCategoriesCallable;
    }

    @Override
    public final void close() throws Exception {
        for (AutoCloseable closeable : this.closeables) {
            closeable.close();
        }
    }
}

