/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1alpha.CreateSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.DeleteSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.GetSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.ListFilesRequest;
import com.google.cloud.discoveryengine.v1alpha.ListFilesResponse;
import com.google.cloud.discoveryengine.v1alpha.ListSessionsRequest;
import com.google.cloud.discoveryengine.v1alpha.ListSessionsResponse;
import com.google.cloud.discoveryengine.v1alpha.Session;
import com.google.cloud.discoveryengine.v1alpha.SessionServiceClient;
import com.google.cloud.discoveryengine.v1alpha.UpdateSessionRequest;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcSessionServiceCallableFactory;
import com.google.cloud.discoveryengine.v1alpha.stub.SessionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.SessionServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcSessionServiceStub
extends SessionServiceStub {
    private static final MethodDescriptor<CreateSessionRequest, Session> createSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/CreateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteSessionRequest, Empty> deleteSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/DeleteSession").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateSessionRequest, Session> updateSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/UpdateSession").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetSessionRequest, Session> getSessionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/GetSession").setRequestMarshaller(ProtoUtils.marshaller((Message)GetSessionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Session.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListSessionsRequest, ListSessionsResponse> listSessionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/ListSessions").setRequestMarshaller(ProtoUtils.marshaller((Message)ListSessionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListSessionsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListFilesRequest, ListFilesResponse> listFilesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1alpha.SessionService/ListFiles").setRequestMarshaller(ProtoUtils.marshaller((Message)ListFilesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListFilesResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateSessionRequest, Session> createSessionCallable;
    private final UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable;
    private final UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable;
    private final UnaryCallable<GetSessionRequest, Session> getSessionCallable;
    private final UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable;
    private final UnaryCallable<ListSessionsRequest, SessionServiceClient.ListSessionsPagedResponse> listSessionsPagedCallable;
    private final UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable;
    private final UnaryCallable<ListFilesRequest, SessionServiceClient.ListFilesPagedResponse> listFilesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcSessionServiceStub create(SessionServiceStubSettings settings) throws IOException {
        return new GrpcSessionServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcSessionServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcSessionServiceStub(SessionServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcSessionServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcSessionServiceStub(SessionServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcSessionServiceStub(SessionServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcSessionServiceCallableFactory());
    }

    protected GrpcSessionServiceStub(SessionServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("session.name", String.valueOf(request.getSession().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getSessionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getSessionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listSessionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listSessionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listFilesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listFilesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.createSessionCallable = callableFactory.createUnaryCallable(createSessionTransportSettings, settings.createSessionSettings(), clientContext);
        this.deleteSessionCallable = callableFactory.createUnaryCallable(deleteSessionTransportSettings, settings.deleteSessionSettings(), clientContext);
        this.updateSessionCallable = callableFactory.createUnaryCallable(updateSessionTransportSettings, settings.updateSessionSettings(), clientContext);
        this.getSessionCallable = callableFactory.createUnaryCallable(getSessionTransportSettings, settings.getSessionSettings(), clientContext);
        this.listSessionsCallable = callableFactory.createUnaryCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listSessionsPagedCallable = callableFactory.createPagedCallable(listSessionsTransportSettings, settings.listSessionsSettings(), clientContext);
        this.listFilesCallable = callableFactory.createUnaryCallable(listFilesTransportSettings, settings.listFilesSettings(), clientContext);
        this.listFilesPagedCallable = callableFactory.createPagedCallable(listFilesTransportSettings, settings.listFilesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateSessionRequest, Session> createSessionCallable() {
        return this.createSessionCallable;
    }

    @Override
    public UnaryCallable<DeleteSessionRequest, Empty> deleteSessionCallable() {
        return this.deleteSessionCallable;
    }

    @Override
    public UnaryCallable<UpdateSessionRequest, Session> updateSessionCallable() {
        return this.updateSessionCallable;
    }

    @Override
    public UnaryCallable<GetSessionRequest, Session> getSessionCallable() {
        return this.getSessionCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, ListSessionsResponse> listSessionsCallable() {
        return this.listSessionsCallable;
    }

    @Override
    public UnaryCallable<ListSessionsRequest, SessionServiceClient.ListSessionsPagedResponse> listSessionsPagedCallable() {
        return this.listSessionsPagedCallable;
    }

    @Override
    public UnaryCallable<ListFilesRequest, ListFilesResponse> listFilesCallable() {
        return this.listFilesCallable;
    }

    @Override
    public UnaryCallable<ListFilesRequest, SessionServiceClient.ListFilesPagedResponse> listFilesPagedCallable() {
        return this.listFilesPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

