/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateDataStoreMetadata;
import com.google.cloud.discoveryengine.v1beta.CreateDataStoreRequest;
import com.google.cloud.discoveryengine.v1beta.DataStore;
import com.google.cloud.discoveryengine.v1beta.DataStoreServiceClient;
import com.google.cloud.discoveryengine.v1beta.DeleteDataStoreMetadata;
import com.google.cloud.discoveryengine.v1beta.DeleteDataStoreRequest;
import com.google.cloud.discoveryengine.v1beta.GetDataStoreRequest;
import com.google.cloud.discoveryengine.v1beta.ListDataStoresRequest;
import com.google.cloud.discoveryengine.v1beta.ListDataStoresResponse;
import com.google.cloud.discoveryengine.v1beta.UpdateDataStoreRequest;
import com.google.cloud.discoveryengine.v1beta.stub.DataStoreServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.DataStoreServiceStubSettings;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcDataStoreServiceCallableFactory;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDataStoreServiceStub
extends DataStoreServiceStub {
    private static final MethodDescriptor<CreateDataStoreRequest, Operation> createDataStoreMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DataStoreService/CreateDataStore").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDataStoreRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDataStoreRequest, DataStore> getDataStoreMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DataStoreService/GetDataStore").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDataStoreRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DataStore.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListDataStoresRequest, ListDataStoresResponse> listDataStoresMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DataStoreService/ListDataStores").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDataStoresRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDataStoresResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDataStoreRequest, Operation> deleteDataStoreMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DataStoreService/DeleteDataStore").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDataStoreRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDataStoreRequest, DataStore> updateDataStoreMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1beta.DataStoreService/UpdateDataStore").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDataStoreRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)DataStore.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<CreateDataStoreRequest, Operation> createDataStoreCallable;
    private final OperationCallable<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationCallable;
    private final UnaryCallable<GetDataStoreRequest, DataStore> getDataStoreCallable;
    private final UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> listDataStoresCallable;
    private final UnaryCallable<ListDataStoresRequest, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresPagedCallable;
    private final UnaryCallable<DeleteDataStoreRequest, Operation> deleteDataStoreCallable;
    private final OperationCallable<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationCallable;
    private final UnaryCallable<UpdateDataStoreRequest, DataStore> updateDataStoreCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDataStoreServiceStub create(DataStoreServiceStubSettings settings) throws IOException {
        return new GrpcDataStoreServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDataStoreServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcDataStoreServiceStub(DataStoreServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDataStoreServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDataStoreServiceStub(DataStoreServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDataStoreServiceStub(DataStoreServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDataStoreServiceCallableFactory());
    }

    protected GrpcDataStoreServiceStub(DataStoreServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createDataStoreTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDataStoreMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDataStoreTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDataStoreMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listDataStoresTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDataStoresMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDataStoreTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDataStoreMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDataStoreTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDataStoreMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("data_store.name", String.valueOf(request.getDataStore().getName()));
            return builder.build();
        }).build();
        this.createDataStoreCallable = callableFactory.createUnaryCallable(createDataStoreTransportSettings, settings.createDataStoreSettings(), clientContext);
        this.createDataStoreOperationCallable = callableFactory.createOperationCallable(createDataStoreTransportSettings, settings.createDataStoreOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getDataStoreCallable = callableFactory.createUnaryCallable(getDataStoreTransportSettings, settings.getDataStoreSettings(), clientContext);
        this.listDataStoresCallable = callableFactory.createUnaryCallable(listDataStoresTransportSettings, settings.listDataStoresSettings(), clientContext);
        this.listDataStoresPagedCallable = callableFactory.createPagedCallable(listDataStoresTransportSettings, settings.listDataStoresSettings(), clientContext);
        this.deleteDataStoreCallable = callableFactory.createUnaryCallable(deleteDataStoreTransportSettings, settings.deleteDataStoreSettings(), clientContext);
        this.deleteDataStoreOperationCallable = callableFactory.createOperationCallable(deleteDataStoreTransportSettings, settings.deleteDataStoreOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateDataStoreCallable = callableFactory.createUnaryCallable(updateDataStoreTransportSettings, settings.updateDataStoreSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateDataStoreRequest, Operation> createDataStoreCallable() {
        return this.createDataStoreCallable;
    }

    @Override
    public OperationCallable<CreateDataStoreRequest, DataStore, CreateDataStoreMetadata> createDataStoreOperationCallable() {
        return this.createDataStoreOperationCallable;
    }

    @Override
    public UnaryCallable<GetDataStoreRequest, DataStore> getDataStoreCallable() {
        return this.getDataStoreCallable;
    }

    @Override
    public UnaryCallable<ListDataStoresRequest, ListDataStoresResponse> listDataStoresCallable() {
        return this.listDataStoresCallable;
    }

    @Override
    public UnaryCallable<ListDataStoresRequest, DataStoreServiceClient.ListDataStoresPagedResponse> listDataStoresPagedCallable() {
        return this.listDataStoresPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteDataStoreRequest, Operation> deleteDataStoreCallable() {
        return this.deleteDataStoreCallable;
    }

    @Override
    public OperationCallable<DeleteDataStoreRequest, Empty, DeleteDataStoreMetadata> deleteDataStoreOperationCallable() {
        return this.deleteDataStoreOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDataStoreRequest, DataStore> updateDataStoreCallable() {
        return this.updateDataStoreCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

