/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1alpha.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryRequest;
import com.google.cloud.discoveryengine.v1alpha.CompleteQueryResponse;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsMetadata;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportCompletionSuggestionsResponse;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1alpha.ImportSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsMetadata;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsRequest;
import com.google.cloud.discoveryengine.v1alpha.PurgeCompletionSuggestionsResponse;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesMetadata;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesRequest;
import com.google.cloud.discoveryengine.v1alpha.PurgeSuggestionDenyListEntriesResponse;
import com.google.cloud.discoveryengine.v1alpha.stub.CompletionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.GrpcCompletionServiceStub;
import com.google.cloud.discoveryengine.v1alpha.stub.HttpJsonCompletionServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class CompletionServiceStubSettings
extends StubSettings<CompletionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CompleteQueryRequest, CompleteQueryResponse> completeQuerySettings;
    private final UnaryCallSettings<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesSettings;
    private final OperationCallSettings<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationSettings;
    private final UnaryCallSettings<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesSettings;
    private final OperationCallSettings<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationSettings;
    private final UnaryCallSettings<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsSettings;
    private final OperationCallSettings<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationSettings;
    private final UnaryCallSettings<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsSettings;
    private final OperationCallSettings<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationSettings;

    public UnaryCallSettings<CompleteQueryRequest, CompleteQueryResponse> completeQuerySettings() {
        return this.completeQuerySettings;
    }

    public UnaryCallSettings<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesSettings() {
        return this.importSuggestionDenyListEntriesSettings;
    }

    public OperationCallSettings<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationSettings() {
        return this.importSuggestionDenyListEntriesOperationSettings;
    }

    public UnaryCallSettings<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesSettings() {
        return this.purgeSuggestionDenyListEntriesSettings;
    }

    public OperationCallSettings<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationSettings() {
        return this.purgeSuggestionDenyListEntriesOperationSettings;
    }

    public UnaryCallSettings<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsSettings() {
        return this.importCompletionSuggestionsSettings;
    }

    public OperationCallSettings<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationSettings() {
        return this.importCompletionSuggestionsOperationSettings;
    }

    public UnaryCallSettings<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsSettings() {
        return this.purgeCompletionSuggestionsSettings;
    }

    public OperationCallSettings<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationSettings() {
        return this.purgeCompletionSuggestionsOperationSettings;
    }

    public CompletionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCompletionServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCompletionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CompletionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CompletionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CompletionServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CompletionServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CompletionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.completeQuerySettings = settingsBuilder.completeQuerySettings().build();
        this.importSuggestionDenyListEntriesSettings = settingsBuilder.importSuggestionDenyListEntriesSettings().build();
        this.importSuggestionDenyListEntriesOperationSettings = settingsBuilder.importSuggestionDenyListEntriesOperationSettings().build();
        this.purgeSuggestionDenyListEntriesSettings = settingsBuilder.purgeSuggestionDenyListEntriesSettings().build();
        this.purgeSuggestionDenyListEntriesOperationSettings = settingsBuilder.purgeSuggestionDenyListEntriesOperationSettings().build();
        this.importCompletionSuggestionsSettings = settingsBuilder.importCompletionSuggestionsSettings().build();
        this.importCompletionSuggestionsOperationSettings = settingsBuilder.importCompletionSuggestionsOperationSettings().build();
        this.purgeCompletionSuggestionsSettings = settingsBuilder.purgeCompletionSuggestionsSettings().build();
        this.purgeCompletionSuggestionsOperationSettings = settingsBuilder.purgeCompletionSuggestionsOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CompletionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CompleteQueryRequest, CompleteQueryResponse> completeQuerySettings;
        private final UnaryCallSettings.Builder<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesSettings;
        private final OperationCallSettings.Builder<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationSettings;
        private final UnaryCallSettings.Builder<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesSettings;
        private final OperationCallSettings.Builder<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationSettings;
        private final UnaryCallSettings.Builder<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsSettings;
        private final OperationCallSettings.Builder<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationSettings;
        private final UnaryCallSettings.Builder<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsSettings;
        private final OperationCallSettings.Builder<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.completeQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importSuggestionDenyListEntriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importSuggestionDenyListEntriesOperationSettings = OperationCallSettings.newBuilder();
            this.purgeSuggestionDenyListEntriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeSuggestionDenyListEntriesOperationSettings = OperationCallSettings.newBuilder();
            this.importCompletionSuggestionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importCompletionSuggestionsOperationSettings = OperationCallSettings.newBuilder();
            this.purgeCompletionSuggestionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.purgeCompletionSuggestionsOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.completeQuerySettings, this.importSuggestionDenyListEntriesSettings, this.purgeSuggestionDenyListEntriesSettings, this.importCompletionSuggestionsSettings, this.purgeCompletionSuggestionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CompletionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.completeQuerySettings = settings.completeQuerySettings.toBuilder();
            this.importSuggestionDenyListEntriesSettings = settings.importSuggestionDenyListEntriesSettings.toBuilder();
            this.importSuggestionDenyListEntriesOperationSettings = settings.importSuggestionDenyListEntriesOperationSettings.toBuilder();
            this.purgeSuggestionDenyListEntriesSettings = settings.purgeSuggestionDenyListEntriesSettings.toBuilder();
            this.purgeSuggestionDenyListEntriesOperationSettings = settings.purgeSuggestionDenyListEntriesOperationSettings.toBuilder();
            this.importCompletionSuggestionsSettings = settings.importCompletionSuggestionsSettings.toBuilder();
            this.importCompletionSuggestionsOperationSettings = settings.importCompletionSuggestionsOperationSettings.toBuilder();
            this.purgeCompletionSuggestionsSettings = settings.purgeCompletionSuggestionsSettings.toBuilder();
            this.purgeCompletionSuggestionsOperationSettings = settings.purgeCompletionSuggestionsOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.completeQuerySettings, this.importSuggestionDenyListEntriesSettings, this.purgeSuggestionDenyListEntriesSettings, this.importCompletionSuggestionsSettings, this.purgeCompletionSuggestionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CompletionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CompletionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CompletionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CompletionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CompletionServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CompletionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CompletionServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CompletionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.completeQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importSuggestionDenyListEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.purgeSuggestionDenyListEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importCompletionSuggestionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.purgeCompletionSuggestionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importSuggestionDenyListEntriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportSuggestionDenyListEntriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportSuggestionDenyListEntriesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.purgeSuggestionDenyListEntriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PurgeSuggestionDenyListEntriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PurgeSuggestionDenyListEntriesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.importCompletionSuggestionsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportCompletionSuggestionsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportCompletionSuggestionsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.purgeCompletionSuggestionsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(PurgeCompletionSuggestionsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PurgeCompletionSuggestionsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CompleteQueryRequest, CompleteQueryResponse> completeQuerySettings() {
            return this.completeQuerySettings;
        }

        public UnaryCallSettings.Builder<ImportSuggestionDenyListEntriesRequest, Operation> importSuggestionDenyListEntriesSettings() {
            return this.importSuggestionDenyListEntriesSettings;
        }

        public OperationCallSettings.Builder<ImportSuggestionDenyListEntriesRequest, ImportSuggestionDenyListEntriesResponse, ImportSuggestionDenyListEntriesMetadata> importSuggestionDenyListEntriesOperationSettings() {
            return this.importSuggestionDenyListEntriesOperationSettings;
        }

        public UnaryCallSettings.Builder<PurgeSuggestionDenyListEntriesRequest, Operation> purgeSuggestionDenyListEntriesSettings() {
            return this.purgeSuggestionDenyListEntriesSettings;
        }

        public OperationCallSettings.Builder<PurgeSuggestionDenyListEntriesRequest, PurgeSuggestionDenyListEntriesResponse, PurgeSuggestionDenyListEntriesMetadata> purgeSuggestionDenyListEntriesOperationSettings() {
            return this.purgeSuggestionDenyListEntriesOperationSettings;
        }

        public UnaryCallSettings.Builder<ImportCompletionSuggestionsRequest, Operation> importCompletionSuggestionsSettings() {
            return this.importCompletionSuggestionsSettings;
        }

        public OperationCallSettings.Builder<ImportCompletionSuggestionsRequest, ImportCompletionSuggestionsResponse, ImportCompletionSuggestionsMetadata> importCompletionSuggestionsOperationSettings() {
            return this.importCompletionSuggestionsOperationSettings;
        }

        public UnaryCallSettings.Builder<PurgeCompletionSuggestionsRequest, Operation> purgeCompletionSuggestionsSettings() {
            return this.purgeCompletionSuggestionsSettings;
        }

        public OperationCallSettings.Builder<PurgeCompletionSuggestionsRequest, PurgeCompletionSuggestionsResponse, PurgeCompletionSuggestionsMetadata> purgeCompletionSuggestionsOperationSettings() {
            return this.purgeCompletionSuggestionsOperationSettings;
        }

        public CompletionServiceStubSettings build() throws IOException {
            return new CompletionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(5000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(5000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(5000L)).setTotalTimeoutDuration(Duration.ofMillis(5000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

