/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1beta.CreateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.DeleteSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.GetSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesMetadata;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1beta.ImportSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1beta.ListSampleQueriesRequest;
import com.google.cloud.discoveryengine.v1beta.ListSampleQueriesResponse;
import com.google.cloud.discoveryengine.v1beta.SampleQuery;
import com.google.cloud.discoveryengine.v1beta.SampleQueryServiceClient;
import com.google.cloud.discoveryengine.v1beta.UpdateSampleQueryRequest;
import com.google.cloud.discoveryengine.v1beta.stub.GrpcSampleQueryServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.HttpJsonSampleQueryServiceStub;
import com.google.cloud.discoveryengine.v1beta.stub.SampleQueryServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class SampleQueryServiceStubSettings
extends StubSettings<SampleQueryServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetSampleQueryRequest, SampleQuery> getSampleQuerySettings;
    private final PagedCallSettings<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesSettings;
    private final UnaryCallSettings<CreateSampleQueryRequest, SampleQuery> createSampleQuerySettings;
    private final UnaryCallSettings<UpdateSampleQueryRequest, SampleQuery> updateSampleQuerySettings;
    private final UnaryCallSettings<DeleteSampleQueryRequest, Empty> deleteSampleQuerySettings;
    private final UnaryCallSettings<ImportSampleQueriesRequest, Operation> importSampleQueriesSettings;
    private final OperationCallSettings<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationSettings;
    private static final PagedListDescriptor<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery> LIST_SAMPLE_QUERIES_PAGE_STR_DESC = new PagedListDescriptor<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery>(){

        public String emptyToken() {
            return "";
        }

        public ListSampleQueriesRequest injectToken(ListSampleQueriesRequest payload, String token) {
            return ListSampleQueriesRequest.newBuilder((ListSampleQueriesRequest)payload).setPageToken(token).build();
        }

        public ListSampleQueriesRequest injectPageSize(ListSampleQueriesRequest payload, int pageSize) {
            return ListSampleQueriesRequest.newBuilder((ListSampleQueriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSampleQueriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSampleQueriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<SampleQuery> extractResources(ListSampleQueriesResponse payload) {
            return payload.getSampleQueriesList();
        }
    };
    private static final PagedListResponseFactory<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse> LIST_SAMPLE_QUERIES_PAGE_STR_FACT = new PagedListResponseFactory<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse>(){

        public ApiFuture<SampleQueryServiceClient.ListSampleQueriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListSampleQueriesRequest, ListSampleQueriesResponse> callable, ListSampleQueriesRequest request, ApiCallContext context, ApiFuture<ListSampleQueriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SAMPLE_QUERIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return SampleQueryServiceClient.ListSampleQueriesPagedResponse.createAsync((PageContext<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQuery>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetSampleQueryRequest, SampleQuery> getSampleQuerySettings() {
        return this.getSampleQuerySettings;
    }

    public PagedCallSettings<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesSettings() {
        return this.listSampleQueriesSettings;
    }

    public UnaryCallSettings<CreateSampleQueryRequest, SampleQuery> createSampleQuerySettings() {
        return this.createSampleQuerySettings;
    }

    public UnaryCallSettings<UpdateSampleQueryRequest, SampleQuery> updateSampleQuerySettings() {
        return this.updateSampleQuerySettings;
    }

    public UnaryCallSettings<DeleteSampleQueryRequest, Empty> deleteSampleQuerySettings() {
        return this.deleteSampleQuerySettings;
    }

    public UnaryCallSettings<ImportSampleQueriesRequest, Operation> importSampleQueriesSettings() {
        return this.importSampleQueriesSettings;
    }

    public OperationCallSettings<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationSettings() {
        return this.importSampleQueriesOperationSettings;
    }

    public SampleQueryServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcSampleQueryServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonSampleQueryServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "discoveryengine";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "discoveryengine.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "discoveryengine.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return SampleQueryServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SampleQueryServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(SampleQueryServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return SampleQueryServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected SampleQueryServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getSampleQuerySettings = settingsBuilder.getSampleQuerySettings().build();
        this.listSampleQueriesSettings = settingsBuilder.listSampleQueriesSettings().build();
        this.createSampleQuerySettings = settingsBuilder.createSampleQuerySettings().build();
        this.updateSampleQuerySettings = settingsBuilder.updateSampleQuerySettings().build();
        this.deleteSampleQuerySettings = settingsBuilder.deleteSampleQuerySettings().build();
        this.importSampleQueriesSettings = settingsBuilder.importSampleQueriesSettings().build();
        this.importSampleQueriesOperationSettings = settingsBuilder.importSampleQueriesOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<SampleQueryServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetSampleQueryRequest, SampleQuery> getSampleQuerySettings;
        private final PagedCallSettings.Builder<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesSettings;
        private final UnaryCallSettings.Builder<CreateSampleQueryRequest, SampleQuery> createSampleQuerySettings;
        private final UnaryCallSettings.Builder<UpdateSampleQueryRequest, SampleQuery> updateSampleQuerySettings;
        private final UnaryCallSettings.Builder<DeleteSampleQueryRequest, Empty> deleteSampleQuerySettings;
        private final UnaryCallSettings.Builder<ImportSampleQueriesRequest, Operation> importSampleQueriesSettings;
        private final OperationCallSettings.Builder<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getSampleQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSampleQueriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SAMPLE_QUERIES_PAGE_STR_FACT);
            this.createSampleQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateSampleQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteSampleQuerySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importSampleQueriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importSampleQueriesOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSampleQuerySettings, this.listSampleQueriesSettings, this.createSampleQuerySettings, this.updateSampleQuerySettings, this.deleteSampleQuerySettings, this.importSampleQueriesSettings);
            Builder.initDefaults(this);
        }

        protected Builder(SampleQueryServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getSampleQuerySettings = settings.getSampleQuerySettings.toBuilder();
            this.listSampleQueriesSettings = settings.listSampleQueriesSettings.toBuilder();
            this.createSampleQuerySettings = settings.createSampleQuerySettings.toBuilder();
            this.updateSampleQuerySettings = settings.updateSampleQuerySettings.toBuilder();
            this.deleteSampleQuerySettings = settings.deleteSampleQuerySettings.toBuilder();
            this.importSampleQueriesSettings = settings.importSampleQueriesSettings.toBuilder();
            this.importSampleQueriesOperationSettings = settings.importSampleQueriesOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getSampleQuerySettings, this.listSampleQueriesSettings, this.createSampleQuerySettings, this.updateSampleQuerySettings, this.deleteSampleQuerySettings, this.importSampleQueriesSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(SampleQueryServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)SampleQueryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SampleQueryServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SampleQueryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)SampleQueryServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)SampleQueryServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)SampleQueryServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(SampleQueryServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getSampleQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listSampleQueriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createSampleQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateSampleQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteSampleQuerySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.importSampleQueriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.importSampleQueriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ImportSampleQueriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ImportSampleQueriesMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetSampleQueryRequest, SampleQuery> getSampleQuerySettings() {
            return this.getSampleQuerySettings;
        }

        public PagedCallSettings.Builder<ListSampleQueriesRequest, ListSampleQueriesResponse, SampleQueryServiceClient.ListSampleQueriesPagedResponse> listSampleQueriesSettings() {
            return this.listSampleQueriesSettings;
        }

        public UnaryCallSettings.Builder<CreateSampleQueryRequest, SampleQuery> createSampleQuerySettings() {
            return this.createSampleQuerySettings;
        }

        public UnaryCallSettings.Builder<UpdateSampleQueryRequest, SampleQuery> updateSampleQuerySettings() {
            return this.updateSampleQuerySettings;
        }

        public UnaryCallSettings.Builder<DeleteSampleQueryRequest, Empty> deleteSampleQuerySettings() {
            return this.deleteSampleQuerySettings;
        }

        public UnaryCallSettings.Builder<ImportSampleQueriesRequest, Operation> importSampleQueriesSettings() {
            return this.importSampleQueriesSettings;
        }

        public OperationCallSettings.Builder<ImportSampleQueriesRequest, ImportSampleQueriesResponse, ImportSampleQueriesMetadata> importSampleQueriesOperationSettings() {
            return this.importSampleQueriesOperationSettings;
        }

        public SampleQueryServiceStubSettings build() throws IOException {
            return new SampleQueryServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)30000L)).setTotalTimeout(Duration.ofMillis((long)30000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

