/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.discoveryengine.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.discoveryengine.v1.Project;
import com.google.cloud.discoveryengine.v1.ProvisionProjectMetadata;
import com.google.cloud.discoveryengine.v1.ProvisionProjectRequest;
import com.google.cloud.discoveryengine.v1.stub.GrpcProjectServiceCallableFactory;
import com.google.cloud.discoveryengine.v1.stub.ProjectServiceStub;
import com.google.cloud.discoveryengine.v1.stub.ProjectServiceStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcProjectServiceStub
extends ProjectServiceStub {
    private static final MethodDescriptor<ProvisionProjectRequest, Operation> provisionProjectMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.discoveryengine.v1.ProjectService/ProvisionProject").setRequestMarshaller(ProtoUtils.marshaller((Message)ProvisionProjectRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable;
    private final OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcProjectServiceStub create(ProjectServiceStubSettings settings) throws IOException {
        return new GrpcProjectServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcProjectServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcProjectServiceStub(ProjectServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcProjectServiceCallableFactory());
    }

    protected GrpcProjectServiceStub(ProjectServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings provisionProjectTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(provisionProjectMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.provisionProjectCallable = callableFactory.createUnaryCallable(provisionProjectTransportSettings, settings.provisionProjectSettings(), clientContext);
        this.provisionProjectOperationCallable = callableFactory.createOperationCallable(provisionProjectTransportSettings, settings.provisionProjectOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ProvisionProjectRequest, Operation> provisionProjectCallable() {
        return this.provisionProjectCallable;
    }

    @Override
    public OperationCallable<ProvisionProjectRequest, Project, ProvisionProjectMetadata> provisionProjectOperationCallable() {
        return this.provisionProjectOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

