/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.AnswerRecord;
import com.google.cloud.dialogflow.v2.AnswerRecordsClient;
import com.google.cloud.dialogflow.v2.ListAnswerRecordsRequest;
import com.google.cloud.dialogflow.v2.ListAnswerRecordsResponse;
import com.google.cloud.dialogflow.v2.UpdateAnswerRecordRequest;
import com.google.cloud.dialogflow.v2.stub.AnswerRecordsStub;
import com.google.cloud.dialogflow.v2.stub.AnswerRecordsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcAnswerRecordsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcAnswerRecordsStub
extends AnswerRecordsStub {
    private static final MethodDescriptor<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.AnswerRecords/ListAnswerRecords").setRequestMarshaller(ProtoUtils.marshaller((Message)ListAnswerRecordsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListAnswerRecordsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.AnswerRecords/UpdateAnswerRecord").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateAnswerRecordRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AnswerRecord.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsCallable;
    private final UnaryCallable<ListAnswerRecordsRequest, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsPagedCallable;
    private final UnaryCallable<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcAnswerRecordsStub create(AnswerRecordsStubSettings settings) throws IOException {
        return new GrpcAnswerRecordsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcAnswerRecordsStub create(ClientContext clientContext) throws IOException {
        return new GrpcAnswerRecordsStub(AnswerRecordsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcAnswerRecordsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcAnswerRecordsStub(AnswerRecordsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcAnswerRecordsStub(AnswerRecordsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcAnswerRecordsCallableFactory());
    }

    protected GrpcAnswerRecordsStub(AnswerRecordsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listAnswerRecordsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listAnswerRecordsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateAnswerRecordTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateAnswerRecordMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("answer_record.name", String.valueOf(request.getAnswerRecord().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listAnswerRecordsCallable = callableFactory.createUnaryCallable(listAnswerRecordsTransportSettings, settings.listAnswerRecordsSettings(), clientContext);
        this.listAnswerRecordsPagedCallable = callableFactory.createPagedCallable(listAnswerRecordsTransportSettings, settings.listAnswerRecordsSettings(), clientContext);
        this.updateAnswerRecordCallable = callableFactory.createUnaryCallable(updateAnswerRecordTransportSettings, settings.updateAnswerRecordSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListAnswerRecordsRequest, ListAnswerRecordsResponse> listAnswerRecordsCallable() {
        return this.listAnswerRecordsCallable;
    }

    @Override
    public UnaryCallable<ListAnswerRecordsRequest, AnswerRecordsClient.ListAnswerRecordsPagedResponse> listAnswerRecordsPagedCallable() {
        return this.listAnswerRecordsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateAnswerRecordRequest, AnswerRecord> updateAnswerRecordCallable() {
        return this.updateAnswerRecordCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, AnswerRecordsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

