/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.DeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersRequest;
import com.google.cloud.dialogflow.v2beta1.ListPhoneNumbersResponse;
import com.google.cloud.dialogflow.v2beta1.PhoneNumber;
import com.google.cloud.dialogflow.v2beta1.PhoneNumbersClient;
import com.google.cloud.dialogflow.v2beta1.UndeletePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.UpdatePhoneNumberRequest;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcPhoneNumbersCallableFactory;
import com.google.cloud.dialogflow.v2beta1.stub.PhoneNumbersStub;
import com.google.cloud.dialogflow.v2beta1.stub.PhoneNumbersStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcPhoneNumbersStub
extends PhoneNumbersStub {
    private static final MethodDescriptor<ListPhoneNumbersRequest, ListPhoneNumbersResponse> listPhoneNumbersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.PhoneNumbers/ListPhoneNumbers").setRequestMarshaller(ProtoUtils.marshaller((Message)ListPhoneNumbersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListPhoneNumbersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.PhoneNumbers/UpdatePhoneNumber").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdatePhoneNumberRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhoneNumber.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.PhoneNumbers/DeletePhoneNumber").setRequestMarshaller(ProtoUtils.marshaller((Message)DeletePhoneNumberRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhoneNumber.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.PhoneNumbers/UndeletePhoneNumber").setRequestMarshaller(ProtoUtils.marshaller((Message)UndeletePhoneNumberRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)PhoneNumber.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListPhoneNumbersRequest, ListPhoneNumbersResponse> listPhoneNumbersCallable;
    private final UnaryCallable<ListPhoneNumbersRequest, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersPagedCallable;
    private final UnaryCallable<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberCallable;
    private final UnaryCallable<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberCallable;
    private final UnaryCallable<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcPhoneNumbersStub create(PhoneNumbersStubSettings settings) throws IOException {
        return new GrpcPhoneNumbersStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcPhoneNumbersStub create(ClientContext clientContext) throws IOException {
        return new GrpcPhoneNumbersStub(PhoneNumbersStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcPhoneNumbersStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcPhoneNumbersStub(PhoneNumbersStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcPhoneNumbersStub(PhoneNumbersStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcPhoneNumbersCallableFactory());
    }

    protected GrpcPhoneNumbersStub(PhoneNumbersStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listPhoneNumbersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listPhoneNumbersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updatePhoneNumberTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updatePhoneNumberMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("phone_number.name", String.valueOf(request.getPhoneNumber().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deletePhoneNumberTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deletePhoneNumberMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings undeletePhoneNumberTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(undeletePhoneNumberMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listPhoneNumbersCallable = callableFactory.createUnaryCallable(listPhoneNumbersTransportSettings, settings.listPhoneNumbersSettings(), clientContext);
        this.listPhoneNumbersPagedCallable = callableFactory.createPagedCallable(listPhoneNumbersTransportSettings, settings.listPhoneNumbersSettings(), clientContext);
        this.updatePhoneNumberCallable = callableFactory.createUnaryCallable(updatePhoneNumberTransportSettings, settings.updatePhoneNumberSettings(), clientContext);
        this.deletePhoneNumberCallable = callableFactory.createUnaryCallable(deletePhoneNumberTransportSettings, settings.deletePhoneNumberSettings(), clientContext);
        this.undeletePhoneNumberCallable = callableFactory.createUnaryCallable(undeletePhoneNumberTransportSettings, settings.undeletePhoneNumberSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListPhoneNumbersRequest, ListPhoneNumbersResponse> listPhoneNumbersCallable() {
        return this.listPhoneNumbersCallable;
    }

    @Override
    public UnaryCallable<ListPhoneNumbersRequest, PhoneNumbersClient.ListPhoneNumbersPagedResponse> listPhoneNumbersPagedCallable() {
        return this.listPhoneNumbersPagedCallable;
    }

    @Override
    public UnaryCallable<UpdatePhoneNumberRequest, PhoneNumber> updatePhoneNumberCallable() {
        return this.updatePhoneNumberCallable;
    }

    @Override
    public UnaryCallable<DeletePhoneNumberRequest, PhoneNumber> deletePhoneNumberCallable() {
        return this.deletePhoneNumberCallable;
    }

    @Override
    public UnaryCallable<UndeletePhoneNumberRequest, PhoneNumber> undeletePhoneNumberCallable() {
        return this.undeletePhoneNumberCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, PhoneNumbersClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

