/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateToolRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteToolRequest;
import com.google.cloud.dialogflow.v2beta1.GetToolRequest;
import com.google.cloud.dialogflow.v2beta1.ListToolsRequest;
import com.google.cloud.dialogflow.v2beta1.ListToolsResponse;
import com.google.cloud.dialogflow.v2beta1.LocationName;
import com.google.cloud.dialogflow.v2beta1.Tool;
import com.google.cloud.dialogflow.v2beta1.ToolName;
import com.google.cloud.dialogflow.v2beta1.ToolsSettings;
import com.google.cloud.dialogflow.v2beta1.UpdateToolRequest;
import com.google.cloud.dialogflow.v2beta1.stub.ToolsStub;
import com.google.cloud.dialogflow.v2beta1.stub.ToolsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ToolsClient
implements BackgroundResource {
    private final ToolsSettings settings;
    private final ToolsStub stub;

    public static final ToolsClient create() throws IOException {
        return ToolsClient.create(ToolsSettings.newBuilder().build());
    }

    public static final ToolsClient create(ToolsSettings settings) throws IOException {
        return new ToolsClient(settings);
    }

    public static final ToolsClient create(ToolsStub stub) {
        return new ToolsClient(stub);
    }

    protected ToolsClient(ToolsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ToolsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ToolsClient(ToolsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ToolsSettings getSettings() {
        return this.settings;
    }

    public ToolsStub getStub() {
        return this.stub;
    }

    public final Tool createTool(LocationName parent, Tool tool, String toolId) {
        CreateToolRequest request = CreateToolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTool(tool).setToolId(toolId).build();
        return this.createTool(request);
    }

    public final Tool createTool(String parent, Tool tool, String toolId) {
        CreateToolRequest request = CreateToolRequest.newBuilder().setParent(parent).setTool(tool).setToolId(toolId).build();
        return this.createTool(request);
    }

    public final Tool createTool(CreateToolRequest request) {
        return (Tool)this.createToolCallable().call((Object)request);
    }

    public final UnaryCallable<CreateToolRequest, Tool> createToolCallable() {
        return this.stub.createToolCallable();
    }

    public final Tool getTool(ToolName name) {
        GetToolRequest request = GetToolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTool(request);
    }

    public final Tool getTool(String name) {
        GetToolRequest request = GetToolRequest.newBuilder().setName(name).build();
        return this.getTool(request);
    }

    public final Tool getTool(GetToolRequest request) {
        return (Tool)this.getToolCallable().call((Object)request);
    }

    public final UnaryCallable<GetToolRequest, Tool> getToolCallable() {
        return this.stub.getToolCallable();
    }

    public final ListToolsPagedResponse listTools(LocationName parent) {
        ListToolsRequest request = ListToolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTools(request);
    }

    public final ListToolsPagedResponse listTools(String parent) {
        ListToolsRequest request = ListToolsRequest.newBuilder().setParent(parent).build();
        return this.listTools(request);
    }

    public final ListToolsPagedResponse listTools(ListToolsRequest request) {
        return (ListToolsPagedResponse)((Object)this.listToolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListToolsRequest, ListToolsPagedResponse> listToolsPagedCallable() {
        return this.stub.listToolsPagedCallable();
    }

    public final UnaryCallable<ListToolsRequest, ListToolsResponse> listToolsCallable() {
        return this.stub.listToolsCallable();
    }

    public final void deleteTool(ToolName name) {
        DeleteToolRequest request = DeleteToolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteTool(request);
    }

    public final void deleteTool(String name) {
        DeleteToolRequest request = DeleteToolRequest.newBuilder().setName(name).build();
        this.deleteTool(request);
    }

    public final void deleteTool(DeleteToolRequest request) {
        this.deleteToolCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteToolRequest, Empty> deleteToolCallable() {
        return this.stub.deleteToolCallable();
    }

    public final Tool updateTool(Tool tool, FieldMask updateMask) {
        UpdateToolRequest request = UpdateToolRequest.newBuilder().setTool(tool).setUpdateMask(updateMask).build();
        return this.updateTool(request);
    }

    public final Tool updateTool(UpdateToolRequest request) {
        return (Tool)this.updateToolCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateToolRequest, Tool> updateToolCallable() {
        return this.stub.updateToolCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListToolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListToolsRequest, ListToolsResponse, Tool, ListToolsPage, ListToolsFixedSizeCollection> {
        private ListToolsFixedSizeCollection(List<ListToolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListToolsFixedSizeCollection createEmptyCollection() {
            return new ListToolsFixedSizeCollection(null, 0);
        }

        protected ListToolsFixedSizeCollection createCollection(List<ListToolsPage> pages, int collectionSize) {
            return new ListToolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListToolsPage
    extends AbstractPage<ListToolsRequest, ListToolsResponse, Tool, ListToolsPage> {
        private ListToolsPage(PageContext<ListToolsRequest, ListToolsResponse, Tool> context, ListToolsResponse response) {
            super(context, (Object)response);
        }

        private static ListToolsPage createEmptyPage() {
            return new ListToolsPage(null, null);
        }

        protected ListToolsPage createPage(PageContext<ListToolsRequest, ListToolsResponse, Tool> context, ListToolsResponse response) {
            return new ListToolsPage(context, response);
        }

        public ApiFuture<ListToolsPage> createPageAsync(PageContext<ListToolsRequest, ListToolsResponse, Tool> context, ApiFuture<ListToolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListToolsPagedResponse
    extends AbstractPagedListResponse<ListToolsRequest, ListToolsResponse, Tool, ListToolsPage, ListToolsFixedSizeCollection> {
        public static ApiFuture<ListToolsPagedResponse> createAsync(PageContext<ListToolsRequest, ListToolsResponse, Tool> context, ApiFuture<ListToolsResponse> futureResponse) {
            ApiFuture<ListToolsPage> futurePage = ListToolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListToolsPagedResponse((ListToolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListToolsPagedResponse(ListToolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListToolsFixedSizeCollection.createEmptyCollection());
        }
    }
}

