/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.Document;
import com.google.cloud.dialogflow.v2beta1.DocumentsClient;
import com.google.cloud.dialogflow.v2beta1.GetDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.ImportDocumentsRequest;
import com.google.cloud.dialogflow.v2beta1.ImportDocumentsResponse;
import com.google.cloud.dialogflow.v2beta1.KnowledgeOperationMetadata;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsRequest;
import com.google.cloud.dialogflow.v2beta1.ListDocumentsResponse;
import com.google.cloud.dialogflow.v2beta1.ReloadDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.UpdateDocumentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.DocumentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.DocumentsStubSettings;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcDocumentsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcDocumentsStub
extends DocumentsStub {
    private static final MethodDescriptor<ListDocumentsRequest, ListDocumentsResponse> listDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/ListDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListDocumentsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetDocumentRequest, Document> getDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/GetDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)GetDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Document.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<CreateDocumentRequest, Operation> createDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/CreateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ImportDocumentsRequest, Operation> importDocumentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/ImportDocuments").setRequestMarshaller(ProtoUtils.marshaller((Message)ImportDocumentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<DeleteDocumentRequest, Operation> deleteDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/DeleteDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateDocumentRequest, Operation> updateDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/UpdateDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ReloadDocumentRequest, Operation> reloadDocumentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2beta1.Documents/ReloadDocument").setRequestMarshaller(ProtoUtils.marshaller((Message)ReloadDocumentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable;
    private final UnaryCallable<ListDocumentsRequest, DocumentsClient.ListDocumentsPagedResponse> listDocumentsPagedCallable;
    private final UnaryCallable<GetDocumentRequest, Document> getDocumentCallable;
    private final UnaryCallable<CreateDocumentRequest, Operation> createDocumentCallable;
    private final OperationCallable<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationCallable;
    private final UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable;
    private final OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationCallable;
    private final UnaryCallable<DeleteDocumentRequest, Operation> deleteDocumentCallable;
    private final OperationCallable<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationCallable;
    private final UnaryCallable<UpdateDocumentRequest, Operation> updateDocumentCallable;
    private final OperationCallable<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationCallable;
    private final UnaryCallable<ReloadDocumentRequest, Operation> reloadDocumentCallable;
    private final OperationCallable<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DocumentsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDocumentsStub create(DocumentsStubSettings settings) throws IOException {
        return new GrpcDocumentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDocumentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcDocumentsStub(DocumentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDocumentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDocumentsStub(DocumentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDocumentsStub(DocumentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDocumentsCallableFactory());
    }

    protected GrpcDocumentsStub(DocumentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings importDocumentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(importDocumentsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("document.name", String.valueOf(request.getDocument().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings reloadDocumentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(reloadDocumentMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listDocumentsCallable = callableFactory.createUnaryCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.listDocumentsPagedCallable = callableFactory.createPagedCallable(listDocumentsTransportSettings, settings.listDocumentsSettings(), clientContext);
        this.getDocumentCallable = callableFactory.createUnaryCallable(getDocumentTransportSettings, settings.getDocumentSettings(), clientContext);
        this.createDocumentCallable = callableFactory.createUnaryCallable(createDocumentTransportSettings, settings.createDocumentSettings(), clientContext);
        this.createDocumentOperationCallable = callableFactory.createOperationCallable(createDocumentTransportSettings, settings.createDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.importDocumentsCallable = callableFactory.createUnaryCallable(importDocumentsTransportSettings, settings.importDocumentsSettings(), clientContext);
        this.importDocumentsOperationCallable = callableFactory.createOperationCallable(importDocumentsTransportSettings, settings.importDocumentsOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteDocumentCallable = callableFactory.createUnaryCallable(deleteDocumentTransportSettings, settings.deleteDocumentSettings(), clientContext);
        this.deleteDocumentOperationCallable = callableFactory.createOperationCallable(deleteDocumentTransportSettings, settings.deleteDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateDocumentCallable = callableFactory.createUnaryCallable(updateDocumentTransportSettings, settings.updateDocumentSettings(), clientContext);
        this.updateDocumentOperationCallable = callableFactory.createOperationCallable(updateDocumentTransportSettings, settings.updateDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.reloadDocumentCallable = callableFactory.createUnaryCallable(reloadDocumentTransportSettings, settings.reloadDocumentSettings(), clientContext);
        this.reloadDocumentOperationCallable = callableFactory.createOperationCallable(reloadDocumentTransportSettings, settings.reloadDocumentOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, ListDocumentsResponse> listDocumentsCallable() {
        return this.listDocumentsCallable;
    }

    @Override
    public UnaryCallable<ListDocumentsRequest, DocumentsClient.ListDocumentsPagedResponse> listDocumentsPagedCallable() {
        return this.listDocumentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetDocumentRequest, Document> getDocumentCallable() {
        return this.getDocumentCallable;
    }

    @Override
    public UnaryCallable<CreateDocumentRequest, Operation> createDocumentCallable() {
        return this.createDocumentCallable;
    }

    @Override
    public OperationCallable<CreateDocumentRequest, Document, KnowledgeOperationMetadata> createDocumentOperationCallable() {
        return this.createDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ImportDocumentsRequest, Operation> importDocumentsCallable() {
        return this.importDocumentsCallable;
    }

    @Override
    public OperationCallable<ImportDocumentsRequest, ImportDocumentsResponse, KnowledgeOperationMetadata> importDocumentsOperationCallable() {
        return this.importDocumentsOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteDocumentRequest, Operation> deleteDocumentCallable() {
        return this.deleteDocumentCallable;
    }

    @Override
    public OperationCallable<DeleteDocumentRequest, Empty, KnowledgeOperationMetadata> deleteDocumentOperationCallable() {
        return this.deleteDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateDocumentRequest, Operation> updateDocumentCallable() {
        return this.updateDocumentCallable;
    }

    @Override
    public OperationCallable<UpdateDocumentRequest, Document, KnowledgeOperationMetadata> updateDocumentOperationCallable() {
        return this.updateDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ReloadDocumentRequest, Operation> reloadDocumentCallable() {
        return this.reloadDocumentCallable;
    }

    @Override
    public OperationCallable<ReloadDocumentRequest, Document, KnowledgeOperationMetadata> reloadDocumentOperationCallable() {
        return this.reloadDocumentOperationCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DocumentsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

