/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.Context;
import com.google.cloud.dialogflow.v2.ContextsClient;
import com.google.cloud.dialogflow.v2.CreateContextRequest;
import com.google.cloud.dialogflow.v2.DeleteAllContextsRequest;
import com.google.cloud.dialogflow.v2.DeleteContextRequest;
import com.google.cloud.dialogflow.v2.GetContextRequest;
import com.google.cloud.dialogflow.v2.ListContextsRequest;
import com.google.cloud.dialogflow.v2.ListContextsResponse;
import com.google.cloud.dialogflow.v2.UpdateContextRequest;
import com.google.cloud.dialogflow.v2.stub.ContextsStub;
import com.google.cloud.dialogflow.v2.stub.ContextsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcContextsCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcContextsStub
extends ContextsStub {
    private static final MethodDescriptor<ListContextsRequest, ListContextsResponse> listContextsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/ListContexts").setRequestMarshaller(ProtoUtils.marshaller((Message)ListContextsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListContextsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetContextRequest, Context> getContextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/GetContext").setRequestMarshaller(ProtoUtils.marshaller((Message)GetContextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Context.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateContextRequest, Context> createContextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/CreateContext").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateContextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Context.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateContextRequest, Context> updateContextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/UpdateContext").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateContextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Context.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteContextRequest, Empty> deleteContextMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/DeleteContext").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteContextRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteAllContextsRequest, Empty> deleteAllContextsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Contexts/DeleteAllContexts").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteAllContextsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable;
    private final UnaryCallable<ListContextsRequest, ContextsClient.ListContextsPagedResponse> listContextsPagedCallable;
    private final UnaryCallable<GetContextRequest, Context> getContextCallable;
    private final UnaryCallable<CreateContextRequest, Context> createContextCallable;
    private final UnaryCallable<UpdateContextRequest, Context> updateContextCallable;
    private final UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable;
    private final UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, ContextsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcContextsStub create(ContextsStubSettings settings) throws IOException {
        return new GrpcContextsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcContextsStub create(ClientContext clientContext) throws IOException {
        return new GrpcContextsStub(ContextsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcContextsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcContextsStub(ContextsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcContextsStub(ContextsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcContextsCallableFactory());
    }

    protected GrpcContextsStub(ContextsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listContextsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listContextsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getContextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getContextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createContextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createContextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateContextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateContextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("context.name", String.valueOf(request.getContext().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteContextTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteContextMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteAllContextsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteAllContextsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listContextsCallable = callableFactory.createUnaryCallable(listContextsTransportSettings, settings.listContextsSettings(), clientContext);
        this.listContextsPagedCallable = callableFactory.createPagedCallable(listContextsTransportSettings, settings.listContextsSettings(), clientContext);
        this.getContextCallable = callableFactory.createUnaryCallable(getContextTransportSettings, settings.getContextSettings(), clientContext);
        this.createContextCallable = callableFactory.createUnaryCallable(createContextTransportSettings, settings.createContextSettings(), clientContext);
        this.updateContextCallable = callableFactory.createUnaryCallable(updateContextTransportSettings, settings.updateContextSettings(), clientContext);
        this.deleteContextCallable = callableFactory.createUnaryCallable(deleteContextTransportSettings, settings.deleteContextSettings(), clientContext);
        this.deleteAllContextsCallable = callableFactory.createUnaryCallable(deleteAllContextsTransportSettings, settings.deleteAllContextsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListContextsRequest, ListContextsResponse> listContextsCallable() {
        return this.listContextsCallable;
    }

    @Override
    public UnaryCallable<ListContextsRequest, ContextsClient.ListContextsPagedResponse> listContextsPagedCallable() {
        return this.listContextsPagedCallable;
    }

    @Override
    public UnaryCallable<GetContextRequest, Context> getContextCallable() {
        return this.getContextCallable;
    }

    @Override
    public UnaryCallable<CreateContextRequest, Context> createContextCallable() {
        return this.createContextCallable;
    }

    @Override
    public UnaryCallable<UpdateContextRequest, Context> updateContextCallable() {
        return this.updateContextCallable;
    }

    @Override
    public UnaryCallable<DeleteContextRequest, Empty> deleteContextCallable() {
        return this.deleteContextCallable;
    }

    @Override
    public UnaryCallable<DeleteAllContextsRequest, Empty> deleteAllContextsCallable() {
        return this.deleteAllContextsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ContextsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

