/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2.CompleteConversationRequest;
import com.google.cloud.dialogflow.v2.Conversation;
import com.google.cloud.dialogflow.v2.ConversationsClient;
import com.google.cloud.dialogflow.v2.CreateConversationRequest;
import com.google.cloud.dialogflow.v2.GetConversationRequest;
import com.google.cloud.dialogflow.v2.ListConversationsRequest;
import com.google.cloud.dialogflow.v2.ListConversationsResponse;
import com.google.cloud.dialogflow.v2.ListMessagesRequest;
import com.google.cloud.dialogflow.v2.ListMessagesResponse;
import com.google.cloud.dialogflow.v2.stub.ConversationsStub;
import com.google.cloud.dialogflow.v2.stub.ConversationsStubSettings;
import com.google.cloud.dialogflow.v2.stub.GrpcConversationsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcConversationsStub
extends ConversationsStub {
    private static final MethodDescriptor<CreateConversationRequest, Conversation> createConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Conversations/CreateConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListConversationsRequest, ListConversationsResponse> listConversationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Conversations/ListConversations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConversationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConversationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConversationRequest, Conversation> getConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Conversations/GetConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<CompleteConversationRequest, Conversation> completeConversationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Conversations/CompleteConversation").setRequestMarshaller(ProtoUtils.marshaller((Message)CompleteConversationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Conversation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListMessagesRequest, ListMessagesResponse> listMessagesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.v2.Conversations/ListMessages").setRequestMarshaller(ProtoUtils.marshaller((Message)ListMessagesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListMessagesResponse.getDefaultInstance())).build();
    private final UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable;
    private final UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable;
    private final UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable;
    private final UnaryCallable<GetConversationRequest, Conversation> getConversationCallable;
    private final UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable;
    private final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcConversationsStub create(ConversationsStubSettings settings) throws IOException {
        return new GrpcConversationsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcConversationsStub create(ClientContext clientContext) throws IOException {
        return new GrpcConversationsStub(ConversationsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcConversationsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcConversationsStub(ConversationsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcConversationsStub(ConversationsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcConversationsCallableFactory());
    }

    protected GrpcConversationsStub(ConversationsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConversationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateConversationRequest>(){

            public Map<String, String> extract(CreateConversationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listConversationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConversationsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListConversationsRequest>(){

            public Map<String, String> extract(ListConversationsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConversationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetConversationRequest>(){

            public Map<String, String> extract(GetConversationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings completeConversationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(completeConversationMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CompleteConversationRequest>(){

            public Map<String, String> extract(CompleteConversationRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listMessagesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listMessagesMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListMessagesRequest>(){

            public Map<String, String> extract(ListMessagesRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        this.createConversationCallable = callableFactory.createUnaryCallable(createConversationTransportSettings, settings.createConversationSettings(), clientContext);
        this.listConversationsCallable = callableFactory.createUnaryCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.listConversationsPagedCallable = callableFactory.createPagedCallable(listConversationsTransportSettings, settings.listConversationsSettings(), clientContext);
        this.getConversationCallable = callableFactory.createUnaryCallable(getConversationTransportSettings, settings.getConversationSettings(), clientContext);
        this.completeConversationCallable = callableFactory.createUnaryCallable(completeConversationTransportSettings, settings.completeConversationSettings(), clientContext);
        this.listMessagesCallable = callableFactory.createUnaryCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMessagesPagedCallable = callableFactory.createPagedCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateConversationRequest, Conversation> createConversationCallable() {
        return this.createConversationCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ListConversationsResponse> listConversationsCallable() {
        return this.listConversationsCallable;
    }

    @Override
    public UnaryCallable<ListConversationsRequest, ConversationsClient.ListConversationsPagedResponse> listConversationsPagedCallable() {
        return this.listConversationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConversationRequest, Conversation> getConversationCallable() {
        return this.getConversationCallable;
    }

    @Override
    public UnaryCallable<CompleteConversationRequest, Conversation> completeConversationCallable() {
        return this.completeConversationCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.listMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ConversationsClient.ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.listMessagesPagedCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

