/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.CreateKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.DeleteKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.GetKnowledgeBaseRequest;
import com.google.cloud.dialogflow.v2beta1.KnowledgeBase;
import com.google.cloud.dialogflow.v2beta1.KnowledgeBasesClient;
import com.google.cloud.dialogflow.v2beta1.ListKnowledgeBasesRequest;
import com.google.cloud.dialogflow.v2beta1.ListKnowledgeBasesResponse;
import com.google.cloud.dialogflow.v2beta1.stub.GrpcKnowledgeBasesStub;
import com.google.cloud.dialogflow.v2beta1.stub.KnowledgeBasesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class KnowledgeBasesStubSettings
extends StubSettings<KnowledgeBasesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> listKnowledgeBasesSettings;
    private final UnaryCallSettings<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseSettings;
    private final UnaryCallSettings<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseSettings;
    private final UnaryCallSettings<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseSettings;
    private static final PagedListDescriptor<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase> LIST_KNOWLEDGE_BASES_PAGE_STR_DESC = new PagedListDescriptor<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase>(){

        public String emptyToken() {
            return "";
        }

        public ListKnowledgeBasesRequest injectToken(ListKnowledgeBasesRequest payload, String token) {
            return ListKnowledgeBasesRequest.newBuilder((ListKnowledgeBasesRequest)payload).setPageToken(token).build();
        }

        public ListKnowledgeBasesRequest injectPageSize(ListKnowledgeBasesRequest payload, int pageSize) {
            return ListKnowledgeBasesRequest.newBuilder((ListKnowledgeBasesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListKnowledgeBasesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListKnowledgeBasesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<KnowledgeBase> extractResources(ListKnowledgeBasesResponse payload) {
            return payload.getKnowledgeBasesList() != null ? payload.getKnowledgeBasesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> LIST_KNOWLEDGE_BASES_PAGE_STR_FACT = new PagedListResponseFactory<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse>(){

        public ApiFuture<KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> getFuturePagedResponse(UnaryCallable<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse> callable, ListKnowledgeBasesRequest request, ApiCallContext context, ApiFuture<ListKnowledgeBasesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_KNOWLEDGE_BASES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return KnowledgeBasesClient.ListKnowledgeBasesPagedResponse.createAsync((PageContext<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBase>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> listKnowledgeBasesSettings() {
        return this.listKnowledgeBasesSettings;
    }

    public UnaryCallSettings<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseSettings() {
        return this.getKnowledgeBaseSettings;
    }

    public UnaryCallSettings<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseSettings() {
        return this.createKnowledgeBaseSettings;
    }

    public UnaryCallSettings<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseSettings() {
        return this.deleteKnowledgeBaseSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KnowledgeBasesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcKnowledgeBasesStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return KnowledgeBasesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(KnowledgeBasesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected KnowledgeBasesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listKnowledgeBasesSettings = settingsBuilder.listKnowledgeBasesSettings().build();
        this.getKnowledgeBaseSettings = settingsBuilder.getKnowledgeBaseSettings().build();
        this.createKnowledgeBaseSettings = settingsBuilder.createKnowledgeBaseSettings().build();
        this.deleteKnowledgeBaseSettings = settingsBuilder.deleteKnowledgeBaseSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<KnowledgeBasesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> listKnowledgeBasesSettings;
        private final UnaryCallSettings.Builder<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseSettings;
        private final UnaryCallSettings.Builder<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseSettings;
        private final UnaryCallSettings.Builder<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listKnowledgeBasesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_KNOWLEDGE_BASES_PAGE_STR_FACT);
            this.getKnowledgeBaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createKnowledgeBaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteKnowledgeBaseSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listKnowledgeBasesSettings, this.getKnowledgeBaseSettings, this.createKnowledgeBaseSettings, this.deleteKnowledgeBaseSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(KnowledgeBasesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)KnowledgeBasesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)KnowledgeBasesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(KnowledgeBasesStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listKnowledgeBasesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getKnowledgeBaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.createKnowledgeBaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"non_idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteKnowledgeBaseSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(KnowledgeBasesStubSettings settings) {
            super((StubSettings)settings);
            this.listKnowledgeBasesSettings = settings.listKnowledgeBasesSettings.toBuilder();
            this.getKnowledgeBaseSettings = settings.getKnowledgeBaseSettings.toBuilder();
            this.createKnowledgeBaseSettings = settings.createKnowledgeBaseSettings.toBuilder();
            this.deleteKnowledgeBaseSettings = settings.deleteKnowledgeBaseSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listKnowledgeBasesSettings, this.getKnowledgeBaseSettings, this.createKnowledgeBaseSettings, this.deleteKnowledgeBaseSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListKnowledgeBasesRequest, ListKnowledgeBasesResponse, KnowledgeBasesClient.ListKnowledgeBasesPagedResponse> listKnowledgeBasesSettings() {
            return this.listKnowledgeBasesSettings;
        }

        public UnaryCallSettings.Builder<GetKnowledgeBaseRequest, KnowledgeBase> getKnowledgeBaseSettings() {
            return this.getKnowledgeBaseSettings;
        }

        public UnaryCallSettings.Builder<CreateKnowledgeBaseRequest, KnowledgeBase> createKnowledgeBaseSettings() {
            return this.createKnowledgeBaseSettings;
        }

        public UnaryCallSettings.Builder<DeleteKnowledgeBaseRequest, Empty> deleteKnowledgeBaseSettings() {
            return this.deleteKnowledgeBaseSettings;
        }

        public KnowledgeBasesStubSettings build() throws IOException {
            return new KnowledgeBasesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

