/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.v2beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.v2beta1.Agent;
import com.google.cloud.dialogflow.v2beta1.AgentsSettings;
import com.google.cloud.dialogflow.v2beta1.ExportAgentRequest;
import com.google.cloud.dialogflow.v2beta1.ExportAgentResponse;
import com.google.cloud.dialogflow.v2beta1.GetAgentRequest;
import com.google.cloud.dialogflow.v2beta1.ImportAgentRequest;
import com.google.cloud.dialogflow.v2beta1.PagedResponseWrappers;
import com.google.cloud.dialogflow.v2beta1.ProjectName;
import com.google.cloud.dialogflow.v2beta1.RestoreAgentRequest;
import com.google.cloud.dialogflow.v2beta1.SearchAgentsRequest;
import com.google.cloud.dialogflow.v2beta1.SearchAgentsResponse;
import com.google.cloud.dialogflow.v2beta1.TrainAgentRequest;
import com.google.cloud.dialogflow.v2beta1.stub.AgentsStub;
import com.google.cloud.dialogflow.v2beta1.stub.AgentsStubSettings;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class AgentsClient
implements BackgroundResource {
    private final AgentsSettings settings;
    private final AgentsStub stub;
    private final OperationsClient operationsClient;

    public static final AgentsClient create() throws IOException {
        return AgentsClient.create(AgentsSettings.newBuilder().build());
    }

    public static final AgentsClient create(AgentsSettings settings) throws IOException {
        return new AgentsClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final AgentsClient create(AgentsStub stub) {
        return new AgentsClient(stub);
    }

    protected AgentsClient(AgentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AgentsStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected AgentsClient(AgentsStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final AgentsSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public AgentsStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final Agent getAgent(ProjectName parent) {
        GetAgentRequest request = GetAgentRequest.newBuilder().setParent(parent.toString()).build();
        return this.getAgent(request);
    }

    private final Agent getAgent(GetAgentRequest request) {
        return (Agent)this.getAgentCallable().call((Object)request);
    }

    public final UnaryCallable<GetAgentRequest, Agent> getAgentCallable() {
        return this.stub.getAgentCallable();
    }

    public final PagedResponseWrappers.SearchAgentsPagedResponse searchAgents(ProjectName parent) {
        SearchAgentsRequest request = SearchAgentsRequest.newBuilder().setParent(parent.toString()).build();
        return this.searchAgents(request);
    }

    public final PagedResponseWrappers.SearchAgentsPagedResponse searchAgents(SearchAgentsRequest request) {
        return (PagedResponseWrappers.SearchAgentsPagedResponse)((Object)this.searchAgentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAgentsRequest, PagedResponseWrappers.SearchAgentsPagedResponse> searchAgentsPagedCallable() {
        return this.stub.searchAgentsPagedCallable();
    }

    public final UnaryCallable<SearchAgentsRequest, SearchAgentsResponse> searchAgentsCallable() {
        return this.stub.searchAgentsCallable();
    }

    public final OperationFuture<Empty, Struct> trainAgentAsync(ProjectName parent) {
        TrainAgentRequest request = TrainAgentRequest.newBuilder().setParent(parent.toString()).build();
        return this.trainAgentAsync(request);
    }

    private final OperationFuture<Empty, Struct> trainAgentAsync(TrainAgentRequest request) {
        return this.trainAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<TrainAgentRequest, Empty, Struct> trainAgentOperationCallable() {
        return this.stub.trainAgentOperationCallable();
    }

    public final UnaryCallable<TrainAgentRequest, Operation> trainAgentCallable() {
        return this.stub.trainAgentCallable();
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ProjectName parent) {
        ExportAgentRequest request = ExportAgentRequest.newBuilder().setParent(parent.toString()).build();
        return this.exportAgentAsync(request);
    }

    public final OperationFuture<ExportAgentResponse, Struct> exportAgentAsync(ExportAgentRequest request) {
        return this.exportAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportAgentRequest, ExportAgentResponse, Struct> exportAgentOperationCallable() {
        return this.stub.exportAgentOperationCallable();
    }

    public final UnaryCallable<ExportAgentRequest, Operation> exportAgentCallable() {
        return this.stub.exportAgentCallable();
    }

    public final OperationFuture<Empty, Struct> importAgentAsync(ImportAgentRequest request) {
        return this.importAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportAgentRequest, Empty, Struct> importAgentOperationCallable() {
        return this.stub.importAgentOperationCallable();
    }

    public final UnaryCallable<ImportAgentRequest, Operation> importAgentCallable() {
        return this.stub.importAgentCallable();
    }

    public final OperationFuture<Empty, Struct> restoreAgentAsync(RestoreAgentRequest request) {
        return this.restoreAgentOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RestoreAgentRequest, Empty, Struct> restoreAgentOperationCallable() {
        return this.stub.restoreAgentOperationCallable();
    }

    public final UnaryCallable<RestoreAgentRequest, Operation> restoreAgentCallable() {
        return this.stub.restoreAgentCallable();
    }

    public final void close() throws Exception {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

