/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.EntityType;
import com.google.cloud.dialogflow.cx.v3.EntityTypesClient;
import com.google.cloud.dialogflow.cx.v3.GetEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesRequest;
import com.google.cloud.dialogflow.cx.v3.ListEntityTypesResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateEntityTypeRequest;
import com.google.cloud.dialogflow.cx.v3.stub.EntityTypesStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcEntityTypesStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EntityTypesStubSettings
extends StubSettings<EntityTypesStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
    private final UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
    private final UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
    private final UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
    private final UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
    private static final PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType> LIST_ENTITY_TYPES_PAGE_STR_DESC = new PagedListDescriptor<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>(){

        public String emptyToken() {
            return "";
        }

        public ListEntityTypesRequest injectToken(ListEntityTypesRequest payload, String token) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageToken(token).build();
        }

        public ListEntityTypesRequest injectPageSize(ListEntityTypesRequest payload, int pageSize) {
            return ListEntityTypesRequest.newBuilder((ListEntityTypesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntityTypesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntityTypesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<EntityType> extractResources(ListEntityTypesResponse payload) {
            return payload.getEntityTypesList() == null ? ImmutableList.of() : payload.getEntityTypesList();
        }
    };
    private static final PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> LIST_ENTITY_TYPES_PAGE_STR_FACT = new PagedListResponseFactory<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse>(){

        public ApiFuture<EntityTypesClient.ListEntityTypesPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntityTypesRequest, ListEntityTypesResponse> callable, ListEntityTypesRequest request, ApiCallContext context, ApiFuture<ListEntityTypesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITY_TYPES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EntityTypesClient.ListEntityTypesPagedResponse.createAsync((PageContext<ListEntityTypesRequest, ListEntityTypesResponse, EntityType>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
        return this.listEntityTypesSettings;
    }

    public UnaryCallSettings<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
        return this.getEntityTypeSettings;
    }

    public UnaryCallSettings<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
        return this.createEntityTypeSettings;
    }

    public UnaryCallSettings<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
        return this.updateEntityTypeSettings;
    }

    public UnaryCallSettings<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
        return this.deleteEntityTypeSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EntityTypesStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEntityTypesStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EntityTypesStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EntityTypesStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EntityTypesStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEntityTypesSettings = settingsBuilder.listEntityTypesSettings().build();
        this.getEntityTypeSettings = settingsBuilder.getEntityTypeSettings().build();
        this.createEntityTypeSettings = settingsBuilder.createEntityTypeSettings().build();
        this.updateEntityTypeSettings = settingsBuilder.updateEntityTypeSettings().build();
        this.deleteEntityTypeSettings = settingsBuilder.deleteEntityTypeSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EntityTypesStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings;
        private final UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings;
        private final UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings;
        private final UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings;
        private final UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEntityTypesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITY_TYPES_PAGE_STR_FACT);
            this.getEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteEntityTypeSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEntityTypesSettings, this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings);
            Builder.initDefaults(this);
        }

        protected Builder(EntityTypesStubSettings settings) {
            super((StubSettings)settings);
            this.listEntityTypesSettings = settings.listEntityTypesSettings.toBuilder();
            this.getEntityTypeSettings = settings.getEntityTypeSettings.toBuilder();
            this.createEntityTypeSettings = settings.createEntityTypeSettings.toBuilder();
            this.updateEntityTypeSettings = settings.updateEntityTypeSettings.toBuilder();
            this.deleteEntityTypeSettings = settings.deleteEntityTypeSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEntityTypesSettings, this.getEntityTypeSettings, this.createEntityTypeSettings, this.updateEntityTypeSettings, this.deleteEntityTypeSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EntityTypesStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EntityTypesStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EntityTypesStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(EntityTypesStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(EntityTypesStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEntityTypesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteEntityTypeSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEntityTypesRequest, ListEntityTypesResponse, EntityTypesClient.ListEntityTypesPagedResponse> listEntityTypesSettings() {
            return this.listEntityTypesSettings;
        }

        public UnaryCallSettings.Builder<GetEntityTypeRequest, EntityType> getEntityTypeSettings() {
            return this.getEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<CreateEntityTypeRequest, EntityType> createEntityTypeSettings() {
            return this.createEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<UpdateEntityTypeRequest, EntityType> updateEntityTypeSettings() {
            return this.updateEntityTypeSettings;
        }

        public UnaryCallSettings.Builder<DeleteEntityTypeRequest, Empty> deleteEntityTypeSettings() {
            return this.deleteEntityTypeSettings;
        }

        public EntityTypesStubSettings build() throws IOException {
            return new EntityTypesStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

