/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.CreateToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportToolsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GetToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolVersionsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolVersionsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListToolsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreToolVersionRequest;
import com.google.cloud.dialogflow.cx.v3beta1.RestoreToolVersionResponse;
import com.google.cloud.dialogflow.cx.v3beta1.Tool;
import com.google.cloud.dialogflow.cx.v3beta1.ToolVersion;
import com.google.cloud.dialogflow.cx.v3beta1.ToolsClient;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateToolRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcToolsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.HttpJsonToolsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ToolsStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class ToolsStubSettings
extends StubSettings<ToolsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final UnaryCallSettings<CreateToolRequest, Tool> createToolSettings;
    private final PagedCallSettings<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse> listToolsSettings;
    private final UnaryCallSettings<ExportToolsRequest, Operation> exportToolsSettings;
    private final OperationCallSettings<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationSettings;
    private final UnaryCallSettings<GetToolRequest, Tool> getToolSettings;
    private final UnaryCallSettings<UpdateToolRequest, Tool> updateToolSettings;
    private final UnaryCallSettings<DeleteToolRequest, Empty> deleteToolSettings;
    private final PagedCallSettings<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsSettings;
    private final UnaryCallSettings<CreateToolVersionRequest, ToolVersion> createToolVersionSettings;
    private final UnaryCallSettings<GetToolVersionRequest, ToolVersion> getToolVersionSettings;
    private final UnaryCallSettings<DeleteToolVersionRequest, Empty> deleteToolVersionSettings;
    private final UnaryCallSettings<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListToolsRequest, ListToolsResponse, Tool> LIST_TOOLS_PAGE_STR_DESC = new PagedListDescriptor<ListToolsRequest, ListToolsResponse, Tool>(){

        public String emptyToken() {
            return "";
        }

        public ListToolsRequest injectToken(ListToolsRequest payload, String token) {
            return ListToolsRequest.newBuilder((ListToolsRequest)payload).setPageToken(token).build();
        }

        public ListToolsRequest injectPageSize(ListToolsRequest payload, int pageSize) {
            return ListToolsRequest.newBuilder((ListToolsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListToolsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListToolsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Tool> extractResources(ListToolsResponse payload) {
            return payload.getToolsList();
        }
    };
    private static final PagedListDescriptor<ListToolVersionsRequest, ListToolVersionsResponse, ToolVersion> LIST_TOOL_VERSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListToolVersionsRequest, ListToolVersionsResponse, ToolVersion>(){

        public String emptyToken() {
            return "";
        }

        public ListToolVersionsRequest injectToken(ListToolVersionsRequest payload, String token) {
            return ListToolVersionsRequest.newBuilder((ListToolVersionsRequest)payload).setPageToken(token).build();
        }

        public ListToolVersionsRequest injectPageSize(ListToolVersionsRequest payload, int pageSize) {
            return ListToolVersionsRequest.newBuilder((ListToolVersionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListToolVersionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListToolVersionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ToolVersion> extractResources(ListToolVersionsResponse payload) {
            return payload.getToolVersionsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse> LIST_TOOLS_PAGE_STR_FACT = new PagedListResponseFactory<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse>(){

        public ApiFuture<ToolsClient.ListToolsPagedResponse> getFuturePagedResponse(UnaryCallable<ListToolsRequest, ListToolsResponse> callable, ListToolsRequest request, ApiCallContext context, ApiFuture<ListToolsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOOLS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ToolsClient.ListToolsPagedResponse.createAsync((PageContext<ListToolsRequest, ListToolsResponse, Tool>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse> LIST_TOOL_VERSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse>(){

        public ApiFuture<ToolsClient.ListToolVersionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListToolVersionsRequest, ListToolVersionsResponse> callable, ListToolVersionsRequest request, ApiCallContext context, ApiFuture<ListToolVersionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TOOL_VERSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ToolsClient.ListToolVersionsPagedResponse.createAsync((PageContext<ListToolVersionsRequest, ListToolVersionsResponse, ToolVersion>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse>(){

        public ApiFuture<ToolsClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ToolsClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateToolRequest, Tool> createToolSettings() {
        return this.createToolSettings;
    }

    public PagedCallSettings<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse> listToolsSettings() {
        return this.listToolsSettings;
    }

    public UnaryCallSettings<ExportToolsRequest, Operation> exportToolsSettings() {
        return this.exportToolsSettings;
    }

    public OperationCallSettings<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationSettings() {
        return this.exportToolsOperationSettings;
    }

    public UnaryCallSettings<GetToolRequest, Tool> getToolSettings() {
        return this.getToolSettings;
    }

    public UnaryCallSettings<UpdateToolRequest, Tool> updateToolSettings() {
        return this.updateToolSettings;
    }

    public UnaryCallSettings<DeleteToolRequest, Empty> deleteToolSettings() {
        return this.deleteToolSettings;
    }

    public PagedCallSettings<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsSettings() {
        return this.listToolVersionsSettings;
    }

    public UnaryCallSettings<CreateToolVersionRequest, ToolVersion> createToolVersionSettings() {
        return this.createToolVersionSettings;
    }

    public UnaryCallSettings<GetToolVersionRequest, ToolVersion> getToolVersionSettings() {
        return this.getToolVersionSettings;
    }

    public UnaryCallSettings<DeleteToolVersionRequest, Empty> deleteToolVersionSettings() {
        return this.deleteToolVersionSettings;
    }

    public UnaryCallSettings<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionSettings() {
        return this.restoreToolVersionSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public ToolsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcToolsStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonToolsStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "dialogflow";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "dialogflow.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ToolsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ToolsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ToolsStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ToolsStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ToolsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createToolSettings = settingsBuilder.createToolSettings().build();
        this.listToolsSettings = settingsBuilder.listToolsSettings().build();
        this.exportToolsSettings = settingsBuilder.exportToolsSettings().build();
        this.exportToolsOperationSettings = settingsBuilder.exportToolsOperationSettings().build();
        this.getToolSettings = settingsBuilder.getToolSettings().build();
        this.updateToolSettings = settingsBuilder.updateToolSettings().build();
        this.deleteToolSettings = settingsBuilder.deleteToolSettings().build();
        this.listToolVersionsSettings = settingsBuilder.listToolVersionsSettings().build();
        this.createToolVersionSettings = settingsBuilder.createToolVersionSettings().build();
        this.getToolVersionSettings = settingsBuilder.getToolVersionSettings().build();
        this.deleteToolVersionSettings = settingsBuilder.deleteToolVersionSettings().build();
        this.restoreToolVersionSettings = settingsBuilder.restoreToolVersionSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ToolsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateToolRequest, Tool> createToolSettings;
        private final PagedCallSettings.Builder<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse> listToolsSettings;
        private final UnaryCallSettings.Builder<ExportToolsRequest, Operation> exportToolsSettings;
        private final OperationCallSettings.Builder<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationSettings;
        private final UnaryCallSettings.Builder<GetToolRequest, Tool> getToolSettings;
        private final UnaryCallSettings.Builder<UpdateToolRequest, Tool> updateToolSettings;
        private final UnaryCallSettings.Builder<DeleteToolRequest, Empty> deleteToolSettings;
        private final PagedCallSettings.Builder<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsSettings;
        private final UnaryCallSettings.Builder<CreateToolVersionRequest, ToolVersion> createToolVersionSettings;
        private final UnaryCallSettings.Builder<GetToolVersionRequest, ToolVersion> getToolVersionSettings;
        private final UnaryCallSettings.Builder<DeleteToolVersionRequest, Empty> deleteToolVersionSettings;
        private final UnaryCallSettings.Builder<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createToolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listToolsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOOLS_PAGE_STR_FACT);
            this.exportToolsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportToolsOperationSettings = OperationCallSettings.newBuilder();
            this.getToolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateToolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteToolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listToolVersionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TOOL_VERSIONS_PAGE_STR_FACT);
            this.createToolVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getToolVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteToolVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.restoreToolVersionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createToolSettings, this.listToolsSettings, this.exportToolsSettings, this.getToolSettings, this.updateToolSettings, this.deleteToolSettings, this.listToolVersionsSettings, this.createToolVersionSettings, this.getToolVersionSettings, this.deleteToolVersionSettings, this.restoreToolVersionSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(ToolsStubSettings settings) {
            super((StubSettings)settings);
            this.createToolSettings = settings.createToolSettings.toBuilder();
            this.listToolsSettings = settings.listToolsSettings.toBuilder();
            this.exportToolsSettings = settings.exportToolsSettings.toBuilder();
            this.exportToolsOperationSettings = settings.exportToolsOperationSettings.toBuilder();
            this.getToolSettings = settings.getToolSettings.toBuilder();
            this.updateToolSettings = settings.updateToolSettings.toBuilder();
            this.deleteToolSettings = settings.deleteToolSettings.toBuilder();
            this.listToolVersionsSettings = settings.listToolVersionsSettings.toBuilder();
            this.createToolVersionSettings = settings.createToolVersionSettings.toBuilder();
            this.getToolVersionSettings = settings.getToolVersionSettings.toBuilder();
            this.deleteToolVersionSettings = settings.deleteToolVersionSettings.toBuilder();
            this.restoreToolVersionSettings = settings.restoreToolVersionSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createToolSettings, this.listToolsSettings, this.exportToolsSettings, this.getToolSettings, this.updateToolSettings, this.deleteToolSettings, this.listToolVersionsSettings, this.createToolVersionSettings, this.getToolVersionSettings, this.deleteToolVersionSettings, this.restoreToolVersionSettings, this.listLocationsSettings, (Object[])new UnaryCallSettings.Builder[]{this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ToolsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ToolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ToolsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ToolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ToolsStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ToolsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ToolsStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ToolsStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createToolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listToolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportToolsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getToolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateToolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteToolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listToolVersionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createToolVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getToolVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteToolVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.restoreToolVersionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportToolsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportToolsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ExportToolsMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateToolRequest, Tool> createToolSettings() {
            return this.createToolSettings;
        }

        public PagedCallSettings.Builder<ListToolsRequest, ListToolsResponse, ToolsClient.ListToolsPagedResponse> listToolsSettings() {
            return this.listToolsSettings;
        }

        public UnaryCallSettings.Builder<ExportToolsRequest, Operation> exportToolsSettings() {
            return this.exportToolsSettings;
        }

        public OperationCallSettings.Builder<ExportToolsRequest, ExportToolsResponse, ExportToolsMetadata> exportToolsOperationSettings() {
            return this.exportToolsOperationSettings;
        }

        public UnaryCallSettings.Builder<GetToolRequest, Tool> getToolSettings() {
            return this.getToolSettings;
        }

        public UnaryCallSettings.Builder<UpdateToolRequest, Tool> updateToolSettings() {
            return this.updateToolSettings;
        }

        public UnaryCallSettings.Builder<DeleteToolRequest, Empty> deleteToolSettings() {
            return this.deleteToolSettings;
        }

        public PagedCallSettings.Builder<ListToolVersionsRequest, ListToolVersionsResponse, ToolsClient.ListToolVersionsPagedResponse> listToolVersionsSettings() {
            return this.listToolVersionsSettings;
        }

        public UnaryCallSettings.Builder<CreateToolVersionRequest, ToolVersion> createToolVersionSettings() {
            return this.createToolVersionSettings;
        }

        public UnaryCallSettings.Builder<GetToolVersionRequest, ToolVersion> getToolVersionSettings() {
            return this.getToolVersionSettings;
        }

        public UnaryCallSettings.Builder<DeleteToolVersionRequest, Empty> deleteToolVersionSettings() {
            return this.deleteToolVersionSettings;
        }

        public UnaryCallSettings.Builder<RestoreToolVersionRequest, RestoreToolVersionResponse> restoreToolVersionSettings() {
            return this.restoreToolVersionSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, ToolsClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public ToolsStubSettings build() throws IOException {
            return new ToolsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

