/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CreateEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3.Environment;
import com.google.cloud.dialogflow.cx.v3.EnvironmentsClient;
import com.google.cloud.dialogflow.cx.v3.GetEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3.ListEnvironmentsRequest;
import com.google.cloud.dialogflow.cx.v3.ListEnvironmentsResponse;
import com.google.cloud.dialogflow.cx.v3.LookupEnvironmentHistoryRequest;
import com.google.cloud.dialogflow.cx.v3.LookupEnvironmentHistoryResponse;
import com.google.cloud.dialogflow.cx.v3.UpdateEnvironmentRequest;
import com.google.cloud.dialogflow.cx.v3.stub.EnvironmentsStub;
import com.google.cloud.dialogflow.cx.v3.stub.GrpcEnvironmentsStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Struct;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class EnvironmentsStubSettings
extends StubSettings<EnvironmentsStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/dialogflow").build();
    private final PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
    private final UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings;
    private final UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
    private final OperationCallSettings<CreateEnvironmentRequest, Environment, Struct> createEnvironmentOperationSettings;
    private final UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
    private final OperationCallSettings<UpdateEnvironmentRequest, Environment, Struct> updateEnvironmentOperationSettings;
    private final UnaryCallSettings<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings;
    private final PagedCallSettings<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> lookupEnvironmentHistorySettings;
    private static final PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment> LIST_ENVIRONMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public ListEnvironmentsRequest injectToken(ListEnvironmentsRequest payload, String token) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageToken(token).build();
        }

        public ListEnvironmentsRequest injectPageSize(ListEnvironmentsRequest payload, int pageSize) {
            return ListEnvironmentsRequest.newBuilder((ListEnvironmentsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEnvironmentsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEnvironmentsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(ListEnvironmentsResponse payload) {
            return payload.getEnvironmentsList() != null ? payload.getEnvironmentsList() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment> LOOKUP_ENVIRONMENT_HISTORY_PAGE_STR_DESC = new PagedListDescriptor<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment>(){

        public String emptyToken() {
            return "";
        }

        public LookupEnvironmentHistoryRequest injectToken(LookupEnvironmentHistoryRequest payload, String token) {
            return LookupEnvironmentHistoryRequest.newBuilder((LookupEnvironmentHistoryRequest)payload).setPageToken(token).build();
        }

        public LookupEnvironmentHistoryRequest injectPageSize(LookupEnvironmentHistoryRequest payload, int pageSize) {
            return LookupEnvironmentHistoryRequest.newBuilder((LookupEnvironmentHistoryRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(LookupEnvironmentHistoryRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(LookupEnvironmentHistoryResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Environment> extractResources(LookupEnvironmentHistoryResponse payload) {
            return payload.getEnvironmentsList() != null ? payload.getEnvironmentsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> LIST_ENVIRONMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse>(){

        public ApiFuture<EnvironmentsClient.ListEnvironmentsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEnvironmentsRequest, ListEnvironmentsResponse> callable, ListEnvironmentsRequest request, ApiCallContext context, ApiFuture<ListEnvironmentsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENVIRONMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.ListEnvironmentsPagedResponse.createAsync((PageContext<ListEnvironmentsRequest, ListEnvironmentsResponse, Environment>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> LOOKUP_ENVIRONMENT_HISTORY_PAGE_STR_FACT = new PagedListResponseFactory<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse>(){

        public ApiFuture<EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> getFuturePagedResponse(UnaryCallable<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse> callable, LookupEnvironmentHistoryRequest request, ApiCallContext context, ApiFuture<LookupEnvironmentHistoryResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LOOKUP_ENVIRONMENT_HISTORY_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return EnvironmentsClient.LookupEnvironmentHistoryPagedResponse.createAsync((PageContext<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, Environment>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
        return this.listEnvironmentsSettings;
    }

    public UnaryCallSettings<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
        return this.getEnvironmentSettings;
    }

    public UnaryCallSettings<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
        return this.createEnvironmentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateEnvironmentRequest, Environment, Struct> createEnvironmentOperationSettings() {
        return this.createEnvironmentOperationSettings;
    }

    public UnaryCallSettings<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
        return this.updateEnvironmentSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateEnvironmentRequest, Environment, Struct> updateEnvironmentOperationSettings() {
        return this.updateEnvironmentOperationSettings;
    }

    public UnaryCallSettings<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings() {
        return this.deleteEnvironmentSettings;
    }

    public PagedCallSettings<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> lookupEnvironmentHistorySettings() {
        return this.lookupEnvironmentHistorySettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public EnvironmentsStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcEnvironmentsStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "dialogflow.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnvironmentsStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(EnvironmentsStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected EnvironmentsStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listEnvironmentsSettings = settingsBuilder.listEnvironmentsSettings().build();
        this.getEnvironmentSettings = settingsBuilder.getEnvironmentSettings().build();
        this.createEnvironmentSettings = settingsBuilder.createEnvironmentSettings().build();
        this.createEnvironmentOperationSettings = settingsBuilder.createEnvironmentOperationSettings().build();
        this.updateEnvironmentSettings = settingsBuilder.updateEnvironmentSettings().build();
        this.updateEnvironmentOperationSettings = settingsBuilder.updateEnvironmentOperationSettings().build();
        this.deleteEnvironmentSettings = settingsBuilder.deleteEnvironmentSettings().build();
        this.lookupEnvironmentHistorySettings = settingsBuilder.lookupEnvironmentHistorySettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<EnvironmentsStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings;
        private final UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings;
        private final UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings;
        private final OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, Struct> createEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings;
        private final OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, Struct> updateEnvironmentOperationSettings;
        private final UnaryCallSettings.Builder<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings;
        private final PagedCallSettings.Builder<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> lookupEnvironmentHistorySettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listEnvironmentsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENVIRONMENTS_PAGE_STR_FACT);
            this.getEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.updateEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateEnvironmentOperationSettings = OperationCallSettings.newBuilder();
            this.deleteEnvironmentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupEnvironmentHistorySettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LOOKUP_ENVIRONMENT_HISTORY_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.lookupEnvironmentHistorySettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(EnvironmentsStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)EnvironmentsStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)EnvironmentsStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(EnvironmentsStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listEnvironmentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteEnvironmentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.lookupEnvironmentHistorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateEnvironmentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Environment.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Struct.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(EnvironmentsStubSettings settings) {
            super((StubSettings)settings);
            this.listEnvironmentsSettings = settings.listEnvironmentsSettings.toBuilder();
            this.getEnvironmentSettings = settings.getEnvironmentSettings.toBuilder();
            this.createEnvironmentSettings = settings.createEnvironmentSettings.toBuilder();
            this.createEnvironmentOperationSettings = settings.createEnvironmentOperationSettings.toBuilder();
            this.updateEnvironmentSettings = settings.updateEnvironmentSettings.toBuilder();
            this.updateEnvironmentOperationSettings = settings.updateEnvironmentOperationSettings.toBuilder();
            this.deleteEnvironmentSettings = settings.deleteEnvironmentSettings.toBuilder();
            this.lookupEnvironmentHistorySettings = settings.lookupEnvironmentHistorySettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listEnvironmentsSettings, this.getEnvironmentSettings, this.createEnvironmentSettings, this.updateEnvironmentSettings, this.deleteEnvironmentSettings, this.lookupEnvironmentHistorySettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListEnvironmentsRequest, ListEnvironmentsResponse, EnvironmentsClient.ListEnvironmentsPagedResponse> listEnvironmentsSettings() {
            return this.listEnvironmentsSettings;
        }

        public UnaryCallSettings.Builder<GetEnvironmentRequest, Environment> getEnvironmentSettings() {
            return this.getEnvironmentSettings;
        }

        public UnaryCallSettings.Builder<CreateEnvironmentRequest, Operation> createEnvironmentSettings() {
            return this.createEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEnvironmentRequest, Environment, Struct> createEnvironmentOperationSettings() {
            return this.createEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateEnvironmentRequest, Operation> updateEnvironmentSettings() {
            return this.updateEnvironmentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateEnvironmentRequest, Environment, Struct> updateEnvironmentOperationSettings() {
            return this.updateEnvironmentOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteEnvironmentRequest, Empty> deleteEnvironmentSettings() {
            return this.deleteEnvironmentSettings;
        }

        public PagedCallSettings.Builder<LookupEnvironmentHistoryRequest, LookupEnvironmentHistoryResponse, EnvironmentsClient.LookupEnvironmentHistoryPagedResponse> lookupEnvironmentHistorySettings() {
            return this.lookupEnvironmentHistorySettings;
        }

        public EnvironmentsStubSettings build() throws IOException {
            return new EnvironmentsStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)220000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)220000L)).setTotalTimeout(Duration.ofMillis((long)220000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)220000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)220000L)).setTotalTimeout(Duration.ofMillis((long)220000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

