/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3.stub;

import com.google.api.HttpRule;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.CompareVersionsRequest;
import com.google.cloud.dialogflow.cx.v3.CompareVersionsResponse;
import com.google.cloud.dialogflow.cx.v3.CreateVersionOperationMetadata;
import com.google.cloud.dialogflow.cx.v3.CreateVersionRequest;
import com.google.cloud.dialogflow.cx.v3.DeleteVersionRequest;
import com.google.cloud.dialogflow.cx.v3.GetVersionRequest;
import com.google.cloud.dialogflow.cx.v3.ListVersionsRequest;
import com.google.cloud.dialogflow.cx.v3.ListVersionsResponse;
import com.google.cloud.dialogflow.cx.v3.LoadVersionRequest;
import com.google.cloud.dialogflow.cx.v3.UpdateVersionRequest;
import com.google.cloud.dialogflow.cx.v3.Version;
import com.google.cloud.dialogflow.cx.v3.VersionsClient;
import com.google.cloud.dialogflow.cx.v3.stub.HttpJsonVersionsCallableFactory;
import com.google.cloud.dialogflow.cx.v3.stub.VersionsStub;
import com.google.cloud.dialogflow.cx.v3.stub.VersionsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonVersionsStub
extends VersionsStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Empty.getDescriptor()).add(Version.getDescriptor()).add(CreateVersionOperationMetadata.getDescriptor()).add(Struct.getDescriptor()).build();
    private static final ApiMethodDescriptor<ListVersionsRequest, ListVersionsResponse> listVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/ListVersions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*/agents/*/flows/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetVersionRequest, Version> getVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/GetVersion").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/agents/*/flows/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Version.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateVersionRequest, Operation> createVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/CreateVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{parent=projects/*/locations/*/agents/*/flows/*}/versions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("version", (Message)request.getVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<UpdateVersionRequest, Version> updateVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/UpdateVersion").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{version.name=projects/*/locations/*/agents/*/flows/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "version.name", (Object)request.getVersion().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("version", (Message)request.getVersion(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Version.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteVersionRequest, Empty> deleteVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/DeleteVersion").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/agents/*/flows/*/versions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<LoadVersionRequest, Operation> loadVersionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/LoadVersion").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*/agents/*/flows/*/versions/*}:load", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<CompareVersionsRequest, CompareVersionsResponse> compareVersionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.dialogflow.cx.v3.Versions/CompareVersions").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{baseVersion=projects/*/locations/*/agents/*/flows/*/versions/*}:compareVersions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "baseVersion", (Object)request.getBaseVersion());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearBaseVersion().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CompareVersionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/ListLocations").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*}/locations", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListLocationsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.location.Locations/GetLocation").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v3/{name=projects/*/locations/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Location.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable;
    private final UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable;
    private final UnaryCallable<GetVersionRequest, Version> getVersionCallable;
    private final UnaryCallable<CreateVersionRequest, Operation> createVersionCallable;
    private final OperationCallable<CreateVersionRequest, Version, CreateVersionOperationMetadata> createVersionOperationCallable;
    private final UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable;
    private final UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable;
    private final UnaryCallable<LoadVersionRequest, Operation> loadVersionCallable;
    private final OperationCallable<LoadVersionRequest, Empty, Struct> loadVersionOperationCallable;
    private final UnaryCallable<CompareVersionsRequest, CompareVersionsResponse> compareVersionsCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, VersionsClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonVersionsStub create(VersionsStubSettings settings) throws IOException {
        return new HttpJsonVersionsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonVersionsStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonVersionsStub(VersionsStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonVersionsStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonVersionsStub(VersionsStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonVersionsStub(VersionsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonVersionsCallableFactory());
    }

    protected HttpJsonVersionsStub(VersionsStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v3/{name=projects/*/operations/*}:cancel").addAdditionalBindings(HttpRule.newBuilder().setPost("/v3/{name=projects/*/locations/*/operations/*}:cancel").build()).build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v3/{name=projects/*/operations/*}").addAdditionalBindings(HttpRule.newBuilder().setGet("/v3/{name=projects/*/locations/*/operations/*}").build()).build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v3/{name=projects/*}/operations").addAdditionalBindings(HttpRule.newBuilder().setGet("/v3/{name=projects/*/locations/*}/operations").build()).build()).build());
        HttpJsonCallSettings listVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listVersionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings loadVersionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(loadVersionMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings compareVersionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(compareVersionsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listLocationsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getLocationTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.listVersionsCallable = callableFactory.createUnaryCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.listVersionsPagedCallable = callableFactory.createPagedCallable(listVersionsTransportSettings, settings.listVersionsSettings(), clientContext);
        this.getVersionCallable = callableFactory.createUnaryCallable(getVersionTransportSettings, settings.getVersionSettings(), clientContext);
        this.createVersionCallable = callableFactory.createUnaryCallable(createVersionTransportSettings, settings.createVersionSettings(), clientContext);
        this.createVersionOperationCallable = callableFactory.createOperationCallable(createVersionTransportSettings, settings.createVersionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.updateVersionCallable = callableFactory.createUnaryCallable(updateVersionTransportSettings, settings.updateVersionSettings(), clientContext);
        this.deleteVersionCallable = callableFactory.createUnaryCallable(deleteVersionTransportSettings, settings.deleteVersionSettings(), clientContext);
        this.loadVersionCallable = callableFactory.createUnaryCallable(loadVersionTransportSettings, settings.loadVersionSettings(), clientContext);
        this.loadVersionOperationCallable = callableFactory.createOperationCallable(loadVersionTransportSettings, settings.loadVersionOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.compareVersionsCallable = callableFactory.createUnaryCallable(compareVersionsTransportSettings, settings.compareVersionsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(listVersionsMethodDescriptor);
        methodDescriptors.add(getVersionMethodDescriptor);
        methodDescriptors.add(createVersionMethodDescriptor);
        methodDescriptors.add(updateVersionMethodDescriptor);
        methodDescriptors.add(deleteVersionMethodDescriptor);
        methodDescriptors.add(loadVersionMethodDescriptor);
        methodDescriptors.add(compareVersionsMethodDescriptor);
        methodDescriptors.add(listLocationsMethodDescriptor);
        methodDescriptors.add(getLocationMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, ListVersionsResponse> listVersionsCallable() {
        return this.listVersionsCallable;
    }

    @Override
    public UnaryCallable<ListVersionsRequest, VersionsClient.ListVersionsPagedResponse> listVersionsPagedCallable() {
        return this.listVersionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetVersionRequest, Version> getVersionCallable() {
        return this.getVersionCallable;
    }

    @Override
    public UnaryCallable<CreateVersionRequest, Operation> createVersionCallable() {
        return this.createVersionCallable;
    }

    @Override
    public OperationCallable<CreateVersionRequest, Version, CreateVersionOperationMetadata> createVersionOperationCallable() {
        return this.createVersionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateVersionRequest, Version> updateVersionCallable() {
        return this.updateVersionCallable;
    }

    @Override
    public UnaryCallable<DeleteVersionRequest, Empty> deleteVersionCallable() {
        return this.deleteVersionCallable;
    }

    @Override
    public UnaryCallable<LoadVersionRequest, Operation> loadVersionCallable() {
        return this.loadVersionCallable;
    }

    @Override
    public OperationCallable<LoadVersionRequest, Empty, Struct> loadVersionOperationCallable() {
        return this.loadVersionOperationCallable;
    }

    @Override
    public UnaryCallable<CompareVersionsRequest, CompareVersionsResponse> compareVersionsCallable() {
        return this.compareVersionsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, VersionsClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

