/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3.AgentName;
import com.google.cloud.dialogflow.cx.v3.Changelog;
import com.google.cloud.dialogflow.cx.v3.ChangelogName;
import com.google.cloud.dialogflow.cx.v3.ChangelogsSettings;
import com.google.cloud.dialogflow.cx.v3.GetChangelogRequest;
import com.google.cloud.dialogflow.cx.v3.ListChangelogsRequest;
import com.google.cloud.dialogflow.cx.v3.ListChangelogsResponse;
import com.google.cloud.dialogflow.cx.v3.stub.ChangelogsStub;
import com.google.cloud.dialogflow.cx.v3.stub.ChangelogsStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ChangelogsClient
implements BackgroundResource {
    private final ChangelogsSettings settings;
    private final ChangelogsStub stub;

    public static final ChangelogsClient create() throws IOException {
        return ChangelogsClient.create(ChangelogsSettings.newBuilder().build());
    }

    public static final ChangelogsClient create(ChangelogsSettings settings) throws IOException {
        return new ChangelogsClient(settings);
    }

    public static final ChangelogsClient create(ChangelogsStub stub) {
        return new ChangelogsClient(stub);
    }

    protected ChangelogsClient(ChangelogsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ChangelogsStubSettings)settings.getStubSettings()).createStub();
    }

    protected ChangelogsClient(ChangelogsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ChangelogsSettings getSettings() {
        return this.settings;
    }

    public ChangelogsStub getStub() {
        return this.stub;
    }

    public final ListChangelogsPagedResponse listChangelogs(AgentName parent) {
        ListChangelogsRequest request = ListChangelogsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listChangelogs(request);
    }

    public final ListChangelogsPagedResponse listChangelogs(String parent) {
        ListChangelogsRequest request = ListChangelogsRequest.newBuilder().setParent(parent).build();
        return this.listChangelogs(request);
    }

    public final ListChangelogsPagedResponse listChangelogs(ListChangelogsRequest request) {
        return (ListChangelogsPagedResponse)((Object)this.listChangelogsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListChangelogsRequest, ListChangelogsPagedResponse> listChangelogsPagedCallable() {
        return this.stub.listChangelogsPagedCallable();
    }

    public final UnaryCallable<ListChangelogsRequest, ListChangelogsResponse> listChangelogsCallable() {
        return this.stub.listChangelogsCallable();
    }

    public final Changelog getChangelog(ChangelogName name) {
        GetChangelogRequest request = GetChangelogRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getChangelog(request);
    }

    public final Changelog getChangelog(String name) {
        GetChangelogRequest request = GetChangelogRequest.newBuilder().setName(name).build();
        return this.getChangelog(request);
    }

    public final Changelog getChangelog(GetChangelogRequest request) {
        return (Changelog)this.getChangelogCallable().call((Object)request);
    }

    public final UnaryCallable<GetChangelogRequest, Changelog> getChangelogCallable() {
        return this.stub.getChangelogCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListChangelogsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListChangelogsRequest, ListChangelogsResponse, Changelog, ListChangelogsPage, ListChangelogsFixedSizeCollection> {
        private ListChangelogsFixedSizeCollection(List<ListChangelogsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListChangelogsFixedSizeCollection createEmptyCollection() {
            return new ListChangelogsFixedSizeCollection(null, 0);
        }

        protected ListChangelogsFixedSizeCollection createCollection(List<ListChangelogsPage> pages, int collectionSize) {
            return new ListChangelogsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListChangelogsPage
    extends AbstractPage<ListChangelogsRequest, ListChangelogsResponse, Changelog, ListChangelogsPage> {
        private ListChangelogsPage(PageContext<ListChangelogsRequest, ListChangelogsResponse, Changelog> context, ListChangelogsResponse response) {
            super(context, (Object)response);
        }

        private static ListChangelogsPage createEmptyPage() {
            return new ListChangelogsPage(null, null);
        }

        protected ListChangelogsPage createPage(PageContext<ListChangelogsRequest, ListChangelogsResponse, Changelog> context, ListChangelogsResponse response) {
            return new ListChangelogsPage(context, response);
        }

        public ApiFuture<ListChangelogsPage> createPageAsync(PageContext<ListChangelogsRequest, ListChangelogsResponse, Changelog> context, ApiFuture<ListChangelogsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListChangelogsPagedResponse
    extends AbstractPagedListResponse<ListChangelogsRequest, ListChangelogsResponse, Changelog, ListChangelogsPage, ListChangelogsFixedSizeCollection> {
        public static ApiFuture<ListChangelogsPagedResponse> createAsync(PageContext<ListChangelogsRequest, ListChangelogsResponse, Changelog> context, ApiFuture<ListChangelogsResponse> futureResponse) {
            ApiFuture<ListChangelogsPage> futurePage = ListChangelogsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListChangelogsPagedResponse((ListChangelogsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListChangelogsPagedResponse(ListChangelogsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListChangelogsFixedSizeCollection.createEmptyCollection());
        }
    }
}

