/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.AgentName;
import com.google.cloud.dialogflow.cx.v3beta1.BatchDeleteTestCasesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.BatchRunTestCasesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageRequest;
import com.google.cloud.dialogflow.cx.v3beta1.CalculateCoverageResponse;
import com.google.cloud.dialogflow.cx.v3beta1.CreateTestCaseRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportTestCasesMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ExportTestCasesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ExportTestCasesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.GetTestCaseRequest;
import com.google.cloud.dialogflow.cx.v3beta1.GetTestCaseResultRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ImportTestCasesMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.ImportTestCasesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ImportTestCasesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListTestCaseResultsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.ListTestCasesRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListTestCasesResponse;
import com.google.cloud.dialogflow.cx.v3beta1.RunTestCaseMetadata;
import com.google.cloud.dialogflow.cx.v3beta1.RunTestCaseRequest;
import com.google.cloud.dialogflow.cx.v3beta1.RunTestCaseResponse;
import com.google.cloud.dialogflow.cx.v3beta1.TestCase;
import com.google.cloud.dialogflow.cx.v3beta1.TestCaseName;
import com.google.cloud.dialogflow.cx.v3beta1.TestCaseResult;
import com.google.cloud.dialogflow.cx.v3beta1.TestCaseResultName;
import com.google.cloud.dialogflow.cx.v3beta1.TestCasesSettings;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateTestCaseRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.TestCasesStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.TestCasesStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class TestCasesClient
implements BackgroundResource {
    private final TestCasesSettings settings;
    private final TestCasesStub stub;
    private final OperationsClient operationsClient;

    public static final TestCasesClient create() throws IOException {
        return TestCasesClient.create(TestCasesSettings.newBuilder().build());
    }

    public static final TestCasesClient create(TestCasesSettings settings) throws IOException {
        return new TestCasesClient(settings);
    }

    public static final TestCasesClient create(TestCasesStub stub) {
        return new TestCasesClient(stub);
    }

    protected TestCasesClient(TestCasesSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((TestCasesStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    protected TestCasesClient(TestCasesStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final TestCasesSettings getSettings() {
        return this.settings;
    }

    public TestCasesStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListTestCasesPagedResponse listTestCases(AgentName parent) {
        ListTestCasesRequest request = ListTestCasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTestCases(request);
    }

    public final ListTestCasesPagedResponse listTestCases(String parent) {
        ListTestCasesRequest request = ListTestCasesRequest.newBuilder().setParent(parent).build();
        return this.listTestCases(request);
    }

    public final ListTestCasesPagedResponse listTestCases(ListTestCasesRequest request) {
        return (ListTestCasesPagedResponse)((Object)this.listTestCasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTestCasesRequest, ListTestCasesPagedResponse> listTestCasesPagedCallable() {
        return this.stub.listTestCasesPagedCallable();
    }

    public final UnaryCallable<ListTestCasesRequest, ListTestCasesResponse> listTestCasesCallable() {
        return this.stub.listTestCasesCallable();
    }

    public final void batchDeleteTestCases(AgentName parent) {
        BatchDeleteTestCasesRequest request = BatchDeleteTestCasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        this.batchDeleteTestCases(request);
    }

    public final void batchDeleteTestCases(String parent) {
        BatchDeleteTestCasesRequest request = BatchDeleteTestCasesRequest.newBuilder().setParent(parent).build();
        this.batchDeleteTestCases(request);
    }

    public final void batchDeleteTestCases(BatchDeleteTestCasesRequest request) {
        this.batchDeleteTestCasesCallable().call((Object)request);
    }

    public final UnaryCallable<BatchDeleteTestCasesRequest, Empty> batchDeleteTestCasesCallable() {
        return this.stub.batchDeleteTestCasesCallable();
    }

    public final TestCase getTestCase(TestCaseName name) {
        GetTestCaseRequest request = GetTestCaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTestCase(request);
    }

    public final TestCase getTestCase(String name) {
        GetTestCaseRequest request = GetTestCaseRequest.newBuilder().setName(name).build();
        return this.getTestCase(request);
    }

    public final TestCase getTestCase(GetTestCaseRequest request) {
        return (TestCase)this.getTestCaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetTestCaseRequest, TestCase> getTestCaseCallable() {
        return this.stub.getTestCaseCallable();
    }

    public final TestCase createTestCase(AgentName parent, TestCase testCase) {
        CreateTestCaseRequest request = CreateTestCaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTestCase(testCase).build();
        return this.createTestCase(request);
    }

    public final TestCase createTestCase(String parent, TestCase testCase) {
        CreateTestCaseRequest request = CreateTestCaseRequest.newBuilder().setParent(parent).setTestCase(testCase).build();
        return this.createTestCase(request);
    }

    public final TestCase createTestCase(CreateTestCaseRequest request) {
        return (TestCase)this.createTestCaseCallable().call((Object)request);
    }

    public final UnaryCallable<CreateTestCaseRequest, TestCase> createTestCaseCallable() {
        return this.stub.createTestCaseCallable();
    }

    public final TestCase updateTestCase(TestCase testCase, FieldMask updateMask) {
        UpdateTestCaseRequest request = UpdateTestCaseRequest.newBuilder().setTestCase(testCase).setUpdateMask(updateMask).build();
        return this.updateTestCase(request);
    }

    public final TestCase updateTestCase(UpdateTestCaseRequest request) {
        return (TestCase)this.updateTestCaseCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateTestCaseRequest, TestCase> updateTestCaseCallable() {
        return this.stub.updateTestCaseCallable();
    }

    public final OperationFuture<RunTestCaseResponse, RunTestCaseMetadata> runTestCaseAsync(RunTestCaseRequest request) {
        return this.runTestCaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunTestCaseRequest, RunTestCaseResponse, RunTestCaseMetadata> runTestCaseOperationCallable() {
        return this.stub.runTestCaseOperationCallable();
    }

    public final UnaryCallable<RunTestCaseRequest, Operation> runTestCaseCallable() {
        return this.stub.runTestCaseCallable();
    }

    public final OperationFuture<BatchRunTestCasesResponse, BatchRunTestCasesMetadata> batchRunTestCasesAsync(BatchRunTestCasesRequest request) {
        return this.batchRunTestCasesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<BatchRunTestCasesRequest, BatchRunTestCasesResponse, BatchRunTestCasesMetadata> batchRunTestCasesOperationCallable() {
        return this.stub.batchRunTestCasesOperationCallable();
    }

    public final UnaryCallable<BatchRunTestCasesRequest, Operation> batchRunTestCasesCallable() {
        return this.stub.batchRunTestCasesCallable();
    }

    public final CalculateCoverageResponse calculateCoverage(CalculateCoverageRequest request) {
        return (CalculateCoverageResponse)this.calculateCoverageCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateCoverageRequest, CalculateCoverageResponse> calculateCoverageCallable() {
        return this.stub.calculateCoverageCallable();
    }

    public final OperationFuture<ImportTestCasesResponse, ImportTestCasesMetadata> importTestCasesAsync(ImportTestCasesRequest request) {
        return this.importTestCasesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ImportTestCasesRequest, ImportTestCasesResponse, ImportTestCasesMetadata> importTestCasesOperationCallable() {
        return this.stub.importTestCasesOperationCallable();
    }

    public final UnaryCallable<ImportTestCasesRequest, Operation> importTestCasesCallable() {
        return this.stub.importTestCasesCallable();
    }

    public final OperationFuture<ExportTestCasesResponse, ExportTestCasesMetadata> exportTestCasesAsync(ExportTestCasesRequest request) {
        return this.exportTestCasesOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<ExportTestCasesRequest, ExportTestCasesResponse, ExportTestCasesMetadata> exportTestCasesOperationCallable() {
        return this.stub.exportTestCasesOperationCallable();
    }

    public final UnaryCallable<ExportTestCasesRequest, Operation> exportTestCasesCallable() {
        return this.stub.exportTestCasesCallable();
    }

    public final ListTestCaseResultsPagedResponse listTestCaseResults(TestCaseName parent) {
        ListTestCaseResultsRequest request = ListTestCaseResultsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTestCaseResults(request);
    }

    public final ListTestCaseResultsPagedResponse listTestCaseResults(String parent) {
        ListTestCaseResultsRequest request = ListTestCaseResultsRequest.newBuilder().setParent(parent).build();
        return this.listTestCaseResults(request);
    }

    public final ListTestCaseResultsPagedResponse listTestCaseResults(ListTestCaseResultsRequest request) {
        return (ListTestCaseResultsPagedResponse)((Object)this.listTestCaseResultsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTestCaseResultsRequest, ListTestCaseResultsPagedResponse> listTestCaseResultsPagedCallable() {
        return this.stub.listTestCaseResultsPagedCallable();
    }

    public final UnaryCallable<ListTestCaseResultsRequest, ListTestCaseResultsResponse> listTestCaseResultsCallable() {
        return this.stub.listTestCaseResultsCallable();
    }

    public final TestCaseResult getTestCaseResult(TestCaseResultName name) {
        GetTestCaseResultRequest request = GetTestCaseResultRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTestCaseResult(request);
    }

    public final TestCaseResult getTestCaseResult(String name) {
        GetTestCaseResultRequest request = GetTestCaseResultRequest.newBuilder().setName(name).build();
        return this.getTestCaseResult(request);
    }

    public final TestCaseResult getTestCaseResult(GetTestCaseResultRequest request) {
        return (TestCaseResult)this.getTestCaseResultCallable().call((Object)request);
    }

    public final UnaryCallable<GetTestCaseResultRequest, TestCaseResult> getTestCaseResultCallable() {
        return this.stub.getTestCaseResultCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListTestCaseResultsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult, ListTestCaseResultsPage, ListTestCaseResultsFixedSizeCollection> {
        private ListTestCaseResultsFixedSizeCollection(List<ListTestCaseResultsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTestCaseResultsFixedSizeCollection createEmptyCollection() {
            return new ListTestCaseResultsFixedSizeCollection(null, 0);
        }

        protected ListTestCaseResultsFixedSizeCollection createCollection(List<ListTestCaseResultsPage> pages, int collectionSize) {
            return new ListTestCaseResultsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTestCaseResultsPage
    extends AbstractPage<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult, ListTestCaseResultsPage> {
        private ListTestCaseResultsPage(PageContext<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult> context, ListTestCaseResultsResponse response) {
            super(context, (Object)response);
        }

        private static ListTestCaseResultsPage createEmptyPage() {
            return new ListTestCaseResultsPage(null, null);
        }

        protected ListTestCaseResultsPage createPage(PageContext<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult> context, ListTestCaseResultsResponse response) {
            return new ListTestCaseResultsPage(context, response);
        }

        public ApiFuture<ListTestCaseResultsPage> createPageAsync(PageContext<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult> context, ApiFuture<ListTestCaseResultsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTestCaseResultsPagedResponse
    extends AbstractPagedListResponse<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult, ListTestCaseResultsPage, ListTestCaseResultsFixedSizeCollection> {
        public static ApiFuture<ListTestCaseResultsPagedResponse> createAsync(PageContext<ListTestCaseResultsRequest, ListTestCaseResultsResponse, TestCaseResult> context, ApiFuture<ListTestCaseResultsResponse> futureResponse) {
            ApiFuture<ListTestCaseResultsPage> futurePage = ListTestCaseResultsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTestCaseResultsPagedResponse((ListTestCaseResultsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTestCaseResultsPagedResponse(ListTestCaseResultsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTestCaseResultsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTestCasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTestCasesRequest, ListTestCasesResponse, TestCase, ListTestCasesPage, ListTestCasesFixedSizeCollection> {
        private ListTestCasesFixedSizeCollection(List<ListTestCasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTestCasesFixedSizeCollection createEmptyCollection() {
            return new ListTestCasesFixedSizeCollection(null, 0);
        }

        protected ListTestCasesFixedSizeCollection createCollection(List<ListTestCasesPage> pages, int collectionSize) {
            return new ListTestCasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTestCasesPage
    extends AbstractPage<ListTestCasesRequest, ListTestCasesResponse, TestCase, ListTestCasesPage> {
        private ListTestCasesPage(PageContext<ListTestCasesRequest, ListTestCasesResponse, TestCase> context, ListTestCasesResponse response) {
            super(context, (Object)response);
        }

        private static ListTestCasesPage createEmptyPage() {
            return new ListTestCasesPage(null, null);
        }

        protected ListTestCasesPage createPage(PageContext<ListTestCasesRequest, ListTestCasesResponse, TestCase> context, ListTestCasesResponse response) {
            return new ListTestCasesPage(context, response);
        }

        public ApiFuture<ListTestCasesPage> createPageAsync(PageContext<ListTestCasesRequest, ListTestCasesResponse, TestCase> context, ApiFuture<ListTestCasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTestCasesPagedResponse
    extends AbstractPagedListResponse<ListTestCasesRequest, ListTestCasesResponse, TestCase, ListTestCasesPage, ListTestCasesFixedSizeCollection> {
        public static ApiFuture<ListTestCasesPagedResponse> createAsync(PageContext<ListTestCasesRequest, ListTestCasesResponse, TestCase> context, ApiFuture<ListTestCasesResponse> futureResponse) {
            ApiFuture<ListTestCasesPage> futurePage = ListTestCasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTestCasesPagedResponse((ListTestCasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTestCasesPagedResponse(ListTestCasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTestCasesFixedSizeCollection.createEmptyCollection());
        }
    }
}

