/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.Deployment;
import com.google.cloud.dialogflow.cx.v3beta1.DeploymentName;
import com.google.cloud.dialogflow.cx.v3beta1.DeploymentsSettings;
import com.google.cloud.dialogflow.cx.v3beta1.EnvironmentName;
import com.google.cloud.dialogflow.cx.v3beta1.GetDeploymentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListDeploymentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListDeploymentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.stub.DeploymentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.DeploymentsStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DeploymentsClient
implements BackgroundResource {
    private final DeploymentsSettings settings;
    private final DeploymentsStub stub;

    public static final DeploymentsClient create() throws IOException {
        return DeploymentsClient.create(DeploymentsSettings.newBuilder().build());
    }

    public static final DeploymentsClient create(DeploymentsSettings settings) throws IOException {
        return new DeploymentsClient(settings);
    }

    public static final DeploymentsClient create(DeploymentsStub stub) {
        return new DeploymentsClient(stub);
    }

    protected DeploymentsClient(DeploymentsSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DeploymentsStubSettings)settings.getStubSettings()).createStub();
    }

    protected DeploymentsClient(DeploymentsStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DeploymentsSettings getSettings() {
        return this.settings;
    }

    public DeploymentsStub getStub() {
        return this.stub;
    }

    public final ListDeploymentsPagedResponse listDeployments(EnvironmentName parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(String parent) {
        ListDeploymentsRequest request = ListDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listDeployments(request);
    }

    public final ListDeploymentsPagedResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsPagedResponse)((Object)this.listDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsPagedResponse> listDeploymentsPagedCallable() {
        return this.stub.listDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListDeploymentsRequest, ListDeploymentsResponse> listDeploymentsCallable() {
        return this.stub.listDeploymentsCallable();
    }

    public final Deployment getDeployment(DeploymentName name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(String name) {
        GetDeploymentRequest request = GetDeploymentRequest.newBuilder().setName(name).build();
        return this.getDeployment(request);
    }

    public final Deployment getDeployment(GetDeploymentRequest request) {
        return (Deployment)this.getDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeploymentRequest, Deployment> getDeploymentCallable() {
        return this.stub.getDeploymentCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        private ListDeploymentsFixedSizeCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListDeploymentsFixedSizeCollection createCollection(List<ListDeploymentsPage> pages, int collectionSize) {
            return new ListDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeploymentsPage
    extends AbstractPage<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage> {
        private ListDeploymentsPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListDeploymentsPage createEmptyPage() {
            return new ListDeploymentsPage(null, null);
        }

        protected ListDeploymentsPage createPage(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ListDeploymentsResponse response) {
            return new ListDeploymentsPage(context, response);
        }

        public ApiFuture<ListDeploymentsPage> createPageAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListDeploymentsRequest, ListDeploymentsResponse, Deployment, ListDeploymentsPage, ListDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListDeploymentsPagedResponse> createAsync(PageContext<ListDeploymentsRequest, ListDeploymentsResponse, Deployment> context, ApiFuture<ListDeploymentsResponse> futureResponse) {
            ApiFuture<ListDeploymentsPage> futurePage = ListDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeploymentsPagedResponse((ListDeploymentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeploymentsPagedResponse(ListDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

