/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dialogflow.cx.v3beta1.stub;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dialogflow.cx.v3beta1.CreateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.DeleteExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.Experiment;
import com.google.cloud.dialogflow.cx.v3beta1.ExperimentsClient;
import com.google.cloud.dialogflow.cx.v3beta1.GetExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExperimentsRequest;
import com.google.cloud.dialogflow.cx.v3beta1.ListExperimentsResponse;
import com.google.cloud.dialogflow.cx.v3beta1.StartExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.StopExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.UpdateExperimentRequest;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExperimentsStub;
import com.google.cloud.dialogflow.cx.v3beta1.stub.ExperimentsStubSettings;
import com.google.cloud.dialogflow.cx.v3beta1.stub.GrpcExperimentsCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GrpcExperimentsStub
extends ExperimentsStub {
    private static final MethodDescriptor<ListExperimentsRequest, ListExperimentsResponse> listExperimentsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/ListExperiments").setRequestMarshaller(ProtoUtils.marshaller((Message)ListExperimentsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListExperimentsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetExperimentRequest, Experiment> getExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/GetExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)GetExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Experiment.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateExperimentRequest, Experiment> createExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/CreateExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Experiment.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateExperimentRequest, Experiment> updateExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/UpdateExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Experiment.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteExperimentRequest, Empty> deleteExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/DeleteExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private static final MethodDescriptor<StartExperimentRequest, Experiment> startExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/StartExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)StartExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Experiment.getDefaultInstance())).build();
    private static final MethodDescriptor<StopExperimentRequest, Experiment> stopExperimentMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dialogflow.cx.v3beta1.Experiments/StopExperiment").setRequestMarshaller(ProtoUtils.marshaller((Message)StopExperimentRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Experiment.getDefaultInstance())).build();
    private final UnaryCallable<ListExperimentsRequest, ListExperimentsResponse> listExperimentsCallable;
    private final UnaryCallable<ListExperimentsRequest, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsPagedCallable;
    private final UnaryCallable<GetExperimentRequest, Experiment> getExperimentCallable;
    private final UnaryCallable<CreateExperimentRequest, Experiment> createExperimentCallable;
    private final UnaryCallable<UpdateExperimentRequest, Experiment> updateExperimentCallable;
    private final UnaryCallable<DeleteExperimentRequest, Empty> deleteExperimentCallable;
    private final UnaryCallable<StartExperimentRequest, Experiment> startExperimentCallable;
    private final UnaryCallable<StopExperimentRequest, Experiment> stopExperimentCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcExperimentsStub create(ExperimentsStubSettings settings) throws IOException {
        return new GrpcExperimentsStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcExperimentsStub create(ClientContext clientContext) throws IOException {
        return new GrpcExperimentsStub(ExperimentsStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcExperimentsStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcExperimentsStub(ExperimentsStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcExperimentsStub(ExperimentsStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcExperimentsCallableFactory());
    }

    protected GrpcExperimentsStub(ExperimentsStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listExperimentsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listExperimentsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings getExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings createExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
            return params.build();
        }).build();
        GrpcCallSettings updateExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"experiment.name", (Object)String.valueOf(request.getExperiment().getName()));
            return params.build();
        }).build();
        GrpcCallSettings deleteExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings startExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        GrpcCallSettings stopExperimentTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopExperimentMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"name", (Object)String.valueOf(request.getName()));
            return params.build();
        }).build();
        this.listExperimentsCallable = callableFactory.createUnaryCallable(listExperimentsTransportSettings, settings.listExperimentsSettings(), clientContext);
        this.listExperimentsPagedCallable = callableFactory.createPagedCallable(listExperimentsTransportSettings, settings.listExperimentsSettings(), clientContext);
        this.getExperimentCallable = callableFactory.createUnaryCallable(getExperimentTransportSettings, settings.getExperimentSettings(), clientContext);
        this.createExperimentCallable = callableFactory.createUnaryCallable(createExperimentTransportSettings, settings.createExperimentSettings(), clientContext);
        this.updateExperimentCallable = callableFactory.createUnaryCallable(updateExperimentTransportSettings, settings.updateExperimentSettings(), clientContext);
        this.deleteExperimentCallable = callableFactory.createUnaryCallable(deleteExperimentTransportSettings, settings.deleteExperimentSettings(), clientContext);
        this.startExperimentCallable = callableFactory.createUnaryCallable(startExperimentTransportSettings, settings.startExperimentSettings(), clientContext);
        this.stopExperimentCallable = callableFactory.createUnaryCallable(stopExperimentTransportSettings, settings.stopExperimentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListExperimentsRequest, ListExperimentsResponse> listExperimentsCallable() {
        return this.listExperimentsCallable;
    }

    @Override
    public UnaryCallable<ListExperimentsRequest, ExperimentsClient.ListExperimentsPagedResponse> listExperimentsPagedCallable() {
        return this.listExperimentsPagedCallable;
    }

    @Override
    public UnaryCallable<GetExperimentRequest, Experiment> getExperimentCallable() {
        return this.getExperimentCallable;
    }

    @Override
    public UnaryCallable<CreateExperimentRequest, Experiment> createExperimentCallable() {
        return this.createExperimentCallable;
    }

    @Override
    public UnaryCallable<UpdateExperimentRequest, Experiment> updateExperimentCallable() {
        return this.updateExperimentCallable;
    }

    @Override
    public UnaryCallable<DeleteExperimentRequest, Empty> deleteExperimentCallable() {
        return this.deleteExperimentCallable;
    }

    @Override
    public UnaryCallable<StartExperimentRequest, Experiment> startExperimentCallable() {
        return this.startExperimentCallable;
    }

    @Override
    public UnaryCallable<StopExperimentRequest, Experiment> stopExperimentCallable() {
        return this.stopExperimentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

