/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devicestreaming.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devicestreaming.v1.AdbMessage;
import com.google.cloud.devicestreaming.v1.CancelDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.CreateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.DeviceMessage;
import com.google.cloud.devicestreaming.v1.DeviceSession;
import com.google.cloud.devicestreaming.v1.DirectAccessServiceClient;
import com.google.cloud.devicestreaming.v1.GetDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsRequest;
import com.google.cloud.devicestreaming.v1.ListDeviceSessionsResponse;
import com.google.cloud.devicestreaming.v1.UpdateDeviceSessionRequest;
import com.google.cloud.devicestreaming.v1.stub.DirectAccessServiceStub;
import com.google.cloud.devicestreaming.v1.stub.GrpcDirectAccessServiceStub;
import com.google.cloud.devicestreaming.v1.stub.HttpJsonDirectAccessServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DirectAccessServiceStubSettings
extends StubSettings<DirectAccessServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionSettings;
    private final PagedCallSettings<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsSettings;
    private final UnaryCallSettings<GetDeviceSessionRequest, DeviceSession> getDeviceSessionSettings;
    private final UnaryCallSettings<CancelDeviceSessionRequest, Empty> cancelDeviceSessionSettings;
    private final UnaryCallSettings<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionSettings;
    private final StreamingCallSettings<AdbMessage, DeviceMessage> adbConnectSettings;
    private static final PagedListDescriptor<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession> LIST_DEVICE_SESSIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession>(){

        public String emptyToken() {
            return "";
        }

        public ListDeviceSessionsRequest injectToken(ListDeviceSessionsRequest payload, String token) {
            return ListDeviceSessionsRequest.newBuilder((ListDeviceSessionsRequest)payload).setPageToken(token).build();
        }

        public ListDeviceSessionsRequest injectPageSize(ListDeviceSessionsRequest payload, int pageSize) {
            return ListDeviceSessionsRequest.newBuilder((ListDeviceSessionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDeviceSessionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDeviceSessionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DeviceSession> extractResources(ListDeviceSessionsResponse payload) {
            return payload.getDeviceSessionsList();
        }
    };
    private static final PagedListResponseFactory<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> LIST_DEVICE_SESSIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse>(){

        public ApiFuture<DirectAccessServiceClient.ListDeviceSessionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDeviceSessionsRequest, ListDeviceSessionsResponse> callable, ListDeviceSessionsRequest request, ApiCallContext context, ApiFuture<ListDeviceSessionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DEVICE_SESSIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DirectAccessServiceClient.ListDeviceSessionsPagedResponse.createAsync((PageContext<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DeviceSession>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionSettings() {
        return this.createDeviceSessionSettings;
    }

    public PagedCallSettings<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsSettings() {
        return this.listDeviceSessionsSettings;
    }

    public UnaryCallSettings<GetDeviceSessionRequest, DeviceSession> getDeviceSessionSettings() {
        return this.getDeviceSessionSettings;
    }

    public UnaryCallSettings<CancelDeviceSessionRequest, Empty> cancelDeviceSessionSettings() {
        return this.cancelDeviceSessionSettings;
    }

    public UnaryCallSettings<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionSettings() {
        return this.updateDeviceSessionSettings;
    }

    public StreamingCallSettings<AdbMessage, DeviceMessage> adbConnectSettings() {
        return this.adbConnectSettings;
    }

    public DirectAccessServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDirectAccessServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDirectAccessServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "devicestreaming";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "devicestreaming.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "devicestreaming.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DirectAccessServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DirectAccessServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DirectAccessServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DirectAccessServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DirectAccessServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDeviceSessionSettings = settingsBuilder.createDeviceSessionSettings().build();
        this.listDeviceSessionsSettings = settingsBuilder.listDeviceSessionsSettings().build();
        this.getDeviceSessionSettings = settingsBuilder.getDeviceSessionSettings().build();
        this.cancelDeviceSessionSettings = settingsBuilder.cancelDeviceSessionSettings().build();
        this.updateDeviceSessionSettings = settingsBuilder.updateDeviceSessionSettings().build();
        this.adbConnectSettings = settingsBuilder.adbConnectSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DirectAccessServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionSettings;
        private final PagedCallSettings.Builder<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsSettings;
        private final UnaryCallSettings.Builder<GetDeviceSessionRequest, DeviceSession> getDeviceSessionSettings;
        private final UnaryCallSettings.Builder<CancelDeviceSessionRequest, Empty> cancelDeviceSessionSettings;
        private final UnaryCallSettings.Builder<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionSettings;
        private final StreamingCallSettings.Builder<AdbMessage, DeviceMessage> adbConnectSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDeviceSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDeviceSessionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DEVICE_SESSIONS_PAGE_STR_FACT);
            this.getDeviceSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelDeviceSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDeviceSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.adbConnectSettings = StreamingCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeviceSessionSettings, this.listDeviceSessionsSettings, this.getDeviceSessionSettings, this.cancelDeviceSessionSettings, this.updateDeviceSessionSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DirectAccessServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDeviceSessionSettings = settings.createDeviceSessionSettings.toBuilder();
            this.listDeviceSessionsSettings = settings.listDeviceSessionsSettings.toBuilder();
            this.getDeviceSessionSettings = settings.getDeviceSessionSettings.toBuilder();
            this.cancelDeviceSessionSettings = settings.cancelDeviceSessionSettings.toBuilder();
            this.updateDeviceSessionSettings = settings.updateDeviceSessionSettings.toBuilder();
            this.adbConnectSettings = settings.adbConnectSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDeviceSessionSettings, this.listDeviceSessionsSettings, this.getDeviceSessionSettings, this.cancelDeviceSessionSettings, this.updateDeviceSessionSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DirectAccessServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DirectAccessServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DirectAccessServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DirectAccessServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DirectAccessServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DirectAccessServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DirectAccessServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DirectAccessServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDeviceSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listDeviceSessionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDeviceSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.cancelDeviceSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDeviceSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDeviceSessionRequest, DeviceSession> createDeviceSessionSettings() {
            return this.createDeviceSessionSettings;
        }

        public PagedCallSettings.Builder<ListDeviceSessionsRequest, ListDeviceSessionsResponse, DirectAccessServiceClient.ListDeviceSessionsPagedResponse> listDeviceSessionsSettings() {
            return this.listDeviceSessionsSettings;
        }

        public UnaryCallSettings.Builder<GetDeviceSessionRequest, DeviceSession> getDeviceSessionSettings() {
            return this.getDeviceSessionSettings;
        }

        public UnaryCallSettings.Builder<CancelDeviceSessionRequest, Empty> cancelDeviceSessionSettings() {
            return this.cancelDeviceSessionSettings;
        }

        public UnaryCallSettings.Builder<UpdateDeviceSessionRequest, DeviceSession> updateDeviceSessionSettings() {
            return this.updateDeviceSessionSettings;
        }

        public StreamingCallSettings.Builder<AdbMessage, DeviceMessage> adbConnectSettings() {
            return this.adbConnectSettings;
        }

        public DirectAccessServiceStubSettings build() throws IOException {
            return new DirectAccessServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(20000L)).setTotalTimeoutDuration(Duration.ofMillis(20000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(20000L)).setTotalTimeoutDuration(Duration.ofMillis(20000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(1800000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(1800000L)).setTotalTimeoutDuration(Duration.ofMillis(1800000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

