/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.CreateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.DeleteInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.GetInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.InsightsConfig;
import com.google.cloud.developerconnect.v1.InsightsConfigServiceClient;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsRequest;
import com.google.cloud.developerconnect.v1.ListInsightsConfigsResponse;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateInsightsConfigRequest;
import com.google.cloud.developerconnect.v1.stub.GrpcInsightsConfigServiceStub;
import com.google.cloud.developerconnect.v1.stub.HttpJsonInsightsConfigServiceStub;
import com.google.cloud.developerconnect.v1.stub.InsightsConfigServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class InsightsConfigServiceStubSettings
extends StubSettings<InsightsConfigServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsSettings;
    private final UnaryCallSettings<CreateInsightsConfigRequest, Operation> createInsightsConfigSettings;
    private final OperationCallSettings<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationSettings;
    private final UnaryCallSettings<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigSettings;
    private final UnaryCallSettings<UpdateInsightsConfigRequest, Operation> updateInsightsConfigSettings;
    private final OperationCallSettings<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationSettings;
    private final UnaryCallSettings<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigSettings;
    private final OperationCallSettings<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig> LIST_INSIGHTS_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListInsightsConfigsRequest injectToken(ListInsightsConfigsRequest payload, String token) {
            return ListInsightsConfigsRequest.newBuilder((ListInsightsConfigsRequest)payload).setPageToken(token).build();
        }

        public ListInsightsConfigsRequest injectPageSize(ListInsightsConfigsRequest payload, int pageSize) {
            return ListInsightsConfigsRequest.newBuilder((ListInsightsConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListInsightsConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListInsightsConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<InsightsConfig> extractResources(ListInsightsConfigsResponse payload) {
            return payload.getInsightsConfigsList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> LIST_INSIGHTS_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse>(){

        public ApiFuture<InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListInsightsConfigsRequest, ListInsightsConfigsResponse> callable, ListInsightsConfigsRequest request, ApiCallContext context, ApiFuture<ListInsightsConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_INSIGHTS_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InsightsConfigServiceClient.ListInsightsConfigsPagedResponse.createAsync((PageContext<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<InsightsConfigServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return InsightsConfigServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsSettings() {
        return this.listInsightsConfigsSettings;
    }

    public UnaryCallSettings<CreateInsightsConfigRequest, Operation> createInsightsConfigSettings() {
        return this.createInsightsConfigSettings;
    }

    public OperationCallSettings<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationSettings() {
        return this.createInsightsConfigOperationSettings;
    }

    public UnaryCallSettings<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigSettings() {
        return this.getInsightsConfigSettings;
    }

    public UnaryCallSettings<UpdateInsightsConfigRequest, Operation> updateInsightsConfigSettings() {
        return this.updateInsightsConfigSettings;
    }

    public OperationCallSettings<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationSettings() {
        return this.updateInsightsConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigSettings() {
        return this.deleteInsightsConfigSettings;
    }

    public OperationCallSettings<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationSettings() {
        return this.deleteInsightsConfigOperationSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public InsightsConfigServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcInsightsConfigServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonInsightsConfigServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "developerconnect";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "developerconnect.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "developerconnect.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return InsightsConfigServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InsightsConfigServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(InsightsConfigServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return InsightsConfigServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected InsightsConfigServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listInsightsConfigsSettings = settingsBuilder.listInsightsConfigsSettings().build();
        this.createInsightsConfigSettings = settingsBuilder.createInsightsConfigSettings().build();
        this.createInsightsConfigOperationSettings = settingsBuilder.createInsightsConfigOperationSettings().build();
        this.getInsightsConfigSettings = settingsBuilder.getInsightsConfigSettings().build();
        this.updateInsightsConfigSettings = settingsBuilder.updateInsightsConfigSettings().build();
        this.updateInsightsConfigOperationSettings = settingsBuilder.updateInsightsConfigOperationSettings().build();
        this.deleteInsightsConfigSettings = settingsBuilder.deleteInsightsConfigSettings().build();
        this.deleteInsightsConfigOperationSettings = settingsBuilder.deleteInsightsConfigOperationSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<InsightsConfigServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsSettings;
        private final UnaryCallSettings.Builder<CreateInsightsConfigRequest, Operation> createInsightsConfigSettings;
        private final OperationCallSettings.Builder<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationSettings;
        private final UnaryCallSettings.Builder<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigSettings;
        private final UnaryCallSettings.Builder<UpdateInsightsConfigRequest, Operation> updateInsightsConfigSettings;
        private final OperationCallSettings.Builder<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigSettings;
        private final OperationCallSettings.Builder<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listInsightsConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_INSIGHTS_CONFIGS_PAGE_STR_FACT);
            this.createInsightsConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createInsightsConfigOperationSettings = OperationCallSettings.newBuilder();
            this.getInsightsConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInsightsConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateInsightsConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteInsightsConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteInsightsConfigOperationSettings = OperationCallSettings.newBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInsightsConfigsSettings, this.createInsightsConfigSettings, this.getInsightsConfigSettings, this.updateInsightsConfigSettings, this.deleteInsightsConfigSettings, this.listLocationsSettings, this.getLocationSettings);
            Builder.initDefaults(this);
        }

        protected Builder(InsightsConfigServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listInsightsConfigsSettings = settings.listInsightsConfigsSettings.toBuilder();
            this.createInsightsConfigSettings = settings.createInsightsConfigSettings.toBuilder();
            this.createInsightsConfigOperationSettings = settings.createInsightsConfigOperationSettings.toBuilder();
            this.getInsightsConfigSettings = settings.getInsightsConfigSettings.toBuilder();
            this.updateInsightsConfigSettings = settings.updateInsightsConfigSettings.toBuilder();
            this.updateInsightsConfigOperationSettings = settings.updateInsightsConfigOperationSettings.toBuilder();
            this.deleteInsightsConfigSettings = settings.deleteInsightsConfigSettings.toBuilder();
            this.deleteInsightsConfigOperationSettings = settings.deleteInsightsConfigOperationSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listInsightsConfigsSettings, this.createInsightsConfigSettings, this.getInsightsConfigSettings, this.updateInsightsConfigSettings, this.deleteInsightsConfigSettings, this.listLocationsSettings, this.getLocationSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(InsightsConfigServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)InsightsConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InsightsConfigServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InsightsConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)InsightsConfigServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)InsightsConfigServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)InsightsConfigServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(InsightsConfigServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listInsightsConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createInsightsConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getInsightsConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateInsightsConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteInsightsConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createInsightsConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InsightsConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.updateInsightsConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(InsightsConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.deleteInsightsConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListInsightsConfigsRequest, ListInsightsConfigsResponse, InsightsConfigServiceClient.ListInsightsConfigsPagedResponse> listInsightsConfigsSettings() {
            return this.listInsightsConfigsSettings;
        }

        public UnaryCallSettings.Builder<CreateInsightsConfigRequest, Operation> createInsightsConfigSettings() {
            return this.createInsightsConfigSettings;
        }

        public OperationCallSettings.Builder<CreateInsightsConfigRequest, InsightsConfig, OperationMetadata> createInsightsConfigOperationSettings() {
            return this.createInsightsConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<GetInsightsConfigRequest, InsightsConfig> getInsightsConfigSettings() {
            return this.getInsightsConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateInsightsConfigRequest, Operation> updateInsightsConfigSettings() {
            return this.updateInsightsConfigSettings;
        }

        public OperationCallSettings.Builder<UpdateInsightsConfigRequest, InsightsConfig, OperationMetadata> updateInsightsConfigOperationSettings() {
            return this.updateInsightsConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteInsightsConfigRequest, Operation> deleteInsightsConfigSettings() {
            return this.deleteInsightsConfigSettings;
        }

        public OperationCallSettings.Builder<DeleteInsightsConfigRequest, Empty, OperationMetadata> deleteInsightsConfigOperationSettings() {
            return this.deleteInsightsConfigOperationSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, InsightsConfigServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public InsightsConfigServiceStubSettings build() throws IOException {
            return new InsightsConfigServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

