/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerconnect.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.developerconnect.v1.Connection;
import com.google.cloud.developerconnect.v1.CreateConnectionRequest;
import com.google.cloud.developerconnect.v1.CreateGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeleteConnectionRequest;
import com.google.cloud.developerconnect.v1.DeleteGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.DeveloperConnectClient;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsRequest;
import com.google.cloud.developerconnect.v1.FetchGitHubInstallationsResponse;
import com.google.cloud.developerconnect.v1.FetchGitRefsRequest;
import com.google.cloud.developerconnect.v1.FetchGitRefsResponse;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesRequest;
import com.google.cloud.developerconnect.v1.FetchLinkableGitRepositoriesResponse;
import com.google.cloud.developerconnect.v1.FetchReadTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadTokenResponse;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenRequest;
import com.google.cloud.developerconnect.v1.FetchReadWriteTokenResponse;
import com.google.cloud.developerconnect.v1.GetConnectionRequest;
import com.google.cloud.developerconnect.v1.GetGitRepositoryLinkRequest;
import com.google.cloud.developerconnect.v1.GitRepositoryLink;
import com.google.cloud.developerconnect.v1.ListConnectionsRequest;
import com.google.cloud.developerconnect.v1.ListConnectionsResponse;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksRequest;
import com.google.cloud.developerconnect.v1.ListGitRepositoryLinksResponse;
import com.google.cloud.developerconnect.v1.OperationMetadata;
import com.google.cloud.developerconnect.v1.UpdateConnectionRequest;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStub;
import com.google.cloud.developerconnect.v1.stub.DeveloperConnectStubSettings;
import com.google.cloud.developerconnect.v1.stub.GrpcDeveloperConnectCallableFactory;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcDeveloperConnectStub
extends DeveloperConnectStub {
    private static final MethodDescriptor<ListConnectionsRequest, ListConnectionsResponse> listConnectionsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/ListConnections").setRequestMarshaller(ProtoUtils.marshaller((Message)ListConnectionsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListConnectionsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetConnectionRequest, Connection> getConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/GetConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)GetConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Connection.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateConnectionRequest, Operation> createConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/CreateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateConnectionRequest, Operation> updateConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/UpdateConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteConnectionRequest, Operation> deleteConnectionMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/DeleteConnection").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteConnectionRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/CreateGitRepositoryLink").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateGitRepositoryLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/DeleteGitRepositoryLink").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteGitRepositoryLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/ListGitRepositoryLinks").setRequestMarshaller(ProtoUtils.marshaller((Message)ListGitRepositoryLinksRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListGitRepositoryLinksResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/GetGitRepositoryLink").setRequestMarshaller(ProtoUtils.marshaller((Message)GetGitRepositoryLinkRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)GitRepositoryLink.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchReadWriteToken").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchReadWriteTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchReadWriteTokenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchReadToken").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchReadTokenRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchReadTokenResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchLinkableGitRepositories").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchLinkableGitRepositoriesRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchLinkableGitRepositoriesResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchGitHubInstallations").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchGitHubInstallationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchGitHubInstallationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.developerconnect.v1.DeveloperConnect/FetchGitRefs").setRequestMarshaller(ProtoUtils.marshaller((Message)FetchGitRefsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)FetchGitRefsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ListLocationsRequest, ListLocationsResponse> listLocationsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/ListLocations").setRequestMarshaller(ProtoUtils.marshaller((Message)ListLocationsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListLocationsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<GetLocationRequest, Location> getLocationMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.location.Locations/GetLocation").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLocationRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Location.getDefaultInstance())).build();
    private final UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable;
    private final UnaryCallable<ListConnectionsRequest, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsPagedCallable;
    private final UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable;
    private final UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable;
    private final OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable;
    private final UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable;
    private final OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable;
    private final UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable;
    private final OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable;
    private final UnaryCallable<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkCallable;
    private final OperationCallable<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationCallable;
    private final UnaryCallable<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkCallable;
    private final OperationCallable<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationCallable;
    private final UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksCallable;
    private final UnaryCallable<ListGitRepositoryLinksRequest, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksPagedCallable;
    private final UnaryCallable<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkCallable;
    private final UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable;
    private final UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable;
    private final UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesCallable;
    private final UnaryCallable<FetchLinkableGitRepositoriesRequest, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesPagedCallable;
    private final UnaryCallable<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsCallable;
    private final UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable;
    private final UnaryCallable<FetchGitRefsRequest, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsPagedCallable;
    private final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable;
    private final UnaryCallable<ListLocationsRequest, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsPagedCallable;
    private final UnaryCallable<GetLocationRequest, Location> getLocationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcDeveloperConnectStub create(DeveloperConnectStubSettings settings) throws IOException {
        return new GrpcDeveloperConnectStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcDeveloperConnectStub create(ClientContext clientContext) throws IOException {
        return new GrpcDeveloperConnectStub(DeveloperConnectStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcDeveloperConnectStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcDeveloperConnectStub(DeveloperConnectStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcDeveloperConnectStub(DeveloperConnectStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcDeveloperConnectCallableFactory());
    }

    protected GrpcDeveloperConnectStub(DeveloperConnectStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings listConnectionsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listConnectionsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings updateConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection.name", String.valueOf(request.getConnection().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteConnectionTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteConnectionMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings createGitRepositoryLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createGitRepositoryLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings deleteGitRepositoryLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteGitRepositoryLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings listGitRepositoryLinksTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listGitRepositoryLinksMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings getGitRepositoryLinkTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getGitRepositoryLinkMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchReadWriteTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchReadWriteTokenMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchReadTokenTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchReadTokenMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchLinkableGitRepositoriesTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchLinkableGitRepositoriesMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection", String.valueOf(request.getConnection()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchGitHubInstallationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchGitHubInstallationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("connection", String.valueOf(request.getConnection()));
            return builder.build();
        }).build();
        GrpcCallSettings fetchGitRefsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(fetchGitRefsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("git_repository_link", String.valueOf(request.getGitRepositoryLink()));
            return builder.build();
        }).build();
        GrpcCallSettings listLocationsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listLocationsMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings getLocationTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLocationMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.listConnectionsCallable = callableFactory.createUnaryCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.listConnectionsPagedCallable = callableFactory.createPagedCallable(listConnectionsTransportSettings, settings.listConnectionsSettings(), clientContext);
        this.getConnectionCallable = callableFactory.createUnaryCallable(getConnectionTransportSettings, settings.getConnectionSettings(), clientContext);
        this.createConnectionCallable = callableFactory.createUnaryCallable(createConnectionTransportSettings, settings.createConnectionSettings(), clientContext);
        this.createConnectionOperationCallable = callableFactory.createOperationCallable(createConnectionTransportSettings, settings.createConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateConnectionCallable = callableFactory.createUnaryCallable(updateConnectionTransportSettings, settings.updateConnectionSettings(), clientContext);
        this.updateConnectionOperationCallable = callableFactory.createOperationCallable(updateConnectionTransportSettings, settings.updateConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteConnectionCallable = callableFactory.createUnaryCallable(deleteConnectionTransportSettings, settings.deleteConnectionSettings(), clientContext);
        this.deleteConnectionOperationCallable = callableFactory.createOperationCallable(deleteConnectionTransportSettings, settings.deleteConnectionOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.createGitRepositoryLinkCallable = callableFactory.createUnaryCallable(createGitRepositoryLinkTransportSettings, settings.createGitRepositoryLinkSettings(), clientContext);
        this.createGitRepositoryLinkOperationCallable = callableFactory.createOperationCallable(createGitRepositoryLinkTransportSettings, settings.createGitRepositoryLinkOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteGitRepositoryLinkCallable = callableFactory.createUnaryCallable(deleteGitRepositoryLinkTransportSettings, settings.deleteGitRepositoryLinkSettings(), clientContext);
        this.deleteGitRepositoryLinkOperationCallable = callableFactory.createOperationCallable(deleteGitRepositoryLinkTransportSettings, settings.deleteGitRepositoryLinkOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.listGitRepositoryLinksCallable = callableFactory.createUnaryCallable(listGitRepositoryLinksTransportSettings, settings.listGitRepositoryLinksSettings(), clientContext);
        this.listGitRepositoryLinksPagedCallable = callableFactory.createPagedCallable(listGitRepositoryLinksTransportSettings, settings.listGitRepositoryLinksSettings(), clientContext);
        this.getGitRepositoryLinkCallable = callableFactory.createUnaryCallable(getGitRepositoryLinkTransportSettings, settings.getGitRepositoryLinkSettings(), clientContext);
        this.fetchReadWriteTokenCallable = callableFactory.createUnaryCallable(fetchReadWriteTokenTransportSettings, settings.fetchReadWriteTokenSettings(), clientContext);
        this.fetchReadTokenCallable = callableFactory.createUnaryCallable(fetchReadTokenTransportSettings, settings.fetchReadTokenSettings(), clientContext);
        this.fetchLinkableGitRepositoriesCallable = callableFactory.createUnaryCallable(fetchLinkableGitRepositoriesTransportSettings, settings.fetchLinkableGitRepositoriesSettings(), clientContext);
        this.fetchLinkableGitRepositoriesPagedCallable = callableFactory.createPagedCallable(fetchLinkableGitRepositoriesTransportSettings, settings.fetchLinkableGitRepositoriesSettings(), clientContext);
        this.fetchGitHubInstallationsCallable = callableFactory.createUnaryCallable(fetchGitHubInstallationsTransportSettings, settings.fetchGitHubInstallationsSettings(), clientContext);
        this.fetchGitRefsCallable = callableFactory.createUnaryCallable(fetchGitRefsTransportSettings, settings.fetchGitRefsSettings(), clientContext);
        this.fetchGitRefsPagedCallable = callableFactory.createPagedCallable(fetchGitRefsTransportSettings, settings.fetchGitRefsSettings(), clientContext);
        this.listLocationsCallable = callableFactory.createUnaryCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.listLocationsPagedCallable = callableFactory.createPagedCallable(listLocationsTransportSettings, settings.listLocationsSettings(), clientContext);
        this.getLocationCallable = callableFactory.createUnaryCallable(getLocationTransportSettings, settings.getLocationSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> listConnectionsCallable() {
        return this.listConnectionsCallable;
    }

    @Override
    public UnaryCallable<ListConnectionsRequest, DeveloperConnectClient.ListConnectionsPagedResponse> listConnectionsPagedCallable() {
        return this.listConnectionsPagedCallable;
    }

    @Override
    public UnaryCallable<GetConnectionRequest, Connection> getConnectionCallable() {
        return this.getConnectionCallable;
    }

    @Override
    public UnaryCallable<CreateConnectionRequest, Operation> createConnectionCallable() {
        return this.createConnectionCallable;
    }

    @Override
    public OperationCallable<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationCallable() {
        return this.createConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateConnectionRequest, Operation> updateConnectionCallable() {
        return this.updateConnectionCallable;
    }

    @Override
    public OperationCallable<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationCallable() {
        return this.updateConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteConnectionRequest, Operation> deleteConnectionCallable() {
        return this.deleteConnectionCallable;
    }

    @Override
    public OperationCallable<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationCallable() {
        return this.deleteConnectionOperationCallable;
    }

    @Override
    public UnaryCallable<CreateGitRepositoryLinkRequest, Operation> createGitRepositoryLinkCallable() {
        return this.createGitRepositoryLinkCallable;
    }

    @Override
    public OperationCallable<CreateGitRepositoryLinkRequest, GitRepositoryLink, OperationMetadata> createGitRepositoryLinkOperationCallable() {
        return this.createGitRepositoryLinkOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteGitRepositoryLinkRequest, Operation> deleteGitRepositoryLinkCallable() {
        return this.deleteGitRepositoryLinkCallable;
    }

    @Override
    public OperationCallable<DeleteGitRepositoryLinkRequest, Empty, OperationMetadata> deleteGitRepositoryLinkOperationCallable() {
        return this.deleteGitRepositoryLinkOperationCallable;
    }

    @Override
    public UnaryCallable<ListGitRepositoryLinksRequest, ListGitRepositoryLinksResponse> listGitRepositoryLinksCallable() {
        return this.listGitRepositoryLinksCallable;
    }

    @Override
    public UnaryCallable<ListGitRepositoryLinksRequest, DeveloperConnectClient.ListGitRepositoryLinksPagedResponse> listGitRepositoryLinksPagedCallable() {
        return this.listGitRepositoryLinksPagedCallable;
    }

    @Override
    public UnaryCallable<GetGitRepositoryLinkRequest, GitRepositoryLink> getGitRepositoryLinkCallable() {
        return this.getGitRepositoryLinkCallable;
    }

    @Override
    public UnaryCallable<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenCallable() {
        return this.fetchReadWriteTokenCallable;
    }

    @Override
    public UnaryCallable<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenCallable() {
        return this.fetchReadTokenCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableGitRepositoriesRequest, FetchLinkableGitRepositoriesResponse> fetchLinkableGitRepositoriesCallable() {
        return this.fetchLinkableGitRepositoriesCallable;
    }

    @Override
    public UnaryCallable<FetchLinkableGitRepositoriesRequest, DeveloperConnectClient.FetchLinkableGitRepositoriesPagedResponse> fetchLinkableGitRepositoriesPagedCallable() {
        return this.fetchLinkableGitRepositoriesPagedCallable;
    }

    @Override
    public UnaryCallable<FetchGitHubInstallationsRequest, FetchGitHubInstallationsResponse> fetchGitHubInstallationsCallable() {
        return this.fetchGitHubInstallationsCallable;
    }

    @Override
    public UnaryCallable<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsCallable() {
        return this.fetchGitRefsCallable;
    }

    @Override
    public UnaryCallable<FetchGitRefsRequest, DeveloperConnectClient.FetchGitRefsPagedResponse> fetchGitRefsPagedCallable() {
        return this.fetchGitRefsPagedCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.listLocationsCallable;
    }

    @Override
    public UnaryCallable<ListLocationsRequest, DeveloperConnectClient.ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.listLocationsPagedCallable;
    }

    @Override
    public UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.getLocationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

