/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.deploy.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.deploy.v1.AbandonReleaseRequest;
import com.google.cloud.deploy.v1.AbandonReleaseResponse;
import com.google.cloud.deploy.v1.AdvanceRolloutRequest;
import com.google.cloud.deploy.v1.AdvanceRolloutResponse;
import com.google.cloud.deploy.v1.ApproveRolloutRequest;
import com.google.cloud.deploy.v1.ApproveRolloutResponse;
import com.google.cloud.deploy.v1.Automation;
import com.google.cloud.deploy.v1.AutomationName;
import com.google.cloud.deploy.v1.AutomationRun;
import com.google.cloud.deploy.v1.AutomationRunName;
import com.google.cloud.deploy.v1.CancelAutomationRunRequest;
import com.google.cloud.deploy.v1.CancelAutomationRunResponse;
import com.google.cloud.deploy.v1.CancelRolloutRequest;
import com.google.cloud.deploy.v1.CancelRolloutResponse;
import com.google.cloud.deploy.v1.CloudDeploySettings;
import com.google.cloud.deploy.v1.Config;
import com.google.cloud.deploy.v1.ConfigName;
import com.google.cloud.deploy.v1.CreateAutomationRequest;
import com.google.cloud.deploy.v1.CreateCustomTargetTypeRequest;
import com.google.cloud.deploy.v1.CreateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.CreateReleaseRequest;
import com.google.cloud.deploy.v1.CreateRolloutRequest;
import com.google.cloud.deploy.v1.CreateTargetRequest;
import com.google.cloud.deploy.v1.CustomTargetType;
import com.google.cloud.deploy.v1.CustomTargetTypeName;
import com.google.cloud.deploy.v1.DeleteAutomationRequest;
import com.google.cloud.deploy.v1.DeleteCustomTargetTypeRequest;
import com.google.cloud.deploy.v1.DeleteDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.DeleteTargetRequest;
import com.google.cloud.deploy.v1.DeliveryPipeline;
import com.google.cloud.deploy.v1.DeliveryPipelineName;
import com.google.cloud.deploy.v1.GetAutomationRequest;
import com.google.cloud.deploy.v1.GetAutomationRunRequest;
import com.google.cloud.deploy.v1.GetConfigRequest;
import com.google.cloud.deploy.v1.GetCustomTargetTypeRequest;
import com.google.cloud.deploy.v1.GetDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.GetJobRunRequest;
import com.google.cloud.deploy.v1.GetReleaseRequest;
import com.google.cloud.deploy.v1.GetRolloutRequest;
import com.google.cloud.deploy.v1.GetTargetRequest;
import com.google.cloud.deploy.v1.IgnoreJobRequest;
import com.google.cloud.deploy.v1.IgnoreJobResponse;
import com.google.cloud.deploy.v1.JobRun;
import com.google.cloud.deploy.v1.JobRunName;
import com.google.cloud.deploy.v1.ListAutomationRunsRequest;
import com.google.cloud.deploy.v1.ListAutomationRunsResponse;
import com.google.cloud.deploy.v1.ListAutomationsRequest;
import com.google.cloud.deploy.v1.ListAutomationsResponse;
import com.google.cloud.deploy.v1.ListCustomTargetTypesRequest;
import com.google.cloud.deploy.v1.ListCustomTargetTypesResponse;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesRequest;
import com.google.cloud.deploy.v1.ListDeliveryPipelinesResponse;
import com.google.cloud.deploy.v1.ListJobRunsRequest;
import com.google.cloud.deploy.v1.ListJobRunsResponse;
import com.google.cloud.deploy.v1.ListReleasesRequest;
import com.google.cloud.deploy.v1.ListReleasesResponse;
import com.google.cloud.deploy.v1.ListRolloutsRequest;
import com.google.cloud.deploy.v1.ListRolloutsResponse;
import com.google.cloud.deploy.v1.ListTargetsRequest;
import com.google.cloud.deploy.v1.ListTargetsResponse;
import com.google.cloud.deploy.v1.LocationName;
import com.google.cloud.deploy.v1.OperationMetadata;
import com.google.cloud.deploy.v1.Release;
import com.google.cloud.deploy.v1.ReleaseName;
import com.google.cloud.deploy.v1.RetryJobRequest;
import com.google.cloud.deploy.v1.RetryJobResponse;
import com.google.cloud.deploy.v1.RollbackTargetRequest;
import com.google.cloud.deploy.v1.RollbackTargetResponse;
import com.google.cloud.deploy.v1.Rollout;
import com.google.cloud.deploy.v1.RolloutName;
import com.google.cloud.deploy.v1.Target;
import com.google.cloud.deploy.v1.TargetName;
import com.google.cloud.deploy.v1.TerminateJobRunRequest;
import com.google.cloud.deploy.v1.TerminateJobRunResponse;
import com.google.cloud.deploy.v1.UpdateAutomationRequest;
import com.google.cloud.deploy.v1.UpdateCustomTargetTypeRequest;
import com.google.cloud.deploy.v1.UpdateDeliveryPipelineRequest;
import com.google.cloud.deploy.v1.UpdateTargetRequest;
import com.google.cloud.deploy.v1.stub.CloudDeployStub;
import com.google.cloud.deploy.v1.stub.CloudDeployStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudDeployClient
implements BackgroundResource {
    private final CloudDeploySettings settings;
    private final CloudDeployStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final CloudDeployClient create() throws IOException {
        return CloudDeployClient.create(CloudDeploySettings.newBuilder().build());
    }

    public static final CloudDeployClient create(CloudDeploySettings settings) throws IOException {
        return new CloudDeployClient(settings);
    }

    public static final CloudDeployClient create(CloudDeployStub stub) {
        return new CloudDeployClient(stub);
    }

    protected CloudDeployClient(CloudDeploySettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudDeployStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected CloudDeployClient(CloudDeployStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final CloudDeploySettings getSettings() {
        return this.settings;
    }

    public CloudDeployStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(LocationName parent) {
        ListDeliveryPipelinesRequest request = ListDeliveryPipelinesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDeliveryPipelines(request);
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(String parent) {
        ListDeliveryPipelinesRequest request = ListDeliveryPipelinesRequest.newBuilder().setParent(parent).build();
        return this.listDeliveryPipelines(request);
    }

    public final ListDeliveryPipelinesPagedResponse listDeliveryPipelines(ListDeliveryPipelinesRequest request) {
        return (ListDeliveryPipelinesPagedResponse)((Object)this.listDeliveryPipelinesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDeliveryPipelinesRequest, ListDeliveryPipelinesPagedResponse> listDeliveryPipelinesPagedCallable() {
        return this.stub.listDeliveryPipelinesPagedCallable();
    }

    public final UnaryCallable<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse> listDeliveryPipelinesCallable() {
        return this.stub.listDeliveryPipelinesCallable();
    }

    public final DeliveryPipeline getDeliveryPipeline(DeliveryPipelineName name) {
        GetDeliveryPipelineRequest request = GetDeliveryPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDeliveryPipeline(request);
    }

    public final DeliveryPipeline getDeliveryPipeline(String name) {
        GetDeliveryPipelineRequest request = GetDeliveryPipelineRequest.newBuilder().setName(name).build();
        return this.getDeliveryPipeline(request);
    }

    public final DeliveryPipeline getDeliveryPipeline(GetDeliveryPipelineRequest request) {
        return (DeliveryPipeline)this.getDeliveryPipelineCallable().call((Object)request);
    }

    public final UnaryCallable<GetDeliveryPipelineRequest, DeliveryPipeline> getDeliveryPipelineCallable() {
        return this.stub.getDeliveryPipelineCallable();
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(LocationName parent, DeliveryPipeline deliveryPipeline, String deliveryPipelineId) {
        CreateDeliveryPipelineRequest request = CreateDeliveryPipelineRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDeliveryPipeline(deliveryPipeline).setDeliveryPipelineId(deliveryPipelineId).build();
        return this.createDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(String parent, DeliveryPipeline deliveryPipeline, String deliveryPipelineId) {
        CreateDeliveryPipelineRequest request = CreateDeliveryPipelineRequest.newBuilder().setParent(parent).setDeliveryPipeline(deliveryPipeline).setDeliveryPipelineId(deliveryPipelineId).build();
        return this.createDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> createDeliveryPipelineAsync(CreateDeliveryPipelineRequest request) {
        return this.createDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> createDeliveryPipelineOperationCallable() {
        return this.stub.createDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<CreateDeliveryPipelineRequest, Operation> createDeliveryPipelineCallable() {
        return this.stub.createDeliveryPipelineCallable();
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> updateDeliveryPipelineAsync(DeliveryPipeline deliveryPipeline, FieldMask updateMask) {
        UpdateDeliveryPipelineRequest request = UpdateDeliveryPipelineRequest.newBuilder().setDeliveryPipeline(deliveryPipeline).setUpdateMask(updateMask).build();
        return this.updateDeliveryPipelineAsync(request);
    }

    public final OperationFuture<DeliveryPipeline, OperationMetadata> updateDeliveryPipelineAsync(UpdateDeliveryPipelineRequest request) {
        return this.updateDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateDeliveryPipelineRequest, DeliveryPipeline, OperationMetadata> updateDeliveryPipelineOperationCallable() {
        return this.stub.updateDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<UpdateDeliveryPipelineRequest, Operation> updateDeliveryPipelineCallable() {
        return this.stub.updateDeliveryPipelineCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(DeliveryPipelineName name) {
        DeleteDeliveryPipelineRequest request = DeleteDeliveryPipelineRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteDeliveryPipelineAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(String name) {
        DeleteDeliveryPipelineRequest request = DeleteDeliveryPipelineRequest.newBuilder().setName(name).build();
        return this.deleteDeliveryPipelineAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteDeliveryPipelineAsync(DeleteDeliveryPipelineRequest request) {
        return this.deleteDeliveryPipelineOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteDeliveryPipelineRequest, Empty, OperationMetadata> deleteDeliveryPipelineOperationCallable() {
        return this.stub.deleteDeliveryPipelineOperationCallable();
    }

    public final UnaryCallable<DeleteDeliveryPipelineRequest, Operation> deleteDeliveryPipelineCallable() {
        return this.stub.deleteDeliveryPipelineCallable();
    }

    public final ListTargetsPagedResponse listTargets(LocationName parent) {
        ListTargetsRequest request = ListTargetsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listTargets(request);
    }

    public final ListTargetsPagedResponse listTargets(String parent) {
        ListTargetsRequest request = ListTargetsRequest.newBuilder().setParent(parent).build();
        return this.listTargets(request);
    }

    public final ListTargetsPagedResponse listTargets(ListTargetsRequest request) {
        return (ListTargetsPagedResponse)((Object)this.listTargetsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListTargetsRequest, ListTargetsPagedResponse> listTargetsPagedCallable() {
        return this.stub.listTargetsPagedCallable();
    }

    public final UnaryCallable<ListTargetsRequest, ListTargetsResponse> listTargetsCallable() {
        return this.stub.listTargetsCallable();
    }

    public final RollbackTargetResponse rollbackTarget(DeliveryPipelineName name, String targetId, String rolloutId) {
        RollbackTargetRequest request = RollbackTargetRequest.newBuilder().setName(name == null ? null : name.toString()).setTargetId(targetId).setRolloutId(rolloutId).build();
        return this.rollbackTarget(request);
    }

    public final RollbackTargetResponse rollbackTarget(String name, String targetId, String rolloutId) {
        RollbackTargetRequest request = RollbackTargetRequest.newBuilder().setName(name).setTargetId(targetId).setRolloutId(rolloutId).build();
        return this.rollbackTarget(request);
    }

    public final RollbackTargetResponse rollbackTarget(RollbackTargetRequest request) {
        return (RollbackTargetResponse)this.rollbackTargetCallable().call((Object)request);
    }

    public final UnaryCallable<RollbackTargetRequest, RollbackTargetResponse> rollbackTargetCallable() {
        return this.stub.rollbackTargetCallable();
    }

    public final Target getTarget(TargetName name) {
        GetTargetRequest request = GetTargetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getTarget(request);
    }

    public final Target getTarget(String name) {
        GetTargetRequest request = GetTargetRequest.newBuilder().setName(name).build();
        return this.getTarget(request);
    }

    public final Target getTarget(GetTargetRequest request) {
        return (Target)this.getTargetCallable().call((Object)request);
    }

    public final UnaryCallable<GetTargetRequest, Target> getTargetCallable() {
        return this.stub.getTargetCallable();
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(LocationName parent, Target target, String targetId) {
        CreateTargetRequest request = CreateTargetRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setTarget(target).setTargetId(targetId).build();
        return this.createTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(String parent, Target target, String targetId) {
        CreateTargetRequest request = CreateTargetRequest.newBuilder().setParent(parent).setTarget(target).setTargetId(targetId).build();
        return this.createTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> createTargetAsync(CreateTargetRequest request) {
        return this.createTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateTargetRequest, Target, OperationMetadata> createTargetOperationCallable() {
        return this.stub.createTargetOperationCallable();
    }

    public final UnaryCallable<CreateTargetRequest, Operation> createTargetCallable() {
        return this.stub.createTargetCallable();
    }

    public final OperationFuture<Target, OperationMetadata> updateTargetAsync(Target target, FieldMask updateMask) {
        UpdateTargetRequest request = UpdateTargetRequest.newBuilder().setTarget(target).setUpdateMask(updateMask).build();
        return this.updateTargetAsync(request);
    }

    public final OperationFuture<Target, OperationMetadata> updateTargetAsync(UpdateTargetRequest request) {
        return this.updateTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateTargetRequest, Target, OperationMetadata> updateTargetOperationCallable() {
        return this.stub.updateTargetOperationCallable();
    }

    public final UnaryCallable<UpdateTargetRequest, Operation> updateTargetCallable() {
        return this.stub.updateTargetCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(TargetName name) {
        DeleteTargetRequest request = DeleteTargetRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteTargetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(String name) {
        DeleteTargetRequest request = DeleteTargetRequest.newBuilder().setName(name).build();
        return this.deleteTargetAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteTargetAsync(DeleteTargetRequest request) {
        return this.deleteTargetOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteTargetRequest, Empty, OperationMetadata> deleteTargetOperationCallable() {
        return this.stub.deleteTargetOperationCallable();
    }

    public final UnaryCallable<DeleteTargetRequest, Operation> deleteTargetCallable() {
        return this.stub.deleteTargetCallable();
    }

    public final ListCustomTargetTypesPagedResponse listCustomTargetTypes(LocationName parent) {
        ListCustomTargetTypesRequest request = ListCustomTargetTypesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomTargetTypes(request);
    }

    public final ListCustomTargetTypesPagedResponse listCustomTargetTypes(String parent) {
        ListCustomTargetTypesRequest request = ListCustomTargetTypesRequest.newBuilder().setParent(parent).build();
        return this.listCustomTargetTypes(request);
    }

    public final ListCustomTargetTypesPagedResponse listCustomTargetTypes(ListCustomTargetTypesRequest request) {
        return (ListCustomTargetTypesPagedResponse)((Object)this.listCustomTargetTypesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomTargetTypesRequest, ListCustomTargetTypesPagedResponse> listCustomTargetTypesPagedCallable() {
        return this.stub.listCustomTargetTypesPagedCallable();
    }

    public final UnaryCallable<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse> listCustomTargetTypesCallable() {
        return this.stub.listCustomTargetTypesCallable();
    }

    public final CustomTargetType getCustomTargetType(CustomTargetTypeName name) {
        GetCustomTargetTypeRequest request = GetCustomTargetTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomTargetType(request);
    }

    public final CustomTargetType getCustomTargetType(String name) {
        GetCustomTargetTypeRequest request = GetCustomTargetTypeRequest.newBuilder().setName(name).build();
        return this.getCustomTargetType(request);
    }

    public final CustomTargetType getCustomTargetType(GetCustomTargetTypeRequest request) {
        return (CustomTargetType)this.getCustomTargetTypeCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomTargetTypeRequest, CustomTargetType> getCustomTargetTypeCallable() {
        return this.stub.getCustomTargetTypeCallable();
    }

    public final OperationFuture<CustomTargetType, OperationMetadata> createCustomTargetTypeAsync(LocationName parent, CustomTargetType customTargetType, String customTargetTypeId) {
        CreateCustomTargetTypeRequest request = CreateCustomTargetTypeRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomTargetType(customTargetType).setCustomTargetTypeId(customTargetTypeId).build();
        return this.createCustomTargetTypeAsync(request);
    }

    public final OperationFuture<CustomTargetType, OperationMetadata> createCustomTargetTypeAsync(String parent, CustomTargetType customTargetType, String customTargetTypeId) {
        CreateCustomTargetTypeRequest request = CreateCustomTargetTypeRequest.newBuilder().setParent(parent).setCustomTargetType(customTargetType).setCustomTargetTypeId(customTargetTypeId).build();
        return this.createCustomTargetTypeAsync(request);
    }

    public final OperationFuture<CustomTargetType, OperationMetadata> createCustomTargetTypeAsync(CreateCustomTargetTypeRequest request) {
        return this.createCustomTargetTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateCustomTargetTypeRequest, CustomTargetType, OperationMetadata> createCustomTargetTypeOperationCallable() {
        return this.stub.createCustomTargetTypeOperationCallable();
    }

    public final UnaryCallable<CreateCustomTargetTypeRequest, Operation> createCustomTargetTypeCallable() {
        return this.stub.createCustomTargetTypeCallable();
    }

    public final OperationFuture<CustomTargetType, OperationMetadata> updateCustomTargetTypeAsync(CustomTargetType customTargetType, FieldMask updateMask) {
        UpdateCustomTargetTypeRequest request = UpdateCustomTargetTypeRequest.newBuilder().setCustomTargetType(customTargetType).setUpdateMask(updateMask).build();
        return this.updateCustomTargetTypeAsync(request);
    }

    public final OperationFuture<CustomTargetType, OperationMetadata> updateCustomTargetTypeAsync(UpdateCustomTargetTypeRequest request) {
        return this.updateCustomTargetTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateCustomTargetTypeRequest, CustomTargetType, OperationMetadata> updateCustomTargetTypeOperationCallable() {
        return this.stub.updateCustomTargetTypeOperationCallable();
    }

    public final UnaryCallable<UpdateCustomTargetTypeRequest, Operation> updateCustomTargetTypeCallable() {
        return this.stub.updateCustomTargetTypeCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCustomTargetTypeAsync(CustomTargetTypeName name) {
        DeleteCustomTargetTypeRequest request = DeleteCustomTargetTypeRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteCustomTargetTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCustomTargetTypeAsync(String name) {
        DeleteCustomTargetTypeRequest request = DeleteCustomTargetTypeRequest.newBuilder().setName(name).build();
        return this.deleteCustomTargetTypeAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteCustomTargetTypeAsync(DeleteCustomTargetTypeRequest request) {
        return this.deleteCustomTargetTypeOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteCustomTargetTypeRequest, Empty, OperationMetadata> deleteCustomTargetTypeOperationCallable() {
        return this.stub.deleteCustomTargetTypeOperationCallable();
    }

    public final UnaryCallable<DeleteCustomTargetTypeRequest, Operation> deleteCustomTargetTypeCallable() {
        return this.stub.deleteCustomTargetTypeCallable();
    }

    public final ListReleasesPagedResponse listReleases(DeliveryPipelineName parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(String parent) {
        ListReleasesRequest request = ListReleasesRequest.newBuilder().setParent(parent).build();
        return this.listReleases(request);
    }

    public final ListReleasesPagedResponse listReleases(ListReleasesRequest request) {
        return (ListReleasesPagedResponse)((Object)this.listReleasesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesPagedResponse> listReleasesPagedCallable() {
        return this.stub.listReleasesPagedCallable();
    }

    public final UnaryCallable<ListReleasesRequest, ListReleasesResponse> listReleasesCallable() {
        return this.stub.listReleasesCallable();
    }

    public final Release getRelease(ReleaseName name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRelease(request);
    }

    public final Release getRelease(String name) {
        GetReleaseRequest request = GetReleaseRequest.newBuilder().setName(name).build();
        return this.getRelease(request);
    }

    public final Release getRelease(GetReleaseRequest request) {
        return (Release)this.getReleaseCallable().call((Object)request);
    }

    public final UnaryCallable<GetReleaseRequest, Release> getReleaseCallable() {
        return this.stub.getReleaseCallable();
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(DeliveryPipelineName parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(String parent, Release release, String releaseId) {
        CreateReleaseRequest request = CreateReleaseRequest.newBuilder().setParent(parent).setRelease(release).setReleaseId(releaseId).build();
        return this.createReleaseAsync(request);
    }

    public final OperationFuture<Release, OperationMetadata> createReleaseAsync(CreateReleaseRequest request) {
        return this.createReleaseOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateReleaseRequest, Release, OperationMetadata> createReleaseOperationCallable() {
        return this.stub.createReleaseOperationCallable();
    }

    public final UnaryCallable<CreateReleaseRequest, Operation> createReleaseCallable() {
        return this.stub.createReleaseCallable();
    }

    public final AbandonReleaseResponse abandonRelease(ReleaseName name) {
        AbandonReleaseRequest request = AbandonReleaseRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.abandonRelease(request);
    }

    public final AbandonReleaseResponse abandonRelease(String name) {
        AbandonReleaseRequest request = AbandonReleaseRequest.newBuilder().setName(name).build();
        return this.abandonRelease(request);
    }

    public final AbandonReleaseResponse abandonRelease(AbandonReleaseRequest request) {
        return (AbandonReleaseResponse)this.abandonReleaseCallable().call((Object)request);
    }

    public final UnaryCallable<AbandonReleaseRequest, AbandonReleaseResponse> abandonReleaseCallable() {
        return this.stub.abandonReleaseCallable();
    }

    public final ApproveRolloutResponse approveRollout(RolloutName name) {
        ApproveRolloutRequest request = ApproveRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.approveRollout(request);
    }

    public final ApproveRolloutResponse approveRollout(String name) {
        ApproveRolloutRequest request = ApproveRolloutRequest.newBuilder().setName(name).build();
        return this.approveRollout(request);
    }

    public final ApproveRolloutResponse approveRollout(ApproveRolloutRequest request) {
        return (ApproveRolloutResponse)this.approveRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<ApproveRolloutRequest, ApproveRolloutResponse> approveRolloutCallable() {
        return this.stub.approveRolloutCallable();
    }

    public final AdvanceRolloutResponse advanceRollout(RolloutName name, String phaseId) {
        AdvanceRolloutRequest request = AdvanceRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).setPhaseId(phaseId).build();
        return this.advanceRollout(request);
    }

    public final AdvanceRolloutResponse advanceRollout(String name, String phaseId) {
        AdvanceRolloutRequest request = AdvanceRolloutRequest.newBuilder().setName(name).setPhaseId(phaseId).build();
        return this.advanceRollout(request);
    }

    public final AdvanceRolloutResponse advanceRollout(AdvanceRolloutRequest request) {
        return (AdvanceRolloutResponse)this.advanceRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<AdvanceRolloutRequest, AdvanceRolloutResponse> advanceRolloutCallable() {
        return this.stub.advanceRolloutCallable();
    }

    public final CancelRolloutResponse cancelRollout(RolloutName name) {
        CancelRolloutRequest request = CancelRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelRollout(request);
    }

    public final CancelRolloutResponse cancelRollout(String name) {
        CancelRolloutRequest request = CancelRolloutRequest.newBuilder().setName(name).build();
        return this.cancelRollout(request);
    }

    public final CancelRolloutResponse cancelRollout(CancelRolloutRequest request) {
        return (CancelRolloutResponse)this.cancelRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<CancelRolloutRequest, CancelRolloutResponse> cancelRolloutCallable() {
        return this.stub.cancelRolloutCallable();
    }

    public final ListRolloutsPagedResponse listRollouts(ReleaseName parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(String parent) {
        ListRolloutsRequest request = ListRolloutsRequest.newBuilder().setParent(parent).build();
        return this.listRollouts(request);
    }

    public final ListRolloutsPagedResponse listRollouts(ListRolloutsRequest request) {
        return (ListRolloutsPagedResponse)((Object)this.listRolloutsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsPagedResponse> listRolloutsPagedCallable() {
        return this.stub.listRolloutsPagedCallable();
    }

    public final UnaryCallable<ListRolloutsRequest, ListRolloutsResponse> listRolloutsCallable() {
        return this.stub.listRolloutsCallable();
    }

    public final Rollout getRollout(RolloutName name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(String name) {
        GetRolloutRequest request = GetRolloutRequest.newBuilder().setName(name).build();
        return this.getRollout(request);
    }

    public final Rollout getRollout(GetRolloutRequest request) {
        return (Rollout)this.getRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<GetRolloutRequest, Rollout> getRolloutCallable() {
        return this.stub.getRolloutCallable();
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(ReleaseName parent, Rollout rollout, String rolloutId) {
        CreateRolloutRequest request = CreateRolloutRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRollout(rollout).setRolloutId(rolloutId).build();
        return this.createRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(String parent, Rollout rollout, String rolloutId) {
        CreateRolloutRequest request = CreateRolloutRequest.newBuilder().setParent(parent).setRollout(rollout).setRolloutId(rolloutId).build();
        return this.createRolloutAsync(request);
    }

    public final OperationFuture<Rollout, OperationMetadata> createRolloutAsync(CreateRolloutRequest request) {
        return this.createRolloutOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateRolloutRequest, Rollout, OperationMetadata> createRolloutOperationCallable() {
        return this.stub.createRolloutOperationCallable();
    }

    public final UnaryCallable<CreateRolloutRequest, Operation> createRolloutCallable() {
        return this.stub.createRolloutCallable();
    }

    public final IgnoreJobResponse ignoreJob(RolloutName rollout, String phaseId, String jobId) {
        IgnoreJobRequest request = IgnoreJobRequest.newBuilder().setRollout(rollout == null ? null : rollout.toString()).setPhaseId(phaseId).setJobId(jobId).build();
        return this.ignoreJob(request);
    }

    public final IgnoreJobResponse ignoreJob(String rollout, String phaseId, String jobId) {
        IgnoreJobRequest request = IgnoreJobRequest.newBuilder().setRollout(rollout).setPhaseId(phaseId).setJobId(jobId).build();
        return this.ignoreJob(request);
    }

    public final IgnoreJobResponse ignoreJob(IgnoreJobRequest request) {
        return (IgnoreJobResponse)this.ignoreJobCallable().call((Object)request);
    }

    public final UnaryCallable<IgnoreJobRequest, IgnoreJobResponse> ignoreJobCallable() {
        return this.stub.ignoreJobCallable();
    }

    public final RetryJobResponse retryJob(RolloutName rollout, String phaseId, String jobId) {
        RetryJobRequest request = RetryJobRequest.newBuilder().setRollout(rollout == null ? null : rollout.toString()).setPhaseId(phaseId).setJobId(jobId).build();
        return this.retryJob(request);
    }

    public final RetryJobResponse retryJob(String rollout, String phaseId, String jobId) {
        RetryJobRequest request = RetryJobRequest.newBuilder().setRollout(rollout).setPhaseId(phaseId).setJobId(jobId).build();
        return this.retryJob(request);
    }

    public final RetryJobResponse retryJob(RetryJobRequest request) {
        return (RetryJobResponse)this.retryJobCallable().call((Object)request);
    }

    public final UnaryCallable<RetryJobRequest, RetryJobResponse> retryJobCallable() {
        return this.stub.retryJobCallable();
    }

    public final ListJobRunsPagedResponse listJobRuns(RolloutName parent) {
        ListJobRunsRequest request = ListJobRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listJobRuns(request);
    }

    public final ListJobRunsPagedResponse listJobRuns(String parent) {
        ListJobRunsRequest request = ListJobRunsRequest.newBuilder().setParent(parent).build();
        return this.listJobRuns(request);
    }

    public final ListJobRunsPagedResponse listJobRuns(ListJobRunsRequest request) {
        return (ListJobRunsPagedResponse)((Object)this.listJobRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListJobRunsRequest, ListJobRunsPagedResponse> listJobRunsPagedCallable() {
        return this.stub.listJobRunsPagedCallable();
    }

    public final UnaryCallable<ListJobRunsRequest, ListJobRunsResponse> listJobRunsCallable() {
        return this.stub.listJobRunsCallable();
    }

    public final JobRun getJobRun(JobRunName name) {
        GetJobRunRequest request = GetJobRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getJobRun(request);
    }

    public final JobRun getJobRun(String name) {
        GetJobRunRequest request = GetJobRunRequest.newBuilder().setName(name).build();
        return this.getJobRun(request);
    }

    public final JobRun getJobRun(GetJobRunRequest request) {
        return (JobRun)this.getJobRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetJobRunRequest, JobRun> getJobRunCallable() {
        return this.stub.getJobRunCallable();
    }

    public final TerminateJobRunResponse terminateJobRun(JobRunName name) {
        TerminateJobRunRequest request = TerminateJobRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.terminateJobRun(request);
    }

    public final TerminateJobRunResponse terminateJobRun(String name) {
        TerminateJobRunRequest request = TerminateJobRunRequest.newBuilder().setName(name).build();
        return this.terminateJobRun(request);
    }

    public final TerminateJobRunResponse terminateJobRun(TerminateJobRunRequest request) {
        return (TerminateJobRunResponse)this.terminateJobRunCallable().call((Object)request);
    }

    public final UnaryCallable<TerminateJobRunRequest, TerminateJobRunResponse> terminateJobRunCallable() {
        return this.stub.terminateJobRunCallable();
    }

    public final Config getConfig(ConfigName name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getConfig(request);
    }

    public final Config getConfig(String name) {
        GetConfigRequest request = GetConfigRequest.newBuilder().setName(name).build();
        return this.getConfig(request);
    }

    public final Config getConfig(GetConfigRequest request) {
        return (Config)this.getConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetConfigRequest, Config> getConfigCallable() {
        return this.stub.getConfigCallable();
    }

    public final OperationFuture<Automation, OperationMetadata> createAutomationAsync(DeliveryPipelineName parent, Automation automation, String automationId) {
        CreateAutomationRequest request = CreateAutomationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAutomation(automation).setAutomationId(automationId).build();
        return this.createAutomationAsync(request);
    }

    public final OperationFuture<Automation, OperationMetadata> createAutomationAsync(String parent, Automation automation, String automationId) {
        CreateAutomationRequest request = CreateAutomationRequest.newBuilder().setParent(parent).setAutomation(automation).setAutomationId(automationId).build();
        return this.createAutomationAsync(request);
    }

    public final OperationFuture<Automation, OperationMetadata> createAutomationAsync(CreateAutomationRequest request) {
        return this.createAutomationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateAutomationRequest, Automation, OperationMetadata> createAutomationOperationCallable() {
        return this.stub.createAutomationOperationCallable();
    }

    public final UnaryCallable<CreateAutomationRequest, Operation> createAutomationCallable() {
        return this.stub.createAutomationCallable();
    }

    public final OperationFuture<Automation, OperationMetadata> updateAutomationAsync(Automation automation, FieldMask updateMask) {
        UpdateAutomationRequest request = UpdateAutomationRequest.newBuilder().setAutomation(automation).setUpdateMask(updateMask).build();
        return this.updateAutomationAsync(request);
    }

    public final OperationFuture<Automation, OperationMetadata> updateAutomationAsync(UpdateAutomationRequest request) {
        return this.updateAutomationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateAutomationRequest, Automation, OperationMetadata> updateAutomationOperationCallable() {
        return this.stub.updateAutomationOperationCallable();
    }

    public final UnaryCallable<UpdateAutomationRequest, Operation> updateAutomationCallable() {
        return this.stub.updateAutomationCallable();
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutomationAsync(AutomationName name) {
        DeleteAutomationRequest request = DeleteAutomationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteAutomationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutomationAsync(String name) {
        DeleteAutomationRequest request = DeleteAutomationRequest.newBuilder().setName(name).build();
        return this.deleteAutomationAsync(request);
    }

    public final OperationFuture<Empty, OperationMetadata> deleteAutomationAsync(DeleteAutomationRequest request) {
        return this.deleteAutomationOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteAutomationRequest, Empty, OperationMetadata> deleteAutomationOperationCallable() {
        return this.stub.deleteAutomationOperationCallable();
    }

    public final UnaryCallable<DeleteAutomationRequest, Operation> deleteAutomationCallable() {
        return this.stub.deleteAutomationCallable();
    }

    public final Automation getAutomation(AutomationName name) {
        GetAutomationRequest request = GetAutomationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAutomation(request);
    }

    public final Automation getAutomation(String name) {
        GetAutomationRequest request = GetAutomationRequest.newBuilder().setName(name).build();
        return this.getAutomation(request);
    }

    public final Automation getAutomation(GetAutomationRequest request) {
        return (Automation)this.getAutomationCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutomationRequest, Automation> getAutomationCallable() {
        return this.stub.getAutomationCallable();
    }

    public final ListAutomationsPagedResponse listAutomations(DeliveryPipelineName parent) {
        ListAutomationsRequest request = ListAutomationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutomations(request);
    }

    public final ListAutomationsPagedResponse listAutomations(String parent) {
        ListAutomationsRequest request = ListAutomationsRequest.newBuilder().setParent(parent).build();
        return this.listAutomations(request);
    }

    public final ListAutomationsPagedResponse listAutomations(ListAutomationsRequest request) {
        return (ListAutomationsPagedResponse)((Object)this.listAutomationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutomationsRequest, ListAutomationsPagedResponse> listAutomationsPagedCallable() {
        return this.stub.listAutomationsPagedCallable();
    }

    public final UnaryCallable<ListAutomationsRequest, ListAutomationsResponse> listAutomationsCallable() {
        return this.stub.listAutomationsCallable();
    }

    public final AutomationRun getAutomationRun(AutomationRunName name) {
        GetAutomationRunRequest request = GetAutomationRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getAutomationRun(request);
    }

    public final AutomationRun getAutomationRun(String name) {
        GetAutomationRunRequest request = GetAutomationRunRequest.newBuilder().setName(name).build();
        return this.getAutomationRun(request);
    }

    public final AutomationRun getAutomationRun(GetAutomationRunRequest request) {
        return (AutomationRun)this.getAutomationRunCallable().call((Object)request);
    }

    public final UnaryCallable<GetAutomationRunRequest, AutomationRun> getAutomationRunCallable() {
        return this.stub.getAutomationRunCallable();
    }

    public final ListAutomationRunsPagedResponse listAutomationRuns(DeliveryPipelineName parent) {
        ListAutomationRunsRequest request = ListAutomationRunsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAutomationRuns(request);
    }

    public final ListAutomationRunsPagedResponse listAutomationRuns(String parent) {
        ListAutomationRunsRequest request = ListAutomationRunsRequest.newBuilder().setParent(parent).build();
        return this.listAutomationRuns(request);
    }

    public final ListAutomationRunsPagedResponse listAutomationRuns(ListAutomationRunsRequest request) {
        return (ListAutomationRunsPagedResponse)((Object)this.listAutomationRunsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAutomationRunsRequest, ListAutomationRunsPagedResponse> listAutomationRunsPagedCallable() {
        return this.stub.listAutomationRunsPagedCallable();
    }

    public final UnaryCallable<ListAutomationRunsRequest, ListAutomationRunsResponse> listAutomationRunsCallable() {
        return this.stub.listAutomationRunsCallable();
    }

    public final CancelAutomationRunResponse cancelAutomationRun(AutomationRunName name) {
        CancelAutomationRunRequest request = CancelAutomationRunRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.cancelAutomationRun(request);
    }

    public final CancelAutomationRunResponse cancelAutomationRun(String name) {
        CancelAutomationRunRequest request = CancelAutomationRunRequest.newBuilder().setName(name).build();
        return this.cancelAutomationRun(request);
    }

    public final CancelAutomationRunResponse cancelAutomationRun(CancelAutomationRunRequest request) {
        return (CancelAutomationRunResponse)this.cancelAutomationRunCallable().call((Object)request);
    }

    public final UnaryCallable<CancelAutomationRunRequest, CancelAutomationRunResponse> cancelAutomationRunCallable() {
        return this.stub.cancelAutomationRunCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutomationRunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun, ListAutomationRunsPage, ListAutomationRunsFixedSizeCollection> {
        private ListAutomationRunsFixedSizeCollection(List<ListAutomationRunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutomationRunsFixedSizeCollection createEmptyCollection() {
            return new ListAutomationRunsFixedSizeCollection(null, 0);
        }

        protected ListAutomationRunsFixedSizeCollection createCollection(List<ListAutomationRunsPage> pages, int collectionSize) {
            return new ListAutomationRunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutomationRunsPage
    extends AbstractPage<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun, ListAutomationRunsPage> {
        private ListAutomationRunsPage(PageContext<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun> context, ListAutomationRunsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutomationRunsPage createEmptyPage() {
            return new ListAutomationRunsPage(null, null);
        }

        protected ListAutomationRunsPage createPage(PageContext<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun> context, ListAutomationRunsResponse response) {
            return new ListAutomationRunsPage(context, response);
        }

        public ApiFuture<ListAutomationRunsPage> createPageAsync(PageContext<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun> context, ApiFuture<ListAutomationRunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutomationRunsPagedResponse
    extends AbstractPagedListResponse<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun, ListAutomationRunsPage, ListAutomationRunsFixedSizeCollection> {
        public static ApiFuture<ListAutomationRunsPagedResponse> createAsync(PageContext<ListAutomationRunsRequest, ListAutomationRunsResponse, AutomationRun> context, ApiFuture<ListAutomationRunsResponse> futureResponse) {
            ApiFuture<ListAutomationRunsPage> futurePage = ListAutomationRunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutomationRunsPagedResponse((ListAutomationRunsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutomationRunsPagedResponse(ListAutomationRunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutomationRunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAutomationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAutomationsRequest, ListAutomationsResponse, Automation, ListAutomationsPage, ListAutomationsFixedSizeCollection> {
        private ListAutomationsFixedSizeCollection(List<ListAutomationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAutomationsFixedSizeCollection createEmptyCollection() {
            return new ListAutomationsFixedSizeCollection(null, 0);
        }

        protected ListAutomationsFixedSizeCollection createCollection(List<ListAutomationsPage> pages, int collectionSize) {
            return new ListAutomationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAutomationsPage
    extends AbstractPage<ListAutomationsRequest, ListAutomationsResponse, Automation, ListAutomationsPage> {
        private ListAutomationsPage(PageContext<ListAutomationsRequest, ListAutomationsResponse, Automation> context, ListAutomationsResponse response) {
            super(context, (Object)response);
        }

        private static ListAutomationsPage createEmptyPage() {
            return new ListAutomationsPage(null, null);
        }

        protected ListAutomationsPage createPage(PageContext<ListAutomationsRequest, ListAutomationsResponse, Automation> context, ListAutomationsResponse response) {
            return new ListAutomationsPage(context, response);
        }

        public ApiFuture<ListAutomationsPage> createPageAsync(PageContext<ListAutomationsRequest, ListAutomationsResponse, Automation> context, ApiFuture<ListAutomationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAutomationsPagedResponse
    extends AbstractPagedListResponse<ListAutomationsRequest, ListAutomationsResponse, Automation, ListAutomationsPage, ListAutomationsFixedSizeCollection> {
        public static ApiFuture<ListAutomationsPagedResponse> createAsync(PageContext<ListAutomationsRequest, ListAutomationsResponse, Automation> context, ApiFuture<ListAutomationsResponse> futureResponse) {
            ApiFuture<ListAutomationsPage> futurePage = ListAutomationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAutomationsPagedResponse((ListAutomationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAutomationsPagedResponse(ListAutomationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAutomationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListJobRunsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListJobRunsRequest, ListJobRunsResponse, JobRun, ListJobRunsPage, ListJobRunsFixedSizeCollection> {
        private ListJobRunsFixedSizeCollection(List<ListJobRunsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListJobRunsFixedSizeCollection createEmptyCollection() {
            return new ListJobRunsFixedSizeCollection(null, 0);
        }

        protected ListJobRunsFixedSizeCollection createCollection(List<ListJobRunsPage> pages, int collectionSize) {
            return new ListJobRunsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListJobRunsPage
    extends AbstractPage<ListJobRunsRequest, ListJobRunsResponse, JobRun, ListJobRunsPage> {
        private ListJobRunsPage(PageContext<ListJobRunsRequest, ListJobRunsResponse, JobRun> context, ListJobRunsResponse response) {
            super(context, (Object)response);
        }

        private static ListJobRunsPage createEmptyPage() {
            return new ListJobRunsPage(null, null);
        }

        protected ListJobRunsPage createPage(PageContext<ListJobRunsRequest, ListJobRunsResponse, JobRun> context, ListJobRunsResponse response) {
            return new ListJobRunsPage(context, response);
        }

        public ApiFuture<ListJobRunsPage> createPageAsync(PageContext<ListJobRunsRequest, ListJobRunsResponse, JobRun> context, ApiFuture<ListJobRunsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListJobRunsPagedResponse
    extends AbstractPagedListResponse<ListJobRunsRequest, ListJobRunsResponse, JobRun, ListJobRunsPage, ListJobRunsFixedSizeCollection> {
        public static ApiFuture<ListJobRunsPagedResponse> createAsync(PageContext<ListJobRunsRequest, ListJobRunsResponse, JobRun> context, ApiFuture<ListJobRunsResponse> futureResponse) {
            ApiFuture<ListJobRunsPage> futurePage = ListJobRunsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListJobRunsPagedResponse((ListJobRunsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListJobRunsPagedResponse(ListJobRunsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListJobRunsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListRolloutsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        private ListRolloutsFixedSizeCollection(List<ListRolloutsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRolloutsFixedSizeCollection createEmptyCollection() {
            return new ListRolloutsFixedSizeCollection(null, 0);
        }

        protected ListRolloutsFixedSizeCollection createCollection(List<ListRolloutsPage> pages, int collectionSize) {
            return new ListRolloutsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRolloutsPage
    extends AbstractPage<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage> {
        private ListRolloutsPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            super(context, (Object)response);
        }

        private static ListRolloutsPage createEmptyPage() {
            return new ListRolloutsPage(null, null);
        }

        protected ListRolloutsPage createPage(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ListRolloutsResponse response) {
            return new ListRolloutsPage(context, response);
        }

        public ApiFuture<ListRolloutsPage> createPageAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRolloutsPagedResponse
    extends AbstractPagedListResponse<ListRolloutsRequest, ListRolloutsResponse, Rollout, ListRolloutsPage, ListRolloutsFixedSizeCollection> {
        public static ApiFuture<ListRolloutsPagedResponse> createAsync(PageContext<ListRolloutsRequest, ListRolloutsResponse, Rollout> context, ApiFuture<ListRolloutsResponse> futureResponse) {
            ApiFuture<ListRolloutsPage> futurePage = ListRolloutsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListRolloutsPagedResponse((ListRolloutsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListRolloutsPagedResponse(ListRolloutsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRolloutsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReleasesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        private ListReleasesFixedSizeCollection(List<ListReleasesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReleasesFixedSizeCollection createEmptyCollection() {
            return new ListReleasesFixedSizeCollection(null, 0);
        }

        protected ListReleasesFixedSizeCollection createCollection(List<ListReleasesPage> pages, int collectionSize) {
            return new ListReleasesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReleasesPage
    extends AbstractPage<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage> {
        private ListReleasesPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            super(context, (Object)response);
        }

        private static ListReleasesPage createEmptyPage() {
            return new ListReleasesPage(null, null);
        }

        protected ListReleasesPage createPage(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ListReleasesResponse response) {
            return new ListReleasesPage(context, response);
        }

        public ApiFuture<ListReleasesPage> createPageAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReleasesPagedResponse
    extends AbstractPagedListResponse<ListReleasesRequest, ListReleasesResponse, Release, ListReleasesPage, ListReleasesFixedSizeCollection> {
        public static ApiFuture<ListReleasesPagedResponse> createAsync(PageContext<ListReleasesRequest, ListReleasesResponse, Release> context, ApiFuture<ListReleasesResponse> futureResponse) {
            ApiFuture<ListReleasesPage> futurePage = ListReleasesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReleasesPagedResponse((ListReleasesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReleasesPagedResponse(ListReleasesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReleasesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCustomTargetTypesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType, ListCustomTargetTypesPage, ListCustomTargetTypesFixedSizeCollection> {
        private ListCustomTargetTypesFixedSizeCollection(List<ListCustomTargetTypesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomTargetTypesFixedSizeCollection createEmptyCollection() {
            return new ListCustomTargetTypesFixedSizeCollection(null, 0);
        }

        protected ListCustomTargetTypesFixedSizeCollection createCollection(List<ListCustomTargetTypesPage> pages, int collectionSize) {
            return new ListCustomTargetTypesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomTargetTypesPage
    extends AbstractPage<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType, ListCustomTargetTypesPage> {
        private ListCustomTargetTypesPage(PageContext<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType> context, ListCustomTargetTypesResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomTargetTypesPage createEmptyPage() {
            return new ListCustomTargetTypesPage(null, null);
        }

        protected ListCustomTargetTypesPage createPage(PageContext<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType> context, ListCustomTargetTypesResponse response) {
            return new ListCustomTargetTypesPage(context, response);
        }

        public ApiFuture<ListCustomTargetTypesPage> createPageAsync(PageContext<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType> context, ApiFuture<ListCustomTargetTypesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomTargetTypesPagedResponse
    extends AbstractPagedListResponse<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType, ListCustomTargetTypesPage, ListCustomTargetTypesFixedSizeCollection> {
        public static ApiFuture<ListCustomTargetTypesPagedResponse> createAsync(PageContext<ListCustomTargetTypesRequest, ListCustomTargetTypesResponse, CustomTargetType> context, ApiFuture<ListCustomTargetTypesResponse> futureResponse) {
            ApiFuture<ListCustomTargetTypesPage> futurePage = ListCustomTargetTypesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomTargetTypesPagedResponse((ListCustomTargetTypesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomTargetTypesPagedResponse(ListCustomTargetTypesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomTargetTypesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListTargetsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage, ListTargetsFixedSizeCollection> {
        private ListTargetsFixedSizeCollection(List<ListTargetsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListTargetsFixedSizeCollection createEmptyCollection() {
            return new ListTargetsFixedSizeCollection(null, 0);
        }

        protected ListTargetsFixedSizeCollection createCollection(List<ListTargetsPage> pages, int collectionSize) {
            return new ListTargetsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListTargetsPage
    extends AbstractPage<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage> {
        private ListTargetsPage(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ListTargetsResponse response) {
            super(context, (Object)response);
        }

        private static ListTargetsPage createEmptyPage() {
            return new ListTargetsPage(null, null);
        }

        protected ListTargetsPage createPage(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ListTargetsResponse response) {
            return new ListTargetsPage(context, response);
        }

        public ApiFuture<ListTargetsPage> createPageAsync(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ApiFuture<ListTargetsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListTargetsPagedResponse
    extends AbstractPagedListResponse<ListTargetsRequest, ListTargetsResponse, Target, ListTargetsPage, ListTargetsFixedSizeCollection> {
        public static ApiFuture<ListTargetsPagedResponse> createAsync(PageContext<ListTargetsRequest, ListTargetsResponse, Target> context, ApiFuture<ListTargetsResponse> futureResponse) {
            ApiFuture<ListTargetsPage> futurePage = ListTargetsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListTargetsPagedResponse((ListTargetsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListTargetsPagedResponse(ListTargetsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListTargetsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListDeliveryPipelinesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage, ListDeliveryPipelinesFixedSizeCollection> {
        private ListDeliveryPipelinesFixedSizeCollection(List<ListDeliveryPipelinesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDeliveryPipelinesFixedSizeCollection createEmptyCollection() {
            return new ListDeliveryPipelinesFixedSizeCollection(null, 0);
        }

        protected ListDeliveryPipelinesFixedSizeCollection createCollection(List<ListDeliveryPipelinesPage> pages, int collectionSize) {
            return new ListDeliveryPipelinesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDeliveryPipelinesPage
    extends AbstractPage<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage> {
        private ListDeliveryPipelinesPage(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ListDeliveryPipelinesResponse response) {
            super(context, (Object)response);
        }

        private static ListDeliveryPipelinesPage createEmptyPage() {
            return new ListDeliveryPipelinesPage(null, null);
        }

        protected ListDeliveryPipelinesPage createPage(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ListDeliveryPipelinesResponse response) {
            return new ListDeliveryPipelinesPage(context, response);
        }

        public ApiFuture<ListDeliveryPipelinesPage> createPageAsync(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ApiFuture<ListDeliveryPipelinesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDeliveryPipelinesPagedResponse
    extends AbstractPagedListResponse<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline, ListDeliveryPipelinesPage, ListDeliveryPipelinesFixedSizeCollection> {
        public static ApiFuture<ListDeliveryPipelinesPagedResponse> createAsync(PageContext<ListDeliveryPipelinesRequest, ListDeliveryPipelinesResponse, DeliveryPipeline> context, ApiFuture<ListDeliveryPipelinesResponse> futureResponse) {
            ApiFuture<ListDeliveryPipelinesPage> futurePage = ListDeliveryPipelinesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDeliveryPipelinesPagedResponse((ListDeliveryPipelinesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDeliveryPipelinesPagedResponse(ListDeliveryPipelinesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDeliveryPipelinesFixedSizeCollection.createEmptyCollection());
        }
    }
}

