/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.AggregationResults;
import com.google.cloud.datastore.GqlQuery;
import com.google.cloud.datastore.Query;
import com.google.cloud.datastore.StructuredQuery;
import com.google.cloud.datastore.aggregation.Aggregation;
import com.google.cloud.datastore.aggregation.AggregationBuilder;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;

public class AggregationQuery
extends Query<AggregationResults> {
    private Set<Aggregation> aggregations;
    private StructuredQuery<?> nestedStructuredQuery;
    private final Mode mode;
    private GqlQuery<?> nestedGqlQuery;

    AggregationQuery(String namespace, Set<Aggregation> aggregations, StructuredQuery<?> nestedQuery) {
        super(namespace);
        Preconditions.checkArgument((!aggregations.isEmpty() ? 1 : 0) != 0, (Object)"At least one aggregation is required for an aggregation query to run");
        this.aggregations = aggregations;
        this.nestedStructuredQuery = nestedQuery;
        this.mode = Mode.STRUCTURED;
    }

    AggregationQuery(String namespace, GqlQuery<?> gqlQuery) {
        super(namespace);
        this.nestedGqlQuery = gqlQuery;
        this.mode = Mode.GQL;
    }

    public Set<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public StructuredQuery<?> getNestedStructuredQuery() {
        return this.nestedStructuredQuery;
    }

    public GqlQuery<?> getNestedGqlQuery() {
        return this.nestedGqlQuery;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        STRUCTURED,
        GQL;

    }

    public static class Builder {
        private String namespace;
        private Mode mode;
        private final Set<Aggregation> aggregations = new HashSet<Aggregation>();
        private StructuredQuery<?> nestedStructuredQuery;
        private GqlQuery<?> nestedGqlQuery;

        public Builder setNamespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder addAggregation(AggregationBuilder<?> aggregationBuilder) {
            this.aggregations.add((Aggregation)aggregationBuilder.build());
            return this;
        }

        public Builder addAggregation(Aggregation aggregation) {
            this.aggregations.add(aggregation);
            return this;
        }

        public Builder over(StructuredQuery<?> nestedQuery) {
            this.nestedStructuredQuery = nestedQuery;
            this.mode = Mode.STRUCTURED;
            return this;
        }

        public Builder over(GqlQuery<?> nestedQuery) {
            this.nestedGqlQuery = nestedQuery;
            this.mode = Mode.GQL;
            return this;
        }

        public AggregationQuery build() {
            boolean nestedQueryProvided = this.nestedGqlQuery != null || this.nestedStructuredQuery != null;
            Preconditions.checkArgument((boolean)nestedQueryProvided, (Object)"Nested query is required for an aggregation query to run");
            if (this.mode == Mode.GQL) {
                return new AggregationQuery(this.namespace, this.nestedGqlQuery);
            }
            return new AggregationQuery(this.namespace, this.aggregations, this.nestedStructuredQuery);
        }
    }
}

