/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.dataproc.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.dataproc.v1.Cluster;
import com.google.cloud.dataproc.v1.ClusterControllerClient;
import com.google.cloud.dataproc.v1.ClusterOperationMetadata;
import com.google.cloud.dataproc.v1.CreateClusterRequest;
import com.google.cloud.dataproc.v1.DeleteClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterRequest;
import com.google.cloud.dataproc.v1.DiagnoseClusterResults;
import com.google.cloud.dataproc.v1.GetClusterRequest;
import com.google.cloud.dataproc.v1.ListClustersRequest;
import com.google.cloud.dataproc.v1.ListClustersResponse;
import com.google.cloud.dataproc.v1.StartClusterRequest;
import com.google.cloud.dataproc.v1.StopClusterRequest;
import com.google.cloud.dataproc.v1.UpdateClusterRequest;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStub;
import com.google.cloud.dataproc.v1.stub.ClusterControllerStubSettings;
import com.google.cloud.dataproc.v1.stub.GrpcClusterControllerCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcClusterControllerStub
extends ClusterControllerStub {
    private static final MethodDescriptor<CreateClusterRequest, Operation> createClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/CreateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateClusterRequest, Operation> updateClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/UpdateCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StopClusterRequest, Operation> stopClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/StopCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)StopClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<StartClusterRequest, Operation> startClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/StartCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)StartClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteClusterRequest, Operation> deleteClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/DeleteCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private static final MethodDescriptor<GetClusterRequest, Cluster> getClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/GetCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)GetClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Cluster.getDefaultInstance())).build();
    private static final MethodDescriptor<ListClustersRequest, ListClustersResponse> listClustersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/ListClusters").setRequestMarshaller(ProtoUtils.marshaller((Message)ListClustersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListClustersResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DiagnoseClusterRequest, Operation> diagnoseClusterMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.dataproc.v1.ClusterController/DiagnoseCluster").setRequestMarshaller(ProtoUtils.marshaller((Message)DiagnoseClusterRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Operation.getDefaultInstance())).build();
    private final UnaryCallable<CreateClusterRequest, Operation> createClusterCallable;
    private final OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable;
    private final UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable;
    private final OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable;
    private final UnaryCallable<StopClusterRequest, Operation> stopClusterCallable;
    private final OperationCallable<StopClusterRequest, Cluster, ClusterOperationMetadata> stopClusterOperationCallable;
    private final UnaryCallable<StartClusterRequest, Operation> startClusterCallable;
    private final OperationCallable<StartClusterRequest, Cluster, ClusterOperationMetadata> startClusterOperationCallable;
    private final UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable;
    private final OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable;
    private final UnaryCallable<GetClusterRequest, Cluster> getClusterCallable;
    private final UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable;
    private final UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable;
    private final UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable;
    private final OperationCallable<DiagnoseClusterRequest, DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterOperationCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcClusterControllerStub create(ClusterControllerStubSettings settings) throws IOException {
        return new GrpcClusterControllerStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcClusterControllerStub create(ClientContext clientContext) throws IOException {
        return new GrpcClusterControllerStub(ClusterControllerStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcClusterControllerStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcClusterControllerStub(ClusterControllerStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcClusterControllerStub(ClusterControllerStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcClusterControllerCallableFactory());
    }

    protected GrpcClusterControllerStub(ClusterControllerStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings updateClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings stopClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(stopClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings startClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(startClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings deleteClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings getClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings listClustersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listClustersMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        GrpcCallSettings diagnoseClusterTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(diagnoseClusterMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder params = ImmutableMap.builder();
            params.put((Object)"cluster_name", (Object)String.valueOf(request.getClusterName()));
            params.put((Object)"project_id", (Object)String.valueOf(request.getProjectId()));
            params.put((Object)"region", (Object)String.valueOf(request.getRegion()));
            return params.build();
        }).build();
        this.createClusterCallable = callableFactory.createUnaryCallable(createClusterTransportSettings, settings.createClusterSettings(), clientContext);
        this.createClusterOperationCallable = callableFactory.createOperationCallable(createClusterTransportSettings, settings.createClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.updateClusterCallable = callableFactory.createUnaryCallable(updateClusterTransportSettings, settings.updateClusterSettings(), clientContext);
        this.updateClusterOperationCallable = callableFactory.createOperationCallable(updateClusterTransportSettings, settings.updateClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.stopClusterCallable = callableFactory.createUnaryCallable(stopClusterTransportSettings, settings.stopClusterSettings(), clientContext);
        this.stopClusterOperationCallable = callableFactory.createOperationCallable(stopClusterTransportSettings, settings.stopClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.startClusterCallable = callableFactory.createUnaryCallable(startClusterTransportSettings, settings.startClusterSettings(), clientContext);
        this.startClusterOperationCallable = callableFactory.createOperationCallable(startClusterTransportSettings, settings.startClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.deleteClusterCallable = callableFactory.createUnaryCallable(deleteClusterTransportSettings, settings.deleteClusterSettings(), clientContext);
        this.deleteClusterOperationCallable = callableFactory.createOperationCallable(deleteClusterTransportSettings, settings.deleteClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.getClusterCallable = callableFactory.createUnaryCallable(getClusterTransportSettings, settings.getClusterSettings(), clientContext);
        this.listClustersCallable = callableFactory.createUnaryCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.listClustersPagedCallable = callableFactory.createPagedCallable(listClustersTransportSettings, settings.listClustersSettings(), clientContext);
        this.diagnoseClusterCallable = callableFactory.createUnaryCallable(diagnoseClusterTransportSettings, settings.diagnoseClusterSettings(), clientContext);
        this.diagnoseClusterOperationCallable = callableFactory.createOperationCallable(diagnoseClusterTransportSettings, settings.diagnoseClusterOperationSettings(), clientContext, (OperationsStub)this.operationsStub);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateClusterRequest, Operation> createClusterCallable() {
        return this.createClusterCallable;
    }

    @Override
    public OperationCallable<CreateClusterRequest, Cluster, ClusterOperationMetadata> createClusterOperationCallable() {
        return this.createClusterOperationCallable;
    }

    @Override
    public UnaryCallable<UpdateClusterRequest, Operation> updateClusterCallable() {
        return this.updateClusterCallable;
    }

    @Override
    public OperationCallable<UpdateClusterRequest, Cluster, ClusterOperationMetadata> updateClusterOperationCallable() {
        return this.updateClusterOperationCallable;
    }

    @Override
    public UnaryCallable<StopClusterRequest, Operation> stopClusterCallable() {
        return this.stopClusterCallable;
    }

    @Override
    public OperationCallable<StopClusterRequest, Cluster, ClusterOperationMetadata> stopClusterOperationCallable() {
        return this.stopClusterOperationCallable;
    }

    @Override
    public UnaryCallable<StartClusterRequest, Operation> startClusterCallable() {
        return this.startClusterCallable;
    }

    @Override
    public OperationCallable<StartClusterRequest, Cluster, ClusterOperationMetadata> startClusterOperationCallable() {
        return this.startClusterOperationCallable;
    }

    @Override
    public UnaryCallable<DeleteClusterRequest, Operation> deleteClusterCallable() {
        return this.deleteClusterCallable;
    }

    @Override
    public OperationCallable<DeleteClusterRequest, Empty, ClusterOperationMetadata> deleteClusterOperationCallable() {
        return this.deleteClusterOperationCallable;
    }

    @Override
    public UnaryCallable<GetClusterRequest, Cluster> getClusterCallable() {
        return this.getClusterCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ListClustersResponse> listClustersCallable() {
        return this.listClustersCallable;
    }

    @Override
    public UnaryCallable<ListClustersRequest, ClusterControllerClient.ListClustersPagedResponse> listClustersPagedCallable() {
        return this.listClustersPagedCallable;
    }

    @Override
    public UnaryCallable<DiagnoseClusterRequest, Operation> diagnoseClusterCallable() {
        return this.diagnoseClusterCallable;
    }

    @Override
    public OperationCallable<DiagnoseClusterRequest, DiagnoseClusterResults, ClusterOperationMetadata> diagnoseClusterOperationCallable() {
        return this.diagnoseClusterOperationCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

